/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.request.employee.payroll.PayrollMonthUpdateItem;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.employee.attendance.AttendancesListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthBusinessUnitStatisticCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthBusinessUnitStatisticsCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthLaborUnionContractStatisticCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthLaborUnionContractStatisticsCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthPageCommon;
import de.qfm.erp.common.response.employee.wagedistribution.QuotationWageDetailCommon;
import de.qfm.erp.common.response.employee.wagedistribution.StageWageCommon;
import de.qfm.erp.common.response.employee.wagedistribution.StageWageListCommon;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.employee.QuotationWageDetail;
import de.qfm.erp.service.model.internal.employee.StageWage;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthBusinessUnitStatistic;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthItemsUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthLaborUnionContractStatistic;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.businessunit.BusinessUnit;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccount;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccountTransaction;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.AttendanceMapper;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.PayrollMonthItemMapper;
import de.qfm.erp.service.service.mapper.WageAccountMapper;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class PayrollMonthMapper {
    private static final Logger log = LogManager.getLogger(PayrollMonthMapper.class);
    private final AttendanceMapper attendanceMapper;
    private final PayrollMonthItemMapper payrollMonthItemMapper;
    private final WageAccountMapper wageAccountMapper;

    @Nonnull
    public PayrollMonthPageCommon map(@NonNull Page<PayrollMonth> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        return this.map(page, (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
    }

    @Nonnull
    public PayrollMonthPageCommon map(@NonNull Page<PayrollMonth> page, @NonNull Iterable<PayrollMonthBusinessUnitStatistic> businessUnitStatistics, @NonNull Iterable<PayrollMonthLaborUnionContractStatistic> laborUnionStatistics) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (businessUnitStatistics == null) {
            throw new NullPointerException("businessUnitStatistics is marked non-null but is null");
        }
        if (laborUnionStatistics == null) {
            throw new NullPointerException("laborUnionStatistics is marked non-null but is null");
        }
        PayrollMonthBusinessUnitStatisticsCommon businessUnitStatisticsCommon = this.mapBusinessUnit(businessUnitStatistics);
        PayrollMonthLaborUnionContractStatisticsCommon laborUnionStatisticsCommon = this.mapLaborUnionContract(laborUnionStatistics);
        return (PayrollMonthPageCommon)BaseMapper.map(page, arg_0 -> this.mapHead(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new PayrollMonthPageCommon(pageNumber, pageSize, totalPages, totalElements, items, businessUnitStatisticsCommon, laborUnionStatisticsCommon));
    }

    @Nonnull
    public PayrollMonthCommon map(@NonNull PayrollMonth payrollMonth, @NonNull Function<User, Boolean> fnUserReleased) {
        WageAccount wageAccount;
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (fnUserReleased == null) {
            throw new NullPointerException("fnUserReleased is marked non-null but is null");
        }
        PayrollMonthCommon common = this.mapHead(payrollMonth);
        List attendances = (List)MoreObjects.firstNonNull((Object)payrollMonth.getAttendances(), (Object)ImmutableList.of());
        AttendancesListCommon attendancesListCommon = this.attendanceMapper.map((Iterable)attendances, fnUserReleased, x -> false);
        common.setAttendances(attendancesListCommon);
        List payrollMonthItems = (List)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthItems(), (Object)ImmutableList.of());
        List incentivePayrollMonthItems = (List)payrollMonthItems.stream().filter(item -> EPayrollItemClazz.INCENTIVE_PAYMENT == item.getPayrollItemClazz()).collect(ImmutableList.toImmutableList());
        List auxiliaryWagePayrollMonthItems = (List)payrollMonthItems.stream().filter(item -> EPayrollItemClazz.AUXILIARY_WAGE == item.getPayrollItemClazz()).collect(ImmutableList.toImmutableList());
        List wageAccountPayrollMonthItems = (List)payrollMonthItems.stream().filter(item -> EPayrollItemClazz.WAGE_ACCOUNT == item.getPayrollItemClazz()).collect(ImmutableList.toImmutableList());
        PayrollMonthItemListCommon incentivePayrollMonthItemsCommon = this.payrollMonthItemMapper.mapPayrollMonthItems((Iterable)incentivePayrollMonthItems, fnUserReleased);
        common.setIncentives(incentivePayrollMonthItemsCommon);
        PayrollMonthItemListCommon auxiliaryWagePayrollMonthItemsCommon = this.payrollMonthItemMapper.mapPayrollMonthItems((Iterable)auxiliaryWagePayrollMonthItems, fnUserReleased);
        common.setAuxiliaryWages(auxiliaryWagePayrollMonthItemsCommon);
        PayrollMonthItemListCommon wageAccountItems = this.payrollMonthItemMapper.mapPayrollMonthItems((Iterable)wageAccountPayrollMonthItems, fnUserReleased);
        common.setWageAccountWages(wageAccountItems);
        User user = payrollMonth.getUser();
        if (null != user && null != (wageAccount = user.getWageAccount())) {
            BigDecimal balance = (BigDecimal)MoreObjects.firstNonNull((Object)wageAccount.getBalance(), (Object)BigDecimal.ZERO);
            BigDecimal limit = (BigDecimal)MoreObjects.firstNonNull((Object)wageAccount.getLimit(), (Object)BigDecimal.ZERO);
            common.setWageAccountBalance(balance);
            common.setWageAccountLimit(limit);
        }
        return common;
    }

    @Nonnull
    private PayrollMonthCommon mapHead(@NonNull PayrollMonth payrollMonth) {
        LaborUnionContract laborUnionContract;
        BusinessUnit businessUnit;
        User user;
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        PayrollMonthCommon common = new PayrollMonthCommon();
        BaseMapper.map((EntityBase)payrollMonth, (EntityBaseCommon)common);
        common.setId(payrollMonth.getId());
        common.setReferenceId(payrollMonth.getReferenceId());
        EPayrollMonthState payrollMonthState = (EPayrollMonthState)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthState(), (Object)EPayrollMonthState.UNKNOWN);
        String payrollMonthStateString = payrollMonthState.name();
        common.setPayrollMonthState(payrollMonthStateString);
        User manager = payrollMonth.getManager();
        if (null != manager) {
            common.setManagerId(manager.getId());
            common.setManagerName(manager.getFullName());
        }
        if (null != (user = payrollMonth.getUser())) {
            common.setUserId(user.getId());
            common.setUserName(user.getFullName());
            common.setPersonalNumber(user.getPersonalNumber());
        }
        if (null != (businessUnit = payrollMonth.getBusinessUnit())) {
            common.setBusinessUnitId(businessUnit.getId().longValue());
            common.setBusinessUnitName(businessUnit.getShortName());
            common.setBusinessUnitCostCenter(businessUnit.getCostCenter());
        }
        if (null != (laborUnionContract = payrollMonth.getLaborUnionContract())) {
            common.setLaborUnionContractId(laborUnionContract.getId().longValue());
            common.setLaborUnionContractName(laborUnionContract.getName());
        }
        common.setCurrentWage(payrollMonth.getCurrentWage());
        common.setExportedWage(payrollMonth.getExportedWage());
        common.setAccountingMonth(payrollMonth.getAccountingMonth());
        common.setRemarks(payrollMonth.getRemarks());
        common.setCostCenter(payrollMonth.getCostCenter());
        User releasedBy = payrollMonth.getReleasedBy();
        if (null != releasedBy) {
            common.setReleasedByUserId(releasedBy.getId());
            common.setReleasedByUserName(releasedBy.getFullName());
        }
        common.setReleasedOn(payrollMonth.getReleasedOn());
        User exportedBy = payrollMonth.getExportedBy();
        if (null != exportedBy) {
            common.setExportedByUserId(exportedBy.getId());
            common.setExportedByUserName(exportedBy.getFullName());
        }
        common.setExportedOn(payrollMonth.getExportedOn());
        User printedBy = payrollMonth.getSlipPrintedBy();
        if (null != printedBy) {
            common.setSlipPrintedByUserId(printedBy.getId());
            common.setSlipPrintedByUserName(printedBy.getFullName());
        }
        common.setSlipPrintedOn(payrollMonth.getSlipPrintedOn());
        return common;
    }

    @Nonnull
    public Pair<PayrollMonth, MergedBucket<Attendance>> merge(@NonNull PayrollMonthUpdateBucket payrollMonthUpdateBucket) {
        if (payrollMonthUpdateBucket == null) {
            throw new NullPointerException("payrollMonthUpdateBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthUpdateBucket.getPayrollMonth();
        WageAccount wageAccount = payrollMonthUpdateBucket.getWageAccount();
        PayrollMonthUpdateItem payrollMonthUpdateItem = payrollMonthUpdateBucket.getPayrollMonthUpdateItem();
        Iterable attendanceUpdateBuckets = payrollMonthUpdateBucket.getAttendanceUpdateBuckets();
        Iterable incentivePayrollItemsBucket = payrollMonthUpdateBucket.getIncentivePayrollItemsBuckets();
        Iterable auxiliaryWagePayrollItemsBucket = payrollMonthUpdateBucket.getAuxiliaryWagePayrollItemsBuckets();
        Iterable wageAccountPayrollItemsBucket = payrollMonthUpdateBucket.getWageAccountItemsUpdateBuckets();
        String costCenter = payrollMonthUpdateBucket.getCostCenter();
        LaborUnionContract laborUnionContract = payrollMonthUpdateBucket.getLaborUnionContract();
        payrollMonth.setRemarks(StringUtils.trimToEmpty((String)payrollMonthUpdateItem.getRemarks()));
        payrollMonth.setLaborUnionContract(laborUnionContract);
        payrollMonth.setCostCenter(costCenter);
        EPayrollMonthState payrollMonthState = payrollMonthUpdateBucket.getPayrollMonthState();
        payrollMonth.setPayrollMonthState(payrollMonthState);
        MergedBucket attendancesMergeBucket = this.attendanceMapper.merge(attendanceUpdateBuckets);
        MergedBucket.printMergeBucket((Object)payrollMonth, Attendance.class, (MergedBucket)attendancesMergeBucket);
        Iterable auxiliaryPayrollItems = (Iterable)payrollMonth.getPayrollMonthItems().stream().filter(item -> EPayrollItemClazz.AUXILIARY_WAGE == item.getPayrollItemClazz()).collect(ImmutableList.toImmutableList());
        Iterable incentivePayrollItems = (Iterable)payrollMonth.getPayrollMonthItems().stream().filter(item -> EPayrollItemClazz.INCENTIVE_PAYMENT == item.getPayrollItemClazz()).collect(ImmutableList.toImmutableList());
        Iterable wageAccountPayrollItems = (Iterable)payrollMonth.getPayrollMonthItems().stream().filter(item -> EPayrollItemClazz.WAGE_ACCOUNT == item.getPayrollItemClazz()).collect(ImmutableList.toImmutableList());
        MergedBucket auxiliaryPayrollItemsMerged = this.payrollMonthItemMapper.merge(PayrollMonthItemsUpdateBucket.of((EPayrollItemClazz)EPayrollItemClazz.AUXILIARY_WAGE, (Iterable)auxiliaryPayrollItems, (Iterable)auxiliaryWagePayrollItemsBucket));
        MergedBucket incentivePayrollItemsMerged = this.payrollMonthItemMapper.merge(PayrollMonthItemsUpdateBucket.of((EPayrollItemClazz)EPayrollItemClazz.INCENTIVE_PAYMENT, (Iterable)incentivePayrollItems, (Iterable)incentivePayrollItemsBucket));
        MergedBucket wageAccountPayrollItemsMerged = this.payrollMonthItemMapper.merge(PayrollMonthItemsUpdateBucket.of((EPayrollItemClazz)EPayrollItemClazz.WAGE_ACCOUNT, (Iterable)wageAccountPayrollItems, (Iterable)wageAccountPayrollItemsBucket));
        BigDecimal balanceBefore = wageAccount.getBalance();
        MergedBucket wageAccountTransactionsMerged = this.wageAccountMapper.merge(wageAccount, wageAccountPayrollItemsMerged);
        BigDecimal balanceAfter = wageAccount.getBalance();
        log.info("Wage Account Adjusted: old: {} new: {}", (Object)balanceBefore, (Object)balanceAfter);
        MergedBucket.printMergeBucket((Object)wageAccount, WageAccountTransaction.class, (MergedBucket)wageAccountTransactionsMerged);
        if (null == payrollMonth.getAttendances()) {
            payrollMonth.setAttendances((List)Lists.newArrayList());
        }
        for (Attendance item2 : attendancesMergeBucket.getAdded()) {
            item2.setPayrollMonth(payrollMonth);
            payrollMonth.getAttendances().add(item2);
        }
        if (null == payrollMonth.getPayrollMonthItems()) {
            payrollMonth.setPayrollMonthItems((List)Lists.newArrayList());
        }
        for (Attendance item2 : incentivePayrollItemsMerged.getAdded()) {
            item2.setPayrollMonth(payrollMonth);
            payrollMonth.getPayrollMonthItems().add(item2);
        }
        for (Attendance item2 : incentivePayrollItemsMerged.getDeleted()) {
            item2.setPayrollMonth(null);
            payrollMonth.getPayrollMonthItems().remove(item2);
        }
        for (Attendance item2 : auxiliaryPayrollItemsMerged.getAdded()) {
            item2.setPayrollMonth(payrollMonth);
            payrollMonth.getPayrollMonthItems().add(item2);
        }
        for (Attendance item2 : auxiliaryPayrollItemsMerged.getDeleted()) {
            item2.setPayrollMonth(null);
            payrollMonth.getPayrollMonthItems().remove(item2);
        }
        for (Attendance item2 : wageAccountPayrollItemsMerged.getAdded()) {
            item2.setPayrollMonth(payrollMonth);
            payrollMonth.getPayrollMonthItems().add(item2);
        }
        for (Attendance item2 : wageAccountPayrollItemsMerged.getDeleted()) {
            item2.setPayrollMonth(null);
            payrollMonth.getPayrollMonthItems().remove(item2);
        }
        return Pair.of((Object)payrollMonth, (Object)attendancesMergeBucket);
    }

    @Nonnull
    public StageWageListCommon mapStageWages(@NonNull Iterable<StageWage> quotationWages) {
        if (quotationWages == null) {
            throw new NullPointerException("quotationWages is marked non-null but is null");
        }
        ImmutableList stageWageCommons = (ImmutableList)IterableHelper.stream(quotationWages).map(arg_0 -> this.mapQuotationWage(arg_0)).sorted(Comparator.comparing(StageWageCommon::getQuotationNumber)).collect(ImmutableList.toImmutableList());
        return new StageWageListCommon(Iterables.size((Iterable)stageWageCommons), (List)stageWageCommons);
    }

    @Nonnull
    private StageWageCommon mapQuotationWage(@NonNull StageWage stageWage) {
        if (stageWage == null) {
            throw new NullPointerException("stageWage is marked non-null but is null");
        }
        StageWageCommon common = new StageWageCommon();
        common.setQuotationNumber(stageWage.getQuotationNumber());
        common.setQentityNumber(stageWage.getStageNumber());
        common.setAlias(stageWage.getStageAlias());
        common.setVersion(stageWage.getStageVersion());
        common.setProjectName(stageWage.getProjectName());
        common.setProjectReferenceId(stageWage.getProjectReferenceId());
        common.setHasFuturePayments(Boolean.valueOf(stageWage.isHasFuturePayments()));
        common.setAmountAvailableWithoutFuturePayments(stageWage.getAmountAvailableWithoutFuturePayments());
        common.setAmountOverall(stageWage.getWageAvailableOverallSum());
        common.setAmountPaid(stageWage.getPaidWagesSum());
        common.setAmountAvailable(stageWage.getWageAvailableOverallSum());
        common.setAmountAvailableWithoutAccountingMonth(stageWage.getWageAvailableOverallWithoutAccountingMonthSum());
        common.setAmountAvailableWithoutThisMonth(stageWage.getWageAvailableOverallWithoutThisMonthSum());
        common.setAmountAvailableWithoutPayrollMonth(stageWage.getWageAvailableOverallWithoutPayrollMonth());
        Iterable details = this.mapQuotationWageDetail(stageWage.getDetails());
        common.setDetails(details);
        return common;
    }

    @Nonnull
    private Iterable<QuotationWageDetailCommon> mapQuotationWageDetail(@NonNull Iterable<QuotationWageDetail> details) {
        if (details == null) {
            throw new NullPointerException("details is marked non-null but is null");
        }
        return (Iterable)IterableHelper.stream(details).map(arg_0 -> this.mapQuotationWageDetail(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private QuotationWageDetailCommon mapQuotationWageDetail(@NonNull QuotationWageDetail detail) {
        if (detail == null) {
            throw new NullPointerException("detail is marked non-null but is null");
        }
        QuotationWageDetailCommon common = new QuotationWageDetailCommon();
        common.setMeasurementNumber(detail.getMeasurementNumber());
        common.setIncentiveWageOverall(detail.getIncentiveWageOverall());
        common.setAccountingMonth(detail.getAccountingMonth());
        return common;
    }

    @Nonnull
    private PayrollMonthBusinessUnitStatisticsCommon mapBusinessUnit(@NonNull Iterable<PayrollMonthBusinessUnitStatistic> payrollMonthStatistics) {
        if (payrollMonthStatistics == null) {
            throw new NullPointerException("payrollMonthStatistics is marked non-null but is null");
        }
        ImmutableList commons = (ImmutableList)IterableHelper.stream(payrollMonthStatistics).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return new PayrollMonthBusinessUnitStatisticsCommon(Iterables.size((Iterable)commons), (List)commons);
    }

    @Nonnull
    private PayrollMonthBusinessUnitStatisticCommon map(@NonNull PayrollMonthBusinessUnitStatistic payrollMonthStatistic) {
        if (payrollMonthStatistic == null) {
            throw new NullPointerException("payrollMonthStatistic is marked non-null but is null");
        }
        return PayrollMonthBusinessUnitStatisticCommon.of((String)((String)payrollMonthStatistic.getId()), (String)payrollMonthStatistic.getName(), (int)payrollMonthStatistic.getExpected(), (int)payrollMonthStatistic.getAvailable(), (BigDecimal)payrollMonthStatistic.getPercent(), (String)payrollMonthStatistic.getCostCenter());
    }

    @Nonnull
    private PayrollMonthLaborUnionContractStatisticsCommon mapLaborUnionContract(@NonNull Iterable<PayrollMonthLaborUnionContractStatistic> payrollMonthStatistics) {
        if (payrollMonthStatistics == null) {
            throw new NullPointerException("payrollMonthStatistics is marked non-null but is null");
        }
        ImmutableList commons = (ImmutableList)IterableHelper.stream(payrollMonthStatistics).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return new PayrollMonthLaborUnionContractStatisticsCommon(Iterables.size((Iterable)commons), (List)commons);
    }

    @Nonnull
    private PayrollMonthLaborUnionContractStatisticCommon map(@NonNull PayrollMonthLaborUnionContractStatistic payrollMonthStatistic) {
        if (payrollMonthStatistic == null) {
            throw new NullPointerException("payrollMonthStatistic is marked non-null but is null");
        }
        return PayrollMonthLaborUnionContractStatisticCommon.of((long)((Long)payrollMonthStatistic.getId()), (String)payrollMonthStatistic.getName(), (int)payrollMonthStatistic.getExpected(), (int)payrollMonthStatistic.getAvailable(), (BigDecimal)payrollMonthStatistic.getPercent());
    }

    public PayrollMonthMapper(AttendanceMapper attendanceMapper, PayrollMonthItemMapper payrollMonthItemMapper, WageAccountMapper wageAccountMapper) {
        this.attendanceMapper = attendanceMapper;
        this.payrollMonthItemMapper = payrollMonthItemMapper;
        this.wageAccountMapper = wageAccountMapper;
    }
}

