/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.measurement.MeasurementPositionCommon;
import de.qfm.erp.service.helper.IMeasurementComparators;
import de.qfm.erp.service.helper.MapperHelper;
import de.qfm.erp.service.helper.MeasurementHelper;
import de.qfm.erp.service.model.internal.measurement.MeasurementPositionUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.security.UserService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MeasurementPositionMapper {
    private static final Logger log = LogManager.getLogger(MeasurementPositionMapper.class);
    private final UserService userService;

    @Nonnull
    public List<MeasurementPositionCommon> map(@NonNull List<MeasurementPosition> measurementPositions) {
        if (measurementPositions == null) {
            throw new NullPointerException("measurementPositions is marked non-null but is null");
        }
        boolean allAttributesVisible = this.userService.hasPrivilege(EPrivilege.MEASUREMENT__ALL_ATTRIBUTES_VISIBLE);
        boolean accountingMonthVisible = this.userService.hasPrivilege(EPrivilege.MEASUREMENT_POSITION__ACCOUNTING_MONTH__VISIBLE);
        return ImmutableList.copyOf(measurementPositions.stream().map((? super T item) -> this.map(item, allAttributesVisible, accountingMonthVisible)).sorted(IMeasurementComparators.MEASUREMENT_POSITION_COMMON_COMPARATOR).iterator());
    }

    @Nonnull
    public MeasurementPositionCommon map(@NonNull MeasurementPosition measurementPosition, boolean allAttributesVisible, boolean accountingMonthVisible) {
        EPositionType positionType;
        QuotationPosition quotationPosition;
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        MeasurementPositionCommon measurementPositionCommon = new MeasurementPositionCommon();
        BaseMapper.map((EntityBase)measurementPosition, (EntityBaseCommon)measurementPositionCommon);
        measurementPositionCommon.setId(measurementPosition.getId());
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getReferenceId(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setReferenceId(arg_0));
        measurementPositionCommon.setAddendumNumber(MeasurementHelper.addendumNumber((MeasurementPosition)measurementPosition, (boolean)false));
        Measurement measurement = measurementPosition.getMeasurement();
        if (null != measurement) {
            measurementPositionCommon.setMeasurementId(measurement.getId());
        }
        if (null != (quotationPosition = measurementPosition.getQuotationPosition())) {
            BaseMapper.apply(() -> ((QuotationPosition)quotationPosition).getId(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setPositionId(arg_0));
            BaseMapper.apply(() -> ((QuotationPosition)quotationPosition).getReferenceId(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setQuotationPositionReferenceId(arg_0));
            if (allAttributesVisible) {
                BaseMapper.apply(() -> ((QuotationPosition)quotationPosition).getOrderedAmount(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setOrderedAmount(arg_0));
            }
        }
        String positionTypeName = null != (positionType = measurementPosition.getPositionType()) ? positionType.name() : EPositionType.UNKNOWN.name();
        BaseMapper.apply(() -> positionTypeName, arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setPositionType(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getAmount(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setAmount(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getFactor1(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setFactor1(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getFactor2(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setFactor2(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getFactor3(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setFactor3(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getRemarks(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setRemarks(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getProduct(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setProduct(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getSurrogatePositionNumber(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setSurrogatePositionNumber(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getQuotationPositionNumber(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setPositionNumber(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getPositionNumberExternal(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setPositionNumberExternal(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getQuotationSubPositionNumber(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setSubPositionNumber(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getFlagAlternativePosition(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setFlagAlternativePosition(arg_0));
        EAlternativePositionType alternativePositionType = (EAlternativePositionType)MoreObjects.firstNonNull((Object)measurementPosition.getAlternativePositionType(), (Object)EAlternativePositionType.NO);
        measurementPositionCommon.setAlternativePositionType(alternativePositionType.name());
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getShortText(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setShortText(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getLongText(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setLongText(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getGroupingElementLevel1(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setGroupingElementLevel1(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getGroupingElementLevel2(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setGroupingElementLevel2(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getGroupingElementLevel3(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setGroupingElementLevel3(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getGroupingElementLevel4(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setGroupingElementLevel4(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getFlagCancel(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setFlagCancel(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getUnit(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setUnit(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getUnitAmount(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setUnitAmount(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getArticleCode(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setArticleCode(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getArticleName(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setArticleName(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getSupplierCode(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setSupplierCode(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getSequenceNumberMeasurementStandard(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setSequenceNumberMeasurementStandard(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getSequenceNumberMeasurementTransposed(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setSequenceNumberMeasurementTransposed(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getColumnIndexTransposed(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setTransposedSortIndex(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getSequenceNumberInvoice(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setSequenceNumberInvoice(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getInternalSquadWagePerUnit(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setSquadWagePerUnit(arg_0), (Object)BigDecimal.ZERO);
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getInternalSquadWageAggregated(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setSquadWageAggregated(arg_0), (Object)BigDecimal.ZERO);
        if (allAttributesVisible) {
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getInternalWagePerUnit(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setWagePerUnit(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getInternalWageAggregated(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setInternalWageAggregated(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getCompanyWageAggregated(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setCompanyWageAggregated(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getCompanyWageAggregatedDiscount(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setCompanyWageAggregatedDiscount(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getCompanyWagePerUnit(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setCompanyWagePerUnit(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getDiscount(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setDiscount(arg_0));
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getOtherDiscount(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setOtherDiscount(arg_0));
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getMaterialPercentage(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setMaterialPercentage(arg_0));
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getWagePercentage(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setWagePercentage(arg_0));
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getExternalServicePercentage(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setExternalServicePercentage(arg_0));
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getMaterialPurchasePriceIncludingDiscountPerUnit(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setMaterialPurchasePricePerUnit(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getMaterialPurchasePriceIncludingDiscountAggregated(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setMaterialPurchasePriceAggregated(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getFlagFlatRate(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setFlagFlatRate(arg_0));
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getMaterialSellingPricePerUnit(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setMaterialSellingPricePerUnit(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getMaterialSellingPriceAggregated(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setMaterialSellingPriceAggregated(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getMaterialSellingPriceAggregatedDiscount(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setMaterialSellingPriceAggregatedDiscount(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getPricePerUnit(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setPricePerUnit(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getPricePerUnit(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setOverallPricePerItem(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getPriceAggregated(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setPriceAggregated(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getPriceAggregatedDiscount(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setPriceAggregatedDiscount(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getExternalServicePurchasePricePerUnit(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setExternalServicePurchasePricePerUnit(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getExternalServicePurchasePriceAggregated(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setExternalServicePurchasePriceAggregated(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getExternalServiceSellingPricePerUnit(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setExternalServiceSellingPricePerUnit(arg_0), (Object)BigDecimal.ZERO);
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getExternalServiceSellingPriceAggregated(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setExternalServiceSellingPriceAggregated(arg_0), (Object)BigDecimal.ZERO);
        }
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getFlagFeePosition(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setFlagFeePosition(arg_0));
        BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getFlagNotInQuotation(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setFlagNotInQuotation(arg_0));
        if (accountingMonthVisible) {
            BaseMapper.apply(() -> ((MeasurementPosition)measurementPosition).getAccountingMonth(), arg_0 -> ((MeasurementPositionCommon)measurementPositionCommon).setAccountingMonth(arg_0));
        }
        return measurementPositionCommon;
    }

    @Nonnull
    public MeasurementPosition mergeMeasurementPositionUpdateItem(@NonNull MeasurementPositionUpdateBucket measurementPositionUpdateBucket) {
        if (measurementPositionUpdateBucket == null) {
            throw new NullPointerException("measurementPositionUpdateBucket is marked non-null but is null");
        }
        return this.mergeMeasurementPositionIntern(measurementPositionUpdateBucket);
    }

    @Nonnull
    private MeasurementPosition mergeMeasurementPositionIntern(@NonNull MeasurementPositionUpdateBucket measurementPositionUpdateBucket) {
        if (measurementPositionUpdateBucket == null) {
            throw new NullPointerException("measurementPositionUpdateBucket is marked non-null but is null");
        }
        MeasurementPosition measurementPosition = measurementPositionUpdateBucket.getMeasurementPosition();
        User assignedUser = measurementPositionUpdateBucket.getAssignedUser();
        measurementPosition.setSurrogatePositionNumber(measurementPositionUpdateBucket.getSurrogatePositionNumber());
        measurementPosition.setAmount(measurementPositionUpdateBucket.getAmount());
        measurementPosition.setFactor1(measurementPositionUpdateBucket.getFactor1());
        measurementPosition.setFactor2(measurementPositionUpdateBucket.getFactor2());
        measurementPosition.setFactor3(measurementPositionUpdateBucket.getFactor3());
        measurementPosition.setRemarks(measurementPositionUpdateBucket.getRemarks());
        boolean hasValuePrivilege = this.userService.hasPrivilege(EPrivilege.MEASUREMENT_POSITION__ACCOUNTING_MONTH__VISIBLE);
        if (hasValuePrivilege) {
            measurementPosition.setAccountingMonth(measurementPositionUpdateBucket.getAccountingMonth());
        }
        measurementPosition.setSequenceNumberMeasurementStandard(measurementPositionUpdateBucket.getSequenceNumberMeasurementStandard());
        measurementPosition.setSequenceNumberMeasurementTransposed(measurementPositionUpdateBucket.getSequenceNumberMeasurementTransposed());
        measurementPosition.setColumnIndexTransposed(measurementPositionUpdateBucket.getTransposedSortIndex());
        measurementPosition.setAssignedUser(assignedUser);
        return measurementPosition;
    }

    @Nonnull
    public MeasurementPosition mergeQuotationPositionIntoMeasurementPosition(@NonNull MeasurementPosition measurementPosition, @NonNull QuotationPosition quotationPosition, @Nullable QuotationPosition jumboQuotationPosition) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        Quotation quotation = quotationPosition.getQuotation();
        measurementPosition.setAddendumNumber(quotation.getAddendumNumber());
        measurementPosition.setQuotation(quotation);
        measurementPosition.setQuotationPosition(quotationPosition);
        QuotationPosition oldJumbo = measurementPosition.getJumboQuotationPosition();
        if (null == oldJumbo) {
            measurementPosition.setJumboQuotationPosition(jumboQuotationPosition);
            if (null != jumboQuotationPosition) {
                measurementPosition.setJumboPositionUnit(jumboQuotationPosition.getUnit());
                measurementPosition.setJumboPositionSurrogatePositionNumber(jumboQuotationPosition.getSurrogatePositionNumber());
                measurementPosition.setJumboPositionPricePerUnit(jumboQuotationPosition.getPricePerUnit());
                measurementPosition.setJumboPositionShortText(jumboQuotationPosition.getShortText());
            }
        }
        measurementPosition.setFlagNotInQuotation(Boolean.valueOf(false));
        measurementPosition.setQuotationPositionNumber(quotationPosition.getPositionNumber());
        measurementPosition.setQuotationSubPositionNumber(quotationPosition.getSubPositionNumber());
        measurementPosition.setPositionNumberExternal(quotationPosition.getPositionNumberExternal());
        measurementPosition.setGroupingElementLevel1(quotationPosition.getGroupingElementLevel1());
        measurementPosition.setGroupingElementLevel2(quotationPosition.getGroupingElementLevel2());
        measurementPosition.setGroupingElementLevel3(quotationPosition.getGroupingElementLevel3());
        measurementPosition.setGroupingElementLevel4(quotationPosition.getGroupingElementLevel4());
        measurementPosition.setUnit(quotationPosition.getUnit());
        measurementPosition.setShortText(quotationPosition.getShortText());
        measurementPosition.setLongText(quotationPosition.getLongText());
        measurementPosition.setPricePerUnit(quotationPosition.getPricePerUnit());
        measurementPosition.setCompanyWagePerUnit(quotationPosition.getCompanyWagePerItem());
        measurementPosition.setCompanyWageAggregated(quotationPosition.getCompanyWageAggregated());
        measurementPosition.setMaterialPurchasePriceDiscount(quotationPosition.getMaterialWholesalePriceDiscount());
        measurementPosition.setMaterialPurchasePriceIncludingDiscountPerUnit(quotationPosition.getMaterialWholesalePriceIncludingDiscountPerItem());
        measurementPosition.setMaterialPurchasePriceExcludingDiscountPerUnit(quotationPosition.getMaterialWholesalePriceExcludingDiscountPerItem());
        measurementPosition.setMaterialPurchasePriceIncludingDiscountAggregated(quotationPosition.getMaterialWholesalePriceIncludingDiscountAggregated());
        measurementPosition.setMaterialPurchasePriceExcludingDiscountAggregated(quotationPosition.getMaterialWholesalePriceExcludingDiscountAggregated());
        measurementPosition.setMaterialSellingPricePerUnit(quotationPosition.getMaterialSellingPricePerUnit());
        measurementPosition.setInternalWagePerUnit(quotationPosition.getWagePerUnit());
        measurementPosition.setInternalSquadWagePerUnit(quotationPosition.getSquadWagePerUnit());
        measurementPosition.setWagePercentage(quotationPosition.getWagePercentage());
        measurementPosition.setExternalServicePercentage(quotationPosition.getExternalServicePercentage());
        measurementPosition.setMaterialPercentage(quotationPosition.getMaterialPercentage());
        measurementPosition.setAggregatedPercentage(quotationPosition.getAggregatedPercentage());
        measurementPosition.setExternalServicePurchasePricePerUnit(quotationPosition.getExternalServicePurchasePricePerUnit());
        measurementPosition.setExternalServiceSellingPricePerUnit(quotationPosition.getExternalServiceSellingPricePerUnit());
        measurementPosition.setFlagFeePosition(quotationPosition.getFlagFeePosition());
        measurementPosition.setFlagAlternativePosition(quotationPosition.getFlagAlternativePosition());
        measurementPosition.setAlternativePositionType(quotationPosition.getAlternativePositionType());
        measurementPosition.setFlagFlatRate(quotationPosition.getFlagFlatRate());
        measurementPosition.setPositionType(quotationPosition.getPositionType());
        return measurementPosition;
    }

    @Nonnull
    public MeasurementPosition mergeMeasurementPosition(@NonNull MeasurementPosition source, @NonNull MeasurementPosition destination, @NonNull QuotationPosition quotationPosition, @Nullable QuotationPosition jumboPosition, @NonNull LocalDate headerAccountingMonth, boolean optionCopyAmounts, boolean flagMeasurementTransposed) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        if (headerAccountingMonth == null) {
            throw new NullPointerException("headerAccountingMonth is marked non-null but is null");
        }
        destination.setSequenceNumberInvoice(null);
        destination.setInvoice(null);
        destination.setSequenceNumberMeasurementStandard(MapperHelper.safeInteger((Integer)source.getSequenceNumberMeasurementStandard()));
        destination.setSequenceNumberMeasurementTransposed(MapperHelper.safeInteger((Integer)source.getSequenceNumberMeasurementTransposed()));
        destination.setColumnIndexTransposed(MapperHelper.safeInteger((Integer)source.getColumnIndexTransposed()));
        destination.setAssignedUser(source.getAssignedUser());
        if (optionCopyAmounts) {
            destination.setAmount(source.getAmount());
            destination.setFactor1(source.getFactor1());
            destination.setFactor2(source.getFactor2());
            destination.setFactor3(source.getFactor3());
            destination.setRemarks(source.getRemarks());
            destination.setAccountingMonth(source.getAccountingMonth());
        } else if (flagMeasurementTransposed) {
            destination.setRemarks(source.getRemarks());
            destination.setAccountingMonth(headerAccountingMonth);
        } else {
            destination.setRemarks("");
            destination.setAccountingMonth(headerAccountingMonth);
        }
        this.mergeQuotationPositionIntoMeasurementPosition(destination, quotationPosition, jumboPosition);
        return destination;
    }

    public MeasurementPositionMapper(UserService userService) {
        this.userService = userService;
    }
}

