/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.helper.InvoiceHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.MeasurementHelper;
import de.qfm.erp.service.model.internal.invoice.CumulativePrintBucket;
import de.qfm.erp.service.model.internal.print.CompanyPrintInfo;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementCumulativePrintGroup;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementCumulativePrintInfo;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementCumulativePrintRow;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.User;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MeasurementCumulativePrintMapper {
    private static final Logger log = LogManager.getLogger(MeasurementCumulativePrintMapper.class);

    @Nonnull
    public MeasurementCumulativePrintInfo printInfo(@NonNull ConfigurationCompany sender, @NonNull Invoice primaryInvoice, @NonNull CumulativePrintBucket cumulativePrintBucket) {
        User primaryResponsibleUser;
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (primaryInvoice == null) {
            throw new NullPointerException("primaryInvoice is marked non-null but is null");
        }
        if (cumulativePrintBucket == null) {
            throw new NullPointerException("cumulativePrintBucket is marked non-null but is null");
        }
        Quotation quotation = primaryInvoice.getQuotation();
        Iterable cumulativeInvoices = cumulativePrintBucket.getCumulativeInvoices();
        MeasurementCumulativePrintInfo printInfo = new MeasurementCumulativePrintInfo();
        printInfo.setCumulativePrint(cumulativePrintBucket.isOptionCumulativePrint());
        printInfo.setCurrency(Currency.getInstance(Locale.GERMANY));
        printInfo.setInvoiceName(StringUtils.trimToEmpty((String)primaryInvoice.getInvoiceName()));
        printInfo.setInvoiceNumber(StringUtils.trimToEmpty((String)primaryInvoice.getInvoiceNumber()));
        if (null != quotation) {
            printInfo.setQuotationNumber(StringUtils.trimToEmpty((String)quotation.getQuotationNumber()));
            printInfo.setContactPerson(StringUtils.trimToEmpty((String)quotation.getContactPersonOld()));
            printInfo.setOrderDate(quotation.getOrderDate());
            printInfo.setOrderNumber(StringUtils.trimToEmpty((String)quotation.getOrderNumber()));
            printInfo.setOrderDescription(StringUtils.trimToEmpty((String)quotation.getOrderDescription()));
            printInfo.setCustomerNumber(StringUtils.trimToEmpty((String)quotation.getFinanceDebtorAccountNumber()));
        }
        if (null != (primaryResponsibleUser = primaryInvoice.getPrimaryResponsibleUser())) {
            printInfo.setPrimaryResponsibleUserId(primaryResponsibleUser.getId());
            printInfo.setPrimaryResponsibleUserFullName(StringUtils.trimToEmpty((String)primaryResponsibleUser.getFullName()));
        }
        printInfo.setCostCenter(StringUtils.trimToEmpty((String)primaryInvoice.getCostCenter()));
        EInvoiceType invoiceType = (EInvoiceType)MoreObjects.firstNonNull((Object)primaryInvoice.getInvoiceType(), (Object)EInvoiceType.UNKNOWN);
        printInfo.setInvoiceType(invoiceType);
        printInfo.setInvoiceTypeComment(StringUtils.trimToEmpty((String)primaryInvoice.getInvoiceTypeComment()));
        printInfo.setInvoiceDate(primaryInvoice.getInvoiceDate());
        printInfo.setAccountingDate(primaryInvoice.getPostingDate());
        printInfo.setOrderNumber(StringUtils.trimToEmpty((String)primaryInvoice.getOrderNumber()));
        printInfo.setOrderDate(primaryInvoice.getOrderDate());
        printInfo.setVoucherNumber(StringUtils.trimToEmpty((String)primaryInvoice.getVoucherNumber()));
        printInfo.setCreditVoucherNumber(StringUtils.trimToEmpty((String)primaryInvoice.getCreditVoucherNumber()));
        printInfo.setConstructionSite(StringUtils.trimToEmpty((String)primaryInvoice.getConstructionSite()));
        printInfo.setProjectExecutionStartDate(primaryInvoice.getProjectExecutionStartDate());
        printInfo.setProjectExecutionEndDate(primaryInvoice.getProjectExecutionEndDate());
        CompanyPrintInfo senderCompanyInfo = this.sender(sender);
        printInfo.setSenderPrintInfo(senderCompanyInfo);
        CompanyPrintInfo recipient = this.recipient(primaryInvoice);
        printInfo.setRecipientPrintInfo(recipient);
        ImmutableList allInvoices = ImmutableList.builder().add((Object)primaryInvoice).addAll(cumulativeInvoices).build();
        List printGroups = this.printGroups((Iterable)allInvoices, cumulativePrintBucket.isOptionCumulativePrint(), cumulativePrintBucket.isOptionCumulativePrintConsiderRemarks());
        printInfo.setMeasurementCumulativePrintGroups((Iterable)printGroups);
        Iterable invoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)primaryInvoice.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        Iterable measurements = InvoiceHelper.measurements((Iterable)invoiceMeasurements);
        List measurementNumbers = (List)Streams.stream((Iterable)measurements).map(Measurement::getMeasurementNumber).collect(ImmutableList.toImmutableList());
        printInfo.setMeasurementNumbers((Iterable)measurementNumbers);
        return printInfo;
    }

    @Nonnull
    private List<MeasurementCumulativePrintGroup> printGroups(@NonNull Iterable<Invoice> allInvoices, boolean isCumulativePrint, boolean considerRemarks) {
        if (allInvoices == null) {
            throw new NullPointerException("allInvoices is marked non-null but is null");
        }
        ArrayListMultimap measurementPositionsByKey = ArrayListMultimap.create();
        for (Invoice invoice : allInvoices) {
            Set invoicePositions = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoicePositions(), (Object)ImmutableSet.of());
            for (InvoicePosition invoicePosition : invoicePositions) {
                Measurement measurement;
                MeasurementPosition measurementPosition = invoicePosition.getMeasurementPosition();
                if (null == measurementPosition || null == (measurement = measurementPosition.getMeasurement())) continue;
                String key = this.key(measurementPosition, considerRemarks);
                measurementPositionsByKey.put((Object)key, (Object)measurementPosition);
            }
        }
        ImmutableSet allKeys = ImmutableSet.copyOf((Collection)Sets.newTreeSet((Iterable)measurementPositionsByKey.keySet()));
        ImmutableList.Builder printGroupBuilder = ImmutableList.builder();
        for (String key : allKeys) {
            Collection measurementPositions = measurementPositionsByKey.get((Object)key);
            BigDecimal product = measurementPositions.stream().map(MeasurementHelper.FN_JUMBO_PROD).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BigDecimalHelper.anyZero((BigDecimal[])new BigDecimal[]{product})) continue;
            List printRows = this.printRows((Iterable)measurementPositions, isCumulativePrint, product);
            MeasurementCumulativePrintGroup invoicePositionPrintGroup = MeasurementCumulativePrintGroup.of((String)key, (BigDecimal)product, (Iterable)printRows);
            printGroupBuilder.add((Object)invoicePositionPrintGroup);
        }
        return printGroupBuilder.build();
    }

    @Nonnull
    private String key(@NonNull MeasurementPosition measurementPosition, boolean considerRemarks) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        EPositionType positionType = measurementPosition.getPositionType();
        String spn = EPositionType.JUMBO_INTERNAL_TYPE_A == positionType || EPositionType.JUMBO_INTERNAL_TYPE_B == positionType ? measurementPosition.getJumboPositionSurrogatePositionNumber() : StringUtils.trimToEmpty((String)measurementPosition.getSurrogatePositionNumber());
        String remark = considerRemarks ? StringUtils.trimToEmpty((String)StringUtils.lowerCase((String)measurementPosition.getRemarks())) : "";
        return StringUtils.join((Object[])new Serializable[]{spn, remark, Character.valueOf('_')});
    }

    @Nonnull
    private List<MeasurementCumulativePrintRow> printRows(@NonNull Iterable<MeasurementPosition> measurementPositions, boolean isCumulativePrint, @NonNull BigDecimal product) {
        if (measurementPositions == null) {
            throw new NullPointerException("measurementPositions is marked non-null but is null");
        }
        if (product == null) {
            throw new NullPointerException("product is marked non-null but is null");
        }
        ImmutableList.Builder printRowsBuilder = ImmutableList.builder();
        if (!BigDecimalHelper.anyZero((BigDecimal[])new BigDecimal[]{product})) {
            if (!isCumulativePrint) {
                int i = 0;
                for (MeasurementPosition measurementPosition : measurementPositions) {
                    int n = i++;
                    this.standardPrintRow(n, measurementPosition).ifPresent(arg_0 -> ((ImmutableList.Builder)printRowsBuilder).add(arg_0));
                }
            } else {
                printRowsBuilder.addAll(this.cumulativePrintRows(measurementPositions, product));
            }
        }
        return printRowsBuilder.build();
    }

    @Nonnull
    private Optional<MeasurementCumulativePrintRow> standardPrintRow(int index, @NonNull MeasurementPosition measurementPosition) {
        Measurement measurement;
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        if (!BigDecimalHelper.anyZero((BigDecimal[])new BigDecimal[]{measurementPosition.getProduct()}) && null != (measurement = measurementPosition.getMeasurement())) {
            MeasurementCumulativePrintRow printRow = new MeasurementCumulativePrintRow();
            printRow.setIndex(index);
            printRow.setMeasurementNumber(measurement.getMeasurementNumber());
            EPositionType positionType = measurementPosition.getPositionType();
            if (EPositionType.JUMBO_INTERNAL_TYPE_A == positionType) {
                BigDecimal priceAggregated = measurementPosition.getPriceAggregated();
                this.applyBigDecimal(() -> priceAggregated, arg_0 -> ((MeasurementCumulativePrintRow)printRow).setAmount(arg_0));
                this.applyBigDecimal(() -> priceAggregated, arg_0 -> ((MeasurementCumulativePrintRow)printRow).setProduct(arg_0));
                this.applyBigDecimal(() -> null, arg_0 -> ((MeasurementCumulativePrintRow)printRow).setFactor1(arg_0));
                this.applyBigDecimal(() -> null, arg_0 -> ((MeasurementCumulativePrintRow)printRow).setFactor2(arg_0));
                this.applyBigDecimal(() -> null, arg_0 -> ((MeasurementCumulativePrintRow)printRow).setFactor3(arg_0));
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionSurrogatePositionNumber(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setSurrogatePositionNumber(arg_0));
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionUnit(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setUnit(arg_0));
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionShortText(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setShortText(arg_0));
            } else if (EPositionType.JUMBO_INTERNAL_TYPE_B == positionType) {
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionSurrogatePositionNumber(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setSurrogatePositionNumber(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getAmount(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setAmount(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getFactor1(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setFactor1(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getFactor2(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setFactor2(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getFactor3(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setFactor3(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getProduct(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setProduct(arg_0));
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getUnit(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setUnit(arg_0));
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getShortText(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setShortText(arg_0));
            } else {
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getSurrogatePositionNumber(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setSurrogatePositionNumber(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getAmount(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setAmount(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getFactor1(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setFactor1(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getFactor2(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setFactor2(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getFactor3(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setFactor3(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getProduct(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setProduct(arg_0));
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getUnit(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setUnit(arg_0));
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getShortText(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setShortText(arg_0));
            }
            this.applyString(() -> ((MeasurementPosition)measurementPosition).getRemarks(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setRemarks(arg_0));
            return Optional.of(printRow);
        }
        return Optional.empty();
    }

    @Nonnull
    private Iterable<MeasurementCumulativePrintRow> cumulativePrintRows(@NonNull Iterable<MeasurementPosition> measurementPositions, @NonNull BigDecimal product) {
        if (measurementPositions == null) {
            throw new NullPointerException("measurementPositions is marked non-null but is null");
        }
        if (product == null) {
            throw new NullPointerException("product is marked non-null but is null");
        }
        if (!BigDecimalHelper.anyZero((BigDecimal[])new BigDecimal[]{product})) {
            ImmutableList.Builder measurementCumulativePrintRowBuilder = ImmutableList.builder();
            Multimap amountPerMNR = MapsHelper.map(measurementPositions, item -> item.getMeasurement().getMeasurementNumber(), (Function)MeasurementHelper.FN_JUMBO_PROD);
            ImmutableSortedSet measurementNumbersSorted = ImmutableSortedSet.copyOf((Collection)amountPerMNR.keySet());
            Iterator<MeasurementPosition> iterator = measurementPositions.iterator();
            if (iterator.hasNext()) {
                MeasurementPosition measurementPosition = iterator.next();
                int i = 0;
                boolean first = true;
                for (String measurementNumber : measurementNumbersSorted) {
                    BigDecimal amount = amountPerMNR.get((Object)measurementNumber).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                    MeasurementCumulativePrintRow printRow = new MeasurementCumulativePrintRow();
                    printRow.setIndex(i++);
                    printRow.setMeasurementNumber(measurementNumber);
                    printRow.setProduct(amount);
                    if (first) {
                        EPositionType positionType = measurementPosition.getPositionType();
                        if (EPositionType.JUMBO_INTERNAL_TYPE_A == positionType) {
                            this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionSurrogatePositionNumber(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setSurrogatePositionNumber(arg_0));
                            this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionUnit(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setUnit(arg_0));
                            this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionShortText(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setShortText(arg_0));
                        } else if (EPositionType.JUMBO_INTERNAL_TYPE_B == positionType) {
                            this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionSurrogatePositionNumber(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setSurrogatePositionNumber(arg_0));
                            this.applyString(() -> ((MeasurementPosition)measurementPosition).getUnit(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setUnit(arg_0));
                            this.applyString(() -> ((MeasurementPosition)measurementPosition).getShortText(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setShortText(arg_0));
                        } else {
                            this.applyString(() -> ((MeasurementPosition)measurementPosition).getSurrogatePositionNumber(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setSurrogatePositionNumber(arg_0));
                            this.applyString(() -> ((MeasurementPosition)measurementPosition).getUnit(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setUnit(arg_0));
                            this.applyString(() -> ((MeasurementPosition)measurementPosition).getShortText(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setShortText(arg_0));
                        }
                        this.applyString(() -> ((MeasurementPosition)measurementPosition).getRemarks(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setRemarks(arg_0));
                    } else {
                        printRow.setSurrogatePositionNumber("");
                        printRow.setUnit("");
                        printRow.setShortText("");
                        this.applyString(() -> ((MeasurementPosition)measurementPosition).getRemarks(), arg_0 -> ((MeasurementCumulativePrintRow)printRow).setRemarks(arg_0));
                    }
                    measurementCumulativePrintRowBuilder.add((Object)printRow);
                    first = false;
                }
            }
            return measurementCumulativePrintRowBuilder.build();
        }
        return ImmutableList.of();
    }

    @Nonnull
    private CompanyPrintInfo sender(@NonNull ConfigurationCompany configurationCompany) {
        if (configurationCompany == null) {
            throw new NullPointerException("configurationCompany is marked non-null but is null");
        }
        CompanyPrintInfo companyPrintInfo = new CompanyPrintInfo();
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyName1(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName1(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyName2(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName2(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyStreet(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreet(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyStreetNo(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreetNo(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyCity(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerCity(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyZipCode(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerZipCode(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyEmail(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerEmail(arg_0));
        return companyPrintInfo;
    }

    @Nonnull
    private CompanyPrintInfo recipient(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        CompanyPrintInfo companyPrintInfo = new CompanyPrintInfo();
        this.applyString(() -> ((Invoice)invoice).getInvoiceName(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName1(arg_0));
        this.applyString(() -> ((Invoice)invoice).getInvoiceAddressSuffix(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName1(arg_0));
        this.applyString(() -> ((Invoice)invoice).getInvoiceStreet(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreet(arg_0));
        this.applyString(() -> ((Invoice)invoice).getInvoiceCity(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerCity(arg_0));
        this.applyString(() -> ((Invoice)invoice).getInvoiceZip(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerZipCode(arg_0));
        return companyPrintInfo;
    }

    private void applyString(@NonNull Supplier<String> supplier, @NonNull Consumer<String> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(StringUtils.trimToEmpty((String)supplier.get()));
    }

    private void applyBigDecimal(@NonNull Supplier<BigDecimal> supplier, @NonNull Consumer<BigDecimal> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(supplier.get());
    }
}

