/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.contract.LaborUnionWageGroupCommon;
import de.qfm.erp.common.response.contract.LaborUnionWageGroupListCommon;
import de.qfm.erp.common.response.contract.LaborUnionWageGroupRateCommon;
import de.qfm.erp.common.response.contract.LaborUnionWageGroupRateListCommon;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroup;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroupRate;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaborUnionWageGroupMapper {
    public static final Ordering<Comparable> NAME_ASCENDING = Ordering.natural().nullsLast();
    public static final Ordering<Comparable> DATE_DESCENDING = Ordering.natural().reverse();
    @Autowired
    private ApplicationConfig applicationConfig;

    @Nonnull
    public LaborUnionWageGroupCommon map(@NonNull LaborUnionWageGroup item, @NonNull Predicate<LaborUnionWageGroupRate> wageGroupRateFilter) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (wageGroupRateFilter == null) {
            throw new NullPointerException("wageGroupRateFilter is marked non-null but is null");
        }
        LaborUnionWageGroupCommon common = new LaborUnionWageGroupCommon();
        BaseMapper.map((EntityBase)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        common.setReferenceId(item.getReferenceId());
        common.setName(item.getName());
        LaborUnionContract laborUnionContract = item.getLaborUnionContract();
        if (null != laborUnionContract) {
            common.setLaborUnionContractId(laborUnionContract.getId());
        }
        Set wageGroupRates = (Set)MoreObjects.firstNonNull((Object)item.getWageGroupRates(), (Object)ImmutableSet.of());
        LaborUnionWageGroupRateListCommon laborUnionWageGroupRateListCommon = this.mapWageGroupRates((Iterable)wageGroupRates, wageGroupRateFilter);
        common.setWageGroupRates(laborUnionWageGroupRateListCommon);
        return common;
    }

    @Nonnull
    public LaborUnionWageGroupListCommon map(@NonNull Iterable<LaborUnionWageGroup> laborUnionWageGroups, @NonNull Predicate<LaborUnionWageGroupRate> wageGroupRateFilter) {
        if (laborUnionWageGroups == null) {
            throw new NullPointerException("laborUnionWageGroups is marked non-null but is null");
        }
        if (wageGroupRateFilter == null) {
            throw new NullPointerException("wageGroupRateFilter is marked non-null but is null");
        }
        int size = Iterables.size(laborUnionWageGroups);
        ImmutableList laborUnionWageGroupsSorted = (ImmutableList)IterableHelper.stream(laborUnionWageGroups).sorted((l, r) -> NAME_ASCENDING.compare((Object)l.getName(), (Object)r.getName())).collect(ImmutableList.toImmutableList());
        List itemsCommon = (List)IterableHelper.stream((Iterable)laborUnionWageGroupsSorted).map(item -> this.map(item, wageGroupRateFilter)).collect(ImmutableList.toImmutableList());
        return new LaborUnionWageGroupListCommon(size, itemsCommon);
    }

    @Nonnull
    public LaborUnionWageGroupRateCommon mapWageGroupRate(@NonNull LaborUnionWageGroupRate entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        LaborUnionWageGroupRateCommon common = new LaborUnionWageGroupRateCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        common.setReferenceId(entity.getReferenceId());
        common.setName(entity.getName());
        common.setWageRatePerHour(entity.getWageRatePerHour());
        LocalDate validBegin = entity.getValidBegin();
        common.setValidBegin(validBegin);
        LocalDate validEnd = entity.getValidEnd();
        if (!Objects.equals(this.applicationConfig.getDefaultEndDate(), validEnd)) {
            common.setValidEnd(validEnd);
        } else {
            common.setValidEnd(null);
        }
        LaborUnionWageGroup laborUnionWageGroup = entity.getLaborUnionWageGroup();
        if (null != laborUnionWageGroup) {
            common.setLaborUnionWageGroupId(laborUnionWageGroup.getId());
        }
        return common;
    }

    @Nonnull
    public LaborUnionWageGroupRateListCommon mapWageGroupRates(@NonNull Iterable<LaborUnionWageGroupRate> laborUnionWageGroupRates, @NonNull Predicate<LaborUnionWageGroupRate> wageGroupRateFilter) {
        if (laborUnionWageGroupRates == null) {
            throw new NullPointerException("laborUnionWageGroupRates is marked non-null but is null");
        }
        if (wageGroupRateFilter == null) {
            throw new NullPointerException("wageGroupRateFilter is marked non-null but is null");
        }
        int size = Iterables.size(laborUnionWageGroupRates);
        ImmutableList laborUnionWageGroupRatesSorted = (ImmutableList)IterableHelper.stream(laborUnionWageGroupRates).sorted((l, r) -> DATE_DESCENDING.compare((Object)l.getValidBegin(), (Object)r.getValidBegin())).collect(ImmutableList.toImmutableList());
        List itemsCommon = (List)IterableHelper.stream((Iterable)laborUnionWageGroupRatesSorted).filter(wageGroupRateFilter).map(arg_0 -> this.mapWageGroupRate(arg_0)).collect(ImmutableList.toImmutableList());
        return new LaborUnionWageGroupRateListCommon(size, itemsCommon);
    }

    public LaborUnionWageGroupMapper(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }
}

