/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.leancoders.common.response.PageCommon;
import de.qfm.erp.common.request.invoice.InvoiceModificationRequest;
import de.qfm.erp.common.request.invoice.InvoicePositionUpdateItem;
import de.qfm.erp.common.request.invoice.InvoiceSupplementUpdateItem;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.invoice.ClosingInvoiceCommon;
import de.qfm.erp.common.response.invoice.ClosingInvoiceListCommon;
import de.qfm.erp.common.response.invoice.CreditVoucherImportResultCommon;
import de.qfm.erp.common.response.invoice.CreditVoucherImportResultListCommon;
import de.qfm.erp.common.response.invoice.InvoiceAddendumDiscountCommon;
import de.qfm.erp.common.response.invoice.InvoiceAttachmentCommon;
import de.qfm.erp.common.response.invoice.InvoiceAttachmentListCommon;
import de.qfm.erp.common.response.invoice.InvoiceCommon;
import de.qfm.erp.common.response.invoice.InvoiceMeasurementAutoCompleteItemCommon;
import de.qfm.erp.common.response.invoice.InvoiceMeasurementAutoCompleteResponse;
import de.qfm.erp.common.response.invoice.InvoiceMeasurementCommon;
import de.qfm.erp.common.response.invoice.InvoicePageCommon;
import de.qfm.erp.common.response.invoice.InvoicePositionsCommon;
import de.qfm.erp.common.response.invoice.InvoiceSupplementCommon;
import de.qfm.erp.common.response.invoice.NewInvoiceAutoCompleteItemCommon;
import de.qfm.erp.common.response.invoice.NewInvoiceAutoCompleteResponse;
import de.qfm.erp.common.response.project.ProjectCommon;
import de.qfm.erp.common.response.search.InvoiceSearchItem;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.helper.CustomerHelper;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.helper.InvoiceHelper;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.invoice.AddendumDiscount;
import de.qfm.erp.service.model.internal.invoice.CreditVoucherImportResult;
import de.qfm.erp.service.model.internal.invoice.DailySaleOutInvoice;
import de.qfm.erp.service.model.internal.invoice.EImportResultType;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.internal.invoice.InvoicePdfExtraction;
import de.qfm.erp.service.model.internal.invoice.InvoicePositionUpdateBucket;
import de.qfm.erp.service.model.internal.invoice.InvoicePositionsUpdateBucket;
import de.qfm.erp.service.model.internal.invoice.InvoiceSupplementUpdateBucket;
import de.qfm.erp.service.model.internal.invoice.InvoiceUpdateBucket;
import de.qfm.erp.service.model.internal.search.Highlight;
import de.qfm.erp.service.model.internal.search.InvoiceSearchItemBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.filestore.FileStore;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceAttachmentType;
import de.qfm.erp.service.model.jpa.invoice.EInvoicePositionType;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceSource;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.InvoiceAddendumDiscount;
import de.qfm.erp.service.model.jpa.invoice.InvoiceAttachment;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.model.jpa.invoice.InvoiceSupplement;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.measurement.InvoiceMeasurement;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementViewType;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.InvoiceIndexEntry;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.HighlightMapper;
import de.qfm.erp.service.service.mapper.InvoiceMapper;
import de.qfm.erp.service.service.mapper.InvoicePositionMapper;
import de.qfm.erp.service.service.mapper.MeasurementMapper;
import de.qfm.erp.service.service.mapper.ProjectMapper;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class InvoiceMapper {
    private static final Logger log = LogManager.getLogger(InvoiceMapper.class);
    private static final Joiner IMPORT_ERROR_JOINER = Joiner.on((String)"\n").skipNulls();
    private final AuthenticationHelper authenticationHelper;
    private final ConfigService configService;
    private final MessageService messageService;
    private final EntityFactory entityFactory;
    private final InvoicePositionMapper invoicePositionMapper;
    private final HighlightMapper highlightMapper;
    private final ProjectMapper projectMapper;
    private final UserService userService;
    private final CompanyConfig companyConfig;
    private static final BiConsumer<InvoicePosition, InvoicePositionUpdateBucket> NO_CALLBACK_IPM = (x, y) -> {};
    private static final BiConsumer<InvoiceSupplement, InvoiceSupplementUpdateBucket> NO_CALLBACK_ISM = (x, y) -> {};

    @Nonnull
    public InvoiceCommon map(@NonNull Invoice item, @NonNull Function<Invoice, Boolean> closingInvoiceFN) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (closingInvoiceFN == null) {
            throw new NullPointerException("closingInvoiceFN is marked non-null but is null");
        }
        return this.map(item, true, true, true, true, closingInvoiceFN);
    }

    @Nonnull
    public InvoiceCommon map(@NonNull Invoice entity, boolean includeMeasurement, boolean includePositions, boolean includeClosingPositionIds, boolean includeAttachments, @NonNull Function<Invoice, Boolean> closingInvoiceFN) {
        User er2ExportedByUser;
        User printedByUser;
        User assignedSquad;
        User primaryResponsibleUser;
        Quotation stage;
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (closingInvoiceFN == null) {
            throw new NullPointerException("closingInvoiceFN is marked non-null but is null");
        }
        InvoiceCommon invoiceCommon = new InvoiceCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)invoiceCommon);
        invoiceCommon.setId(entity.getId());
        invoiceCommon.setInvoiceNumber(StringUtils.trimToEmpty((String)entity.getInvoiceNumber()));
        invoiceCommon.setContactPerson(entity.getContactPerson());
        invoiceCommon.setOrderDate(entity.getOrderDate());
        invoiceCommon.setOrderDescription(entity.getOrderDescription());
        invoiceCommon.setOrderNumber(entity.getOrderNumber());
        invoiceCommon.setInvoiceDate(entity.getInvoiceDate());
        invoiceCommon.setPostingDate(entity.getPostingDate());
        invoiceCommon.setVoucherNumber(entity.getVoucherNumber());
        invoiceCommon.setCreditVoucherNumber(entity.getCreditVoucherNumber());
        invoiceCommon.setInternalPartialNumber(entity.getInternalPartialFinalNumber());
        invoiceCommon.setCumulativeNumber(entity.getCumulativeNumber());
        invoiceCommon.setCostCenter(entity.getCostCenter());
        invoiceCommon.setConstructionSite(entity.getConstructionSite());
        invoiceCommon.setProjectExecutionStartDate(entity.getProjectExecutionStartDate());
        invoiceCommon.setProjectExecutionEndDate(entity.getProjectExecutionEndDate());
        invoiceCommon.setImportErrors(entity.getImportErrors());
        invoiceCommon.setImportFileName(entity.getImportFileName());
        invoiceCommon.setAdditionalInfoHeader1(entity.getAdditionalInfoHeader1());
        invoiceCommon.setAdditionalInfoDetail1(entity.getAdditionalInfoDetail1());
        invoiceCommon.setAdditionalInfoHeader2(entity.getAdditionalInfoHeader2());
        invoiceCommon.setAdditionalInfoDetail2(entity.getAdditionalInfoDetail2());
        invoiceCommon.setAdditionalInfoHeader3(entity.getAdditionalInfoHeader3());
        invoiceCommon.setAdditionalInfoDetail3(entity.getAdditionalInfoDetail3());
        invoiceCommon.setAttachments(entity.getAttachments());
        invoiceCommon.setAdditionalAttachments(entity.getAdditionalAttachments());
        invoiceCommon.setFooterText(entity.getFooterText());
        EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)entity.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
        invoiceCommon.setInvoiceState(invoiceState.name());
        invoiceCommon.setInvoiceStateSince(entity.getInvoiceStateSince());
        EInvoiceType invoiceType = (EInvoiceType)MoreObjects.firstNonNull((Object)entity.getInvoiceType(), (Object)EInvoiceType.UNKNOWN);
        invoiceCommon.setInvoiceType(invoiceType.name());
        invoiceCommon.setInvoiceTypeComment(entity.getInvoiceTypeComment());
        EInvoiceSource invoiceSource = (EInvoiceSource)MoreObjects.firstNonNull((Object)entity.getInvoiceSource(), (Object)EInvoiceSource.UNKNOWN);
        invoiceCommon.setInvoiceSource(invoiceSource.name());
        Address invoiceAddress = entity.getInvoiceAddress();
        if (null != invoiceAddress) {
            invoiceCommon.setInvoiceAddressId(invoiceAddress.getId());
        }
        invoiceCommon.setInvoiceName(entity.getInvoiceName());
        invoiceCommon.setInvoiceAddressSuffix(entity.getInvoiceAddressSuffix());
        invoiceCommon.setInvoicePoBox(entity.getInvoicePoBox());
        invoiceCommon.setInvoiceStreet(entity.getInvoiceStreet());
        invoiceCommon.setInvoiceStreetNo(entity.getInvoiceStreetNo());
        invoiceCommon.setInvoiceZip(entity.getInvoiceZip());
        invoiceCommon.setInvoiceCity(entity.getInvoiceCity());
        invoiceCommon.setInvoiceCountry(entity.getInvoiceCountry());
        invoiceCommon.setInvoiceEmail(entity.getInvoiceEmail());
        invoiceCommon.setInvoicePortal(entity.getInvoicePortal());
        invoiceCommon.setInvoiceRemarks(entity.getInvoiceRemarks());
        Address invoiceRefAddress = entity.getInvoiceRefAddress();
        if (null != invoiceRefAddress) {
            invoiceCommon.setInvoiceRefAddressId(invoiceRefAddress.getId());
        }
        invoiceCommon.setInvoiceRefName(entity.getInvoiceRefName());
        invoiceCommon.setInvoiceRefAddressSuffix(entity.getInvoiceRefAddressSuffix());
        invoiceCommon.setInvoiceRefPoBox(entity.getInvoiceRefPoBox());
        invoiceCommon.setInvoiceRefStreet(entity.getInvoiceRefStreet());
        invoiceCommon.setInvoiceRefStreetNo(entity.getInvoiceRefStreetNo());
        invoiceCommon.setInvoiceRefZip(entity.getInvoiceRefZip());
        invoiceCommon.setInvoiceRefCity(entity.getInvoiceRefCity());
        invoiceCommon.setInvoiceRefCountry(entity.getInvoiceRefCountry());
        invoiceCommon.setInvoiceRefEmail(entity.getInvoiceRefEmail());
        invoiceCommon.setInvoiceRefPortal(entity.getInvoiceRefPortal());
        invoiceCommon.setInvoiceRefRemarks(entity.getInvoiceRefRemarks());
        invoiceCommon.setFinanceCompanyNumber(entity.getFinanceCompanyNumber());
        invoiceCommon.setFinanceAccountingText(entity.getFinanceAccountingText());
        invoiceCommon.setFinanceTimeForPayment(entity.getFinanceTimeForPayment());
        invoiceCommon.setFinanceCashDiscountTime1(entity.getFinanceCashDiscountTime1());
        invoiceCommon.setFinanceCashDiscount1(entity.getFinanceCashDiscount1());
        invoiceCommon.setFinanceCashDiscountTime2(entity.getFinanceCashDiscountTime2());
        invoiceCommon.setFinanceCashDiscount2(entity.getFinanceCashDiscount2());
        invoiceCommon.setFinanceDebtorAccountNumber(entity.getFinanceDebtorAccountNumber());
        invoiceCommon.setFinanceRoutingReferenceId(entity.getFinanceRoutingReferenceId());
        TaxKey financeTaxKey = entity.getFinanceTaxKey();
        if (null != financeTaxKey) {
            invoiceCommon.setFinanceTaxKeyId(financeTaxKey.getId());
        }
        invoiceCommon.setFinanceTaxKeyValue(entity.getFinanceTaxKeyValue());
        invoiceCommon.setFinanceAccount(entity.getFinanceAccount());
        invoiceCommon.setVatPercent(entity.getVatPercent());
        invoiceCommon.setVatValue(entity.getVatValue());
        invoiceCommon.setFlagSecurityRetention((Boolean)MoreObjects.firstNonNull((Object)entity.getFlagSecurityRetention(), (Object)Boolean.FALSE));
        invoiceCommon.setSubtotalWithoutDiscountValueNet(entity.getSubtotalWithoutDiscountValueNet());
        invoiceCommon.setSubtotalWithDiscountValueNet(entity.getSubtotalWithDiscountValueNet());
        invoiceCommon.setTotalDiscountValueNet(entity.getTotalDiscountValueNet());
        invoiceCommon.setTotalValueNet(entity.getTotalValueNet());
        invoiceCommon.setTotalValueGross(entity.getTotalValueGross());
        invoiceCommon.setVatPercent(entity.getVatPercent());
        invoiceCommon.setVatValue(entity.getVatValue());
        invoiceCommon.setInvoiceDueValueGross(entity.getInvoiceDueValueGross());
        invoiceCommon.setWarrantySecurityRetentionPercent(entity.getWarrantySecurityRetentionPercent());
        invoiceCommon.setWarrantySecurityRetentionValue(entity.getWarrantySecurityRetentionValue());
        invoiceCommon.setFulfillmentSecurityRetentionPercent(entity.getFulfillmentSecurityRetentionPercent());
        invoiceCommon.setFulfillmentSecurityRetentionValue(entity.getFulfillmentSecurityRetentionValue());
        invoiceCommon.setFulfillmentSecurityRetentionCumulativeValue(entity.getFulfillmentSecurityRetentionCumulativeValue());
        invoiceCommon.setInternalWageOverall(entity.getInternalWageOverall());
        invoiceCommon.setSquadWageOverall(entity.getSquadWageOverall());
        invoiceCommon.setCompanyWageOverall(entity.getCompanyWageOverall());
        invoiceCommon.setMaterialPurchasePriceOverall(entity.getMaterialPurchasePriceOverall());
        invoiceCommon.setMaterialSellingPriceOverall(entity.getMaterialSellingPriceOverall());
        invoiceCommon.setExternalServicePurchasePriceOverall(entity.getExternalServicePurchasePriceOverall());
        invoiceCommon.setExternalServiceSellingPriceOverall(entity.getExternalServiceSellingPriceOverall());
        invoiceCommon.setExpectPDFValueOverallNet(entity.getExpectedPDFValueOverallNet());
        invoiceCommon.setExpectPDFVAT(entity.getExpectedPDFVAT());
        invoiceCommon.setExpectPDFValueOverallVAT(entity.getExpectedPDFValueOverallVAT());
        invoiceCommon.setExpectPDFValueOverallGross(entity.getExpectedPDFValueOverallGross());
        invoiceCommon.setGeneralDiscount(entity.getGeneralDiscount());
        invoiceCommon.setOtherDiscount(entity.getOtherDiscount());
        invoiceCommon.setFlagClosed((Boolean)MoreObjects.firstNonNull((Object)entity.getFlagClosed(), (Object)false));
        invoiceCommon.setClosedOn(entity.getClosedOn());
        Invoice closedByInvoice = entity.getClosedByInvoice();
        if (null != closedByInvoice) {
            invoiceCommon.setClosedByInvoiceId(closedByInvoice.getId());
            invoiceCommon.setClosedByInvoiceNumber(StringUtils.trimToEmpty((String)closedByInvoice.getInvoiceNumber()));
        } else {
            invoiceCommon.setClosedByInvoiceNumber("");
        }
        User closedByUser = entity.getClosedByUser();
        if (null != closedByUser) {
            invoiceCommon.setClosedByUserId(closedByUser.getId());
            invoiceCommon.setClosedByUserFullName(StringUtils.trimToEmpty((String)closedByUser.getFullName()));
        } else {
            invoiceCommon.setClosedByUserFullName("");
        }
        Invoice referencedByInvoice = entity.getReferencedByInvoice();
        if (null != referencedByInvoice) {
            invoiceCommon.setReferenceInvoiceId(referencedByInvoice.getId());
            EInvoiceType referencedInvoiceType = (EInvoiceType)MoreObjects.firstNonNull((Object)referencedByInvoice.getInvoiceType(), (Object)EInvoiceType.UNKNOWN);
            invoiceCommon.setReferenceInvoiceType(referencedInvoiceType.name());
            invoiceCommon.setReferenceInvoiceNumber(referencedByInvoice.getInvoiceNumber());
        }
        invoiceCommon.setCancellationDebitNote(entity.getCancellationDebitNote());
        invoiceCommon.setCancellationRemarks(entity.getCancellationRemarks());
        invoiceCommon.setCancellationDate(entity.getCancellationDate());
        invoiceCommon.setCancellationPeriod(entity.getCancellationPeriod());
        invoiceCommon.setOptionPrint13bParagraph(entity.getOptionPrint13bParagraph());
        invoiceCommon.setOptionPrintSubcontractorParagraph(entity.getOptionPrintSubcontractorParagraph());
        invoiceCommon.setOptionPrintStromnetzParagraph(entity.getOptionPrintStromnetzParagraph());
        invoiceCommon.setOptionCumulativePrint(entity.getOptionCumulativePrint());
        invoiceCommon.setOptionMeasurementPrint(entity.getOptionMeasurementPrint());
        invoiceCommon.setOptionMeasurementCumulativePrint(entity.getOptionMeasurementCumulativePrint());
        if (includeClosingPositionIds) {
            Iterable closingInvoices = (Iterable)MoreObjects.firstNonNull((Object)entity.getClosedInvoices(), (Object)ImmutableSet.of());
            List closingInvoiceCommons = this.mapClosingInvoice(closingInvoices, closingInvoiceFN).getItems();
            invoiceCommon.setClosingInvoices(closingInvoiceCommons);
        }
        if (includeAttachments) {
            Iterable invoiceAttachments = (Iterable)MoreObjects.firstNonNull((Object)entity.getInvoiceAttachments(), (Object)ImmutableSet.of());
            List invoiceAttachmentCommons = this.mapInvoiceAttachments(invoiceAttachments).getItems();
            invoiceCommon.setInvoiceAttachments(invoiceAttachmentCommons);
        }
        invoiceCommon.setMeasurementNumbers(entity.getMeasurementNumbers());
        if (includeMeasurement) {
            Iterable invoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)entity.getInvoiceMeasurements(), (Object)ImmutableSet.of());
            List measurementCommons = (List)Streams.stream((Iterable)invoiceMeasurements).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
            invoiceCommon.setMeasurements(measurementCommons);
            ImmutableList measurementIds = (ImmutableList)Streams.stream((Iterable)invoiceMeasurements).map(InvoiceMeasurement::getMeasurement).filter(Objects::nonNull).map(Measurement::getId).collect(ImmutableList.toImmutableList());
            invoiceCommon.setMeasurementIds((List)measurementIds);
        }
        if (null != (stage = entity.getQuotation())) {
            invoiceCommon.setQuotationId(stage.getId());
            invoiceCommon.setQuotationNumber(stage.getQuotationNumber());
            invoiceCommon.setStageId(stage.getId());
            invoiceCommon.setAlias(stage.getAlias());
            invoiceCommon.setQentityNumber(stage.getQNumber());
            invoiceCommon.setStageVersion(stage.getVersion());
            Project project = stage.getProject();
            if (null != project) {
                ProjectCommon projectCommon = this.projectMapper.map(project);
                invoiceCommon.setProject(projectCommon);
            }
        }
        if (includePositions) {
            Iterable invoicePositions = (Iterable)MoreObjects.firstNonNull((Object)entity.getInvoicePositions(), (Object)ImmutableSet.of());
            InvoicePositionsCommon invoicePositionsCommon = this.invoicePositionMapper.map(invoicePositions);
            invoiceCommon.setInvoicePositions(invoicePositionsCommon);
        }
        if (null != (primaryResponsibleUser = entity.getPrimaryResponsibleUser())) {
            invoiceCommon.setPrimaryResponsibleUserId(primaryResponsibleUser.getId());
            invoiceCommon.setPrimaryResponsibleUserFullName(primaryResponsibleUser.getFullName());
        }
        if (null != (assignedSquad = entity.getAssignedSquad())) {
            invoiceCommon.setAssignedSquadId(assignedSquad.getId());
            invoiceCommon.setAssignedSquadFullName(assignedSquad.getFullName());
        }
        if (null != (printedByUser = entity.getPrintedByUser())) {
            invoiceCommon.setPrintedByUserId(printedByUser.getId());
            invoiceCommon.setPrintedByUserFullName(printedByUser.getFullName());
        }
        invoiceCommon.setPrintedOn(entity.getPrintedOn());
        User accountedByUser = entity.getAccountedByUser();
        if (null != accountedByUser) {
            invoiceCommon.setAccountedByUserId(accountedByUser.getId());
            invoiceCommon.setAccountedByUserFullName(accountedByUser.getFullName());
        }
        if (null != (er2ExportedByUser = entity.getEr2ExportedBy())) {
            invoiceCommon.setEr2ExportedByUserId(er2ExportedByUser.getId());
            invoiceCommon.setEr2ExportedByUserFullName(er2ExportedByUser.getFullName());
        }
        invoiceCommon.setEr2ExportedOn(entity.getEr2ExportedOn());
        invoiceCommon.setPaymentConditions(StringUtils.trimToEmpty((String)entity.getPaymentConditions()));
        Set invoiceAddendumDiscounts = (Set)MoreObjects.firstNonNull((Object)entity.getInvoiceAddendumDiscounts(), (Object)ImmutableSet.of());
        Iterable invoiceAddendumDiscountsCommon = this.mapInvoiceAddendumDiscounts((Iterable)invoiceAddendumDiscounts);
        invoiceCommon.setInvoiceAddendumDiscounts((List)ImmutableList.copyOf((Iterable)invoiceAddendumDiscountsCommon));
        Set invoiceSupplements = (Set)MoreObjects.firstNonNull((Object)entity.getInvoiceSupplements(), (Object)ImmutableSet.of());
        Iterable invoiceSupplementCommons = this.mapInvoiceSupplements((Iterable)invoiceSupplements);
        invoiceCommon.setInvoiceSupplements((List)ImmutableList.copyOf((Iterable)invoiceSupplementCommons));
        return invoiceCommon;
    }

    @Nonnull
    public Iterable<InvoiceAddendumDiscountCommon> mapInvoiceAddendumDiscounts(@NonNull Iterable<InvoiceAddendumDiscount> invoiceAddendumDiscounts) {
        if (invoiceAddendumDiscounts == null) {
            throw new NullPointerException("invoiceAddendumDiscounts is marked non-null but is null");
        }
        return (Iterable)Streams.stream(invoiceAddendumDiscounts).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public InvoiceAddendumDiscountCommon map(@NonNull InvoiceAddendumDiscount invoiceAddendumDiscount) {
        if (invoiceAddendumDiscount == null) {
            throw new NullPointerException("invoiceAddendumDiscount is marked non-null but is null");
        }
        InvoiceAddendumDiscountCommon invoiceAddendumDiscountCommon = (InvoiceAddendumDiscountCommon)BaseMapper.map((EntityBase)invoiceAddendumDiscount, (EntityBaseCommon)new InvoiceAddendumDiscountCommon());
        invoiceAddendumDiscountCommon.setAddendumNumber(invoiceAddendumDiscount.getAddendumNumber());
        invoiceAddendumDiscountCommon.setPercent(invoiceAddendumDiscount.getPercent());
        invoiceAddendumDiscountCommon.setValueNet(invoiceAddendumDiscount.getValueNet());
        return invoiceAddendumDiscountCommon;
    }

    @Nonnull
    public Iterable<InvoiceSupplementCommon> mapInvoiceSupplements(@NonNull Iterable<InvoiceSupplement> invoiceSupplements) {
        if (invoiceSupplements == null) {
            throw new NullPointerException("invoiceSupplements is marked non-null but is null");
        }
        return (Iterable)Streams.stream(invoiceSupplements).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public InvoiceSupplementCommon map(@NonNull InvoiceSupplement invoiceSupplement) {
        if (invoiceSupplement == null) {
            throw new NullPointerException("invoiceSupplement is marked non-null but is null");
        }
        InvoiceSupplementCommon invoiceSupplementCommon = (InvoiceSupplementCommon)BaseMapper.map((EntityBase)invoiceSupplement, (EntityBaseCommon)new InvoiceSupplementCommon());
        invoiceSupplementCommon.setId(invoiceSupplement.getId());
        invoiceSupplementCommon.setName(invoiceSupplement.getName());
        invoiceSupplementCommon.setPercent(invoiceSupplement.getPercent());
        invoiceSupplementCommon.setValue(invoiceSupplement.getValue());
        Invoice invoice = invoiceSupplement.getInvoice();
        if (null != invoice) {
            invoiceSupplementCommon.setInvoiceId(invoice.getId());
        }
        return invoiceSupplementCommon;
    }

    @Nonnull
    public InvoiceMeasurementCommon map(@NonNull InvoiceMeasurement invoiceMeasurement) {
        Quotation quotation;
        if (invoiceMeasurement == null) {
            throw new NullPointerException("invoiceMeasurement is marked non-null but is null");
        }
        InvoiceMeasurementCommon common = new InvoiceMeasurementCommon();
        Measurement measurement = invoiceMeasurement.getMeasurement();
        BaseMapper.map((EntityBase)measurement, (EntityBaseCommon)common);
        common.setId(measurement.getId());
        common.setMeasurementNumber(measurement.getMeasurementNumber());
        String measurementViewType = ((EMeasurementViewType)MoreObjects.firstNonNull((Object)measurement.getMeasurementViewType(), (Object)EMeasurementViewType.STANDARD)).getValue();
        common.setMeasurementViewType(measurementViewType);
        String measurementType = ((EMeasurementType)MoreObjects.firstNonNull((Object)measurement.getMeasurementType(), (Object)EMeasurementType.NONE)).getValue();
        common.setMeasurementType(measurementType);
        String measurementState = MeasurementMapper.measurementStateToCommon((Measurement)measurement);
        common.setMeasurementState(measurementState);
        User assignedUser = measurement.getAssignedUser();
        if (null != assignedUser) {
            common.setAssignedUserId(assignedUser.getId());
            common.setAssignedUserFullName(assignedUser.getFullName());
            LocalDate projectExecutionStartDate = measurement.getProjectExecutionStartDate();
            if (null != projectExecutionStartDate) {
                String cc = EmployeeHelper.currentUserCostCenterNotFailing((User)assignedUser, (LocalDate)projectExecutionStartDate).map(UserCostCenter::getCostCenter).orElse("");
                common.setAssignedUserCostCenter(cc);
            }
        }
        if (null != (quotation = measurement.getQuotation())) {
            common.setQuotationId(quotation.getId());
            common.setQuotationNumber(quotation.getQuotationNumber());
            common.setStageId(quotation.getId());
            common.setAlias(quotation.getAlias());
            common.setQentityNumber(quotation.getQNumber());
        }
        common.setConstructionSite(measurement.getConstructionSite());
        common.setRemarks(measurement.getRemarks());
        common.setPersonResponsibleAtCustomer(measurement.getPersonResponsibleAtCustomer());
        common.setCustomerArea(measurement.getCustomerArea());
        common.setProjectExecutionStartDate(measurement.getProjectExecutionStartDate());
        common.setProjectExecutionEndDate(measurement.getProjectExecutionEndDate());
        common.setAccountingMonth(measurement.getAccountingMonth());
        if (this.userService.hasPrivilege(EPrivilege.MEASUREMENT__ALL_ATTRIBUTES_VISIBLE)) {
            common.setValueOverall(measurement.getValueOverall());
            common.setMaterialPurchasePriceOverall(measurement.getMaterialPurchasePriceOverall());
            common.setCompanyWageOverall(measurement.getCompanyWageOverall());
        }
        common.setWageOverall(measurement.getWageOverall());
        common.setSquadWageOverall(measurement.getSquadWageOverall());
        return common;
    }

    @Nonnull
    public InvoicePageCommon map(@NonNull Page<Invoice> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        long totalElements = page.getTotalElements();
        int totalPages = page.getTotalPages();
        Pageable pageable = page.getPageable();
        int pageSize = pageable.getPageSize();
        int pageNumber = pageable.getPageNumber();
        List content = page.getContent();
        List itemsCommon = (List)content.stream().map((? super T item) -> this.map(item, false, false, false, false, x -> false)).collect(ImmutableList.toImmutableList());
        return new InvoicePageCommon(pageNumber, pageSize, totalPages, totalElements, itemsCommon);
    }

    @Nonnull
    public Invoice merge(@NonNull InvoiceUpdateBucket updateBucket, @NonNull InvoicePositionsUpdateBucket invoicePositionsUpdateBucket) {
        boolean isNew;
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        if (invoicePositionsUpdateBucket == null) {
            throw new NullPointerException("invoicePositionsUpdateBucket is marked non-null but is null");
        }
        User authenticatedUser = this.userService.authenticatedUser();
        Invoice invoice = (Invoice)updateBucket.getEntity();
        InvoiceModificationRequest request = (InvoiceModificationRequest)updateBucket.getRequest();
        Quotation stage = updateBucket.getStage();
        boolean bl = isNew = null == invoice.getId();
        if (isNew) {
            Iterable addendumDiscounts = updateBucket.getAddendumDiscounts();
            this.refreshStageData(invoice, addendumDiscounts);
        }
        invoice.setInvoiceType(updateBucket.getInvoiceType());
        invoice.setInvoiceTypeComment(StringUtils.trimToEmpty((String)request.getInvoiceTypeComment()));
        invoice.setQuotation(stage);
        invoice.setPrimaryResponsibleUser(updateBucket.getPrimaryResponsibleUser());
        invoice.setAssignedSquad(updateBucket.getAssignedSquad());
        invoice.setPaymentConditions(StringUtils.trimToEmpty((String)request.getPaymentConditions()));
        invoice.setCostCenter(StringUtils.trimToEmpty((String)request.getCostCenter()));
        invoice.setVoucherNumber(StringUtils.trimToEmpty((String)request.getVoucherNumber()));
        invoice.setContactPerson(StringUtils.trimToEmpty((String)request.getContactPerson()));
        invoice.setOrderDate(request.getOrderDate());
        invoice.setOrderDescription(StringUtils.trimToEmpty((String)request.getOrderDescription()));
        invoice.setOrderNumber(StringUtils.trimToEmpty((String)request.getOrderNumber()));
        invoice.setConstructionSite(StringUtils.trimToEmpty((String)request.getConstructionSite()));
        invoice.setProjectExecutionStartDate(request.getProjectExecutionStartDate());
        invoice.setProjectExecutionEndDate(request.getProjectExecutionEndDate());
        invoice.setInvoiceAddress(updateBucket.getInvoiceAddress());
        invoice.setInvoiceName(StringUtils.trimToEmpty((String)request.getInvoiceName()));
        invoice.setInvoiceAddressSuffix(StringUtils.trimToEmpty((String)request.getInvoiceAddressSuffix()));
        invoice.setInvoicePoBox(StringUtils.trimToEmpty((String)request.getInvoicePoBox()));
        invoice.setInvoiceStreet(StringUtils.trimToEmpty((String)request.getInvoiceStreet()));
        invoice.setInvoiceStreetNo(StringUtils.trimToEmpty((String)request.getInvoiceStreetNo()));
        invoice.setInvoiceZip(StringUtils.trimToEmpty((String)request.getInvoiceZip()));
        invoice.setInvoiceCity(StringUtils.trimToEmpty((String)request.getInvoiceCity()));
        invoice.setInvoiceCountry(StringUtils.trimToEmpty((String)request.getInvoiceCountry()));
        invoice.setInvoiceEmail(StringUtils.trimToEmpty((String)request.getInvoiceEmail()));
        invoice.setInvoicePortal(StringUtils.trimToEmpty((String)request.getInvoicePortal()));
        invoice.setInvoiceRemarks(StringUtils.trimToEmpty((String)request.getInvoiceRemarks()));
        invoice.setInvoiceRefAddress(updateBucket.getInvoiceRefAddress());
        invoice.setInvoiceRefName(StringUtils.trimToEmpty((String)request.getInvoiceRefName()));
        invoice.setInvoiceRefAddressSuffix(StringUtils.trimToEmpty((String)request.getInvoiceRefAddressSuffix()));
        invoice.setInvoiceRefPoBox(StringUtils.trimToEmpty((String)request.getInvoiceRefPoBox()));
        invoice.setInvoiceRefStreet(StringUtils.trimToEmpty((String)request.getInvoiceRefStreet()));
        invoice.setInvoiceRefStreetNo(StringUtils.trimToEmpty((String)request.getInvoiceRefStreetNo()));
        invoice.setInvoiceRefZip(StringUtils.trimToEmpty((String)request.getInvoiceRefZip()));
        invoice.setInvoiceRefCity(StringUtils.trimToEmpty((String)request.getInvoiceRefCity()));
        invoice.setInvoiceRefCountry(StringUtils.trimToEmpty((String)request.getInvoiceRefCountry()));
        invoice.setInvoiceRefEmail(StringUtils.trimToEmpty((String)request.getInvoiceRefEmail()));
        invoice.setInvoiceRefPortal(StringUtils.trimToEmpty((String)request.getInvoiceRefPortal()));
        invoice.setInvoiceRefRemarks(StringUtils.trimToEmpty((String)request.getInvoiceRefRemarks()));
        invoice.setAdditionalInfoHeader1(StringUtils.trimToEmpty((String)request.getAdditionalInfoHeader1()));
        invoice.setAdditionalInfoDetail1(StringUtils.trimToEmpty((String)request.getAdditionalInfoDetail1()));
        invoice.setAdditionalInfoHeader2(StringUtils.trimToEmpty((String)request.getAdditionalInfoHeader2()));
        invoice.setAdditionalInfoDetail2(StringUtils.trimToEmpty((String)request.getAdditionalInfoDetail2()));
        invoice.setAdditionalInfoHeader3(StringUtils.trimToEmpty((String)request.getAdditionalInfoHeader3()));
        invoice.setAdditionalInfoDetail3(StringUtils.trimToEmpty((String)request.getAdditionalInfoDetail3()));
        invoice.setFinanceAccountingText(StringUtils.trimToEmpty((String)request.getFinanceAccountingText()));
        invoice.setFinanceDebtorAccountNumber(StringUtils.trimToEmpty((String)request.getFinanceDebtorAccountNumber()));
        invoice.setFinanceTimeForPayment(request.getFinanceTimeForPayment());
        invoice.setFinanceCashDiscountTime1(request.getFinanceCashDiscountTime1());
        invoice.setFinanceCashDiscount1(request.getFinanceCashDiscount1());
        invoice.setFinanceCashDiscountTime2(request.getFinanceCashDiscountTime2());
        invoice.setFinanceCashDiscount2(request.getFinanceCashDiscount2());
        invoice.setFinanceRoutingReferenceId(StringUtils.trimToEmpty((String)request.getFinanceRoutingReferenceId()));
        TaxKey taxKey = updateBucket.getTaxKey();
        if (null != taxKey) {
            invoice.setFinanceTaxKey(taxKey);
            invoice.setFinanceTaxKeyValue(StringUtils.trimToEmpty((String)taxKey.getTaxKey()));
            invoice.setFinanceAccount(StringUtils.trimToEmpty((String)taxKey.getAccount()));
            invoice.setVatPercent(taxKey.getVat());
        } else {
            invoice.setFinanceTaxKey(null);
            invoice.setFinanceTaxKeyValue(null);
            invoice.setFinanceAccount(null);
            invoice.setVatPercent(null);
        }
        invoice.setGeneralDiscount(request.getGeneralDiscount());
        invoice.setOtherDiscount(request.getOtherDiscount());
        invoice.setFlagSecurityRetention((Boolean)MoreObjects.firstNonNull((Object)request.getFlagSecurityRetention(), (Object)Boolean.FALSE));
        invoice.setWarrantySecurityRetentionPercent((BigDecimal)MoreObjects.firstNonNull((Object)request.getWarrantySecurityRetentionPercent(), (Object)BigDecimal.ZERO));
        invoice.setFulfillmentSecurityRetentionPercent((BigDecimal)MoreObjects.firstNonNull((Object)request.getFulfillmentSecurityRetentionPercent(), (Object)BigDecimal.ZERO));
        Iterable measurementsToAttach = (Iterable)MoreObjects.firstNonNull((Object)updateBucket.getInvoiceMeasurements(), (Object)ImmutableList.of());
        MergedBucket measurementMergedBucket = BaseMapper.merge((EntityBase)invoice, Invoice::getInvoiceMeasurements, arg_0 -> ((Invoice)invoice).setInvoiceMeasurements(arg_0), (Iterable)measurementsToAttach, InvoiceMeasurement::getId, InvoiceMeasurement::setInvoice);
        MergedBucket.printMergeBucket((Object)invoice, InvoiceMeasurement.class, (MergedBucket)measurementMergedBucket);
        Iterable customPositionMeasurementUpdateBuckets = (Iterable)MoreObjects.firstNonNull((Object)invoicePositionsUpdateBucket.getCustomPositionUpdateBuckets(), (Object)ImmutableList.of());
        Multimap measurementInvoicePositionUpdateBuckets = (Multimap)MoreObjects.firstNonNull((Object)invoicePositionsUpdateBucket.getMeasurementInvoicePositionUpdateBuckets(), (Object)ImmutableMultimap.of());
        Iterable allPositionUpdateBuckets = Iterables.concat((Iterable)customPositionMeasurementUpdateBuckets, (Iterable)measurementInvoicePositionUpdateBuckets.values());
        MergedBucket invoicePositionMeasurementMergedBucket = BaseMapper.merge((EntityBase)invoice, Invoice::getInvoicePositions, arg_0 -> ((Invoice)invoice).setInvoicePositions(arg_0), (Iterable)allPositionUpdateBuckets, InvoicePositionUpdateBucket::getId, InvoicePosition::getId, () -> ((EntityFactory)this.entityFactory).invoicePosition(), (arg_0, arg_1) -> this.mergeInvoicePosition(arg_0, arg_1), InvoicePosition::setInvoice, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NO_CALLBACK_IPM);
        MergedBucket.printMergeBucket((Object)invoice, InvoicePosition.class, (MergedBucket)invoicePositionMeasurementMergedBucket);
        Iterable invoiceAttachmentsToAttach = (Iterable)MoreObjects.firstNonNull((Object)updateBucket.getInvoiceAttachments(), (Object)ImmutableList.of());
        MergedBucket attachmentMergedBucket = BaseMapper.merge((EntityBase)invoice, Invoice::getInvoiceAttachments, arg_0 -> ((Invoice)invoice).setInvoiceAttachments(arg_0), (Iterable)invoiceAttachmentsToAttach, InvoiceAttachment::getId, InvoiceAttachment::setInvoice);
        MergedBucket.printMergeBucket((Object)invoice, InvoiceAttachment.class, (MergedBucket)attachmentMergedBucket);
        HashSet invoicesToBeClosed = Sets.newHashSet((Iterable)updateBucket.getClosedInvoices());
        for (Invoice invoiceToBeClosed : invoicesToBeClosed) {
            invoiceToBeClosed.setFlagClosed(Boolean.TRUE);
            invoiceToBeClosed.setClosedOn(DateTimeHelper.now());
            invoiceToBeClosed.setClosedByUser(authenticatedUser);
        }
        if (null == invoice.getClosedInvoices()) {
            invoice.setClosedInvoices((Set)Sets.newHashSet());
        }
        Set closedInvoicesExisting = invoice.getClosedInvoices();
        ImmutableSet invoicesToBeAdded = ImmutableSet.copyOf((Collection)Sets.difference((Set)invoicesToBeClosed, (Set)closedInvoicesExisting));
        ImmutableSet invoicesToBeUnclosed = ImmutableSet.copyOf((Collection)Sets.difference((Set)closedInvoicesExisting, (Set)invoicesToBeClosed));
        for (Invoice invoiceToBeUnclosed : invoicesToBeUnclosed) {
            invoiceToBeUnclosed.setFlagClosed(Boolean.FALSE);
            invoiceToBeUnclosed.setClosedOn(null);
            invoiceToBeUnclosed.setClosedByUser(null);
        }
        if (!Iterables.isEmpty((Iterable)invoicesToBeAdded)) {
            invoicesToBeAdded.forEach(item -> item.setClosedByInvoice(invoice));
            invoice.getClosedInvoices().addAll(invoicesToBeAdded);
        }
        if (!Iterables.isEmpty((Iterable)invoicesToBeUnclosed)) {
            invoicesToBeUnclosed.forEach(item -> item.setClosedByInvoice(null));
            invoice.getClosedInvoices().removeAll((Collection<?>)invoicesToBeUnclosed);
        }
        Iterable invoiceSupplementUpdateBuckets = (Iterable)MoreObjects.firstNonNull((Object)updateBucket.getInvoiceSupplementUpdateBuckets(), (Object)ImmutableList.of());
        MergedBucket invoiceSupplementMergedBucket = BaseMapper.merge((EntityBase)invoice, Invoice::getInvoiceSupplements, arg_0 -> ((Invoice)invoice).setInvoiceSupplements(arg_0), (Iterable)invoiceSupplementUpdateBuckets, InvoiceSupplementUpdateBucket::getId, InvoiceSupplement::getId, () -> ((EntityFactory)this.entityFactory).invoiceSupplement(), (arg_0, arg_1) -> this.mergeInvoiceSupplement(arg_0, arg_1), InvoiceSupplement::setInvoice, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NO_CALLBACK_ISM);
        MergedBucket.printMergeBucket((Object)invoice, InvoiceSupplement.class, (MergedBucket)invoiceSupplementMergedBucket);
        return invoice;
    }

    private void refreshStageData(@NonNull Invoice invoice, @NonNull Iterable<AddendumDiscount> addendumDiscounts) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (addendumDiscounts == null) {
            throw new NullPointerException("addendumDiscounts is marked non-null but is null");
        }
        Set invoiceAddendumDiscounts = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoiceAddendumDiscounts(), (Object)Sets.newHashSet());
        invoiceAddendumDiscounts.forEach(invoiceAddendumDiscount -> invoiceAddendumDiscount.setInvoice(null));
        invoiceAddendumDiscounts.clear();
        for (AddendumDiscount addendumDiscount : addendumDiscounts) {
            Long addendumNumber = addendumDiscount.getAddendumNumber();
            BigDecimal generalDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)addendumDiscount.getGeneralDiscount(), (Object)BigDecimal.ZERO);
            BigDecimal otherDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)addendumDiscount.getOtherDiscount(), (Object)BigDecimal.ZERO);
            BigDecimal generalAddendumDiscount = generalDiscount.add(otherDiscount);
            InvoiceAddendumDiscount invoiceAddendumDiscount2 = this.entityFactory.invoiceAddendumDiscount();
            invoiceAddendumDiscount2.setAddendumNumber(addendumNumber);
            invoiceAddendumDiscount2.setPercent(generalAddendumDiscount);
            invoiceAddendumDiscount2.setDiscountableValueNet(BigDecimal.ZERO);
            invoiceAddendumDiscount2.setValueNet(BigDecimal.ZERO);
            invoiceAddendumDiscounts.add(invoiceAddendumDiscount2);
        }
        invoice.setInvoiceAddendumDiscounts(invoiceAddendumDiscounts);
        invoiceAddendumDiscounts.forEach(item -> item.setInvoice(invoice));
    }

    @Nonnull
    public InvoicePosition mergeInvoicePosition(@NonNull InvoicePosition entity, @NonNull InvoicePositionUpdateBucket updateBucket) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        InvoicePositionUpdateItem updateItem = updateBucket.getUpdateItem();
        entity.setSequenceNumber(updateItem.getSequenceNumber());
        entity.setInvoicePositionType(updateBucket.getInvoicePositionType());
        entity.setAddendumNumber(updateBucket.getAddendumNumber());
        entity.setDiscount(updateBucket.getDiscount());
        EInvoicePositionType invoicePositionType = updateBucket.getInvoicePositionType();
        if (EInvoicePositionType.MEASUREMENT_POSITION == invoicePositionType) {
            MeasurementPosition measurementPosition = updateBucket.getMeasurementPosition();
            entity.setMeasurementPosition(measurementPosition);
            if (null != measurementPosition) {
                entity.setPositionNumber(measurementPosition.getQuotationPositionNumber());
                entity.setUnit(measurementPosition.getQuotationPositionNumber());
                entity.setShortText(measurementPosition.getQuotationPositionNumber());
                entity.setRemarks(measurementPosition.getQuotationPositionNumber());
                entity.setPricePerUnit(measurementPosition.getPricePerUnit());
                entity.setPriceAggregated(measurementPosition.getPriceAggregated());
                entity.setAmount(measurementPosition.getAmount());
                entity.setFactor1(measurementPosition.getFactor1());
                entity.setFactor2(measurementPosition.getFactor2());
                entity.setFactor3(measurementPosition.getFactor3());
                entity.setProduct(measurementPosition.getProduct());
                entity.setFlagFeePosition(measurementPosition.getFlagFeePosition());
                entity.setMaterialPurchasePricePerUnit(updateItem.getMaterialPurchasePricePerUnit());
                entity.setMaterialFactor(updateItem.getMaterialFactor());
                entity.setMaterialSellingPricePerUnit(updateItem.getMaterialSellingPricePerUnit());
            }
        } else if (EInvoicePositionType.CUSTOM == invoicePositionType) {
            entity.setPositionNumber(StringUtils.trimToEmpty((String)updateItem.getSurrogatePositionNumber()));
            entity.setUnit(StringUtils.trimToEmpty((String)updateItem.getUnit()));
            entity.setShortText(StringUtils.trimToEmpty((String)updateItem.getShortText()));
            entity.setRemarks(StringUtils.trimToEmpty((String)updateItem.getRemarks()));
            entity.setAmount(updateItem.getAmount());
            entity.setFactor1(updateItem.getFactor1());
            entity.setFactor2(updateItem.getFactor2());
            entity.setFactor3(updateItem.getFactor3());
            entity.setProduct(updateItem.getProduct());
            entity.setMaterialPurchasePricePerUnit(updateItem.getMaterialPurchasePricePerUnit());
            entity.setMaterialFactor(updateItem.getMaterialFactor());
            entity.setMaterialSellingPricePerUnit(updateItem.getMaterialSellingPricePerUnit());
            entity.setPricePerUnit(updateItem.getPricePerUnit());
            entity.setPriceAggregated(updateItem.getPriceAggregated());
        }
        return entity;
    }

    @Nonnull
    public InvoiceSupplement mergeInvoiceSupplement(@NonNull InvoiceSupplement entity, @NonNull InvoiceSupplementUpdateBucket updateBucket) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        InvoiceSupplementUpdateItem updateItem = updateBucket.getUpdateItem();
        entity.setValue(BigDecimal.ZERO);
        entity.setPercent((BigDecimal)MoreObjects.firstNonNull((Object)updateItem.getPercent(), (Object)BigDecimal.ZERO));
        entity.setName(StringUtils.trimToEmpty((String)updateItem.getName()));
        return entity;
    }

    @Nonnull
    public InvoiceMeasurementAutoCompleteResponse mapAutoComplete(@NonNull Page<Measurement> measurements) {
        if (measurements == null) {
            throw new NullPointerException("measurements is marked non-null but is null");
        }
        ImmutableList common = (ImmutableList)measurements.stream().map(arg_0 -> this.mapAutoComplete(arg_0)).sorted((l, r) -> StringUtils.compareIgnoreCase((String)l.getMeasurementNumber(), (String)r.getMeasurementNumber())).collect(ImmutableList.toImmutableList());
        return new InvoiceMeasurementAutoCompleteResponse(measurements.getNumberOfElements(), (List)common);
    }

    @Nonnull
    public InvoiceMeasurementAutoCompleteItemCommon mapAutoComplete(@NonNull Measurement measurement) {
        Quotation quotation;
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        InvoiceMeasurementAutoCompleteItemCommon common = new InvoiceMeasurementAutoCompleteItemCommon();
        common.setId(measurement.getId());
        common.setMeasurementNumber(measurement.getMeasurementNumber());
        MeasurementState measurementState = measurement.getMeasurementState();
        EMeasurementState eMeasurementState = measurementState.getMeasurementState();
        String measurementStateString = ((EMeasurementState)MoreObjects.firstNonNull((Object)eMeasurementState, (Object)EMeasurementState.UNKNOWN)).key();
        common.setMeasurementState(measurementStateString);
        String measurementType = ((EMeasurementType)MoreObjects.firstNonNull((Object)measurement.getMeasurementType(), (Object)EMeasurementType.NONE)).getValue();
        common.setMeasurementType(measurementType);
        User assignedUser = measurement.getAssignedUser();
        if (null != assignedUser) {
            common.setAssignedUserId(assignedUser.getId());
            common.setAssignedUserFullName(assignedUser.getFullName());
            LocalDate projectExecutionStartDate = measurement.getProjectExecutionStartDate();
            if (null != projectExecutionStartDate) {
                String cc = EmployeeHelper.currentUserCostCenterNotFailing((User)assignedUser, (LocalDate)projectExecutionStartDate).map(UserCostCenter::getCostCenter).orElse("");
                common.setAssignedUserCostCenter(cc);
            }
        }
        if (null != (quotation = measurement.getQuotation())) {
            common.setQuotationId(quotation.getId());
            common.setQuotationNumber(quotation.getQuotationNumber());
            common.setStageId(quotation.getId());
            common.setAlias(quotation.getAlias());
            common.setQentityNumber(quotation.getQNumber());
        }
        if (Objects.equals(EMeasurementState.ACCOUNTED, eMeasurementState) || Objects.equals(EMeasurementState.IN_ACCOUNTING, eMeasurementState)) {
            Set invoiceMeasurements = (Set)MoreObjects.firstNonNull((Object)measurement.getInvoiceMeasurements(), (Object)ImmutableSet.of());
            Optional<Invoice> foundOne = invoiceMeasurements.stream().map(InvoiceMeasurement::getInvoice).filter(Objects::nonNull).filter(item -> Objects.equals(EInvoiceState.ACCOUNTED, item.getInvoiceState()) || Objects.equals(EInvoiceState.IN_ACCOUNTING, item.getInvoiceState())).findFirst();
            if (foundOne.isPresent()) {
                Invoice invoice = foundOne.get();
                String invoiceNumber = StringUtils.trimToEmpty((String)invoice.getInvoiceNumber());
                common.setBlockedByInvoiceNumber(invoiceNumber);
                EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)invoice.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
                common.setBlockedByInvoiceState(invoiceState.name());
                common.setAvailable(Boolean.valueOf(false));
            }
        } else {
            common.setAvailable(Boolean.valueOf(true));
        }
        return common;
    }

    @Nonnull
    public Invoice merge(@NonNull String originalFilename, @NonNull InvoicePdfExtraction invoicePdfExtraction, @NonNull Optional<TaxKey> taxKeyCandidate, @NonNull Iterable<Measurement> measurements, @NonNull Invoice invoice, @NonNull Iterable<InvoicePosition> invoicePositions, @NonNull Iterable<String> importErrors, @NonNull EInvoiceType invoiceType, @NonNull Iterable<InvoiceAttachment> invoiceAttachments) {
        if (originalFilename == null) {
            throw new NullPointerException("originalFilename is marked non-null but is null");
        }
        if (invoicePdfExtraction == null) {
            throw new NullPointerException("invoicePdfExtraction is marked non-null but is null");
        }
        if (taxKeyCandidate == null) {
            throw new NullPointerException("taxKeyCandidate is marked non-null but is null");
        }
        if (measurements == null) {
            throw new NullPointerException("measurements is marked non-null but is null");
        }
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (invoicePositions == null) {
            throw new NullPointerException("invoicePositions is marked non-null but is null");
        }
        if (importErrors == null) {
            throw new NullPointerException("importErrors is marked non-null but is null");
        }
        if (invoiceType == null) {
            throw new NullPointerException("invoiceType is marked non-null but is null");
        }
        if (invoiceAttachments == null) {
            throw new NullPointerException("invoiceAttachments is marked non-null but is null");
        }
        User authenticatedUser = this.userService.authenticatedUser();
        invoice.setPrimaryResponsibleUser(authenticatedUser);
        EPdfExtractType pdfExtractType = invoicePdfExtraction.getPdfExtractType();
        switch (1.$SwitchMap$de$qfm$erp$service$model$internal$invoice$EPdfExtractType[pdfExtractType.ordinal()]) {
            case 1: {
                invoice.setVoucherNumber(invoicePdfExtraction.getCreditVoucherNumber());
                invoice.setCreditVoucherNumber(invoicePdfExtraction.getVoucherNumber());
                break;
            }
            default: {
                invoice.setVoucherNumber(invoicePdfExtraction.getVoucherNumber());
                invoice.setCreditVoucherNumber(invoicePdfExtraction.getCreditVoucherNumber());
            }
        }
        invoice.setAdditionalInfoDetail3(String.format("PDF: \nNr.1: %s \nNr.2: %s", StringUtils.trimToEmpty((String)invoicePdfExtraction.getOrderNumber1()), StringUtils.trimToEmpty((String)invoicePdfExtraction.getOrderNumber2())));
        invoice.setProjectExecutionStartDate(invoicePdfExtraction.getProjectExecutionFrom());
        invoice.setProjectExecutionEndDate(invoicePdfExtraction.getProjectExecutionEnd());
        invoice.setExpectedPDFValueOverallNet(invoicePdfExtraction.getValueOverallNet());
        invoice.setExpectedPDFVAT(invoicePdfExtraction.getVatPercent());
        invoice.setExpectedPDFValueOverallVAT(invoicePdfExtraction.getValueOverallVAT());
        invoice.setExpectedPDFValueOverallGross(invoicePdfExtraction.getValueOverallGross());
        invoice.setExpectedPDFCostCenter(invoicePdfExtraction.getCostCenter());
        invoice.setImportFileName(originalFilename);
        String importErrorText = StringUtils.left((String)IMPORT_ERROR_JOINER.join(importErrors), (int)2000);
        invoice.setImportErrors(importErrorText);
        HashSet invoiceMeasurements = Sets.newHashSet();
        measurements.forEach(measurement -> {
            measurement.setInvoice(invoice);
            InvoiceMeasurement invoiceMeasurement = this.entityFactory.invoiceMeasurement();
            invoiceMeasurement.setInvoice(invoice);
            invoiceMeasurement.setMeasurement(measurement);
            invoiceMeasurements.add(invoiceMeasurement);
        });
        invoice.setInvoiceMeasurements((Set)invoiceMeasurements);
        invoiceAttachments.forEach(invoiceAttachment -> invoiceAttachment.setInvoice(invoice));
        invoice.setInvoiceAttachments((Set)Sets.newHashSet(invoiceAttachments));
        if (!Iterables.isEmpty(measurements)) {
            Measurement first = (Measurement)Iterables.get(measurements, (int)0);
            if (null != first) {
                User assignedUser = first.getAssignedUser();
                Quotation stage = first.getQuotation();
                LocalDate projectExecutionStartDate = first.getProjectExecutionStartDate();
                invoice.setAssignedSquad(assignedUser);
                invoice.setQuotation(stage);
                String costCenter = EmployeeHelper.currentCostCenterNotFailing((User)assignedUser, (LocalDate)projectExecutionStartDate).orElse("n/a");
                invoice.setCostCenter(costCenter);
                invoice.setConstructionSite(StringUtils.trimToEmpty((String)first.getConstructionSite()));
                if (null != stage) {
                    ContactPerson contactPerson = stage.getContactPerson();
                    if (null != contactPerson) {
                        String contactPersonText = CustomerHelper.contactPersonText((ContactPerson)contactPerson, (boolean)true);
                        invoice.setContactPerson(contactPersonText);
                    }
                    invoice.setOrderDescription(stage.getOrderDescriptionCustomer());
                    invoice.setOrderDate(stage.getCommissionDate());
                    if (EPdfExtractType.TELEKOM == pdfExtractType) {
                        invoice.setOrderNumber(invoicePdfExtraction.getOrderNumber1());
                    } else if (EPdfExtractType.STROMNETZ_BERLIN == pdfExtractType) {
                        invoice.setOrderNumber(invoicePdfExtraction.getOrderNumber1());
                    } else {
                        invoice.setOrderNumber(stage.getOrderNumber());
                    }
                    Customer customer = stage.getCustomer();
                    Customer customerInvoice = stage.getCustomerInvoice();
                    if (null != customer) {
                        invoice.setFinanceDebtorAccountNumber(customer.getDebtorAccountNumber());
                    }
                    if (null != customerInvoice) {
                        invoice.setFinanceDebtorAccountNumber(customerInvoice.getDebtorAccountNumber());
                    }
                    Address customerInvoiceAddress = stage.getCustomerInvoiceAddress();
                    invoice.setInvoiceAddress(customerInvoiceAddress);
                    if (null != customerInvoiceAddress) {
                        invoice.setInvoiceName(StringUtils.trimToEmpty((String)customerInvoiceAddress.getName()));
                        invoice.setInvoiceAddressSuffix(StringUtils.trimToEmpty((String)customerInvoiceAddress.getAddressSuffix()));
                        invoice.setInvoicePoBox(StringUtils.trimToEmpty((String)customerInvoiceAddress.getPoBox()));
                        invoice.setInvoiceStreet(StringUtils.trimToEmpty((String)customerInvoiceAddress.getStreet()));
                        invoice.setInvoiceStreetNo(StringUtils.trimToEmpty((String)customerInvoiceAddress.getStreetNo()));
                        invoice.setInvoiceZip(StringUtils.trimToEmpty((String)customerInvoiceAddress.getZipCode()));
                        invoice.setInvoiceCity(StringUtils.trimToEmpty((String)customerInvoiceAddress.getCity()));
                        invoice.setInvoiceRemarks(StringUtils.trimToEmpty((String)customerInvoiceAddress.getRemarks()));
                        invoice.setInvoiceEmail(StringUtils.trimToEmpty((String)customerInvoiceAddress.getEmail()));
                        invoice.setInvoicePortal(StringUtils.trimToEmpty((String)customerInvoiceAddress.getPortal()));
                    }
                    Address agentInvoiceAddress = stage.getAgentInvoiceAddress();
                    invoice.setInvoiceRefAddress(agentInvoiceAddress);
                    if (null != agentInvoiceAddress) {
                        invoice.setInvoiceRefName(StringUtils.trimToEmpty((String)agentInvoiceAddress.getName()));
                        invoice.setInvoiceRefAddressSuffix(StringUtils.trimToEmpty((String)agentInvoiceAddress.getAddressSuffix()));
                        invoice.setInvoiceRefPoBox(StringUtils.trimToEmpty((String)agentInvoiceAddress.getPoBox()));
                        invoice.setInvoiceRefStreet(StringUtils.trimToEmpty((String)agentInvoiceAddress.getStreet()));
                        invoice.setInvoiceRefStreetNo(StringUtils.trimToEmpty((String)agentInvoiceAddress.getStreetNo()));
                        invoice.setInvoiceRefZip(StringUtils.trimToEmpty((String)agentInvoiceAddress.getZipCode()));
                        invoice.setInvoiceRefCity(StringUtils.trimToEmpty((String)agentInvoiceAddress.getCity()));
                        invoice.setInvoiceRefRemarks(StringUtils.trimToEmpty((String)agentInvoiceAddress.getRemarks()));
                        invoice.setInvoiceRefEmail(StringUtils.trimToEmpty((String)agentInvoiceAddress.getEmail()));
                        invoice.setInvoiceRefPortal(StringUtils.trimToEmpty((String)agentInvoiceAddress.getPortal()));
                    }
                    invoice.setFinanceAccountingText(stage.getFinanceAccountingText());
                    invoice.setFinanceTimeForPayment(stage.getFinanceTimeForPayment());
                    invoice.setFinanceCashDiscountTime1(stage.getFinanceCashDiscountTime1());
                    invoice.setFinanceCashDiscount1(stage.getFinanceCashDiscount1());
                    invoice.setFinanceCashDiscountTime2(stage.getFinanceCashDiscountTime2());
                    invoice.setFinanceCashDiscount2(stage.getFinanceCashDiscount2());
                    invoice.setFinanceRoutingReferenceId(stage.getFinanceRoutingReferenceId());
                    TaxKey financeTaxKey = taxKeyCandidate.orElse(null);
                    invoice.setFinanceTaxKey(financeTaxKey);
                    if (null != financeTaxKey) {
                        invoice.setFinanceTaxKeyValue(financeTaxKey.getTaxKey());
                        invoice.setFinanceAccount(financeTaxKey.getAccount());
                    }
                    invoice.setVatPercent(invoicePdfExtraction.getVatPercent());
                    invoice.setGeneralDiscount(stage.getGeneralDiscount());
                    invoice.setOtherDiscount(stage.getOtherDiscount());
                }
            }
            for (InvoicePosition invoicePosition : invoicePositions) {
                invoicePosition.setInvoice(invoice);
            }
            invoice.setInvoicePositions((Set)Sets.newHashSet(invoicePositions));
        }
        invoice.setFlagSecurityRetention(Boolean.valueOf(false));
        invoice.setWarrantySecurityRetentionPercent(BigDecimal.ZERO);
        invoice.setWarrantySecurityRetentionValue(BigDecimal.ZERO);
        invoice.setFulfillmentSecurityRetentionPercent(BigDecimal.ZERO);
        invoice.setFulfillmentSecurityRetentionValue(BigDecimal.ZERO);
        invoice.setInvoiceStateSince(DateTimeHelper.now());
        invoice.setInvoiceState(EInvoiceState.IN_ACCOUNTING);
        invoice.setInvoiceSource(EInvoiceSource.VOUCHER);
        invoice.setInvoiceType(invoiceType);
        return invoice;
    }

    @Nonnull
    public CreditVoucherImportResultListCommon mapVoucherImportResults(@NonNull Iterable<CreditVoucherImportResult> creditVoucherImportResults) {
        if (creditVoucherImportResults == null) {
            throw new NullPointerException("creditVoucherImportResults is marked non-null but is null");
        }
        ImmutableList commons = (ImmutableList)Streams.stream(creditVoucherImportResults).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return new CreditVoucherImportResultListCommon(commons.size(), (List)commons);
    }

    @Nonnull
    private CreditVoucherImportResultCommon map(@NonNull CreditVoucherImportResult creditVoucherImportResult) {
        if (creditVoucherImportResult == null) {
            throw new NullPointerException("creditVoucherImportResult is marked non-null but is null");
        }
        MultipartFile multipartFile = creditVoucherImportResult.getMultipartFile();
        Invoice invoice = creditVoucherImportResult.getInvoice();
        EPdfExtractType pdfExtractType = creditVoucherImportResult.getPdfExtractType();
        Iterable errors = creditVoucherImportResult.getErrors();
        String originalFilename = multipartFile.getOriginalFilename();
        Long invoiceId = invoice.getId();
        String pdfExtractTypeName = pdfExtractType.name();
        EImportResultType importResultType = creditVoucherImportResult.getImportResultType();
        String importResultTypeTxt = importResultType.name();
        return CreditVoucherImportResultCommon.of((String)importResultTypeTxt, (String)originalFilename, (Long)invoiceId, (String)pdfExtractTypeName, (List)ImmutableList.copyOf((Iterable)errors));
    }

    @Nonnull
    public ClosingInvoiceListCommon mapClosingInvoice(@NonNull Iterable<Invoice> entities, @NonNull Function<Invoice, Boolean> closingInvoiceFN) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        if (closingInvoiceFN == null) {
            throw new NullPointerException("closingInvoiceFN is marked non-null but is null");
        }
        List commons = (List)Streams.stream(entities).map((? super T item) -> this.mapClosingInvoice(item, closingInvoiceFN)).collect(ImmutableList.toImmutableList());
        return new ClosingInvoiceListCommon(Iterables.size((Iterable)commons), commons);
    }

    @Nonnull
    public ClosingInvoiceCommon mapClosingInvoice(@NonNull Invoice entity, @NonNull Function<Invoice, Boolean> closingInvoiceFN) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (closingInvoiceFN == null) {
            throw new NullPointerException("closingInvoiceFN is marked non-null but is null");
        }
        ClosingInvoiceCommon common = new ClosingInvoiceCommon();
        common.setId(entity.getId());
        common.setInvoiceNumber(entity.getInvoiceNumber());
        Boolean selected = closingInvoiceFN.apply(entity);
        common.setSelected(selected);
        EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)entity.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
        common.setInvoiceState(invoiceState.name());
        EInvoiceType invoiceType = (EInvoiceType)MoreObjects.firstNonNull((Object)entity.getInvoiceType(), (Object)EInvoiceType.UNKNOWN);
        common.setInvoiceType(invoiceType.name());
        common.setInvoiceTypeComment(entity.getInvoiceTypeComment());
        return common;
    }

    @Nonnull
    public Invoice mergeAsVoucher(@NonNull Invoice from, @NonNull Invoice to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        to.setInvoiceSource(EInvoiceSource.VOUCHER);
        to.setInvoiceStateSince(DateTimeHelper.now());
        to.setInvoiceState(EInvoiceState.IN_ACCOUNTING);
        to.setInvoiceDate(DateTimeHelper.today());
        to.setPostingDate(DateTimeHelper.today());
        to.setQuotation(from.getQuotation());
        to.setInvoiceNumber(null);
        to.setSequentialNumber(null);
        to.setInternalPartialNumber(null);
        to.setInternalPartialFinalNumber(null);
        to.setCumulativeNumber(null);
        to.setAccountedByUser(null);
        to.setPaymentConditions(from.getPaymentConditions());
        to.setPrimaryResponsibleUser(from.getPrimaryResponsibleUser());
        to.setAssignedSquad(from.getAssignedSquad());
        to.setCostCenter(from.getCostCenter());
        to.setInvoiceType(EInvoiceType.CUSTOMER_VOUCHER);
        to.setInvoiceTypeComment("Kundengutschrift zu: " + from.getInvoiceNumber());
        to.setContactPerson(from.getContactPerson());
        to.setOrderDate(from.getOrderDate());
        to.setOrderDescription(from.getOrderDescription());
        to.setOrderNumber(from.getOrderNumber());
        to.setVoucherNumber(null);
        to.setCreditVoucherNumber(null);
        to.setConstructionSite(from.getConstructionSite());
        to.setProjectExecutionStartDate(from.getProjectExecutionStartDate());
        to.setProjectExecutionEndDate(from.getProjectExecutionEndDate());
        to.setInvoiceName(from.getInvoiceName());
        to.setInvoiceAddress(from.getInvoiceAddress());
        to.setInvoiceAddressSuffix(from.getInvoiceAddressSuffix());
        to.setInvoicePoBox(from.getInvoicePoBox());
        to.setInvoiceStreet(from.getInvoiceStreet());
        to.setInvoiceStreetNo(from.getInvoiceStreetNo());
        to.setInvoiceZip(from.getInvoiceZip());
        to.setInvoiceCity(from.getInvoiceCity());
        to.setInvoiceCountry(from.getInvoiceCountry());
        to.setInvoiceEmail(from.getInvoiceEmail());
        to.setInvoicePortal(from.getInvoicePortal());
        to.setInvoiceRemarks(from.getInvoiceRemarks());
        to.setInvoiceRefName(from.getInvoiceRefName());
        to.setInvoiceRefAddress(from.getInvoiceRefAddress());
        to.setInvoiceRefAddressSuffix(from.getInvoiceRefAddressSuffix());
        to.setInvoiceRefPoBox(from.getInvoiceRefPoBox());
        to.setInvoiceRefStreet(from.getInvoiceRefStreet());
        to.setInvoiceRefStreetNo(from.getInvoiceRefStreetNo());
        to.setInvoiceRefZip(from.getInvoiceRefZip());
        to.setInvoiceRefCity(from.getInvoiceRefCity());
        to.setInvoiceRefCountry(from.getInvoiceRefCountry());
        to.setInvoiceRefEmail(from.getInvoiceRefEmail());
        to.setInvoiceRefPortal(from.getInvoiceRefPortal());
        to.setInvoiceRefRemarks(from.getInvoiceRefRemarks());
        to.setAdditionalInfoHeader1(from.getAdditionalInfoHeader1());
        to.setAdditionalInfoDetail1(from.getAdditionalInfoDetail1());
        to.setAdditionalInfoHeader2(from.getAdditionalInfoHeader2());
        to.setAdditionalInfoDetail2(from.getAdditionalInfoDetail2());
        to.setAdditionalInfoHeader3(from.getAdditionalInfoHeader3());
        to.setAdditionalInfoDetail3(from.getAdditionalInfoDetail3());
        to.setAttachments(from.getAttachments());
        to.setAdditionalAttachments(from.getAdditionalAttachments());
        to.setFooterText(from.getFooterText());
        to.setFinanceCompanyNumber(from.getFinanceCompanyNumber());
        to.setFinanceAccountingText(from.getFinanceAccountingText());
        to.setFinanceTimeForPayment(from.getFinanceTimeForPayment());
        to.setFinanceCashDiscountTime1(from.getFinanceCashDiscountTime1());
        to.setFinanceCashDiscount1(from.getFinanceCashDiscount1());
        to.setFinanceCashDiscountTime2(from.getFinanceCashDiscountTime2());
        to.setFinanceCashDiscount2(from.getFinanceCashDiscount2());
        to.setFinanceDebtorAccountNumber(from.getFinanceDebtorAccountNumber());
        to.setFinanceTaxKeyValue(from.getFinanceTaxKeyValue());
        to.setFinanceAccount(from.getFinanceAccount());
        to.setFinanceRoutingReferenceId(from.getFinanceRoutingReferenceId());
        to.setSubtotalWithoutDiscountValueNet(from.getSubtotalWithoutDiscountValueNet());
        to.setSubtotalWithDiscountValueNet(from.getSubtotalWithDiscountValueNet());
        to.setTotalDiscountValueNet(from.getTotalDiscountValueNet());
        to.setTotalValueNet(from.getTotalValueNet());
        to.setTotalValueGross(from.getTotalValueGross());
        to.setVatPercent(from.getVatPercent());
        to.setVatValue(from.getVatValue());
        to.setInvoiceDueValueGross(from.getInvoiceDueValueGross());
        to.setWarrantySecurityRetentionPercent(from.getWarrantySecurityRetentionPercent());
        to.setWarrantySecurityRetentionValue(from.getWarrantySecurityRetentionValue());
        to.setFulfillmentSecurityRetentionPercent(from.getFulfillmentSecurityRetentionPercent());
        to.setFulfillmentSecurityRetentionValue(from.getFulfillmentSecurityRetentionValue());
        to.setFulfillmentSecurityRetentionCumulativeValue(from.getFulfillmentSecurityRetentionCumulativeValue());
        to.setGeneralDiscount(from.getGeneralDiscount());
        to.setOtherDiscount(from.getOtherDiscount());
        to.setExpectedPDFValueOverallNet(from.getExpectedPDFValueOverallNet());
        to.setExpectedPDFVAT(from.getExpectedPDFVAT());
        to.setExpectedPDFValueOverallVAT(from.getExpectedPDFValueOverallVAT());
        to.setExpectedPDFValueOverallGross(from.getExpectedPDFValueOverallGross());
        to.setExpectedPDFCostCenter(from.getExpectedPDFCostCenter());
        to.setFinanceTaxKey(from.getFinanceTaxKey());
        to.setCancellationRemarks(from.getCancellationRemarks());
        to.setCancellationDebitNote(from.getCancellationDebitNote());
        to.setCancellationDate(from.getCancellationDate());
        to.setCancellationPeriod(from.getCancellationPeriod());
        to.setFlagSecurityRetention(from.getFlagSecurityRetention());
        to.setWarrantySecurityRetentionPercent(from.getWarrantySecurityRetentionPercent());
        to.setWarrantySecurityRetentionValue(from.getWarrantySecurityRetentionValue());
        to.setFulfillmentSecurityRetentionPercent(from.getFulfillmentSecurityRetentionPercent());
        to.setFulfillmentSecurityRetentionValue(from.getFulfillmentSecurityRetentionValue());
        to.setImportErrors("");
        to.setImportFileName("");
        to.setMeasurementNumbers(from.getMeasurementNumbers());
        to.setEr2ExportedBy(null);
        to.setEr2ExportedOn(null);
        to.setPrintedByUser(null);
        to.setPrintedOn(null);
        to.setFlagClosed(null);
        to.setClosedOn(null);
        to.setClosedByInvoice(null);
        to.setClosedByUser(null);
        to.setReferencedByInvoice(null);
        to.setOptionPrint13bParagraph(from.getOptionPrint13bParagraph());
        to.setOptionPrintSubcontractorParagraph(from.getOptionPrintSubcontractorParagraph());
        to.setOptionPrintStromnetzParagraph(from.getOptionPrintStromnetzParagraph());
        to.setOptionCumulativePrint(from.getOptionCumulativePrint());
        to.setOptionMeasurementPrint(from.getOptionMeasurementPrint());
        to.setOptionMeasurementCumulativePrint(from.getOptionMeasurementCumulativePrint());
        Iterable originalInvoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)from.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        HashSet voucherInvoiceMeasurements = Sets.newHashSet();
        originalInvoiceMeasurements.forEach(item -> {
            InvoiceMeasurement invoiceMeasurement = this.entityFactory.invoiceMeasurement();
            invoiceMeasurement.setInvoice(to);
            invoiceMeasurement.setMeasurement(item.getMeasurement());
            voucherInvoiceMeasurements.add(invoiceMeasurement);
        });
        to.setInvoiceMeasurements((Set)voucherInvoiceMeasurements);
        Iterable originalInvoicePositions = (Iterable)MoreObjects.firstNonNull((Object)from.getInvoicePositions(), (Object)ImmutableSet.of());
        HashSet voucherInvoicePositions = Sets.newHashSet();
        originalInvoicePositions.forEach(item -> {
            InvoicePosition invoicePosition = this.entityFactory.invoicePosition();
            InvoicePosition invoicePositionMerged = this.merge(item, invoicePosition);
            invoicePositionMerged.setInvoice(to);
            voucherInvoicePositions.add(invoicePositionMerged);
        });
        to.setInvoicePositions((Set)voucherInvoicePositions);
        to.setClosedInvoices((Set)Sets.newHashSet());
        to.setInvoiceAddendumDiscounts((Set)Sets.newHashSet());
        Set fromInvoiceAddendumDiscounts = (Set)MoreObjects.firstNonNull((Object)from.getInvoiceAddendumDiscounts(), (Object)ImmutableSet.of());
        for (InvoiceAddendumDiscount fromInvoiceAddendumDiscount : fromInvoiceAddendumDiscounts) {
            InvoiceAddendumDiscount toInvoiceAddendumDiscount = this.entityFactory.invoiceAddendumDiscount();
            this.merge(fromInvoiceAddendumDiscount, toInvoiceAddendumDiscount);
            to.getInvoiceAddendumDiscounts().add(toInvoiceAddendumDiscount);
            toInvoiceAddendumDiscount.setInvoice(to);
        }
        to.setInvoiceSupplements((Set)Sets.newHashSet());
        Set fromInvoiceSupplements = (Set)MoreObjects.firstNonNull((Object)from.getInvoiceSupplements(), (Object)ImmutableSet.of());
        for (InvoiceSupplement fromInvoiceSupplement : fromInvoiceSupplements) {
            InvoiceSupplement toInvoiceSupplement = this.entityFactory.invoiceSupplement();
            this.merge(fromInvoiceSupplement, toInvoiceSupplement);
            to.getInvoiceSupplements().add(toInvoiceSupplement);
            toInvoiceSupplement.setInvoice(to);
        }
        return to;
    }

    private void merge(@NonNull InvoiceAddendumDiscount from, @NonNull InvoiceAddendumDiscount to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        to.setAddendumNumber(from.getAddendumNumber());
        to.setDiscountableValueNet(from.getDiscountableValueNet());
        to.setPercent(from.getPercent());
        to.setValueNet(from.getValueNet());
    }

    private void merge(@NonNull InvoiceSupplement from, @NonNull InvoiceSupplement to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        to.setName(from.getName());
        to.setPercent(from.getPercent());
        to.setValue(from.getValue());
    }

    @Nonnull
    private InvoicePosition merge(@NonNull InvoicePosition from, @NonNull InvoicePosition to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        to.setInvoicePositionType(from.getInvoicePositionType());
        to.setSequenceNumber(from.getSequenceNumber());
        to.setMeasurementPosition(from.getMeasurementPosition());
        to.setPositionNumber(from.getPositionNumber());
        to.setAmount(from.getAmount());
        to.setFactor1(from.getFactor1());
        to.setFactor2(from.getFactor2());
        to.setFactor3(from.getFactor3());
        to.setProduct(from.getProduct());
        to.setUnit(from.getUnit());
        to.setShortText(from.getShortText());
        to.setRemarks(from.getRemarks());
        to.setMaterialPurchasePricePerUnit(from.getMaterialPurchasePricePerUnit());
        to.setMaterialPurchasePriceAgg(from.getMaterialPurchasePriceAgg());
        to.setMaterialSellingPricePerUnit(from.getMaterialSellingPricePerUnit());
        to.setMaterialSellingPriceAggregated(from.getMaterialSellingPriceAggregated());
        to.setMaterialFactor(from.getMaterialFactor());
        to.setPricePerUnit(from.getPricePerUnit());
        to.setPriceAggregated(from.getPriceAggregated());
        to.setAddendumNumber(from.getAddendumNumber());
        to.setDiscount(from.getDiscount());
        to.setDiscountValueAggregated(from.getDiscountValueAggregated());
        to.setPriceAggregatedWithDiscount(from.getPriceAggregatedWithDiscount());
        to.setFlagFeePosition(from.getFlagFeePosition());
        return to;
    }

    @Nonnull
    public Iterable<DailySaleOutInvoice> mapXLS(@NonNull Iterable<Pair<Invoice, BigDecimal>> invoices) {
        if (invoices == null) {
            throw new NullPointerException("invoices is marked non-null but is null");
        }
        return (Iterable)Streams.stream(invoices).map(arg_0 -> this.mapXLS(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public DailySaleOutInvoice mapXLS(@NonNull Pair<Invoice, BigDecimal> pair) {
        if (pair == null) {
            throw new NullPointerException("pair is marked non-null but is null");
        }
        Invoice entity = (Invoice)pair.getLeft();
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        String costUnit = InvoiceHelper.costUnitEnaio((Invoice)entity, (String)stageOrEntityNumberPrefix);
        BigDecimal totalValueGrossCumulative = (BigDecimal)pair.getRight();
        boolean negate = entity.getInvoiceState() == EInvoiceState.CANCELLED;
        BigDecimal factor = negate ? BigDecimal.ONE.negate() : BigDecimal.ONE;
        LocalDate accountingDate = InvoiceHelper.accountingDate((Invoice)entity);
        LocalDate postingDate = InvoiceHelper.postingDate((Invoice)entity);
        DailySaleOutInvoice item = new DailySaleOutInvoice();
        item.setDebtorAccountNumber(StringUtils.trimToEmpty((String)entity.getFinanceDebtorAccountNumber()));
        item.setInvoiceNumber(StringUtils.trimToEmpty((String)entity.getInvoiceNumber()));
        item.setAccountingDate(accountingDate);
        item.setPostingDate(postingDate);
        item.setFinanceAccount(StringUtils.trimToEmpty((String)entity.getFinanceAccount()));
        item.setCostCenter(StringUtils.trimToEmpty((String)entity.getCostCenter()));
        item.setCostUnit(costUnit);
        item.setVoucherNumber(StringUtils.trimToEmpty((String)entity.getVoucherNumber()));
        this.apply(factor, () -> ((Invoice)entity).getSubtotalWithoutDiscountValueNet(), arg_0 -> ((DailySaleOutInvoice)item).setSubtotalWithoutDiscountValueNet(arg_0));
        this.apply(factor, () -> ((Invoice)entity).getSubtotalWithDiscountValueNet(), arg_0 -> ((DailySaleOutInvoice)item).setSubtotalWithDiscountValueNet(arg_0));
        this.apply(factor, () -> ((Invoice)entity).getTotalDiscountValueNet(), arg_0 -> ((DailySaleOutInvoice)item).setTotalDiscountValueNet(arg_0));
        this.apply(factor, () -> ((Invoice)entity).getTotalValueNet(), arg_0 -> ((DailySaleOutInvoice)item).setTotalValueNet(arg_0));
        this.apply(factor, () -> ((Invoice)entity).getTotalValueGross(), arg_0 -> ((DailySaleOutInvoice)item).setTotalValueGross(arg_0));
        this.apply(factor, () -> ((Invoice)entity).getVatValue(), arg_0 -> ((DailySaleOutInvoice)item).setVatValue(arg_0));
        this.apply(factor, () -> ((Invoice)entity).getInvoiceDueValueGross(), arg_0 -> ((DailySaleOutInvoice)item).setInvoiceDueValueGross(arg_0));
        this.apply(factor, () -> ((Invoice)entity).getWarrantySecurityRetentionPercent(), arg_0 -> ((DailySaleOutInvoice)item).setWarrantySecurityRetentionPercent(arg_0));
        this.apply(factor, () -> ((Invoice)entity).getWarrantySecurityRetentionValue(), arg_0 -> ((DailySaleOutInvoice)item).setWarrantySecurityRetentionValue(arg_0));
        this.apply(factor, () -> ((Invoice)entity).getFulfillmentSecurityRetentionValue(), arg_0 -> ((DailySaleOutInvoice)item).setFulfillmentSecurityRetentionValue(arg_0));
        item.setVatPercent(entity.getVatPercent());
        item.setFlagSecurityRetention(entity.getFlagSecurityRetention());
        item.setTotalValueGrossCumulative(totalValueGrossCumulative);
        item.setFinanceAccountingText(StringUtils.trimToEmpty((String)entity.getFinanceAccountingText()));
        item.setFinanceTimeForPayment((Integer)MoreObjects.firstNonNull((Object)entity.getFinanceTimeForPayment(), (Object)0));
        item.setFinanceCashDiscountTime1(entity.getFinanceCashDiscountTime1());
        item.setFinanceCashDiscount1(entity.getFinanceCashDiscount1());
        item.setFinanceCashDiscountTime2(entity.getFinanceCashDiscountTime2());
        item.setFinanceCashDiscount2(entity.getFinanceCashDiscount2());
        item.setVatPercent((BigDecimal)MoreObjects.firstNonNull((Object)entity.getVatPercent(), (Object)BigDecimal.ZERO));
        item.setZipCode(StringUtils.trimToEmpty((String)entity.getInvoiceZip()));
        item.setCity(StringUtils.trimToEmpty((String)entity.getInvoiceCity()));
        item.setInvoiceName(StringUtils.trimToEmpty((String)entity.getInvoiceName()));
        item.setInvoiceAddressSuffix(StringUtils.trimToEmpty((String)entity.getInvoiceAddressSuffix()));
        item.setBankCode("");
        item.setMaterialSellingPriceOverall(BigDecimal.ZERO);
        Set invoiceMeasurements = (Set)MoreObjects.firstNonNull((Object)entity.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        ImmutableSet measurementNumbers = (ImmutableSet)invoiceMeasurements.stream().map(InvoiceMeasurement::getMeasurement).filter(Objects::nonNull).map(Measurement::getMeasurementNumber).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        item.setMeasurementNumbers((Iterable)measurementNumbers);
        return item;
    }

    private void apply(@NonNull BigDecimal factor, @NonNull Supplier<BigDecimal> source, @NonNull Consumer<BigDecimal> setter) {
        if (factor == null) {
            throw new NullPointerException("factor is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (setter == null) {
            throw new NullPointerException("setter is marked non-null but is null");
        }
        BigDecimal value = factor.multiply((BigDecimal)MoreObjects.firstNonNull((Object)source.get(), (Object)BigDecimal.ZERO));
        setter.accept(value);
    }

    @Nonnull
    public NewInvoiceAutoCompleteResponse mapNewInvoiceAutoComplete(@NonNull Iterable<Quotation> quotations, @NonNull Iterable<Measurement> measurements) {
        NewInvoiceAutoCompleteItemCommon common;
        if (quotations == null) {
            throw new NullPointerException("quotations is marked non-null but is null");
        }
        if (measurements == null) {
            throw new NullPointerException("measurements is marked non-null but is null");
        }
        ImmutableList.Builder commonBuilder = ImmutableList.builder();
        for (Quotation quotation : quotations) {
            common = new NewInvoiceAutoCompleteItemCommon();
            common.setQuotationId(quotation.getId());
            common.setQuotationNumber(quotation.getQuotationNumber());
            common.setStageId(quotation.getId());
            common.setAlias(quotation.getAlias());
            common.setQentityNumber(quotation.getQNumber());
            EStageOrigin origin = quotation.getOrigin();
            String qNumber = quotation.getQNumber();
            String alias = quotation.getAlias();
            if (StringUtils.isNotBlank((CharSequence)alias) && !StringUtils.equalsIgnoreCase((CharSequence)qNumber, (CharSequence)alias)) {
                common.setText(String.format("%s / %s", alias, qNumber));
            } else {
                common.setText(String.format("%s", qNumber));
            }
            commonBuilder.add((Object)common);
        }
        for (Measurement measurement : measurements) {
            common = new NewInvoiceAutoCompleteItemCommon();
            Quotation quotation = measurement.getQuotation();
            common.setQuotationId(quotation.getId());
            common.setQuotationNumber(quotation.getQuotationNumber());
            common.setStageId(quotation.getId());
            common.setAlias(quotation.getAlias());
            common.setQentityNumber(quotation.getQNumber());
            common.setMeasurementId(measurement.getId());
            common.setMeasurementNumber(measurement.getMeasurementNumber());
            common.setText(measurement.getMeasurementNumber());
            commonBuilder.add((Object)common);
        }
        ImmutableList autoCompleteItems = commonBuilder.build();
        ImmutableList autoCompleteItemsSorted = (ImmutableList)autoCompleteItems.stream().sorted((l, r) -> StringUtils.compareIgnoreCase((String)l.getMeasurementNumber(), (String)r.getMeasurementNumber())).collect(ImmutableList.toImmutableList());
        return new NewInvoiceAutoCompleteResponse(autoCompleteItemsSorted.size(), (List)autoCompleteItemsSorted);
    }

    @Nonnull
    public PageCommon<InvoiceSearchItem> mapToSearchItem(Page<InvoiceSearchItemBucket> buckets) {
        return BaseMapper.map(buckets, arg_0 -> this.mapToSearchItem(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new PageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public InvoiceSearchItem mapToSearchItem(@NonNull InvoiceSearchItemBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        InvoiceIndexEntry invoice = bucket.getInvoice();
        String details = bucket.getDetails();
        Highlight rootHighlight = bucket.getRootHighlight();
        Highlight detailHighlight = bucket.getDetailHighlight();
        String companyName = this.companyConfig.getCompanyName();
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        IndexField field = detailHighlight.getField();
        String fieldName = this.messageService.get(field, new Object[]{companyName, stageOrEntityNumberPrefix});
        Iterable rootHighlightCommon = this.highlightMapper.map(rootHighlight);
        Iterable detailHighlightCommon = this.highlightMapper.map(detailHighlight);
        String invoiceNumber = invoice.getInvoiceNumber();
        String effectiveInvoiceNumber = StringUtils.isNotBlank((CharSequence)invoiceNumber) ? invoiceNumber : StringUtils.trimToEmpty((String)invoice.getStageNumber());
        return InvoiceSearchItem.of((long)invoice.getId(), (String)effectiveInvoiceNumber, (Iterable)rootHighlightCommon, (String)details, (String)field.fieldName(), (String)fieldName, (Iterable)detailHighlightCommon);
    }

    @Nonnull
    public InvoiceAttachmentListCommon mapInvoiceAttachments(@NonNull Iterable<InvoiceAttachment> invoiceAttachments) {
        if (invoiceAttachments == null) {
            throw new NullPointerException("invoiceAttachments is marked non-null but is null");
        }
        List commons = (List)Streams.stream(invoiceAttachments).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return new InvoiceAttachmentListCommon(Iterables.size((Iterable)commons), commons);
    }

    @Nonnull
    public InvoiceAttachmentCommon map(@NonNull InvoiceAttachment invoiceAttachment) {
        if (invoiceAttachment == null) {
            throw new NullPointerException("invoiceAttachment is marked non-null but is null");
        }
        InvoiceAttachmentCommon common = new InvoiceAttachmentCommon();
        BaseMapper.map((EntityBase)invoiceAttachment, (EntityBaseCommon)common);
        common.setId(invoiceAttachment.getId());
        EInvoiceAttachmentType attachmentType = (EInvoiceAttachmentType)MoreObjects.firstNonNull((Object)invoiceAttachment.getInvoiceAttachmentType(), (Object)EInvoiceAttachmentType.UNKNOWN);
        common.setAttachmentType(attachmentType.name());
        common.setName(StringUtils.trimToEmpty((String)invoiceAttachment.getName()));
        common.setTtl(invoiceAttachment.getTtl());
        Invoice invoice = invoiceAttachment.getInvoice();
        Long invoiceId = null != invoice ? invoice.getId() : null;
        common.setInvoiceId(invoiceId);
        FileStore fileStore = invoiceAttachment.getFileStore();
        Long fileStoreId = null != fileStore ? fileStore.getId() : null;
        common.setFileStoreId(fileStoreId);
        common.setOptionPrint(((Boolean)MoreObjects.firstNonNull((Object)invoiceAttachment.getOptionPrint(), (Object)false)).booleanValue());
        FileStore fileStorePDF = invoiceAttachment.getFileStorePDF();
        Long fileStorePDFId = null != fileStorePDF ? fileStorePDF.getId() : null;
        common.setFileStorePDFId(fileStorePDFId);
        return common;
    }

    public InvoiceMapper(AuthenticationHelper authenticationHelper, ConfigService configService, MessageService messageService, EntityFactory entityFactory, InvoicePositionMapper invoicePositionMapper, HighlightMapper highlightMapper, ProjectMapper projectMapper, UserService userService, CompanyConfig companyConfig) {
        this.authenticationHelper = authenticationHelper;
        this.configService = configService;
        this.messageService = messageService;
        this.entityFactory = entityFactory;
        this.invoicePositionMapper = invoicePositionMapper;
        this.highlightMapper = highlightMapper;
        this.projectMapper = projectMapper;
        this.userService = userService;
        this.companyConfig = companyConfig;
    }
}

