/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import de.qfm.erp.common.response.search.HighlightCommon;
import de.qfm.erp.service.model.internal.search.Highlight;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HighlightMapper {
    @Nonnull
    public Iterable<HighlightCommon> map(@NonNull Highlight highlight) {
        int upperEndpoint;
        if (highlight == null) {
            throw new NullPointerException("highlight is marked non-null but is null");
        }
        Range range = highlight.getRange();
        int lowerEndpoint = range.hasLowerBound() ? (Integer)range.lowerEndpoint() : 0;
        int n = upperEndpoint = range.hasUpperBound() ? (Integer)range.upperEndpoint() : 0;
        if (lowerEndpoint <= 0 && upperEndpoint <= 0) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)HighlightCommon.of((String)highlight.getOriginal(), (int)lowerEndpoint, (int)upperEndpoint));
    }

    @Autowired
    public HighlightMapper() {
    }
}

