/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.response.user.UserAutoCompleteItemCommon;
import de.qfm.erp.common.response.user.UserAutoCompleteResponse;
import de.qfm.erp.service.model.internal.user.AutoCompleteBucket;
import de.qfm.erp.service.model.internal.user.CachedAutoCompleteUser;
import de.qfm.erp.service.model.internal.user.CachedUser;
import de.qfm.erp.service.model.jpa.user.ERole;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class AutoCompleteMapper {
    @Nonnull
    public UserAutoCompleteItemCommon map(@NonNull AutoCompleteBucket<CachedUser> autoCompleteBucket) {
        if (autoCompleteBucket == null) {
            throw new NullPointerException("autoCompleteBucket is marked non-null but is null");
        }
        CachedUser user = (CachedUser)autoCompleteBucket.getUser();
        boolean disabled = autoCompleteBucket.isDisabled();
        UserAutoCompleteItemCommon common = new UserAutoCompleteItemCommon();
        common.setId(user.getId());
        common.setFirstName(user.getFirstName());
        common.setLastName(user.getLastName());
        common.setFullName(user.getFullName());
        common.setPersonalNumber(user.getPersonalNumber());
        common.setFlagDisabled(disabled);
        ERole role = (ERole)MoreObjects.firstNonNull((Object)user.getRole(), (Object)ERole.ROLE_NONE);
        String roleName = role.getAuthority();
        common.setRole(roleName);
        common.setSquadLeaderUserId(user.getCurrentSquadLeaderUserId());
        common.setSquadLeaderPersonalNumber(user.getCurrentSquadLeaderPersonalNumber());
        common.setSquadLeaderFullName(user.getCurrentSquadLeaderFullName());
        common.setManagerUserId(user.getCurrentManagerUserId());
        common.setManagerPersonalNumber(user.getCurrentManagerPersonalNumber());
        common.setManagerFullName(user.getCurrentManagerFullName());
        return common;
    }

    @Nonnull
    public UserAutoCompleteResponse map(@NonNull Iterable<AutoCompleteBucket<CachedUser>> autoCompleteBuckets) {
        if (autoCompleteBuckets == null) {
            throw new NullPointerException("autoCompleteBuckets is marked non-null but is null");
        }
        List itemsCommon = (List)IterableHelper.stream(autoCompleteBuckets).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return new UserAutoCompleteResponse(itemsCommon.size(), itemsCommon);
    }

    @Nonnull
    public UserAutoCompleteItemCommon mapAutoComplete(@NonNull AutoCompleteBucket<CachedAutoCompleteUser> autoCompleteBucket) {
        if (autoCompleteBucket == null) {
            throw new NullPointerException("autoCompleteBucket is marked non-null but is null");
        }
        CachedAutoCompleteUser cachedUser = (CachedAutoCompleteUser)autoCompleteBucket.getUser();
        boolean flagDisabled = autoCompleteBucket.isDisabled();
        UserAutoCompleteItemCommon common = new UserAutoCompleteItemCommon();
        common.setId(cachedUser.getId());
        common.setFirstName(cachedUser.getFirstName());
        common.setLastName(cachedUser.getLastName());
        common.setFullName(cachedUser.getFullName());
        common.setPersonalNumber(cachedUser.getPersonalNumber());
        common.setFlagDisabled(flagDisabled);
        common.setSquadLeaderUserId(cachedUser.getSquadLeaderUserId());
        common.setSquadLeaderPersonalNumber(cachedUser.getSquadLeaderPersonalNumber());
        common.setSquadLeaderFullName(cachedUser.getSquadLeaderFullName());
        return common;
    }

    @Nonnull
    public UserAutoCompleteResponse mapAutoComplete(Iterable<AutoCompleteBucket<CachedAutoCompleteUser>> cachedUsers) {
        List itemsCommon = (List)IterableHelper.stream(cachedUsers).map(arg_0 -> this.mapAutoComplete(arg_0)).collect(ImmutableList.toImmutableList());
        return new UserAutoCompleteResponse(itemsCommon.size(), itemsCommon);
    }
}

