/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.DateRange;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.print.attendances.CostCenterAttendancePrintBucket;
import de.qfm.erp.service.model.internal.print.payroll.AttendanceReportPrintStandard;
import de.qfm.erp.service.model.internal.print.payroll.AttendanceReportPrintStandardRow;
import de.qfm.erp.service.model.internal.print.payroll.BadWeatherReportPrintStandard;
import de.qfm.erp.service.model.internal.print.payroll.BadWeatherReportPrintStandardRow;
import de.qfm.erp.service.model.internal.print.payroll.PayrollMonthAttendance;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemUnit;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.generic.BankingHoliday;
import de.qfm.erp.service.model.jpa.generic.EDay;
import de.qfm.erp.service.model.jpa.generic.EDayType;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.WageTypeCalculators;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.handler.PayrollItemTypeHandler;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class AttendancePrintMapper {
    private static final Logger log = LogManager.getLogger(AttendancePrintMapper.class);
    private static final Set<EWageType> WAGE_TYPES_TO_CALCULATE = ImmutableSet.of((Object)EWageType.STANDARD_WAGE, (Object)EWageType.INCENTIVE_WAGE);
    private final WageTypeCalculators wageTypeCalculators;
    private final PayrollItemTypeHandler payrollItemTypeHandler;

    @Nonnull
    public Iterable<AttendanceReportPrintStandardRow> attendanceReportRows(@NonNull YearMonth yearMonth, @NonNull Iterable<CostCenterAttendancePrintBucket> payrollMonths, @NonNull Iterable<BankingHoliday> bankingHolidays) {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (payrollMonths == null) {
            throw new NullPointerException("payrollMonths is marked non-null but is null");
        }
        if (bankingHolidays == null) {
            throw new NullPointerException("bankingHolidays is marked non-null but is null");
        }
        Iterable localDates = DateRange.from((YearMonth)yearMonth).asList();
        Iterable accountingMonths = (Iterable)Streams.stream(payrollMonths).map(CostCenterAttendancePrintBucket::getAccountingMonth).collect(ImmutableSet.toImmutableSet());
        if (Iterables.size((Iterable)accountingMonths) > 1) {
            throw new IllegalArgumentException("Payroll Months are not allowed to be from different Months");
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (CostCenterAttendancePrintBucket costCenterAttendancePrintBucket : payrollMonths) {
            PayrollMonth payrollMonth = costCenterAttendancePrintBucket.getPayrollMonth();
            User user = payrollMonth.getUser();
            Integer personalNumber = user.getPersonalNumber();
            String firstName = user.getFirstName();
            String lastName = user.getLastName();
            LaborUnionContract laborUnionContract = payrollMonth.getLaborUnionContract();
            BigDecimal effectiveWagePerHour = WageCalculatorHelper.effectiveWagePerHour((YearMonth)yearMonth, (User)user);
            Iterable payrollItemTypes = this.payrollItemTypeHandler.relevantUnique(laborUnionContract);
            ImmutableList collect = (ImmutableList)Streams.stream((Iterable)payrollItemTypes).filter(item -> WAGE_TYPES_TO_CALCULATE.contains(item.getWageType())).collect(ImmutableList.toImmutableList());
            Iterable calculate = this.wageTypeCalculators.calculate(payrollMonth, (Iterable)collect);
            BigDecimal standardWage = Streams.stream((Iterable)calculate).filter(item -> item.getWageCalculation() == EWageType.STANDARD_WAGE).map(WageTypeCalculationResult::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal incentiveWage = Streams.stream((Iterable)calculate).filter(item -> item.getWageCalculation() == EWageType.INCENTIVE_WAGE).map(WageTypeCalculationResult::getDescriptionValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            Iterable attendances = (Iterable)MoreObjects.firstNonNull((Object)payrollMonth.getAttendances(), (Object)ImmutableList.of());
            ImmutableMap attendancesByDay = (ImmutableMap)Streams.stream((Iterable)attendances).filter(item -> null != item.getDate()).collect(ImmutableMap.toImmutableMap(Attendance::getDayOfMonth, item -> item));
            ImmutableMap bankingHolidaysByDay = (ImmutableMap)Streams.stream(bankingHolidays).filter(item -> null != item.getDayOfMonth()).collect(ImmutableMap.toImmutableMap(BankingHoliday::getDayOfMonth, item -> item));
            List payrollMonthItems = (List)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthItems(), (Object)ImmutableList.of());
            ImmutableList payrollMonthItemsWithHours = (ImmutableList)payrollMonthItems.stream().filter(item -> item.getPayrollItemClazz() == EPayrollItemClazz.AUXILIARY_WAGE).filter(item -> item.getPayrollItemType() != null && Objects.equals(item.getPayrollItemType().getUnit(), EPayrollItemUnit.HOUR)).filter(item -> item.getValue().compareTo(BigDecimal.ZERO) != 0).collect(ImmutableList.toImmutableList());
            AttendanceReportPrintStandardRow row = new AttendanceReportPrintStandardRow();
            row.setStandardWageAggregated(standardWage);
            row.setIncentiveWageAggregated(incentiveWage);
            row.setEmployeePersonalNumber(Integer.toString(personalNumber));
            row.setEmployeeFirstName(firstName);
            row.setEmployeeLastName(lastName);
            row.setEffectiveWagePerHour(effectiveWagePerHour);
            ImmutableMap.Builder attendancesBuilder = ImmutableMap.builder();
            for (LocalDate localDate : localDates) {
                AttendanceReportPrintStandard attendanceReportPrintStandard = new AttendanceReportPrintStandard();
                int dayOfMonth = localDate.getDayOfMonth();
                EDay day = EDay.from((DayOfWeek)localDate.getDayOfWeek());
                boolean isBankingHoliday = bankingHolidaysByDay.containsKey((Object)dayOfMonth);
                EDayType dayType = isBankingHoliday ? EDayType.BANKING_HOLIDAY : EDayType.STANDARD;
                attendanceReportPrintStandard.setDate(localDate);
                attendanceReportPrintStandard.setDay(day);
                attendanceReportPrintStandard.setDayType(dayType);
                Attendance attendance = (Attendance)attendancesByDay.get((Object)dayOfMonth);
                if (null != attendance) {
                    attendanceReportPrintStandard.setCreatedBy(attendance.getCreatedBy());
                    attendanceReportPrintStandard.setCreatedOn(attendance.getCreatedOn());
                    attendanceReportPrintStandard.setUpdatedBy(attendance.getUpdatedBy());
                    attendanceReportPrintStandard.setUpdatedOn(attendance.getUpdatedOn());
                    attendanceReportPrintStandard.setEmployeeDayType(attendance.getEmployeeDayType());
                    attendanceReportPrintStandard.setWorkDuration(attendance.getWorkDuration());
                    attendanceReportPrintStandard.setBreakDuration(attendance.getBreakDuration());
                    attendanceReportPrintStandard.setBadWeatherDuration(attendance.getBadWeatherDuration());
                    attendanceReportPrintStandard.setConstructionSite(attendance.getConstructionSite());
                    attendanceReportPrintStandard.setRemarks(attendance.getRemarks());
                    User squadLeader = attendance.getSquadLeader();
                    if (null != squadLeader) {
                        attendanceReportPrintStandard.setSquadLeaderPersonalNumber(squadLeader.getPersonalNumber());
                        attendanceReportPrintStandard.setSquadLeaderFullName(squadLeader.getFullName());
                    }
                } else {
                    attendanceReportPrintStandard.setCreatedBy("");
                    attendanceReportPrintStandard.setCreatedOn(null);
                    attendanceReportPrintStandard.setUpdatedBy("");
                    attendanceReportPrintStandard.setUpdatedOn(null);
                    attendanceReportPrintStandard.setWorkDuration(Duration.ZERO);
                    attendanceReportPrintStandard.setBreakDuration(Duration.ZERO);
                    attendanceReportPrintStandard.setBadWeatherDuration(Duration.ZERO);
                    attendanceReportPrintStandard.setConstructionSite("");
                    attendanceReportPrintStandard.setRemarks("");
                    attendanceReportPrintStandard.setSquadLeaderPersonalNumber(null);
                    attendanceReportPrintStandard.setSquadLeaderFullName("");
                }
                attendancesBuilder.put((Object)localDate, (Object)attendanceReportPrintStandard);
            }
            row.setAttendances((Map)attendancesBuilder.build());
            row.setDurationAggregatedByType(costCenterAttendancePrintBucket.getDurationAggregatedByType());
            row.setDayCountAggregatedByType(costCenterAttendancePrintBucket.getDayCountAggregatedByType());
            rowsBuilder.add((Object)row);
        }
        return rowsBuilder.build();
    }

    @Nonnull
    public Iterable<BadWeatherReportPrintStandardRow> badWeatherReportRows(@NonNull YearMonth yearMonth, @NonNull Iterable<CostCenterAttendancePrintBucket> payrollMonths, @NonNull Iterable<BankingHoliday> bankingHolidays) {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (payrollMonths == null) {
            throw new NullPointerException("payrollMonths is marked non-null but is null");
        }
        if (bankingHolidays == null) {
            throw new NullPointerException("bankingHolidays is marked non-null but is null");
        }
        Iterable localDates = DateRange.from((YearMonth)yearMonth).asList();
        Iterable accountingMonths = (Iterable)Streams.stream(payrollMonths).map(CostCenterAttendancePrintBucket::getAccountingMonth).collect(ImmutableSet.toImmutableSet());
        if (Iterables.size((Iterable)accountingMonths) > 1) {
            throw new IllegalArgumentException("Payroll Months are not allowed to be from different Months");
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (CostCenterAttendancePrintBucket costCenterAttendancePrintBucket : payrollMonths) {
            PayrollMonth payrollMonth = costCenterAttendancePrintBucket.getPayrollMonth();
            User user = payrollMonth.getUser();
            Integer personalNumber = user.getPersonalNumber();
            String firstName = user.getFirstName();
            String lastName = user.getLastName();
            Iterable attendances = (Iterable)MoreObjects.firstNonNull((Object)payrollMonth.getAttendances(), (Object)ImmutableList.of());
            ImmutableMap attendancesByDay = (ImmutableMap)Streams.stream((Iterable)attendances).filter(item -> null != item.getDate()).collect(ImmutableMap.toImmutableMap(Attendance::getDayOfMonth, item -> item));
            ImmutableMap bankingHolidaysByDay = (ImmutableMap)Streams.stream(bankingHolidays).filter(item -> null != item.getDayOfMonth()).collect(ImmutableMap.toImmutableMap(BankingHoliday::getDayOfMonth, item -> item));
            List payrollMonthItems = (List)MoreObjects.firstNonNull((Object)payrollMonth.getPayrollMonthItems(), (Object)ImmutableList.of());
            ImmutableList payrollMonthItemsWithHours = (ImmutableList)payrollMonthItems.stream().filter(item -> item.getPayrollItemClazz() == EPayrollItemClazz.AUXILIARY_WAGE).filter(item -> item.getPayrollItemType() != null && Objects.equals(item.getPayrollItemType().getUnit(), EPayrollItemUnit.HOUR)).filter(item -> item.getValue().compareTo(BigDecimal.ZERO) != 0).collect(ImmutableList.toImmutableList());
            BadWeatherReportPrintStandardRow row = new BadWeatherReportPrintStandardRow();
            row.setEmployeePersonalNumber(Integer.toString(personalNumber));
            row.setEmployeeFirstName(firstName);
            row.setEmployeeLastName(lastName);
            ImmutableMap.Builder attendancesBuilder = ImmutableMap.builder();
            for (LocalDate localDate : localDates) {
                BadWeatherReportPrintStandard badWeatherReportPrintStandard = new BadWeatherReportPrintStandard();
                int dayOfMonth = localDate.getDayOfMonth();
                EDay day = EDay.from((DayOfWeek)localDate.getDayOfWeek());
                boolean isBankingHoliday = bankingHolidaysByDay.containsKey((Object)dayOfMonth);
                EDayType dayType = isBankingHoliday ? EDayType.BANKING_HOLIDAY : EDayType.STANDARD;
                badWeatherReportPrintStandard.setDate(localDate);
                badWeatherReportPrintStandard.setDay(day);
                badWeatherReportPrintStandard.setDayType(dayType);
                Attendance attendance = (Attendance)attendancesByDay.get((Object)dayOfMonth);
                if (null != attendance) {
                    badWeatherReportPrintStandard.setEmployeeDayType(attendance.getEmployeeDayType());
                    badWeatherReportPrintStandard.setWorkDuration(attendance.getWorkDuration());
                    badWeatherReportPrintStandard.setBreakDuration(attendance.getBreakDuration());
                    badWeatherReportPrintStandard.setBadWeatherDuration(attendance.getBadWeatherDuration());
                    badWeatherReportPrintStandard.setConstructionSite(attendance.getConstructionSite());
                    badWeatherReportPrintStandard.setRemarks(attendance.getRemarks());
                } else {
                    badWeatherReportPrintStandard.setWorkDuration(Duration.ZERO);
                    badWeatherReportPrintStandard.setBreakDuration(Duration.ZERO);
                    badWeatherReportPrintStandard.setBadWeatherDuration(Duration.ZERO);
                    badWeatherReportPrintStandard.setConstructionSite("");
                    badWeatherReportPrintStandard.setRemarks("");
                }
                attendancesBuilder.put((Object)localDate, (Object)badWeatherReportPrintStandard);
            }
            row.setAttendances((Map)attendancesBuilder.build());
            Duration duration = WageCalculatorHelper.durationInHours((Iterable)attendances, Attendance::getWorkDuration);
            row.setDurationAggregated(duration);
            row.setDurationAggregatedByType(costCenterAttendancePrintBucket.getDurationAggregatedByType());
            row.setDayCountAggregatedByType(costCenterAttendancePrintBucket.getDayCountAggregatedByType());
            rowsBuilder.add((Object)row);
        }
        return rowsBuilder.build();
    }

    @Nonnull
    public Iterable<PayrollMonthAttendance> payrollMonthAttendanceRows(@NonNull PayrollMonth payrollMonth, @NonNull Iterable<BankingHoliday> bankingHolidays) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (bankingHolidays == null) {
            throw new NullPointerException("bankingHolidays is marked non-null but is null");
        }
        YearMonth yearMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        Iterable localDates = DateRange.from((YearMonth)yearMonth).asList();
        Iterable attendances = (Iterable)MoreObjects.firstNonNull((Object)payrollMonth.getAttendances(), (Object)ImmutableList.of());
        ImmutableMap attendancesByDay = (ImmutableMap)Streams.stream((Iterable)attendances).filter(item -> null != item.getDate()).collect(ImmutableMap.toImmutableMap(Attendance::getDayOfMonth, item -> item));
        ImmutableMap bankingHolidaysByDay = (ImmutableMap)Streams.stream(bankingHolidays).filter(item -> null != item.getDayOfMonth()).collect(ImmutableMap.toImmutableMap(BankingHoliday::getDayOfMonth, item -> item));
        ImmutableList.Builder attendancesBuilder = ImmutableList.builder();
        for (LocalDate localDate : localDates) {
            PayrollMonthAttendance payrollMonthAttendance = new PayrollMonthAttendance();
            int dayOfMonth = localDate.getDayOfMonth();
            EDay day = EDay.from((DayOfWeek)localDate.getDayOfWeek());
            boolean isBankingHoliday = bankingHolidaysByDay.containsKey((Object)dayOfMonth);
            EDayType dayType = isBankingHoliday ? EDayType.BANKING_HOLIDAY : EDayType.STANDARD;
            payrollMonthAttendance.setDate(localDate);
            payrollMonthAttendance.setDay(day);
            payrollMonthAttendance.setDayType(dayType);
            payrollMonthAttendance.setDayOfMonth(localDate.getDayOfMonth());
            Attendance attendance = (Attendance)attendancesByDay.get((Object)dayOfMonth);
            if (null != attendance) {
                payrollMonthAttendance.setId(attendance.getId());
                payrollMonthAttendance.setCreatedBy(attendance.getCreatedBy());
                payrollMonthAttendance.setCreatedOn(attendance.getCreatedOn());
                payrollMonthAttendance.setUpdatedBy(attendance.getUpdatedBy());
                payrollMonthAttendance.setUpdatedOn(attendance.getUpdatedOn());
                payrollMonthAttendance.setEmployeeDayType(attendance.getEmployeeDayType());
                payrollMonthAttendance.setWorkStart(attendance.getWorkStart());
                payrollMonthAttendance.setWorkEnd(attendance.getWorkEnd());
                payrollMonthAttendance.setWorkDuration(attendance.getWorkDuration());
                payrollMonthAttendance.setBreakDuration(attendance.getBreakDuration());
                payrollMonthAttendance.setBadWeatherDuration(attendance.getBadWeatherDuration());
                payrollMonthAttendance.setConstructionSite(attendance.getConstructionSite());
                payrollMonthAttendance.setRemarks(attendance.getRemarks());
                User squadLeader = attendance.getSquadLeader();
                if (null != squadLeader) {
                    payrollMonthAttendance.setSquadLeaderPersonalNumber(squadLeader.getPersonalNumber());
                    payrollMonthAttendance.setSquadLeaderFullName(squadLeader.getFullName());
                }
            } else {
                payrollMonthAttendance.setCreatedBy("");
                payrollMonthAttendance.setCreatedOn(null);
                payrollMonthAttendance.setUpdatedBy("");
                payrollMonthAttendance.setUpdatedOn(null);
                payrollMonthAttendance.setWorkDuration(Duration.ZERO);
                payrollMonthAttendance.setBreakDuration(Duration.ZERO);
                payrollMonthAttendance.setBadWeatherDuration(Duration.ZERO);
                payrollMonthAttendance.setConstructionSite("");
                payrollMonthAttendance.setRemarks("");
                payrollMonthAttendance.setSquadLeaderPersonalNumber(null);
                payrollMonthAttendance.setSquadLeaderFullName("");
            }
            attendancesBuilder.add((Object)payrollMonthAttendance);
        }
        return attendancesBuilder.build();
    }

    public AttendancePrintMapper(WageTypeCalculators wageTypeCalculators, PayrollItemTypeHandler payrollItemTypeHandler) {
        this.wageTypeCalculators = wageTypeCalculators;
        this.payrollItemTypeHandler = payrollItemTypeHandler;
    }
}

