/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.job;

import de.qfm.erp.service.service.route.UserRoute;
import java.sql.Date;
import java.time.Clock;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

public class DisableUserJob {
    private static final Logger log = LogManager.getLogger(DisableUserJob.class);
    private final UserRoute route;

    @Scheduled(cron="${scheduler.user.disable.cron}")
    @Transactional
    public boolean trigger() {
        log.info("Triggering Disable Users at: {}", (Object)Date.from(Instant.now(Clock.systemUTC())));
        return this.route.disableUsers();
    }

    @Scheduled(cron="${scheduler.heartbeat.cron}")
    public void schedulerHeartbeat() {
        log.info("Disable Users Heartbeat at {}", (Object)Date.from(Instant.now(Clock.systemUTC())));
    }

    public DisableUserJob(UserRoute route) {
        this.route = route;
    }
}

