/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.job;

import de.qfm.erp.service.service.route.impl.CustomerSearchRoute;
import de.qfm.erp.service.service.route.impl.EntitySearchRoute;
import de.qfm.erp.service.service.route.impl.InvoiceSearchRoute;
import de.qfm.erp.service.service.route.impl.MeasurementSearchRoute;
import de.qfm.erp.service.service.route.impl.StageSearchRoute;
import de.qfm.erp.service.service.route.impl.SubProjectSearchRoute;
import de.qfm.erp.service.service.route.impl.UserSearchRoute;
import java.sql.Date;
import java.time.Clock;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

public class DirtySearchIndexRefreshJob {
    private static final Logger log = LogManager.getLogger(DirtySearchIndexRefreshJob.class);
    private final CustomerSearchRoute customerSearchRoute;
    private final EntitySearchRoute entitySearchRoute;
    private final InvoiceSearchRoute invoiceSearchRoute;
    private final MeasurementSearchRoute measurementSearchRoute;
    private final StageSearchRoute stageSearchRoute;
    private final SubProjectSearchRoute subProjectSearchRoute;
    private final UserSearchRoute userSearchRoute;

    @Scheduled(initialDelayString="${scheduler.search.indexer.dirty.processing.ms}", fixedDelayString="${scheduler.search.indexer.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerMeasurement() {
        log.debug("Triggering Dirty Measurement Refresh");
        return this.measurementSearchRoute.refresh();
    }

    @Scheduled(initialDelayString="${scheduler.search.indexer.dirty.processing.ms}", fixedDelayString="${scheduler.search.indexer.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerCustomer() {
        log.debug("Triggering Dirty Customer Refresh");
        return this.customerSearchRoute.refresh();
    }

    @Scheduled(initialDelayString="${scheduler.search.indexer.dirty.processing.ms}", fixedDelayString="${scheduler.search.indexer.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerEntity() {
        log.debug("Triggering Dirty Entity Refresh");
        return this.entitySearchRoute.refresh();
    }

    @Scheduled(initialDelayString="${scheduler.search.indexer.dirty.processing.ms}", fixedDelayString="${scheduler.search.indexer.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerInvoice() {
        log.debug("Triggering Dirty Invoice Refresh");
        return this.invoiceSearchRoute.refresh();
    }

    @Scheduled(initialDelayString="${scheduler.search.indexer.dirty.processing.ms}", fixedDelayString="${scheduler.search.indexer.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerStage() {
        log.debug("Triggering Dirty Stage Refresh");
        return this.stageSearchRoute.refresh();
    }

    @Scheduled(initialDelayString="${scheduler.search.indexer.dirty.processing.ms}", fixedDelayString="${scheduler.search.indexer.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerSubProject() {
        log.debug("Triggering Dirty SubProject Refresh");
        return this.subProjectSearchRoute.refresh();
    }

    @Scheduled(initialDelayString="${scheduler.search.indexer.dirty.processing.ms}", fixedDelayString="${scheduler.search.indexer.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerUser() {
        log.debug("Triggering Dirty User Refresh");
        return this.userSearchRoute.refresh();
    }

    @Scheduled(cron="${scheduler.heartbeat.cron}")
    public void schedulerHeartbeat() {
        log.info("Search Sync Heartbeat at {}", (Object)Date.from(Instant.now(Clock.systemUTC())));
    }

    public DirtySearchIndexRefreshJob(CustomerSearchRoute customerSearchRoute, EntitySearchRoute entitySearchRoute, InvoiceSearchRoute invoiceSearchRoute, MeasurementSearchRoute measurementSearchRoute, StageSearchRoute stageSearchRoute, SubProjectSearchRoute subProjectSearchRoute, UserSearchRoute userSearchRoute) {
        this.customerSearchRoute = customerSearchRoute;
        this.entitySearchRoute = entitySearchRoute;
        this.invoiceSearchRoute = invoiceSearchRoute;
        this.measurementSearchRoute = measurementSearchRoute;
        this.stageSearchRoute = stageSearchRoute;
        this.subProjectSearchRoute = subProjectSearchRoute;
        this.userSearchRoute = userSearchRoute;
    }
}

