/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.job;

import de.qfm.erp.service.service.route.PsxSyncRoute;
import java.sql.Date;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

public class DirtyPsxNotifyJob {
    private static final Logger log = LogManager.getLogger(DirtyPsxNotifyJob.class);
    private final PsxSyncRoute psxSyncRoute;

    @Scheduled(initialDelayString="${scheduler.psx.dirty.processing.ms}", fixedDelayString="${scheduler.psx.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerCustomer() {
        log.debug("Triggering Dirty Customer PSX-Notify");
        Optional psxNotifyResponse = this.psxSyncRoute.processNextCustomer();
        psxNotifyResponse.ifPresent(notifyResponse -> log.info("Customer notified: {}", notifyResponse));
        return true;
    }

    @Scheduled(initialDelayString="${scheduler.psx.dirty.processing.ms}", fixedDelayString="${scheduler.psx.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerProjectTeam() {
        log.debug("Triggering Dirty Project Team PSX-Notify");
        Optional psxNotifyResponse = this.psxSyncRoute.processNextProjectTeam();
        psxNotifyResponse.ifPresent(notifyResponse -> log.info("Project Team notified: {}", notifyResponse));
        return true;
    }

    @Scheduled(initialDelayString="${scheduler.psx.dirty.processing.ms}", fixedDelayString="${scheduler.psx.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerUser() {
        log.debug("Triggering Dirty User PSX-Notify");
        Optional psxNotifyResponse = this.psxSyncRoute.processNextUser();
        psxNotifyResponse.ifPresent(notifyResponse -> log.info("User notified: {}", notifyResponse));
        return true;
    }

    @Scheduled(initialDelayString="${scheduler.psx.dirty.processing.ms}", fixedDelayString="${scheduler.psx.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerEntity() {
        log.debug("Triggering Dirty Entity PSX-Notify");
        Optional psxNotifyResponse = this.psxSyncRoute.processNextEntity();
        psxNotifyResponse.ifPresent(notifyResponse -> log.info("Entity notified: {}", notifyResponse));
        return true;
    }

    @Scheduled(initialDelayString="${scheduler.psx.dirty.processing.ms}", fixedDelayString="${scheduler.psx.dirty.processing.ms}")
    @Transactional(readOnly=false)
    public boolean triggerStage() {
        log.debug("Triggering Dirty Stage Refresh");
        Optional psxNotifyResponse = this.psxSyncRoute.processNextStage();
        psxNotifyResponse.ifPresent(notifyResponse -> log.info("Stage notified: {}", notifyResponse));
        return true;
    }

    @Scheduled(cron="${scheduler.heartbeat.cron}")
    public void schedulerHeartbeat() {
        log.info("PSX Notify Heartbeat at {}", (Object)Date.from(Instant.now(Clock.systemUTC())));
    }

    public DirtyPsxNotifyJob(PsxSyncRoute psxSyncRoute) {
        this.psxSyncRoute = psxSyncRoute;
    }
}

