/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.repository.SubProjectRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class SubProjectHandler
extends BaseHandler<SubProject> {
    private static final Logger log = LogManager.getLogger(SubProjectHandler.class);
    private final SubProjectRepository repository;

    @Autowired
    public SubProjectHandler(StandardPersistenceHelper standardPersistenceHelper, SubProjectRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<SubProject> clazz() {
        return SubProject.class;
    }

    @Nonnull
    protected SubProject beforeUpdate(@NonNull SubProject item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        return item;
    }

    @Nonnull
    protected SubProject afterUpdate(@NonNull SubProject item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected SubProject afterDelete(@NonNull SubProject item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected SubProject beforeDelete(@NonNull SubProject item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        return item;
    }

    @Nonnull
    public Page<SubProject> page(int page, int size, @NonNull Iterable<Long> qEntityIds, @NonNull String filterText) {
        if (qEntityIds == null) {
            throw new NullPointerException("qEntityIds is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        SubProjectRepository.SubProjectSpecifications.nameLike((String)filterText).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        SubProjectRepository.SubProjectSpecifications.qEntityIdIn(qEntityIds).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList specs = specsBuilder.build();
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"name")});
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)sort);
        Specification conjunction = SubProjectRepository.SubProjectSpecifications.conjunction((Specification)SubProjectRepository.SubProjectSpecifications.identity(), (Iterable)specs);
        return this.repository.findAll(conjunction, (Pageable)pageRequest);
    }

    public boolean dirty() {
        return !this.repository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)1)).isEmpty();
    }

    @Nonnull
    public Iterable<SubProject> dirtyPage(int max) {
        return this.repository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)max, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"updatedOn", "id"})));
    }

    public int markIndexed(@NonNull Iterable<SubProject> itemsProcessed) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        ImmutableSet subProjectIds = (ImmutableSet)Streams.stream(itemsProcessed).map(SubProject::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return this.repository.updateSearchIndexState(ESearchIndexState.INDEXED, (Iterable)subProjectIds);
    }
}

