/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.jpa.queue.EProcessingState;
import de.qfm.erp.service.model.jpa.quotation.StagePropagation;
import de.qfm.erp.service.repository.StagePropagationRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class StagePropagationHandler
extends BaseHandler<StagePropagation> {
    private static final Logger log = LogManager.getLogger(StagePropagationHandler.class);
    private final StagePropagationRepository stagePropagationRepository;

    @Autowired
    public StagePropagationHandler(StandardPersistenceHelper standardPersistenceHelper, StagePropagationRepository stagePropagationRepository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)stagePropagationRepository);
        this.stagePropagationRepository = stagePropagationRepository;
    }

    protected Class<StagePropagation> clazz() {
        return StagePropagation.class;
    }

    @Nonnull
    protected StagePropagation beforeUpdate(@NonNull StagePropagation item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected StagePropagation beforeDelete(@NonNull StagePropagation item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected StagePropagation afterUpdate(@NonNull StagePropagation item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected StagePropagation afterDelete(@NonNull StagePropagation item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Iterable<Long> lastBatches(@NonNull Iterable<Long> filterStageIds, int size) {
        if (filterStageIds == null) {
            throw new NullPointerException("filterStageIds is marked non-null but is null");
        }
        return this.stagePropagationRepository.lastBatch(filterStageIds, (Pageable)PageRequest.of((int)0, (int)size));
    }

    @Nonnull
    public Iterable<Long> unfinishedBatches(@NonNull Iterable<Long> filterStageIds) {
        if (filterStageIds == null) {
            throw new NullPointerException("filterStageIds is marked non-null but is null");
        }
        return this.stagePropagationRepository.unfinishedBatches(filterStageIds);
    }

    @Nonnull
    public Iterable<StagePropagation> list(@NonNull Iterable<Long> filterStageIds, @NonNull Iterable<Long> batches, boolean showProcessed) {
        if (filterStageIds == null) {
            throw new NullPointerException("filterStageIds is marked non-null but is null");
        }
        if (batches == null) {
            throw new NullPointerException("batches is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        ImmutableSet processingStates = showProcessed ? ImmutableSet.of((Object)EProcessingState.UNPROCESSED, (Object)EProcessingState.PROCESSED) : ImmutableSet.of((Object)EProcessingState.UNPROCESSED);
        StagePropagationRepository.processingStateIn((Iterable)processingStates).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        StagePropagationRepository.batchIn(batches).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        StagePropagationRepository.sourceStageIdIn(filterStageIds).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList globalSpecs = specsBuilder.build();
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"id")});
        PageRequest pageRequest = PageRequest.of((int)0, (int)1000, (Sort)sort);
        Specification conjunction = StagePropagationRepository.conjunction((Iterable)globalSpecs);
        return this.stagePropagationRepository.findAll(conjunction, (Pageable)pageRequest);
    }

    @Nonnull
    public Iterable<StagePropagation> nextUnprocessed() {
        return this.stagePropagationRepository.nextUnprocessed((Pageable)PageRequest.of((int)0, (int)1));
    }
}

