/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.JpaConfig;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.repository.StagePositionRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class StagePositionHandler
extends BaseHandler<QuotationPosition> {
    private static final Logger log = LogManager.getLogger(StagePositionHandler.class);
    private final JpaConfig jpaConfig;
    private final StagePositionRepository stagePositionRepository;

    @Autowired
    public StagePositionHandler(StandardPersistenceHelper standardPersistenceHelper, JpaConfig jpaConfig, StagePositionRepository stagePositionRepository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)stagePositionRepository);
        this.jpaConfig = jpaConfig;
        this.stagePositionRepository = stagePositionRepository;
    }

    protected Class<QuotationPosition> clazz() {
        return QuotationPosition.class;
    }

    @Nonnull
    protected QuotationPosition beforeUpdate(@NonNull QuotationPosition item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected QuotationPosition beforeDelete(@NonNull QuotationPosition item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected QuotationPosition afterUpdate(@NonNull QuotationPosition item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected QuotationPosition afterDelete(@NonNull QuotationPosition item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public List<QuotationPosition> byIds(@NonNull Iterable<Long> stagePositionIds) {
        if (stagePositionIds == null) {
            throw new NullPointerException("stagePositionIds is marked non-null but is null");
        }
        int databaseClauseLimit = this.jpaConfig.getDatabaseClauseLimit();
        Set uniqueStagePositionIds = Streams.stream(stagePositionIds).filter(Objects::nonNull).collect(Collectors.toSet());
        Iterable partitions = Iterables.partition(uniqueStagePositionIds, (int)databaseClauseLimit);
        ImmutableList.Builder positionBuilder = ImmutableList.builder();
        positionBuilder.addAll(((Stream)Streams.stream((Iterable)partitions).parallel()).flatMap(partition -> this.stagePositionRepository.findAllById((Iterable)partition).stream()).iterator());
        return positionBuilder.build();
    }

    @Nonnull
    public List<QuotationPosition> allByReferencePosition(@NonNull Quotation stage, @NonNull Iterable<QuotationPosition> stagePositions) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (stagePositions == null) {
            throw new NullPointerException("stagePositions is marked non-null but is null");
        }
        int databaseClauseLimit = this.jpaConfig.getDatabaseClauseLimit();
        Set uniqueStagePositions = Streams.stream(stagePositions).filter(Objects::nonNull).collect(Collectors.toSet());
        Iterable positionPartitions = Iterables.partition(uniqueStagePositions, (int)databaseClauseLimit);
        ImmutableList.Builder positionBuilder = ImmutableList.builder();
        positionBuilder.addAll(((Stream)Streams.stream((Iterable)positionPartitions).parallel()).flatMap(partition -> this.stagePositionRepository.findAllByReferencePositionIn(stage, (Collection)partition).stream()).iterator());
        return positionBuilder.build();
    }

    @Nonnull
    public Page<QuotationPosition> positions(@NonNull Iterable<Long> stageIds, @NonNull Iterable<EPositionType> positionTypes, @NonNull String filterStageText, @NonNull String filterText) {
        if (stageIds == null) {
            throw new NullPointerException("stageIds is marked non-null but is null");
        }
        if (positionTypes == null) {
            throw new NullPointerException("positionTypes is marked non-null but is null");
        }
        if (filterStageText == null) {
            throw new NullPointerException("filterStageText is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        ImmutableSet tokens = ImmutableSet.copyOf((Iterable)Splitter.on((char)' ').trimResults().split((CharSequence)filterText));
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        for (String token : tokens) {
            ImmutableList.Builder localSpecsBuilder = ImmutableList.builder();
            StagePositionRepository.QuotationPositionSpec.shortTextLike((String)token).ifPresent(arg_0 -> ((ImmutableList.Builder)localSpecsBuilder).add(arg_0));
            ImmutableList localSpecs = localSpecsBuilder.build();
            StagePositionRepository.QuotationPositionSpec.disjunction((Iterable)localSpecs).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        }
        StagePositionRepository.QuotationPositionSpec.stageIdsIn(stageIds).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        StagePositionRepository.QuotationPositionSpec.stageText((String)filterStageText).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        StagePositionRepository.QuotationPositionSpec.positionTypesIn(positionTypes).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList globalSpecs = specsBuilder.build();
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"id")});
        PageRequest pageRequest = PageRequest.of((int)0, (int)10000, (Sort)sort);
        Specification conjunction = StagePositionRepository.QuotationPositionSpec.conjunction((Iterable)globalSpecs);
        return this.stagePositionRepository.findAll(conjunction, (Pageable)pageRequest);
    }
}

