/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.JpaConfig;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.QuotationHelper;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.invoice.AddendumDiscount;
import de.qfm.erp.service.model.internal.quotation.ECostUnitCEViewMode;
import de.qfm.erp.service.model.internal.quotation.StageAmountPriceWage;
import de.qfm.erp.service.model.internal.quotation.StageBudget;
import de.qfm.erp.service.model.internal.quotation.StageIdTypeState;
import de.qfm.erp.service.model.internal.quotation.StageTypeAndState;
import de.qfm.erp.service.model.jpa.EPsxNotifyState;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.quotation.EER2ExportState;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.repository.QuotationRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class StageHandler
extends BaseHandler<Quotation> {
    private static final Logger log = LogManager.getLogger(StageHandler.class);
    List<EntityState> ENTITY_STATES__NOT_DELETED = ImmutableList.of((Object)EntityState.VALID);
    private final JpaConfig jpaConfig;
    private final EntityManager em;
    private final QuotationRepository stageRepository;

    @Autowired
    public StageHandler(StandardPersistenceHelper standardPersistenceHelper, JpaConfig jpaConfig, EntityManager em, QuotationRepository stageRepository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)stageRepository);
        this.jpaConfig = jpaConfig;
        this.em = em;
        this.stageRepository = stageRepository;
    }

    protected Class<Quotation> clazz() {
        return Quotation.class;
    }

    @Nonnull
    public Quotation update(@NonNull Quotation item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return (Quotation)super.update((EntityBase)item);
    }

    @Nonnull
    protected Quotation beforeUpdate(@NonNull Quotation item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        EStageOrigin origin = item.getOrigin();
        String supposedQuotationNumber = item.getQNumber();
        String existingQuotationNumber = item.getQuotationNumber();
        if (EStageOrigin.QUANTE_V2 == origin && StringUtils.isBlank((CharSequence)existingQuotationNumber)) {
            item.setQuotationNumber(supposedQuotationNumber);
        } else if (EStageOrigin.QUANTE_V2 == origin && StringUtils.isNotBlank((CharSequence)existingQuotationNumber) && !StringUtils.equalsIgnoreCase((CharSequence)existingQuotationNumber, (CharSequence)supposedQuotationNumber)) {
            item.setQuotationNumber(supposedQuotationNumber);
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        item.setPsxNotifyState(EPsxNotifyState.NOT_NOTIFIED);
        return item;
    }

    @Nonnull
    protected Quotation beforeDelete(@NonNull Quotation item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        item.setPsxNotifyState(EPsxNotifyState.NOT_NOTIFIED);
        return item;
    }

    @Nonnull
    protected Quotation afterUpdate(@NonNull Quotation item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Quotation afterDelete(@NonNull Quotation item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Quotation byReferenceIdFailing(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        Optional byId = this.byReferenceIdNotFailing(referenceId);
        if (byId.isEmpty()) {
            throw ResourceNotFoundException.of((String)Quotation.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.REFERENCE_ID), (String)referenceId);
        }
        return (Quotation)byId.get();
    }

    @Nonnull
    public Optional<Quotation> byReferenceIdNotFailing(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        return this.stageRepository.findByReferenceId(referenceId);
    }

    @Nonnull
    public Quotation firstByQuotationNumberFailing(@NonNull String quotationNumber) {
        if (quotationNumber == null) {
            throw new NullPointerException("quotationNumber is marked non-null but is null");
        }
        Optional quotationByQuotationNumber = this.firstQuotationByQuotationNumberNotFailing(quotationNumber);
        if (quotationByQuotationNumber.isEmpty()) {
            throw ResourceNotFoundException.of((String)Quotation.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.QSTAGE__QUOTATION_NUMBER), (String)quotationNumber);
        }
        return (Quotation)quotationByQuotationNumber.get();
    }

    @Nonnull
    public List<Quotation> allQuotationsByQuotationNumberFailing(@NonNull String quotationNumber) {
        if (quotationNumber == null) {
            throw new NullPointerException("quotationNumber is marked non-null but is null");
        }
        List quotationList = this.allQuotationsByQuotationNumberNotFailing(quotationNumber);
        if (quotationList.isEmpty()) {
            throw ResourceNotFoundException.of((String)Quotation.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.QSTAGE__QUOTATION_NUMBER), (String)quotationNumber);
        }
        return ImmutableList.copyOf((Collection)quotationList);
    }

    @Nonnull
    public List<Quotation> allQuotationsByQuotationNumberNotFailing(@NonNull String quotationNumber) {
        if (quotationNumber == null) {
            throw new NullPointerException("quotationNumber is marked non-null but is null");
        }
        return this.stageRepository.findAllByQuotationNumber(quotationNumber);
    }

    @Nonnull
    public Page<Quotation> newInvoiceAutoCompleteByText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        ImmutableSet tokens = ImmutableSet.copyOf((Iterable)Splitter.on((char)' ').trimResults().split((CharSequence)text));
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        for (String token : tokens) {
            ImmutableList.Builder localSpecsBuilder = ImmutableList.builder();
            QuotationRepository.QuotationSpecifications.quotationNumberLike((String)token).ifPresent(arg_0 -> ((ImmutableList.Builder)localSpecsBuilder).add(arg_0));
            QuotationRepository.QuotationSpecifications.financeCostUnitLike((String)token).ifPresent(arg_0 -> ((ImmutableList.Builder)localSpecsBuilder).add(arg_0));
            QuotationRepository.QuotationSpecifications.qNumberLike((String)token).ifPresent(arg_0 -> ((ImmutableList.Builder)localSpecsBuilder).add(arg_0));
            QuotationRepository.QuotationSpecifications.aliasLike((String)token).ifPresent(arg_0 -> ((ImmutableList.Builder)localSpecsBuilder).add(arg_0));
            ImmutableList localSpecs = localSpecsBuilder.build();
            QuotationRepository.QuotationSpecifications.disjunction((Iterable)localSpecs).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        }
        QuotationRepository.QuotationSpecifications.mainCommission().ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.stageTypesAndStates((Iterable)StageTypeAndState.from((Multimap)StageHelper.MEASUREMENT_ACTIVE__COMMISSION_TYPE_AND_STATES)).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList globalSpecs = specsBuilder.build();
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"id")});
        PageRequest pageRequest = PageRequest.of((int)0, (int)25, (Sort)sort);
        Specification conjunction = QuotationRepository.QuotationSpecifications.conjunction((Iterable)globalSpecs);
        return this.stageRepository.findAll(conjunction, (Pageable)pageRequest);
    }

    @Nonnull
    public Page<Quotation> autoComplete(@NonNull String text, @NonNull Iterable<QEntity> filterByQEntities, @NonNull Iterable<Integer> filterVersions, @NonNull Iterable<StageTypeAndState> stageTypeAndStates) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (filterByQEntities == null) {
            throw new NullPointerException("filterByQEntities is marked non-null but is null");
        }
        if (filterVersions == null) {
            throw new NullPointerException("filterVersions is marked non-null but is null");
        }
        if (stageTypeAndStates == null) {
            throw new NullPointerException("stageTypeAndStates is marked non-null but is null");
        }
        ImmutableSet tokens = ImmutableSet.copyOf((Iterable)Splitter.on((char)' ').trimResults().split((CharSequence)text));
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        for (String token : tokens) {
            ImmutableList.Builder localSpecsBuilder = ImmutableList.builder();
            QuotationRepository.QuotationSpecifications.aliasLike((String)token).ifPresent(arg_0 -> ((ImmutableList.Builder)localSpecsBuilder).add(arg_0));
            QuotationRepository.QuotationSpecifications.qNumberLike((String)token).ifPresent(arg_0 -> ((ImmutableList.Builder)localSpecsBuilder).add(arg_0));
            ImmutableList localSpecs = localSpecsBuilder.build();
            QuotationRepository.QuotationSpecifications.disjunction((Iterable)localSpecs).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        }
        QuotationRepository.QuotationSpecifications.stageTypesAndStates(stageTypeAndStates).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.versionIn(filterVersions).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.entitiesIn(filterByQEntities).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList globalSpecs = specsBuilder.build();
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"id")});
        PageRequest pageRequest = PageRequest.of((int)0, (int)25, (Sort)sort);
        Specification conjunction = QuotationRepository.QuotationSpecifications.conjunction((Iterable)globalSpecs);
        return this.stageRepository.findAll(conjunction, (Pageable)pageRequest);
    }

    @Nonnull
    public Page<Quotation> page(int page, int size, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        return this.stages((Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), filterText, (Pageable)PageRequest.of((int)page, (int)size));
    }

    @Nonnull
    public Page<Quotation> stages(@NonNull Iterable<QEntity> qEntities, @NonNull Iterable<Integer> versions, @NonNull Iterable<Quotation> stageOrParentStageIn, @NonNull Iterable<Customer> customers, @NonNull Iterable<StageTypeAndState> stageTypesAndStates, @NonNull String filterText) {
        if (qEntities == null) {
            throw new NullPointerException("qEntities is marked non-null but is null");
        }
        if (versions == null) {
            throw new NullPointerException("versions is marked non-null but is null");
        }
        if (stageOrParentStageIn == null) {
            throw new NullPointerException("stageOrParentStageIn is marked non-null but is null");
        }
        if (customers == null) {
            throw new NullPointerException("customers is marked non-null but is null");
        }
        if (stageTypesAndStates == null) {
            throw new NullPointerException("stageTypesAndStates is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        return this.stages(qEntities, versions, stageOrParentStageIn, customers, stageTypesAndStates, filterText, Pageable.unpaged());
    }

    @Nonnull
    public Page<Quotation> stages(@NonNull Iterable<QEntity> qEntities, @NonNull Iterable<Integer> versions, @NonNull Iterable<Quotation> stageOrParentStageIn, @NonNull Iterable<Customer> customers, @NonNull Iterable<StageTypeAndState> stageTypesAndStates, @NonNull String filterText, @NonNull Pageable pageable) {
        if (qEntities == null) {
            throw new NullPointerException("qEntities is marked non-null but is null");
        }
        if (versions == null) {
            throw new NullPointerException("versions is marked non-null but is null");
        }
        if (stageOrParentStageIn == null) {
            throw new NullPointerException("stageOrParentStageIn is marked non-null but is null");
        }
        if (customers == null) {
            throw new NullPointerException("customers is marked non-null but is null");
        }
        if (stageTypesAndStates == null) {
            throw new NullPointerException("stageTypesAndStates is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (pageable == null) {
            throw new NullPointerException("pageable is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        QuotationRepository.QuotationSpecifications.entitiesIn(qEntities).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.versionIn(versions).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.stageOrParentStageIn(stageOrParentStageIn).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.stageTypesAndStates(stageTypesAndStates).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.customersIn(customers).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.filterText((String)filterText).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList globalSpecs = specsBuilder.build();
        Specification conjunction = QuotationRepository.QuotationSpecifications.conjunction((Iterable)globalSpecs);
        return this.stageRepository.findAll(conjunction, pageable);
    }

    @NonNull
    public List<QuotationPosition> allQuotationPositionsByQuotationNumberFailing(@NonNull Quotation quotation, boolean ignoreCommissionFlag) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        return this.allQuotationPositionsByQuotationNumberFailing(quotation.getQuotationNumber(), ignoreCommissionFlag);
    }

    @NonNull
    public List<QuotationPosition> allQuotationPositionsByQuotationNumberFailing(@NonNull String quotationNumber, boolean ignoreCommissionFlag) {
        if (quotationNumber == null) {
            throw new NullPointerException("quotationNumber is marked non-null but is null");
        }
        List allQuotations = this.allQuotationsByQuotationNumberFailing(quotationNumber);
        return ImmutableList.copyOf(allQuotations.stream().filter(item -> ignoreCommissionFlag || item.getFlagMeasurementWithoutCommissionNumberAllowed() != false).map(Quotation::getQuotationPositions).flatMap(Collection::stream).iterator());
    }

    @Nonnull
    public Map<Long, BigDecimal> stageDiscountsAsMap(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Iterable iAddendumDiscounts = this.allStageDiscounts(stage);
        return MapsHelper.mapKeyAndValue((Iterable)iAddendumDiscounts, item -> (Long)MoreObjects.firstNonNull((Object)item.getAddendumNumber(), (Object)0L), QuotationHelper::discount);
    }

    @Nonnull
    public Iterable<StageIdTypeState> fetchStageIdTypeState(@NonNull QEntity entity, @NonNull Iterable<EQStageType> stageTypes) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (stageTypes == null) {
            throw new NullPointerException("stageTypes is marked non-null but is null");
        }
        return this.fetchStageIdTypeState(entity.getId(), stageTypes);
    }

    @Nonnull
    public Iterable<AddendumDiscount> allStageDiscounts(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        return this.allStageDiscounts((Iterable)ImmutableList.of((Object)stage));
    }

    @Nonnull
    public Iterable<AddendumDiscount> allStageDiscounts(@NonNull Iterable<Quotation> stages) {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        ImmutableList.Builder allAddendumDiscountsBuilder = ImmutableList.builder();
        for (Quotation stage : stages) {
            Long stageId = stage.getId();
            EQStageType stageType = stage.getStageType();
            Integer stageVersion = stage.getVersion();
            ArrayList localAddendumDiscountsBuilder = Lists.newArrayList();
            if (EQStageType.COMMISSION == stageType || EQStageType.COMMISSION__COST_UNIT == stageType || EQStageType.COMMISSION__COST_UNIT__CE == stageType) {
                List allDiscountsByStageId = this.allDiscountsByStageId(stageId);
                for (AddendumDiscount addendumDiscount : allDiscountsByStageId) {
                    Integer addendumDiscountVersion = addendumDiscount.getVersion();
                    if (!Objects.equals(stageVersion, addendumDiscountVersion)) continue;
                    localAddendumDiscountsBuilder.add(addendumDiscount);
                }
            }
            allAddendumDiscountsBuilder.addAll((Iterable)localAddendumDiscountsBuilder);
        }
        return allAddendumDiscountsBuilder.build();
    }

    @Nonnull
    private List<AddendumDiscount> allDiscountsByStageId(@NonNull Long stageId) {
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        return this.stageRepository.allStageDiscountsOfTypeByStageId(stageId, (Iterable)ImmutableList.of((Object)EQStageType.COMMISSION__ADDENDUM, (Object)EQStageType.COST_UNIT__ADDENDUM), EQStageState.ACCOUNTABLE_STAGE_STATES);
    }

    @Nonnull
    private List<StageIdTypeState> fetchStageIdTypeState(@NonNull Long entityId, @NonNull Iterable<EQStageType> stageTypes) {
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        if (stageTypes == null) {
            throw new NullPointerException("stageTypes is marked non-null but is null");
        }
        return this.stageRepository.fetchStageIdTypeState(entityId, stageTypes);
    }

    @Nonnull
    public Optional<Quotation> firstQuotationByQuotationNumberNotFailing(@NonNull String quotationNumber) {
        if (quotationNumber == null) {
            throw new NullPointerException("quotationNumber is marked non-null but is null");
        }
        return this.stageRepository.findFirstQuotationByQuotationNumberEqualsOrderByAddendumNumberAsc(quotationNumber);
    }

    @Nonnull
    public Optional<Quotation> byQuotationNumberNotFailing(@NonNull String quotationNumber, @NonNull Long addendumNumber) {
        if (quotationNumber == null) {
            throw new NullPointerException("quotationNumber is marked non-null but is null");
        }
        if (addendumNumber == null) {
            throw new NullPointerException("addendumNumber is marked non-null but is null");
        }
        return this.stageRepository.findQuotationByQuotationNumberEqualsAndAddendumNumberEquals(quotationNumber, addendumNumber);
    }

    @Deprecated
    public boolean quotationNumberExists(@NonNull String quotationNumber, @NonNull Long addendumNumber) {
        if (quotationNumber == null) {
            throw new NullPointerException("quotationNumber is marked non-null but is null");
        }
        if (addendumNumber == null) {
            throw new NullPointerException("addendumNumber is marked non-null but is null");
        }
        return this.stageRepository.findQuotationByQuotationNumberEqualsAndAddendumNumberEquals(quotationNumber, addendumNumber).isPresent();
    }

    @Nonnull
    public Optional<Quotation> byStageNumberNotFailing(@NonNull String stageNumber) {
        if (stageNumber == null) {
            throw new NullPointerException("stageNumber is marked non-null but is null");
        }
        PageRequest pageable = PageRequest.of((int)0, (int)1, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        List byStageNumber = this.stageRepository.findByStageNumber(stageNumber, (Pageable)pageable);
        if (Iterables.isEmpty((Iterable)byStageNumber)) {
            return Optional.empty();
        }
        return Optional.of((Quotation)byStageNumber.get(0));
    }

    @Nonnull
    public List<StageAmountPriceWage> amountPriceWage(@NonNull Iterable<Long> stageIds, @NonNull Iterable<Long> positionIds, @NonNull Iterable<EPositionType> positionTypes) {
        if (stageIds == null) {
            throw new NullPointerException("stageIds is marked non-null but is null");
        }
        if (positionIds == null) {
            throw new NullPointerException("positionIds is marked non-null but is null");
        }
        if (positionTypes == null) {
            throw new NullPointerException("positionTypes is marked non-null but is null");
        }
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(StageAmountPriceWage.class);
        Root fetchRoot = fetchQuery.from(Quotation.class);
        Join childrenProd_Q_QE = fetchRoot.join("qEntity", JoinType.LEFT);
        Join childrenProd_Q_P = fetchRoot.join("project", JoinType.LEFT);
        Join childrenProd_Q_SP = fetchRoot.join("subProject", JoinType.LEFT);
        Join childrenProd_Q_QP = fetchRoot.join("quotationPositions", JoinType.INNER);
        Join childrenProd_QP_QP = childrenProd_Q_QP.join("referencePosition", JoinType.LEFT);
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        QuotationRepository.QuotationSpecifications.stageIdIn(stageIds).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.positionIdIn((Join)childrenProd_Q_QP, positionIds).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.positionTypeIn((Join)childrenProd_Q_QP, positionTypes).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        ImmutableList predicates = predicatesBuilder.build();
        Predicate predicate = QuotationRepository.QuotationSpecifications.conjunction((Iterable)predicates).toPredicate(fetchRoot, fetchQuery, criteriaBuilder);
        CriteriaQuery amountPriceWageQuery = fetchQuery.multiselect(new Selection[]{fetchRoot.get("id").alias("stageId"), fetchRoot.get("qNumber").alias("stageNumber"), fetchRoot.get("alias").alias("stageAlias"), fetchRoot.get("version").alias("stageVersion"), fetchRoot.get("addendumNumber").alias("addendumNumber"), childrenProd_Q_QE.get("id").alias("entityId"), childrenProd_Q_QE.get("qNumber").alias("entityNumber"), childrenProd_Q_QE.get("alias").alias("entityAlias"), childrenProd_Q_P.get("id").alias("projectId"), childrenProd_Q_P.get("name").alias("projectName"), childrenProd_Q_P.get("referenceId").alias("projectReferenceId"), childrenProd_Q_SP.get("id").alias("subProjectId"), childrenProd_Q_SP.get("name").alias("subProjectName"), childrenProd_Q_QP.get("id").alias("positionId"), childrenProd_QP_QP.get("id").alias("referencePositionId"), childrenProd_Q_QP.get("positionType").alias("positionType"), childrenProd_Q_QP.get("positionNumber").alias("positionNumber"), childrenProd_Q_QP.get("subPositionNumber").alias("subPositionNumber"), childrenProd_Q_QP.get("surrogatePositionNumber").alias("surrogatePositionNumber"), childrenProd_Q_QP.get("shortText").alias("shortText"), childrenProd_Q_QP.get("longText").alias("longText"), childrenProd_Q_QP.get("unit").alias("unit"), childrenProd_Q_QP.get("alternativePositionType").alias("alternativePositionType"), childrenProd_Q_QP.get("sequenceNumberQuotationStandard").alias("sequenceNumberQuotationStandard"), childrenProd_Q_QP.get("orderedAmount").alias("product"), childrenProd_Q_QP.get("pricePerUnit").alias("pricePerUnit"), childrenProd_Q_QP.get("priceAggregated").alias("price"), childrenProd_Q_QP.get("squadWageAggregated").alias("squadWageAggregated"), childrenProd_Q_QP.get("companyWageAggregated").alias("companyWageAggregated"), childrenProd_Q_QP.get("materialSellingPriceAggregated").alias("materialSellingPriceAggregated"), childrenProd_Q_QP.get("externalServiceSellingPriceAggregated").alias("externalServiceSellingPriceAggregated")}).where((Expression)predicate);
        TypedQuery query = this.em.createQuery(amountPriceWageQuery);
        List resultList = query.getResultList();
        return resultList;
    }

    @Nonnull
    public Page<Quotation> page(int page, int size, @NonNull Iterable<String> quotationNumbers) {
        if (quotationNumbers == null) {
            throw new NullPointerException("quotationNumbers is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        QuotationRepository.QuotationSpecifications.entityStatesIn((Iterable)this.ENTITY_STATES__NOT_DELETED).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.quotationNumberIn(quotationNumbers).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList specs = specsBuilder.build();
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"id")});
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)sort);
        Specification conjunction = QuotationRepository.QuotationSpecifications.conjunction((Specification)QuotationRepository.QuotationSpecifications.identity(), (Iterable)specs);
        return this.stageRepository.findAll(conjunction, (Pageable)pageRequest);
    }

    public int patchAlias(@NonNull Long stageId, @NonNull String aliasNew, @NonNull Boolean aliasChanged) {
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        if (aliasNew == null) {
            throw new NullPointerException("aliasNew is marked non-null but is null");
        }
        if (aliasChanged == null) {
            throw new NullPointerException("aliasChanged is marked non-null but is null");
        }
        return this.stageRepository.patchAlias(stageId, aliasNew, aliasChanged);
    }

    public int patchER2(@NonNull Long id, @NonNull LocalDateTime er2ExportedOn, @NonNull String er2ExportedToPath, @NonNull EER2ExportState exportState) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (er2ExportedOn == null) {
            throw new NullPointerException("er2ExportedOn is marked non-null but is null");
        }
        if (er2ExportedToPath == null) {
            throw new NullPointerException("er2ExportedToPath is marked non-null but is null");
        }
        if (exportState == null) {
            throw new NullPointerException("exportState is marked non-null but is null");
        }
        return this.stageRepository.patchER2(id, er2ExportedOn, er2ExportedToPath, exportState);
    }

    public int patchProject(@NonNull Long stageId, @Nullable Project project) {
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        return this.stageRepository.patchProject(stageId, project);
    }

    @Nonnull
    public Optional<Integer> maxVersion(@NonNull Long entityId) {
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        return this.stageRepository.maxVersion(entityId);
    }

    public void applyLastInvoice(@NonNull Quotation stage, @NonNull Invoice invoice) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        this.stageRepository.applyLastInvoice(stage, invoice);
    }

    public void applyFinalInvoice(@NonNull Quotation stage, @NonNull Invoice invoice) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        this.stageRepository.applyFinalInvoice(stage, invoice);
    }

    @Nonnull
    public Iterable<Quotation> stagesUsedInPositions(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        return this.stageRepository.stagesUsedInPositions(measurement);
    }

    @Nonnull
    public Map<Quotation, Iterable<QuotationPosition>> allPositionStages(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        return this.allPositionStages(stage, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of((Object)ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE), true);
    }

    @Nonnull
    public Map<Quotation, Iterable<QuotationPosition>> allPositionStages(@NonNull Quotation stage, @NonNull ECostUnitCEViewMode costUnitCEViewMode, boolean considerCommissionFlag) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (costUnitCEViewMode == null) {
            throw new NullPointerException("costUnitCEViewMode is marked non-null but is null");
        }
        return this.allPositionStages(stage, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of((Object)costUnitCEViewMode), considerCommissionFlag);
    }

    @Nonnull
    public Map<Quotation, Iterable<QuotationPosition>> allPositionStages(@NonNull Quotation stage, @NonNull Iterable<Quotation> additionalStages, @NonNull Iterable<ECostUnitCEViewMode> costUnitCEViewModes, boolean considerCommissionFlag) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (additionalStages == null) {
            throw new NullPointerException("additionalStages is marked non-null but is null");
        }
        if (costUnitCEViewModes == null) {
            throw new NullPointerException("costUnitCEViewModes is marked non-null but is null");
        }
        QEntity entity = stage.getQEntity();
        Integer version = stage.getVersion();
        EQStageType stageType = stage.getStageType();
        ImmutableSet versions = null != version ? ImmutableSet.of((Object)version) : ImmutableSet.of();
        ImmutableSet.Builder allStages = ImmutableSet.builder();
        if (stageType == EQStageType.COMMISSION__COST_UNIT) {
            Iterable stageTypeAndStates = StageHelper.accountableStates((Quotation)stage, (boolean)considerCommissionFlag);
            Page costUnitAddendumList = this.stages((Iterable)ImmutableSet.of((Object)entity), (Iterable)versions, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), stageTypeAndStates, "", Pageable.unpaged());
            allStages.add((Object)stage);
            allStages.addAll((Iterable)costUnitAddendumList);
        } else if (stageType == EQStageType.COMMISSION__COST_UNIT__CE) {
            Iterable stageTypeAndStates = StageHelper.accountableStates((Quotation)stage, (boolean)considerCommissionFlag);
            Page costUnitAddendumList = this.stages((Iterable)ImmutableSet.of((Object)entity), (Iterable)versions, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), stageTypeAndStates, "", Pageable.unpaged());
            Quotation commission = entity.getPrimaryStage();
            if (Iterables.contains(costUnitCEViewModes, (Object)ECostUnitCEViewMode.COMMISSION)) {
                allStages.add((Object)commission);
            }
            if (Iterables.contains(costUnitCEViewModes, (Object)ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE)) {
                allStages.add((Object)stage);
            }
            allStages.addAll((Iterable)costUnitAddendumList);
        } else if (stageType == EQStageType.QUOTATION) {
            Iterable stageTypeAndStates = StageHelper.accountableStates((Quotation)stage, (boolean)considerCommissionFlag);
            Page costUnitAddendumList = this.stages((Iterable)ImmutableSet.of((Object)entity), (Iterable)versions, (Iterable)ImmutableSet.of((Object)stage), (Iterable)ImmutableSet.of(), stageTypeAndStates, "", Pageable.unpaged());
            allStages.add((Object)stage);
            allStages.addAll((Iterable)costUnitAddendumList);
        } else {
            Iterable stageTypeAndStates = StageHelper.accountableStates((Quotation)stage, (boolean)considerCommissionFlag);
            Page stages = this.stages((Iterable)ImmutableSet.of((Object)entity), (Iterable)versions, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), stageTypeAndStates, "", Pageable.unpaged());
            allStages.addAll((Iterable)stages);
        }
        allStages.addAll(additionalStages);
        return (Map)allStages.build().stream().collect(ImmutableMap.toImmutableMap(item -> item, item -> (Iterable)MoreObjects.firstNonNull((Object)item.getQuotationPositions(), (Object)ImmutableSet.of())));
    }

    @Nonnull
    public List<Quotation> allWithReferencePositionForStagePropagation(@NonNull QEntity entity, @NonNull Iterable<QuotationPosition> referencePositions) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (referencePositions == null) {
            throw new NullPointerException("referencePositions is marked non-null but is null");
        }
        int databaseClauseLimit = this.jpaConfig.getDatabaseClauseLimit();
        Set uniqueReferencePositions = Streams.stream(referencePositions).filter(Objects::nonNull).collect(Collectors.toSet());
        Iterable referencePositionPartitions = Iterables.partition(uniqueReferencePositions, (int)databaseClauseLimit);
        ImmutableList.Builder positionBuilder = ImmutableList.builder();
        positionBuilder.addAll(((Stream)Streams.stream((Iterable)referencePositionPartitions).parallel()).flatMap(partition -> this.stageRepository.allWithReferencePosition(entity, (Iterable)partition, EQStageType.STAGE_PROPAGATION_RECIPIENTS).stream()).iterator());
        return positionBuilder.build();
    }

    @Nonnull
    public Optional<Quotation> costUnitsForCostEstimate(@NonNull Quotation referenceStage) {
        if (referenceStage == null) {
            throw new NullPointerException("referenceStage is marked non-null but is null");
        }
        return this.stageRepository.costUnitForCostEstimate(EQStageType.COMMISSION__COST_UNIT__CE, referenceStage);
    }

    @Nonnull
    public Iterable<Quotation> notExportedToDMS(int diamantPushBatchSize) {
        Sort sortById = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"id"});
        return this.stageRepository.findAllByEr2ExportState(EER2ExportState.NOT_EXPORTED, sortById);
    }

    @Nonnull
    public Iterable<StageBudget> budgets(@NonNull Iterable<Quotation> stages, @NonNull Iterable<QEntity> entities, @NonNull Iterable<EQStageType> budgetTypes, @NonNull Iterable<EQStageState> budgetStates) {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        if (budgetTypes == null) {
            throw new NullPointerException("budgetTypes is marked non-null but is null");
        }
        if (budgetStates == null) {
            throw new NullPointerException("budgetStates is marked non-null but is null");
        }
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(StageBudget.class);
        Root fetchRoot = fetchQuery.from(Quotation.class);
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        QuotationRepository.QuotationSpecifications.stagesIn(stages).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.entitiesIn(entities).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.stageTypeIn(budgetTypes).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        QuotationRepository.QuotationSpecifications.stageStateIn(budgetStates).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        ImmutableList predicates = predicatesBuilder.build();
        Predicate predicate = QuotationRepository.QuotationSpecifications.conjunction((Iterable)predicates).toPredicate(fetchRoot, fetchQuery, criteriaBuilder);
        CriteriaQuery amountPriceWageQuery = fetchQuery.multiselect(new Selection[]{fetchRoot.get("id").alias("stageId"), fetchRoot.get("version").alias("version"), fetchRoot.get("stageType").alias("stageType"), fetchRoot.get("stageState").alias("stageState"), fetchRoot.get("flagBudgetRelevant").alias("flagBudgetRelevant"), fetchRoot.get("flagCrossVersionOrderValue").alias("flagCrossVersionOrderValue"), fetchRoot.get("orderValue").alias("orderValue"), fetchRoot.get("orderValueEstimate").alias("orderValueEstimate"), fetchRoot.get("budgetAllowedOverdraftPercent").alias("budgetAllowedOverdraftPercent"), fetchRoot.get("budgetAllowedOverdraftValue").alias("budgetAllowedOverdraftValue")}).where((Expression)predicate);
        TypedQuery query = this.em.createQuery(amountPriceWageQuery);
        return query.getResultList();
    }

    public boolean dirty() {
        return !this.stageRepository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)1)).isEmpty();
    }

    @Nonnull
    public Iterable<Quotation> dirtyPage(int max) {
        return this.stageRepository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)max, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"updatedOn", "id"})));
    }

    public int markIndexed(@NonNull Iterable<Quotation> itemsProcessed) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        ImmutableSet stageIds = (ImmutableSet)Streams.stream(itemsProcessed).map(Quotation::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return this.stageRepository.updateSearchIndexState(ESearchIndexState.INDEXED, (Iterable)stageIds);
    }

    @Nonnull
    public Iterable<Quotation> nextNotNotified() {
        return this.stageRepository.nextNotNotified((Pageable)PageRequest.of((int)0, (int)1));
    }

    public int markPsxNotified(long stageId) {
        return this.stageRepository.updatePsxNotifyState(EPsxNotifyState.NOTIFIED, (Iterable)ImmutableSet.of((Object)stageId));
    }
}

