/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthSnapShot;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.PayrollMonthSnapShotRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.time.YearMonth;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class PayrollMonthSnapShotHandler
extends BaseHandler<PayrollMonthSnapShot> {
    private static final Logger log = LogManager.getLogger(PayrollMonthSnapShotHandler.class);
    private final PayrollMonthSnapShotRepository repository;

    @Autowired
    public PayrollMonthSnapShotHandler(StandardPersistenceHelper standardPersistenceHelper, PayrollMonthSnapShotRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<PayrollMonthSnapShot> clazz() {
        return PayrollMonthSnapShot.class;
    }

    @Nonnull
    protected PayrollMonthSnapShot beforeUpdate(@NonNull PayrollMonthSnapShot payrollMonthSnapShot) {
        if (payrollMonthSnapShot == null) {
            throw new NullPointerException("payrollMonthSnapShot is marked non-null but is null");
        }
        return payrollMonthSnapShot;
    }

    @Nonnull
    protected PayrollMonthSnapShot beforeDelete(@NonNull PayrollMonthSnapShot item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PayrollMonthSnapShot afterUpdate(@NonNull PayrollMonthSnapShot item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PayrollMonthSnapShot afterDelete(@NonNull PayrollMonthSnapShot item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Optional<PayrollMonthSnapShot> findByPayrollMonth(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        return this.repository.findByPayrollMonth(payrollMonth);
    }

    @Nonnull
    public Iterable<PayrollMonthSnapShot> findByAccountingMonth(@NonNull YearMonth accountingMonth) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        return this.repository.findByAccountingMonth(accountingMonth.atDay(1));
    }

    @Nonnull
    public Optional<PayrollMonthSnapShot> findByAccountingMonth(@NonNull YearMonth accountingMonth, @NonNull User user) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return this.repository.findByAccountingMonth(accountingMonth.atDay(1), user);
    }
}

