/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import de.qfm.erp.service.model.jpa.invoice.EntityNumber;
import de.qfm.erp.service.repository.EntityNumberRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class EntityNumberHandler
extends BaseHandler<EntityNumber> {
    private static final Logger log = LogManager.getLogger(EntityNumberHandler.class);
    private final EntityNumberRepository repository;

    @Autowired
    public EntityNumberHandler(StandardPersistenceHelper standardPersistenceHelper, EntityNumberRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<EntityNumber> clazz() {
        return EntityNumber.class;
    }

    @Nonnull
    protected EntityNumber beforeUpdate(@NonNull EntityNumber item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected EntityNumber afterUpdate(@NonNull EntityNumber item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected EntityNumber beforeDelete(@NonNull EntityNumber item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected EntityNumber afterDelete(@NonNull EntityNumber item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Optional<EntityNumber> byYearNotFailing(@NonNull Integer year) {
        if (year == null) {
            throw new NullPointerException("year is marked non-null but is null");
        }
        return this.repository.findByYear(year);
    }
}

