/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.quotation.EEntitySort;
import de.qfm.erp.service.model.internal.quotation.EntityStatistics;
import de.qfm.erp.service.model.internal.quotation.QEntityTreeStatistics;
import de.qfm.erp.service.model.jpa.EPsxNotifyState;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.quotation.EQEntityState;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.QEntityRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EntityHandler
extends BaseHandler<QEntity> {
    private static final Logger log = LogManager.getLogger(EntityHandler.class);
    private final EntityManager em;
    private final QEntityRepository entityRepository;

    @Autowired
    public EntityHandler(StandardPersistenceHelper standardPersistenceHelper, EntityManager em, QEntityRepository entityRepository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)entityRepository);
        this.em = em;
        this.entityRepository = entityRepository;
    }

    protected Class<QEntity> clazz() {
        return QEntity.class;
    }

    @Nonnull
    protected QEntity beforeUpdate(@NonNull QEntity item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        item.setPsxNotifyState(EPsxNotifyState.NOT_NOTIFIED);
        return item;
    }

    @Nonnull
    protected QEntity beforeDelete(@NonNull QEntity item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        item.setPsxNotifyState(EPsxNotifyState.NOT_NOTIFIED);
        return item;
    }

    @Nonnull
    protected QEntity afterUpdate(@NonNull QEntity item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected QEntity afterDelete(@NonNull QEntity item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public static Specification<QEntity> specification(@NonNull String filterText, @NonNull Range<LocalDateTime> submissionDateTimeRangePS, @NonNull Range<LocalDate> plannedSubmissionDateRangePS, @NonNull Range<LocalDate> executionPeriodDateRangePS, @NonNull Iterable<Customer> filterCustomers, @NonNull Iterable<Customer> filterCustomersPS, @NonNull Iterable<Project> projectsPS, @NonNull Iterable<User> responsibleUsersPS, @NonNull Iterable<EQEntityState> entityStates, boolean autocompleteMode, boolean searchInStageText, boolean searchInCustomer) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (submissionDateTimeRangePS == null) {
            throw new NullPointerException("submissionDateTimeRangePS is marked non-null but is null");
        }
        if (plannedSubmissionDateRangePS == null) {
            throw new NullPointerException("plannedSubmissionDateRangePS is marked non-null but is null");
        }
        if (executionPeriodDateRangePS == null) {
            throw new NullPointerException("executionPeriodDateRangePS is marked non-null but is null");
        }
        if (filterCustomers == null) {
            throw new NullPointerException("filterCustomers is marked non-null but is null");
        }
        if (filterCustomersPS == null) {
            throw new NullPointerException("filterCustomersPS is marked non-null but is null");
        }
        if (projectsPS == null) {
            throw new NullPointerException("projectsPS is marked non-null but is null");
        }
        if (responsibleUsersPS == null) {
            throw new NullPointerException("responsibleUsersPS is marked non-null but is null");
        }
        if (entityStates == null) {
            throw new NullPointerException("entityStates is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        ArrayList numberAlias = Lists.newArrayList();
        QEntityRepository.QEntitySpecifications.entityText((String)filterText).ifPresent(numberAlias::add);
        if (searchInStageText) {
            QEntityRepository.QEntitySpecifications.stageText((String)filterText).ifPresent(numberAlias::add);
        }
        if (searchInCustomer) {
            QEntityRepository.QEntitySpecifications.customerText((String)filterText).ifPresent(numberAlias::add);
        }
        QEntityRepository.QEntitySpecifications.submissionDateTimeBetween(submissionDateTimeRangePS).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QEntityRepository.QEntitySpecifications.plannedSubmissionDateBetween(plannedSubmissionDateRangePS).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QEntityRepository.QEntitySpecifications.executionPeriodDateRangeBetween(executionPeriodDateRangePS).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        numberAlias.stream().filter(Objects::nonNull).reduce(Specification::or).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QEntityRepository.QEntitySpecifications.customersIn(filterCustomers).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QEntityRepository.QEntitySpecifications.customersInPS(filterCustomersPS).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QEntityRepository.QEntitySpecifications.projectsInPS(projectsPS).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QEntityRepository.QEntitySpecifications.responsibleUsersInPS(responsibleUsersPS).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        QEntityRepository.QEntitySpecifications.qEntityStateIn(entityStates).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        if (autocompleteMode) {
            QEntityRepository.QEntitySpecifications.containsStageType((Iterable)EQStageType.ENTITY_AUTOCOMPLETE_STAGE_TYPES).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        }
        ImmutableList specs = specsBuilder.build();
        return QEntityRepository.QEntitySpecifications.conjunction((Specification)QEntityRepository.QEntitySpecifications.identity(), (Iterable)specs);
    }

    @Nonnull
    public Page<QEntity> page(int page, int size, @NonNull String filterText, @NonNull Range<LocalDateTime> submissionDateTimeRange, @NonNull Range<LocalDate> plannedSubmissionDateRange, @NonNull Range<LocalDate> executionPeriodDateRange, @NonNull Iterable<Customer> filterCustomers, @NonNull Iterable<Project> projects, @NonNull Iterable<User> responsibleUsers, @NonNull Iterable<EQEntityState> entityStates, boolean autoCompleteMode, boolean searchInStageText, boolean searchInCustomer) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (submissionDateTimeRange == null) {
            throw new NullPointerException("submissionDateTimeRange is marked non-null but is null");
        }
        if (plannedSubmissionDateRange == null) {
            throw new NullPointerException("plannedSubmissionDateRange is marked non-null but is null");
        }
        if (executionPeriodDateRange == null) {
            throw new NullPointerException("executionPeriodDateRange is marked non-null but is null");
        }
        if (filterCustomers == null) {
            throw new NullPointerException("filterCustomers is marked non-null but is null");
        }
        if (projects == null) {
            throw new NullPointerException("projects is marked non-null but is null");
        }
        if (responsibleUsers == null) {
            throw new NullPointerException("responsibleUsers is marked non-null but is null");
        }
        if (entityStates == null) {
            throw new NullPointerException("entityStates is marked non-null but is null");
        }
        Specification specification = EntityHandler.specification((String)filterText, submissionDateTimeRange, plannedSubmissionDateRange, executionPeriodDateRange, (Iterable)ImmutableList.of(), filterCustomers, projects, responsibleUsers, entityStates, (boolean)autoCompleteMode, (boolean)searchInStageText, (boolean)searchInCustomer);
        if (size > 0) {
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"id")}));
            return this.entityRepository.findAll(specification, (Pageable)pageable);
        }
        long total = this.entityRepository.count(specification);
        return new PageImpl((List)ImmutableList.of(), Pageable.unpaged(), total);
    }

    @Nonnull
    public Iterable<EntityStatistics> stagesStatistics(int page, int size, @NonNull String filterText, @NonNull Range<LocalDateTime> submissionDateTimeRange, @NonNull Range<LocalDate> plannedSubmissionDateRange, @NonNull Range<LocalDate> executionPeriodDateRange, @NonNull Iterable<Customer> customers, @NonNull Iterable<Project> projects, @NonNull Iterable<User> responsibleUsers, @NonNull Iterable<EQEntityState> entityStates, @NonNull Iterable<EQStageState> stageStates, boolean searchInStageText, boolean searchInCustomer, @NonNull EEntitySort sort) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (submissionDateTimeRange == null) {
            throw new NullPointerException("submissionDateTimeRange is marked non-null but is null");
        }
        if (plannedSubmissionDateRange == null) {
            throw new NullPointerException("plannedSubmissionDateRange is marked non-null but is null");
        }
        if (executionPeriodDateRange == null) {
            throw new NullPointerException("executionPeriodDateRange is marked non-null but is null");
        }
        if (customers == null) {
            throw new NullPointerException("customers is marked non-null but is null");
        }
        if (projects == null) {
            throw new NullPointerException("projects is marked non-null but is null");
        }
        if (responsibleUsers == null) {
            throw new NullPointerException("responsibleUsers is marked non-null but is null");
        }
        if (entityStates == null) {
            throw new NullPointerException("entityStates is marked non-null but is null");
        }
        if (stageStates == null) {
            throw new NullPointerException("stageStates is marked non-null but is null");
        }
        if (sort == null) {
            throw new NullPointerException("sort is marked non-null but is null");
        }
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(EntityStatistics.class);
        Root fetchRoot = fetchQuery.from(QEntity.class);
        Join childrenProd_Q = fetchRoot.join("stages", JoinType.LEFT);
        Join childrenProd_PS = fetchRoot.join("primaryStage", JoinType.LEFT);
        Join childrenProd_Q_I = childrenProd_Q.join("finalInvoice", JoinType.LEFT);
        Join childrenProd_P = childrenProd_Q.join("project", JoinType.LEFT);
        Specification textAndCustomerSpec = EntityHandler.specification((String)filterText, submissionDateTimeRange, plannedSubmissionDateRange, executionPeriodDateRange, customers, (Iterable)ImmutableList.of(), projects, responsibleUsers, entityStates, (boolean)false, (boolean)searchInStageText, (boolean)searchInCustomer);
        Specification stageStateSpecification = (Specification)QEntityRepository.QEntitySpecifications.stageStateIn((Join)childrenProd_Q, stageStates).get();
        Specification specification = textAndCustomerSpec.and(stageStateSpecification);
        Predicate predicate = specification.toPredicate(fetchRoot, fetchQuery, criteriaBuilder);
        CriteriaQuery where = fetchQuery.multiselect(new Selection[]{fetchRoot.get("id").alias("entityId"), fetchRoot.get("alias").alias("entityAlias"), fetchRoot.get("qNumber").alias("entityQNumber"), fetchRoot.get("qEntityState").alias("entityQEntityState"), childrenProd_PS.get("id").alias("primaryStageId"), childrenProd_Q.get("version").alias("version"), childrenProd_Q.get("versionSince").alias("versionSince"), childrenProd_Q.get("stageNotifyUsersText").alias("notifyUsersText"), childrenProd_Q.get("stageSignatureUsersText").alias("signatureUsersText"), childrenProd_Q.get("stageResponsibleUsersText").alias("responsibleUsersText"), childrenProd_Q.get("id").alias("stageId"), childrenProd_Q.get("updatedOn").alias("updatedOn"), childrenProd_Q.get("updatedBy").alias("updatedBy"), childrenProd_Q.get("alias").alias("stageAlias"), childrenProd_Q.get("qNumber").alias("stageQNumber"), childrenProd_Q.get("projectExecutionStartDate").alias("projectExecutionStartDate"), childrenProd_Q.get("projectExecutionEndDate").alias("projectExecutionEndDate"), childrenProd_Q.get("commissionDate").alias("commissionDate"), childrenProd_Q.get("orderDescriptionCustomer").alias("orderDescriptionCustomer"), childrenProd_Q.get("orderDescriptionInternal").alias("orderDescriptionInternal"), childrenProd_Q.get("orderNumber").alias("orderNumber"), childrenProd_P.get("id").alias("projectId"), childrenProd_P.get("name").alias("projectName"), childrenProd_P.get("referenceId").alias("projectReferenceId"), childrenProd_Q.get("stageType").alias("stageType"), childrenProd_Q.get("stageState").alias("stageState"), childrenProd_Q.get("orderValueEstimate").alias("orderValueEstimate"), childrenProd_Q.get("valueAggregated").alias("valueAggregated"), childrenProd_Q.get("priceAggregated").alias("priceAggregated"), childrenProd_Q.get("budget").alias("budget"), childrenProd_Q.get("customer").alias("customer"), childrenProd_Q_I.get("id").alias("finalInvoiceId"), childrenProd_Q_I.get("invoiceNumber").alias("finalInvoiceNumber"), childrenProd_Q.get("procurementNumber").alias("procurementNumber"), childrenProd_Q.get("commissionType").alias("commissionType"), childrenProd_Q.get("submissionDateTime").alias("submissionDateTime"), childrenProd_Q.get("submissionOfBidDate").alias("submissionOfBidDate"), childrenProd_Q.get("plannedSubmissionDate").alias("plannedSubmissionDate"), childrenProd_Q.get("bindingPeriodDate").alias("bindingPeriodDate"), childrenProd_Q.get("priceWithDiscountSum").alias("priceWithDiscountSum"), childrenProd_Q.get("priceWithoutDiscountSum").alias("priceWithoutDiscountSum"), childrenProd_Q.get("orderValue").alias("orderValue"), childrenProd_Q.get("orderValueWithDiscount").alias("orderValueWithDiscount"), childrenProd_Q.get("flagMeasurementWithoutCommissionNumberAllowed").alias("flagMeasurementWithoutCommissionNumberAllowed")}).where((Expression)predicate).orderBy(new Order[]{EntityHandler.orderBy((EEntitySort)sort, (CriteriaBuilder)criteriaBuilder, (Root)fetchRoot, (Join)childrenProd_PS), criteriaBuilder.asc((Expression)fetchRoot.get("qNumber"))}).distinct(true);
        TypedQuery query = this.em.createQuery(where);
        if (pageable.isPaged()) {
            query.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
        }
        return query.getResultList();
    }

    @Nonnull
    public Iterable<EntityStatistics> primaryStageStatistics(int page, int size, @NonNull String filterText, @NonNull Range<LocalDateTime> submissionDateTimeRange, @NonNull Range<LocalDate> plannedSubmissionDateRange, @NonNull Range<LocalDate> executionPeriodDateRange, @NonNull Iterable<Customer> customers, @NonNull Iterable<Project> projects, @NonNull Iterable<User> responsibleUsers, @NonNull Iterable<EQEntityState> entityStates, @NonNull Iterable<EQStageState> stageStates, boolean searchInStageText, boolean searchInCustomer, @NonNull EEntitySort sort) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (submissionDateTimeRange == null) {
            throw new NullPointerException("submissionDateTimeRange is marked non-null but is null");
        }
        if (plannedSubmissionDateRange == null) {
            throw new NullPointerException("plannedSubmissionDateRange is marked non-null but is null");
        }
        if (executionPeriodDateRange == null) {
            throw new NullPointerException("executionPeriodDateRange is marked non-null but is null");
        }
        if (customers == null) {
            throw new NullPointerException("customers is marked non-null but is null");
        }
        if (projects == null) {
            throw new NullPointerException("projects is marked non-null but is null");
        }
        if (responsibleUsers == null) {
            throw new NullPointerException("responsibleUsers is marked non-null but is null");
        }
        if (entityStates == null) {
            throw new NullPointerException("entityStates is marked non-null but is null");
        }
        if (stageStates == null) {
            throw new NullPointerException("stageStates is marked non-null but is null");
        }
        if (sort == null) {
            throw new NullPointerException("sort is marked non-null but is null");
        }
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(EntityStatistics.class);
        Root fetchRoot = fetchQuery.from(QEntity.class);
        Join childrenProd_PS = fetchRoot.join("primaryStage", JoinType.LEFT);
        Join childrenProd_Q_I = childrenProd_PS.join("finalInvoice", JoinType.LEFT);
        Join childrenProd_P = childrenProd_PS.join("project", JoinType.LEFT);
        Specification textAndCustomerSpec = EntityHandler.specification((String)filterText, submissionDateTimeRange, plannedSubmissionDateRange, executionPeriodDateRange, customers, (Iterable)ImmutableList.of(), projects, responsibleUsers, entityStates, (boolean)false, (boolean)searchInStageText, (boolean)searchInCustomer);
        Specification stageStateSpecification = (Specification)QEntityRepository.QEntitySpecifications.stageStateIn((Join)childrenProd_PS, stageStates).get();
        Specification specification = textAndCustomerSpec.and(stageStateSpecification);
        Predicate predicate = specification.toPredicate(fetchRoot, fetchQuery, criteriaBuilder);
        CriteriaQuery where = fetchQuery.multiselect(new Selection[]{fetchRoot.get("id").alias("entityId"), fetchRoot.get("alias").alias("entityAlias"), fetchRoot.get("qNumber").alias("entityQNumber"), fetchRoot.get("qEntityState").alias("entityQEntityState"), childrenProd_PS.get("id").alias("primaryStageId"), childrenProd_PS.get("version").alias("version"), childrenProd_PS.get("versionSince").alias("versionSince"), childrenProd_PS.get("stageNotifyUsersText").alias("notifyUsersText"), childrenProd_PS.get("stageSignatureUsersText").alias("signatureUsersText"), childrenProd_PS.get("stageResponsibleUsersText").alias("responsibleUsersText"), childrenProd_PS.get("updatedOn").alias("updatedOn"), childrenProd_PS.get("updatedBy").alias("updatedBy"), childrenProd_PS.get("alias").alias("stageAlias"), childrenProd_PS.get("qNumber").alias("stageQNumber"), childrenProd_PS.get("projectExecutionStartDate").alias("projectExecutionStartDate"), childrenProd_PS.get("projectExecutionEndDate").alias("projectExecutionEndDate"), childrenProd_PS.get("commissionDate").alias("commissionDate"), childrenProd_PS.get("orderDescriptionCustomer").alias("orderDescriptionCustomer"), childrenProd_PS.get("orderDescriptionInternal").alias("orderDescriptionInternal"), childrenProd_PS.get("orderNumber").alias("orderNumber"), childrenProd_P.get("id").alias("projectId"), childrenProd_P.get("name").alias("projectName"), childrenProd_P.get("referenceId").alias("projectReferenceId"), childrenProd_PS.get("stageType").alias("stageType"), childrenProd_PS.get("stageState").alias("stageState"), childrenProd_PS.get("orderValueEstimate").alias("orderValueEstimate"), childrenProd_PS.get("valueAggregated").alias("valueAggregated"), childrenProd_PS.get("priceAggregated").alias("priceAggregated"), childrenProd_PS.get("budget").alias("budget"), childrenProd_PS.get("customer").alias("customer"), childrenProd_Q_I.get("id").alias("finalInvoiceId"), childrenProd_Q_I.get("invoiceNumber").alias("finalInvoiceNumber"), childrenProd_PS.get("procurementNumber").alias("procurementNumber"), childrenProd_PS.get("commissionType").alias("commissionType"), childrenProd_PS.get("submissionDateTime").alias("submissionDateTime"), childrenProd_PS.get("submissionOfBidDate").alias("submissionOfBidDate"), childrenProd_PS.get("plannedSubmissionDate").alias("plannedSubmissionDate"), childrenProd_PS.get("bindingPeriodDate").alias("bindingPeriodDate"), childrenProd_PS.get("priceWithDiscountSum").alias("priceWithDiscountSum"), childrenProd_PS.get("priceWithoutDiscountSum").alias("priceWithoutDiscountSum"), childrenProd_PS.get("orderValue").alias("orderValue"), childrenProd_PS.get("orderValueWithDiscount").alias("orderValueWithDiscount"), childrenProd_PS.get("flagMeasurementWithoutCommissionNumberAllowed").alias("flagMeasurementWithoutCommissionNumberAllowed")}).where((Expression)predicate).orderBy(new Order[]{EntityHandler.orderBy((EEntitySort)sort, (CriteriaBuilder)criteriaBuilder, (Root)fetchRoot, (Join)childrenProd_PS), criteriaBuilder.asc((Expression)fetchRoot.get("qNumber"))}).distinct(true);
        TypedQuery query = this.em.createQuery(where);
        if (pageable.isPaged()) {
            query.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
        }
        return query.getResultList();
    }

    private static Order orderBy(@NonNull EEntitySort entitySort, @NonNull CriteriaBuilder criteriaBuilder, @NonNull Root<QEntity> fetchRoot, @NonNull Join<QEntity, Quotation> childrenProd_PS) {
        if (entitySort == null) {
            throw new NullPointerException("entitySort is marked non-null but is null");
        }
        if (criteriaBuilder == null) {
            throw new NullPointerException("criteriaBuilder is marked non-null but is null");
        }
        if (fetchRoot == null) {
            throw new NullPointerException("fetchRoot is marked non-null but is null");
        }
        if (childrenProd_PS == null) {
            throw new NullPointerException("childrenProd_PS is marked non-null but is null");
        }
        if (EEntitySort.ID_DESC == entitySort) {
            return criteriaBuilder.desc((Expression)fetchRoot.get("id"));
        }
        if (EEntitySort.ENTITY_STATE_ASC == entitySort) {
            return criteriaBuilder.asc(criteriaBuilder.function("DECODE", String.class, new Expression[]{fetchRoot.get("qEntityState"), criteriaBuilder.literal((Object)EQEntityState.COMMISSION_REWORK.name()), criteriaBuilder.literal((Object)1), criteriaBuilder.literal((Object)EQEntityState.QUOTATION_DESIGNATED_COMMISSION.name()), criteriaBuilder.literal((Object)2), criteriaBuilder.literal((Object)EQEntityState.COMMISSION_CLOSED.name()), criteriaBuilder.literal((Object)3), criteriaBuilder.literal((Object)EQEntityState.QUOTATION_SUBMITTED.name()), criteriaBuilder.literal((Object)4), criteriaBuilder.literal((Object)EQEntityState.INQUIRY_NOTIFIED.name()), criteriaBuilder.literal((Object)5), criteriaBuilder.literal((Object)EQEntityState.COMMISSION_TEMPORARY.name()), criteriaBuilder.literal((Object)6), criteriaBuilder.literal((Object)EQEntityState.COMMISSION_ACTIVE.name()), criteriaBuilder.literal((Object)7), criteriaBuilder.literal((Object)EQEntityState.QUOTATION_TEMPORARY.name()), criteriaBuilder.literal((Object)8), criteriaBuilder.literal((Object)EQEntityState.CALCULATION_TEMPORARY.name()), criteriaBuilder.literal((Object)9), criteriaBuilder.literal((Object)EQEntityState.INQUIRY_TEMPORARY.name()), criteriaBuilder.literal((Object)10), criteriaBuilder.literal((Object)EQEntityState.COMMISSION_ARCHIVED.name()), criteriaBuilder.literal((Object)11), criteriaBuilder.literal((Object)EQEntityState.QUOTATION_ARCHIVED.name()), criteriaBuilder.literal((Object)12), criteriaBuilder.literal((Object)EQEntityState.INQUIRY_ARCHIVED.name()), criteriaBuilder.literal((Object)13), criteriaBuilder.literal((Object)99)}));
        }
        if (EEntitySort.SUBMISSION_DATE_TIME_ASC == entitySort) {
            return criteriaBuilder.asc((Expression)childrenProd_PS.get("submissionDateTime"));
        }
        if (EEntitySort.PLANNED_SUBMISSION_DATE_ASC == entitySort) {
            return criteriaBuilder.asc((Expression)childrenProd_PS.get("plannedSubmissionDate"));
        }
        if (EEntitySort.STAGE_NUMBER_DESC == entitySort) {
            return criteriaBuilder.desc((Expression)fetchRoot.get("qNumber"));
        }
        return criteriaBuilder.asc((Expression)fetchRoot.get("id"));
    }

    @Nonnull
    public Iterable<QEntityTreeStatistics> stagesStatistics(long entityId, boolean filterArchived) {
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(QEntityTreeStatistics.class);
        Root fetchRoot = fetchQuery.from(QEntity.class);
        Join childrenProd_Q = fetchRoot.join("stages", JoinType.LEFT);
        Join referenceProd_Q = childrenProd_Q.join("reference", JoinType.LEFT);
        Join parentProd_Q = childrenProd_Q.join("parent", JoinType.LEFT);
        Join childrenProd_Q_SP = childrenProd_Q.join("subProject", JoinType.LEFT);
        Specification & Serializable qEntityIdSpec = (Specification & Serializable)(root, cq, cb) -> {
            ArrayList predicates = Lists.newArrayList();
            predicates.add(cb.equal((Expression)fetchRoot.get("id"), (Object)entityId));
            return cb.and(predicates.toArray(new Predicate[0]));
        };
        Predicate entityPredicate = qEntityIdSpec.toPredicate(fetchRoot, fetchQuery, criteriaBuilder);
        Collection statesToBeUsed = filterArchived ? EQStageState.ALL_STATES_WITHOUT_ARCHIVED : EQStageState.ALL_VALID;
        Predicate statesPredicate = childrenProd_Q.get("stageState").in(statesToBeUsed);
        Predicate predicate = criteriaBuilder.and((Expression)entityPredicate, (Expression)statesPredicate);
        CriteriaQuery where = fetchQuery.multiselect(new Selection[]{childrenProd_Q.get("id").alias("stageId"), childrenProd_Q.get("alias").alias("stageAlias"), childrenProd_Q.get("qNumber").alias("stageQNumber"), childrenProd_Q.get("quotationNumber").alias("stageQuotationNumber"), childrenProd_Q.get("version").alias("version"), childrenProd_Q.get("stageType").alias("stageType"), childrenProd_Q.get("stageState").alias("stageState"), referenceProd_Q.get("id").alias("referenceId"), referenceProd_Q.get("alias").alias("referenceAlias"), referenceProd_Q.get("qNumber").alias("referenceQNumber"), parentProd_Q.get("id").alias("parentId"), parentProd_Q.get("alias").alias("parentAlias"), parentProd_Q.get("qNumber").alias("parentQNumber"), childrenProd_Q_SP.get("id").alias("subProjectId"), childrenProd_Q_SP.get("name").alias("subProjectName"), childrenProd_Q.get("orderDescriptionCustomer").alias("orderDescriptionCustomer"), childrenProd_Q.get("orderDescriptionInternal").alias("orderDescriptionInternal"), childrenProd_Q.get("orderNumber").alias("orderNumber")}).where((Expression)predicate).orderBy(new Order[]{criteriaBuilder.desc((Expression)fetchRoot.get("id"))}).distinct(true);
        TypedQuery query = this.em.createQuery(where);
        Pageable pageable = Pageable.unpaged();
        if (pageable.isPaged()) {
            query.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
        }
        return query.getResultList();
    }

    public boolean dirty() {
        return !this.entityRepository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)1)).isEmpty();
    }

    @Nonnull
    public Iterable<QEntity> dirtyPage(int max) {
        return this.entityRepository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)max, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"updatedOn", "id"})));
    }

    public int markIndexed(@NonNull Iterable<QEntity> itemsProcessed) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        ImmutableSet entityIds = (ImmutableSet)Streams.stream(itemsProcessed).map(QEntity::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return this.entityRepository.updateSearchIndexState(ESearchIndexState.INDEXED, (Iterable)entityIds);
    }

    @Nonnull
    public Iterable<QEntity> nextNotNotified() {
        return this.entityRepository.nextNotNotified((Pageable)PageRequest.of((int)0, (int)1));
    }

    public int markPsxNotified(long entityId) {
        return this.entityRepository.updatePsxNotifyState(EPsxNotifyState.NOTIFIED, (Iterable)ImmutableSet.of((Object)entityId));
    }
}

