/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.model.internal.sharepoint.ESharepointState;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.businessunit.UserBusinessUnit;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.customer.ECustomerState;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.contract.EmployeeContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroup;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroupRate;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthState;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthSnapShot;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthSnapShotItem;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccount;
import de.qfm.erp.service.model.jpa.employee.payroll.WageAccountTransaction;
import de.qfm.erp.service.model.jpa.filestore.FileStore;
import de.qfm.erp.service.model.jpa.generic.BankingHoliday;
import de.qfm.erp.service.model.jpa.generic.DictionaryItem;
import de.qfm.erp.service.model.jpa.generic.EDay;
import de.qfm.erp.service.model.jpa.history.HistoryItem;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceNumberGroup;
import de.qfm.erp.service.model.jpa.invoice.EntityNumber;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.InvoiceAddendumDiscount;
import de.qfm.erp.service.model.jpa.invoice.InvoiceAttachment;
import de.qfm.erp.service.model.jpa.invoice.InvoiceNumber;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.model.jpa.invoice.InvoiceSupplement;
import de.qfm.erp.service.model.jpa.invoice.StageNumber;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.measurement.InvoiceMeasurement;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.MeasurementSheetNumber;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.MeasurementTransposedRemark;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.PsxReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementOrigin;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementStateReason;
import de.qfm.erp.service.model.jpa.navigation.EntityUsage;
import de.qfm.erp.service.model.jpa.profile.UserSetting;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.jpa.queue.EProcessingState;
import de.qfm.erp.service.model.jpa.queue.QueueItem;
import de.qfm.erp.service.model.jpa.quotation.EER2ExportState;
import de.qfm.erp.service.model.jpa.quotation.ENotificationState;
import de.qfm.erp.service.model.jpa.quotation.EQStageNumberType;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.EStagePropagationItemType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationBoQ;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.quotation.StageInvoiceSupplement;
import de.qfm.erp.service.model.jpa.quotation.StageNotifyUser;
import de.qfm.erp.service.model.jpa.quotation.StageOrderNumber;
import de.qfm.erp.service.model.jpa.quotation.StagePropagation;
import de.qfm.erp.service.model.jpa.quotation.StagePropagationItem;
import de.qfm.erp.service.model.jpa.quotation.StageResponsibleUser;
import de.qfm.erp.service.model.jpa.quotation.StageSignatureUser;
import de.qfm.erp.service.model.jpa.search.NodeOffset;
import de.qfm.erp.service.model.jpa.tracking.TrackingPoint;
import de.qfm.erp.service.model.jpa.tracking.TrackingPointPayload;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.model.jpa.user.RolePrivilege;
import de.qfm.erp.service.model.jpa.user.UserPrivilege;
import de.qfm.erp.service.model.jpa.user.UserRole;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.temporal.WeekFields;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EntityFactory {
    private final CompanyConfig companyConfig;
    private final AuthenticationHelper authenticationHelper;

    @Nonnull
    private <T extends EntityBase> T create(@NonNull Supplier<T> entityBase) {
        if (entityBase == null) {
            throw new NullPointerException("entityBase is marked non-null but is null");
        }
        return (T)this.create(entityBase, () -> ((AuthenticationHelper)this.authenticationHelper).currentUser());
    }

    @Nonnull
    private <T extends EntityBase> T create(@NonNull Supplier<T> entityBase, @NonNull Supplier<User> userSupplier) {
        if (entityBase == null) {
            throw new NullPointerException("entityBase is marked non-null but is null");
        }
        if (userSupplier == null) {
            throw new NullPointerException("userSupplier is marked non-null but is null");
        }
        String username = userSupplier.get().getUsername();
        EntityBase entity = (EntityBase)entityBase.get();
        entity.setCreatedBy(username);
        entity.setCreatedOn(DateTimeHelper.now());
        entity.setUpdatedBy(username);
        entity.setUpdatedOn(DateTimeHelper.now());
        entity.setEntityState(EntityState.VALID);
        return (T)entity;
    }

    @Nonnull
    public HistoryItem historyItem() {
        return (HistoryItem)this.create(HistoryItem::new);
    }

    @Nonnull
    public Measurement measurement(@NonNull EMeasurementOrigin origin) {
        if (origin == null) {
            throw new NullPointerException("origin is marked non-null but is null");
        }
        Measurement measurement = (Measurement)this.create(Measurement::new);
        measurement.setOrigin(origin);
        measurement.setLastOrigin(origin);
        measurement.setMeasurementStates((Set)Sets.newLinkedHashSet());
        measurement.setMeasurementPositions((List)Lists.newArrayList());
        return measurement;
    }

    public MeasurementState measurementState() {
        MeasurementState measurementState = (MeasurementState)this.create(MeasurementState::new);
        measurementState.setMeasurementState(EMeasurementState.UNKNOWN);
        measurementState.setMeasurementStateReason(EMeasurementStateReason.UNKNOWN);
        measurementState.setMeasurementStateSince(DateTimeHelper.now());
        return measurementState;
    }

    @Nonnull
    public MeasurementPosition measurementPosition() {
        return (MeasurementPosition)this.create(MeasurementPosition::new);
    }

    @Nonnull
    public ReleaseOrder releaseOrder() {
        ReleaseOrder releaseOrder = (ReleaseOrder)this.create(ReleaseOrder::new);
        releaseOrder.setReferenceId(EntityFactory.referenceId());
        return releaseOrder;
    }

    @Nonnull
    public PssReleaseOrder pssReleaseOrder() {
        return (PssReleaseOrder)this.create(PssReleaseOrder::new, () -> ((AuthenticationHelper)AuthenticationHelper.INTERNAL_AUTH).currentUser());
    }

    @Nonnull
    public PsxReleaseOrder psxReleaseOrder() {
        return (PsxReleaseOrder)this.create(PsxReleaseOrder::new, () -> ((AuthenticationHelper)AuthenticationHelper.INTERNAL_AUTH).currentUser());
    }

    @Nonnull
    public QueueItem queueItem() {
        QueueItem queueItem = (QueueItem)this.create(QueueItem::new, () -> ((AuthenticationHelper)AuthenticationHelper.INTERNAL_AUTH).currentUser());
        queueItem.setFailureAmount(Integer.valueOf(0));
        return queueItem;
    }

    @Nonnull
    public QEntity qEntity() {
        return (QEntity)this.create(QEntity::new);
    }

    @Nonnull
    public Quotation stage() {
        Quotation stage = (Quotation)this.create(Quotation::new);
        stage.setOrigin(EStageOrigin.QUANTE_V2);
        stage.setEr2ExportedOn(null);
        stage.setEr2ExportState(EER2ExportState.EXPORTED);
        stage.setEr2ExportedToPath("");
        return stage;
    }

    @Nonnull
    public QuotationBoQ quotationBoQ() {
        return (QuotationBoQ)this.create(QuotationBoQ::new);
    }

    @Nonnull
    public QuotationPosition quotationPosition() {
        QuotationPosition quotationPosition = (QuotationPosition)this.create(QuotationPosition::new);
        quotationPosition.setChildren((Set)Sets.newLinkedHashSet());
        return quotationPosition;
    }

    @Nonnull
    public QuotationPosition quotationPosition(AuthenticationHelper authenticationHelper) {
        return (QuotationPosition)this.create(QuotationPosition::new, () -> ((AuthenticationHelper)authenticationHelper).currentUser());
    }

    @Nonnull
    public StageNotifyUser stageNotifyUser() {
        StageNotifyUser stageNotifyUser = (StageNotifyUser)this.create(StageNotifyUser::new);
        stageNotifyUser.setAccepted(Boolean.valueOf(false));
        stageNotifyUser.setNotificationState(ENotificationState.NOT_NOTIFIED);
        stageNotifyUser.setNotificationStateOn(DateTimeHelper.now());
        return stageNotifyUser;
    }

    @Nonnull
    public StageResponsibleUser stageResponsibleUser() {
        return (StageResponsibleUser)this.create(StageResponsibleUser::new);
    }

    @Nonnull
    public StageResponsibleUser stageResponsibleUser(@NonNull AuthenticationHelper authenticationHelper) {
        if (authenticationHelper == null) {
            throw new NullPointerException("authenticationHelper is marked non-null but is null");
        }
        return (StageResponsibleUser)this.create(StageResponsibleUser::new, () -> ((AuthenticationHelper)authenticationHelper).currentUser());
    }

    @Nonnull
    public StageSignatureUser stageSignatureUser() {
        return (StageSignatureUser)this.create(StageSignatureUser::new);
    }

    @Nonnull
    public de.qfm.erp.service.model.jpa.user.User user() {
        return (de.qfm.erp.service.model.jpa.user.User)this.create(de.qfm.erp.service.model.jpa.user.User::new);
    }

    @Nonnull
    private static String referenceId() {
        return UUID.randomUUID().toString();
    }

    @Nonnull
    public EntityUsage entityUsage() {
        return (EntityUsage)this.create(EntityUsage::new);
    }

    @Nonnull
    public UserSetting profileEntry() {
        return (UserSetting)this.create(UserSetting::new);
    }

    @Nonnull
    public NodeOffset nodeOffset(@NonNull EEntityClass entityClazz, @NonNull String nodeName, @NonNull LocalDateTime localDateTime) {
        if (entityClazz == null) {
            throw new NullPointerException("entityClazz is marked non-null but is null");
        }
        if (nodeName == null) {
            throw new NullPointerException("nodeName is marked non-null but is null");
        }
        if (localDateTime == null) {
            throw new NullPointerException("localDateTime is marked non-null but is null");
        }
        NodeOffset nodeOffset = (NodeOffset)this.create(NodeOffset::new, () -> ((AuthenticationHelper)AuthenticationHelper.INTERNAL_AUTH).currentUser());
        nodeOffset.setNodeName(nodeName);
        nodeOffset.setEntityClazz(entityClazz);
        nodeOffset.setReferenceDateTime(localDateTime);
        return nodeOffset;
    }

    @Nonnull
    public TrackingPoint trackingPoint() {
        return (TrackingPoint)this.create(TrackingPoint::new);
    }

    @Nonnull
    public TrackingPointPayload trackingPointPayload() {
        return (TrackingPointPayload)this.create(TrackingPointPayload::new);
    }

    @Nonnull
    public Attendance attendance(@NonNull LocalDate referenceDate) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        Attendance attendance = (Attendance)this.create(Attendance::new);
        attendance.setDate(referenceDate);
        attendance.setYear(referenceDate.getYear());
        attendance.setMonth(referenceDate.getMonthValue());
        attendance.setDayOfMonth(referenceDate.getDayOfMonth());
        WeekFields weekFields = WeekFields.of(Locale.GERMAN);
        int weekNumber = referenceDate.get(weekFields.weekOfWeekBasedYear());
        attendance.setWeek(weekNumber);
        attendance.setDay(EDay.from((DayOfWeek)referenceDate.getDayOfWeek()));
        attendance.setEmployeeDayType(EAttendanceDayType.NONE);
        return attendance;
    }

    @Nonnull
    public PayrollMonthItem payrollMonthItem() {
        return (PayrollMonthItem)this.create(PayrollMonthItem::new);
    }

    @Nonnull
    public PayrollMonth payrollMonth(@NonNull de.qfm.erp.service.model.jpa.user.User user, @Nullable de.qfm.erp.service.model.jpa.user.User manager, @NonNull YearMonth yearMonth, @NonNull LaborUnionContract laborUnionContract, @NonNull String costCenter, @NonNull EPayrollMonthState initialState, @NonNull Iterable<Attendance> attendances) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (laborUnionContract == null) {
            throw new NullPointerException("laborUnionContract is marked non-null but is null");
        }
        if (costCenter == null) {
            throw new NullPointerException("costCenter is marked non-null but is null");
        }
        if (initialState == null) {
            throw new NullPointerException("initialState is marked non-null but is null");
        }
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        PayrollMonth payrollMonth = (PayrollMonth)this.create(PayrollMonth::new);
        payrollMonth.setPayrollMonthState(initialState);
        payrollMonth.setUser(user);
        payrollMonth.setManager(manager);
        payrollMonth.setAccountingMonth(yearMonth.atDay(1));
        payrollMonth.setLaborUnionContract(laborUnionContract);
        payrollMonth.setCostCenter(costCenter);
        if (null == payrollMonth.getAttendances()) {
            payrollMonth.setAttendances((List)Lists.newArrayList());
        }
        attendances.forEach(attendance -> {
            attendance.setPayrollMonth(payrollMonth);
            payrollMonth.getAttendances().add(attendance);
        });
        return payrollMonth;
    }

    @Nonnull
    public DictionaryItem dictionaryItem() {
        return (DictionaryItem)this.create(DictionaryItem::new);
    }

    @Nonnull
    public BankingHoliday bankingHoliday() {
        return (BankingHoliday)this.create(BankingHoliday::new);
    }

    @Nonnull
    public PayrollItemType payrollItemType() {
        return (PayrollItemType)this.create(PayrollItemType::new);
    }

    @Nonnull
    public UserBusinessUnit userBusinessUnit() {
        UserBusinessUnit userBusinessUnit = (UserBusinessUnit)this.create(UserBusinessUnit::new);
        userBusinessUnit.setPercent(Integer.valueOf(100));
        return userBusinessUnit;
    }

    @Nonnull
    public UserCostCenter userCostCenter() {
        UserCostCenter userCostCenter = (UserCostCenter)this.create(UserCostCenter::new);
        userCostCenter.setCostCenter("");
        userCostCenter.setFlagLead(Boolean.FALSE);
        return userCostCenter;
    }

    @Nonnull
    public EmployeeContract employeeContract() {
        return (EmployeeContract)this.create(EmployeeContract::new);
    }

    @Nonnull
    public LaborUnionContract laborUnionContract() {
        return (LaborUnionContract)this.create(LaborUnionContract::new);
    }

    @Nonnull
    public LaborUnionWageGroup laborUnionWageGroup() {
        return (LaborUnionWageGroup)this.create(LaborUnionWageGroup::new);
    }

    @Nonnull
    public UserRole userRole(@NonNull Role role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        UserRole userRole = (UserRole)this.create(UserRole::new);
        userRole.setRole(role);
        return userRole;
    }

    @Nonnull
    public Role role() {
        return (Role)this.create(Role::new);
    }

    @Nonnull
    public RolePrivilege rolePrivilege(@NonNull EPrivilege privilege) {
        if (privilege == null) {
            throw new NullPointerException("privilege is marked non-null but is null");
        }
        RolePrivilege rolePrivilege = (RolePrivilege)this.create(RolePrivilege::new);
        rolePrivilege.setPrivilege(privilege);
        return rolePrivilege;
    }

    @Nonnull
    public LaborUnionWageGroupRate laborUnionWageGroupRate() {
        return (LaborUnionWageGroupRate)this.create(LaborUnionWageGroupRate::new);
    }

    @Nonnull
    public UserPrivilege userPrivilege(@NonNull EPrivilege privilege) {
        if (privilege == null) {
            throw new NullPointerException("privilege is marked non-null but is null");
        }
        UserPrivilege userPrivilege = (UserPrivilege)this.create(UserPrivilege::new);
        userPrivilege.setPrivilege(privilege);
        return userPrivilege;
    }

    @Nonnull
    public Customer customer() {
        Customer item = (Customer)this.create(Customer::new);
        item.setCustomerState(ECustomerState.TEMPORARY);
        item.setSharepointState(ESharepointState.UNKNOWN);
        return item;
    }

    @Nonnull
    public Invoice invoice() {
        Invoice item = (Invoice)this.create(Invoice::new);
        String companyNumber = StringUtils.trimToEmpty((String)this.companyConfig.getDiamantMandant());
        item.setFinanceCompanyNumber(companyNumber);
        return item;
    }

    @Nonnull
    public InvoiceNumber invoiceNumber(@NonNull EInvoiceNumberGroup invoiceNumberGroup) {
        if (invoiceNumberGroup == null) {
            throw new NullPointerException("invoiceNumberGroup is marked non-null but is null");
        }
        InvoiceNumber entity = (InvoiceNumber)this.create(InvoiceNumber::new);
        entity.setInvoiceNumberGroup(invoiceNumberGroup);
        entity.setInvoiceYear(Integer.valueOf(0));
        entity.setInvoiceNumber(Long.valueOf(0L));
        return entity;
    }

    @Nonnull
    public MeasurementSheetNumber measurementSheetNumber(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        MeasurementSheetNumber entity = (MeasurementSheetNumber)this.create(MeasurementSheetNumber::new);
        entity.setStage(stage);
        entity.setSheetNumberValue(Long.valueOf(0L));
        return entity;
    }

    @Nonnull
    public InvoiceNumber invoiceNumber(@NonNull EInvoiceNumberGroup invoiceNumberGroup, int year) {
        if (invoiceNumberGroup == null) {
            throw new NullPointerException("invoiceNumberGroup is marked non-null but is null");
        }
        InvoiceNumber entity = (InvoiceNumber)this.create(InvoiceNumber::new);
        entity.setInvoiceNumberGroup(invoiceNumberGroup);
        entity.setInvoiceYear(Integer.valueOf(year));
        entity.setInvoiceNumber(Long.valueOf(0L));
        return entity;
    }

    @Nonnull
    public EntityNumber entityNumber(int year) {
        EntityNumber entity = (EntityNumber)this.create(EntityNumber::new);
        entity.setYear(Integer.valueOf(year));
        entity.setCurrentValue(Long.valueOf(0L));
        return entity;
    }

    @Nonnull
    public StageNumber stageNumber(@NonNull String entityNumber, @NonNull EQStageNumberType stageNumberType) {
        if (entityNumber == null) {
            throw new NullPointerException("entityNumber is marked non-null but is null");
        }
        if (stageNumberType == null) {
            throw new NullPointerException("stageNumberType is marked non-null but is null");
        }
        StageNumber entity = (StageNumber)this.create(StageNumber::new);
        entity.setEntityNumber(entityNumber);
        entity.setStageNumberType(stageNumberType);
        return entity;
    }

    @Nonnull
    public InvoicePosition invoicePosition() {
        InvoicePosition entity = (InvoicePosition)this.create(InvoicePosition::new);
        return entity;
    }

    @Nonnull
    public InvoiceMeasurement invoiceMeasurement() {
        InvoiceMeasurement entity = (InvoiceMeasurement)this.create(InvoiceMeasurement::new);
        return entity;
    }

    @Nonnull
    public TaxKey taxKey() {
        TaxKey entity = (TaxKey)this.create(TaxKey::new);
        return entity;
    }

    @Nonnull
    public FileStore fileStore() {
        FileStore fileStore = (FileStore)this.create(FileStore::new);
        fileStore.setUuid(UUID.randomUUID().toString());
        return fileStore;
    }

    @Nonnull
    public InvoiceAttachment invoiceAttachment() {
        return (InvoiceAttachment)this.create(InvoiceAttachment::new);
    }

    @Nonnull
    public Address address() {
        return (Address)this.create(Address::new);
    }

    @Nonnull
    public ContactPerson contactPerson() {
        return (ContactPerson)this.create(ContactPerson::new);
    }

    @Nonnull
    public SubProject subProject() {
        return (SubProject)this.create(SubProject::new);
    }

    @Nonnull
    public PayrollMonthSnapShot payrollMonthSnapShot(PayrollMonth payrollMonth) {
        PayrollMonthSnapShot payrollMonthSnapShot = (PayrollMonthSnapShot)this.create(PayrollMonthSnapShot::new);
        payrollMonthSnapShot.setPayrollMonth(payrollMonth);
        return payrollMonthSnapShot;
    }

    @Nonnull
    public PayrollMonthSnapShotItem payrollMonthSnapShotItem() {
        return (PayrollMonthSnapShotItem)this.create(PayrollMonthSnapShotItem::new);
    }

    @Nonnull
    public StagePropagation stagePropagation(@NonNull Long batch) {
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        StagePropagation stagePropagation = (StagePropagation)this.create(StagePropagation::new);
        stagePropagation.setBatch(batch);
        stagePropagation.setProcessingState(EProcessingState.UNPROCESSED);
        stagePropagation.setItems((List)Lists.newArrayList());
        return stagePropagation;
    }

    @Nonnull
    public StagePropagationItem stagePropagationItem(@NonNull QuotationPosition quotationPosition, @NonNull EStagePropagationItemType propagationItemType) {
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        if (propagationItemType == null) {
            throw new NullPointerException("propagationItemType is marked non-null but is null");
        }
        StagePropagationItem stagePropagationItem = (StagePropagationItem)this.create(StagePropagationItem::new);
        stagePropagationItem.setStagePropagationItemType(propagationItemType);
        stagePropagationItem.setPosition(quotationPosition);
        return stagePropagationItem;
    }

    @Nonnull
    public WageAccountTransaction wageAccountTransaction() {
        WageAccountTransaction wageAccountTransaction = (WageAccountTransaction)this.create(WageAccountTransaction::new);
        wageAccountTransaction.setBalanceNew(BigDecimal.ZERO);
        wageAccountTransaction.setBalanceOld(BigDecimal.ZERO);
        wageAccountTransaction.setAmount(BigDecimal.ZERO);
        return wageAccountTransaction;
    }

    @Nonnull
    public WageAccount wageAccount(@NonNull de.qfm.erp.service.model.jpa.user.User user, @NonNull BigDecimal limit) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        WageAccount wageAccount = (WageAccount)this.create(WageAccount::new);
        wageAccount.setUser(user);
        wageAccount.setLimit(limit);
        wageAccount.setBalance(BigDecimal.ZERO);
        return wageAccount;
    }

    @Nonnull
    public Project project() {
        return (Project)this.create(Project::new);
    }

    @Nonnull
    public MeasurementTransposedRemark measurementTransposedRemark() {
        return (MeasurementTransposedRemark)this.create(MeasurementTransposedRemark::new);
    }

    @Nonnull
    public InvoiceAddendumDiscount invoiceAddendumDiscount() {
        return (InvoiceAddendumDiscount)this.create(InvoiceAddendumDiscount::new);
    }

    @Nonnull
    public InvoiceSupplement invoiceSupplement() {
        return (InvoiceSupplement)this.create(InvoiceSupplement::new);
    }

    @Nonnull
    public StageInvoiceSupplement stageInvoiceSupplement() {
        return (StageInvoiceSupplement)this.create(StageInvoiceSupplement::new);
    }

    @Nonnull
    public StageOrderNumber stageOrderNumber() {
        return (StageOrderNumber)this.create(StageOrderNumber::new);
    }

    public EntityFactory(CompanyConfig companyConfig, AuthenticationHelper authenticationHelper) {
        this.companyConfig = companyConfig;
        this.authenticationHelper = authenticationHelper;
    }
}

