/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.generic.BoilerPlate;
import de.qfm.erp.service.model.jpa.generic.EBoilerPlateKey;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.repository.BoilerPlateRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class BoilerPlateHandler
extends BaseHandler<BoilerPlate> {
    private static final Logger log = LogManager.getLogger(BoilerPlateHandler.class);
    private final BoilerPlateRepository repository;

    @Autowired
    public BoilerPlateHandler(StandardPersistenceHelper standardPersistenceHelper, BoilerPlateRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<BoilerPlate> clazz() {
        return BoilerPlate.class;
    }

    @Nonnull
    protected BoilerPlate beforeUpdate(@NonNull BoilerPlate item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected BoilerPlate afterUpdate(@NonNull BoilerPlate item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected BoilerPlate afterDelete(@NonNull BoilerPlate item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected BoilerPlate beforeDelete(@NonNull BoilerPlate item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public BoilerPlate byBoilerPlateKeyFailing(@NonNull EBoilerPlateKey boilerPlateKey) {
        if (boilerPlateKey == null) {
            throw new NullPointerException("boilerPlateKey is marked non-null but is null");
        }
        Optional candidate = this.repository.findOne(Specification.where((Specification)BoilerPlateRepository.filter((EBoilerPlateKey)boilerPlateKey)));
        if (candidate.isEmpty()) {
            throw ResourceNotFoundException.of((String)BoilerPlate.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.BOILER_PLATE_KEY), (String)boilerPlateKey.name());
        }
        return (BoilerPlate)candidate.get();
    }

    @Nonnull
    public Iterable<BoilerPlate> byKeysFailing(@NonNull Iterable<EBoilerPlateKey> boilerPlateKeys) {
        if (boilerPlateKeys == null) {
            throw new NullPointerException("boilerPlateKeys is marked non-null but is null");
        }
        List all = this.repository.findAll(Specification.where((Specification)BoilerPlateRepository.filter(boilerPlateKeys)));
        Iterable foundKeys = IterableHelper.stream((Iterable)all).map(BoilerPlate::getBoilerPlateKey).collect(Collectors.toSet());
        ImmutableSet difference = Sets.difference((Set)ImmutableSet.copyOf(boilerPlateKeys), (Set)ImmutableSet.copyOf((Iterable)foundKeys)).immutableCopy();
        if (!difference.isEmpty()) {
            String idsNotFound = ID_JOINER.join((Iterable)difference);
            throw ResourceNotFoundException.of((String)EBoilerPlateKey.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.BOILER_PLATE_KEY), (String)idsNotFound);
        }
        return ImmutableList.copyOf((Collection)all);
    }

    @Nonnull
    public Map<Pair<EBoilerPlateKey, EQStageType>, String> byKeysAsMap(@NonNull Iterable<EBoilerPlateKey> boilerPlateKeys) {
        if (boilerPlateKeys == null) {
            throw new NullPointerException("boilerPlateKeys is marked non-null but is null");
        }
        List all = this.repository.findAll(Specification.where((Specification)BoilerPlateRepository.filter(boilerPlateKeys)));
        return MapsHelper.mapKeyAndValue((Iterable)all, item -> Pair.of((Object)item.getBoilerPlateKey(), (Object)item.getStageType()), BoilerPlate::getValue);
    }
}

