/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.payroll.IAggregatedAttendanceUser;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.AttendanceRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class AttendanceHandler
extends BaseHandler<Attendance> {
    private final AttendanceRepository repository;

    @Autowired
    public AttendanceHandler(StandardPersistenceHelper standardPersistenceHelper, AttendanceRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<Attendance> clazz() {
        return Attendance.class;
    }

    @Nonnull
    protected Attendance beforeUpdate(@NonNull Attendance item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Attendance beforeDelete(@NonNull Attendance item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Attendance afterUpdate(@NonNull Attendance item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Attendance afterDelete(@NonNull Attendance item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Attendance byReferenceIdFailing(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        Optional byId = this.byReferenceIdNotFailing(referenceId);
        if (byId.isEmpty()) {
            throw ResourceNotFoundException.of((String)Attendance.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.REFERENCE_ID), (String)referenceId);
        }
        return (Attendance)byId.get();
    }

    @Nonnull
    public Optional<Attendance> byReferenceIdNotFailing(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        return this.repository.findByReferenceId(referenceId);
    }

    @Nonnull
    public Iterable<Attendance> findByTypeAndDateIsBetween(@NonNull EAttendanceDayType attendanceDayType, @NonNull Range<LocalDate> dateRange) {
        if (attendanceDayType == null) {
            throw new NullPointerException("attendanceDayType is marked non-null but is null");
        }
        if (dateRange == null) {
            throw new NullPointerException("dateRange is marked non-null but is null");
        }
        return this.repository.findByEmployeeDayTypeAndDateBetweenAndPayrollMonthIsNotNull(attendanceDayType, (LocalDate)dateRange.lowerEndpoint(), (LocalDate)dateRange.upperEndpoint());
    }

    @Nonnull
    public Iterable<Attendance> findSquadLeaderAttendances(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        User user = payrollMonth.getUser();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        LocalDate accountingMonthStart = accountingMonth.atDay(1);
        LocalDate accountingMonthEnd = accountingMonth.atEndOfMonth();
        return this.repository.findByDateBetweenAndSquadLeader(accountingMonthStart, accountingMonthEnd, user, Duration.of(1L, ChronoUnit.MINUTES));
    }

    @Nonnull
    public Iterable<IAggregatedAttendanceUser> releasedPayrollMonthAttendances(@NonNull LocalDate accountingMonth, @NonNull Iterable<Long> relevantUserIds) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (relevantUserIds == null) {
            throw new NullPointerException("relevantUserIds is marked non-null but is null");
        }
        return this.repository.releaseAttendances(accountingMonth, relevantUserIds);
    }

    @Nonnull
    public Iterable<IAggregatedAttendanceUser> alreadyOfTypeOrPayrollMonthEdited(@NonNull LocalDate referenceDate, @NonNull Iterable<Long> relevantUserIds, @NonNull Iterable<EAttendanceDayType> attendanceDayTypes) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        if (relevantUserIds == null) {
            throw new NullPointerException("relevantUserIds is marked non-null but is null");
        }
        if (attendanceDayTypes == null) {
            throw new NullPointerException("attendanceDayTypes is marked non-null but is null");
        }
        return this.repository.alreadyOfTypeOrPayrollMonthEdited(referenceDate, relevantUserIds, (Iterable)ImmutableSet.copyOf(attendanceDayTypes));
    }
}

