/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.customer.EAddressType;
import de.qfm.erp.service.repository.AddressRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class AddressHandler
extends BaseHandler<Address> {
    private static final Logger log = LogManager.getLogger(AddressHandler.class);
    private final AddressRepository repository;

    @Autowired
    public AddressHandler(StandardPersistenceHelper standardPersistenceHelper, AddressRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<Address> clazz() {
        return Address.class;
    }

    @Nonnull
    protected Address beforeUpdate(@NonNull Address item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Address afterUpdate(@NonNull Address item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Address afterDelete(@NonNull Address item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Address beforeDelete(@NonNull Address item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Page<Address> page(int page, int size, @NonNull Iterable<Customer> filterCustomers, @NonNull Iterable<EAddressType> filterAddressTypes, @NonNull String filterText) {
        if (filterCustomers == null) {
            throw new NullPointerException("filterCustomers is marked non-null but is null");
        }
        if (filterAddressTypes == null) {
            throw new NullPointerException("filterAddressTypes is marked non-null but is null");
        }
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        AddressRepository.AddressSpec.entityStatesIn((Iterable)EntityState.ENTITY_STATES__NOT_DELETED).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        AddressRepository.AddressSpec.addressTypesIn(filterAddressTypes).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        AddressRepository.AddressSpec.customerIn(filterCustomers).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        AddressRepository.AddressSpec.text((String)filterText).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        AddressRepository.AddressSpec.onlyValid().ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        specsBuilder.add((Object)AddressRepository.AddressSpec.identity((boolean)true));
        ImmutableList specs = specsBuilder.build();
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"name"), Sort.Order.asc((String)"poBox")});
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)sort);
        Specification conjunction = AddressRepository.AddressSpec.conjunction((Specification)AddressRepository.AddressSpec.identity((boolean)true), (Iterable)specs);
        return this.repository.findAll(conjunction, (Pageable)pageRequest);
    }
}

