/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.collect.Streams;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.helper.DurationHelper;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.contract.EmployeeContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroupRate;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.user.User;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class WageCalculatorHelper {
    @Nonnull
    public static YearMonth yearMonth(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        LocalDate accountingMonth = payrollMonth.getAccountingMonth();
        return YearMonth.of(accountingMonth.getYear(), accountingMonth.getMonthValue());
    }

    @Nonnull
    public static Optional<BigDecimal> contractualWagePerHour(@NonNull YearMonth yearMonth, @NonNull User employee) {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (employee == null) {
            throw new NullPointerException("employee is marked non-null but is null");
        }
        Optional laborUnionWageGroupRateCandidate = EmployeeHelper.currentWageGroupRateNotFailing((User)employee, (YearMonth)yearMonth);
        if (laborUnionWageGroupRateCandidate.isPresent()) {
            LaborUnionWageGroupRate laborUnionWageGroupRate = (LaborUnionWageGroupRate)laborUnionWageGroupRateCandidate.get();
            return Optional.ofNullable(laborUnionWageGroupRate.getWageRatePerHour());
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<BigDecimal> nonTariffWagePerHour(@NonNull YearMonth yearMonth, @NonNull User employee) {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (employee == null) {
            throw new NullPointerException("employee is marked non-null but is null");
        }
        Optional employeeContractCandidate = EmployeeHelper.currentEmployeeContractNotFailing((User)employee, (YearMonth)yearMonth);
        if (employeeContractCandidate.isPresent()) {
            EmployeeContract employeeContract = (EmployeeContract)employeeContractCandidate.get();
            return Optional.ofNullable(employeeContract.getNonTariffHourlyWage());
        }
        return Optional.empty();
    }

    @Nonnull
    public static BigDecimal effectiveWagePerHour(@NonNull YearMonth yearMonth, @NonNull User employee) {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (employee == null) {
            throw new NullPointerException("employee is marked non-null but is null");
        }
        Optional nonTariffWagePerHourCand = WageCalculatorHelper.nonTariffWagePerHour((YearMonth)yearMonth, (User)employee);
        Optional contractualWagePerHourCand = WageCalculatorHelper.contractualWagePerHour((YearMonth)yearMonth, (User)employee);
        BigDecimal nonTariffWagePerHour = nonTariffWagePerHourCand.orElse(BigDecimal.ZERO);
        BigDecimal contractualWagePerHour = contractualWagePerHourCand.orElse(BigDecimal.ZERO);
        return nonTariffWagePerHour.max(contractualWagePerHour);
    }

    @Nullable
    public static BigDecimal effectiveWagePerHourNullable(@NonNull YearMonth yearMonth, @NonNull User employee) {
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        if (employee == null) {
            throw new NullPointerException("employee is marked non-null but is null");
        }
        Optional nonTariffWagePerHourCand = WageCalculatorHelper.nonTariffWagePerHour((YearMonth)yearMonth, (User)employee);
        Optional contractualWagePerHourCand = WageCalculatorHelper.contractualWagePerHour((YearMonth)yearMonth, (User)employee);
        if (nonTariffWagePerHourCand.isEmpty() && contractualWagePerHourCand.isEmpty()) {
            return null;
        }
        BigDecimal nonTariffWagePerHour = nonTariffWagePerHourCand.orElse(BigDecimal.ZERO);
        BigDecimal contractualWagePerHour = contractualWagePerHourCand.orElse(BigDecimal.ZERO);
        return nonTariffWagePerHour.max(contractualWagePerHour);
    }

    @Nonnull
    public static BigDecimal effectiveWageTotal(@NonNull BigDecimal hours, @NonNull BigDecimal wageRatePerHour) {
        if (hours == null) {
            throw new NullPointerException("hours is marked non-null but is null");
        }
        if (wageRatePerHour == null) {
            throw new NullPointerException("wageRatePerHour is marked non-null but is null");
        }
        return wageRatePerHour.multiply(hours).setScale(2, RoundingMode.HALF_UP);
    }

    @Nonnull
    public static BigDecimal hours(@NonNull Duration duration) {
        if (duration == null) {
            throw new NullPointerException("duration is marked non-null but is null");
        }
        return DurationHelper.hours((Duration)duration);
    }

    @Nonnull
    public static Duration durationInHours(@NonNull Iterable<Attendance> attendances, @NonNull Function<Attendance, Duration> durationFn) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        if (durationFn == null) {
            throw new NullPointerException("durationFn is marked non-null but is null");
        }
        return IterableHelper.stream(attendances).map(durationFn).filter(Objects::nonNull).reduce(Duration.ZERO, Duration::plus);
    }

    @Nonnull
    public static BigDecimal dayCount(@NonNull Iterable<Attendance> attendances, @NonNull Function<Attendance, Duration> durationFn) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        if (durationFn == null) {
            throw new NullPointerException("durationFn is marked non-null but is null");
        }
        return BigDecimal.valueOf(IterableHelper.stream(attendances).map(durationFn).filter(Objects::nonNull).count());
    }

    @Nonnull
    public static BigDecimal incentiveWageSum(@NonNull Iterable<PayrollMonthItem> incentivePayrollMonthItems, @NonNull Iterable<PayrollMonthItem> auxiliaryMappedAsIncentivePayrollMonthItems, @NonNull Iterable<PayrollMonthItem> wageAccountPayrollMonthItems) {
        if (incentivePayrollMonthItems == null) {
            throw new NullPointerException("incentivePayrollMonthItems is marked non-null but is null");
        }
        if (auxiliaryMappedAsIncentivePayrollMonthItems == null) {
            throw new NullPointerException("auxiliaryMappedAsIncentivePayrollMonthItems is marked non-null but is null");
        }
        if (wageAccountPayrollMonthItems == null) {
            throw new NullPointerException("wageAccountPayrollMonthItems is marked non-null but is null");
        }
        BigDecimal incentivePayrollMonthItemsSum = Streams.stream(incentivePayrollMonthItems).map(PayrollMonthItem::getValue).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal auxiliaryMappedAsIncentivePayrollMonthItemsSum = Streams.stream(auxiliaryMappedAsIncentivePayrollMonthItems).map(PayrollMonthItem::getValue).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal wageAccountPayrollMonthItemsSum = Streams.stream(wageAccountPayrollMonthItems).map(PayrollMonthItem::getValue).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        return incentivePayrollMonthItemsSum.add(auxiliaryMappedAsIncentivePayrollMonthItemsSum).add(wageAccountPayrollMonthItemsSum);
    }

    protected WageCalculatorHelper() {
    }

    public String toString() {
        return "WageCalculatorHelper()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WageCalculatorHelper)) {
            return false;
        }
        WageCalculatorHelper other = (WageCalculatorHelper)o;
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof WageCalculatorHelper;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

