/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.model.internal.employee.payroll.EDurationType;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AbsentDaysVacation_WageTypeCalculator
extends WageTypeCalculator {
    public static final int MAX_DIGITS = 5;
    private static final Function<Attendance, BigDecimal> VACATION_HOURS_FUNCTION = attendance -> WageCalculatorHelper.hours((Duration)((Duration)MoreObjects.firstNonNull((Object)attendance.getContractualWorkTimeDuration(), (Object)Duration.ZERO)));

    public AbsentDaysVacation_WageTypeCalculator() {
        super(EWageType.ABSENT_DAYS__VACATION);
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        User employee = payrollMonth.getUser();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        List attendances = payrollMonth.getAttendances();
        EDurationType sbsDurationOutputType = (EDurationType)MoreObjects.firstNonNull((Object)payrollItemType.getSbsDurationOutputType(), (Object)EDurationType.HOUR);
        boolean correctionFactorEnabled = EDurationType.DAY == sbsDurationOutputType;
        Iterable vacationDays = AbsentDaysVacation_WageTypeCalculator.attendances((Iterable)attendances, (EAttendanceDayType)EAttendanceDayType.VACATION);
        Duration duration = WageCalculatorHelper.durationInHours((Iterable)vacationDays, Attendance::getContractualWorkTimeDuration);
        BigDecimal durationInHours = WageCalculatorHelper.hours((Duration)duration);
        BigDecimal durationInDays = WageCalculatorHelper.dayCount((Iterable)vacationDays, Attendance::getContractualWorkTimeDuration);
        BigDecimal sbsCorrectionFactor = correctionFactorEnabled ? durationInDays : BigDecimal.ZERO;
        Function<Iterable, BigDecimal> groupedCorrectionFactorFn = attendancesLocal -> {
            if (correctionFactorEnabled && durationInHours.compareTo(BigDecimal.ZERO) != 0) {
                return durationInDays.divide(durationInHours, 5, RoundingMode.HALF_UP);
            }
            return BigDecimal.ZERO;
        };
        Function<Attendance, BigDecimal> detailCorrectionFactorFn = attendance -> {
            Duration contractualWorkTimeDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getContractualWorkTimeDuration(), (Object)Duration.ZERO);
            BigDecimal contractualWorkTimeDurationSum = WageCalculatorHelper.hours((Duration)contractualWorkTimeDuration);
            if (correctionFactorEnabled && contractualWorkTimeDurationSum.compareTo(BigDecimal.ZERO) != 0) {
                return BigDecimal.ONE.divide(contractualWorkTimeDurationSum, 5, RoundingMode.HALF_UP);
            }
            return BigDecimal.ZERO;
        };
        BigDecimal effectiveWagePerHour = WageCalculatorHelper.effectiveWagePerHour((YearMonth)yearMonth, (User)employee);
        BigDecimal wageTotalWithoutDeductions = AbsentDaysVacation_WageTypeCalculator.effectiveWageTotal((BigDecimal)durationInHours, (BigDecimal)effectiveWagePerHour);
        String currentContractName = EmployeeHelper.currentContractName((User)employee, (YearMonth)yearMonth).orElse("");
        WageTypeCalculationResult aggregationRow = WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)currentContractName, (BigDecimal)BigDecimal.ZERO, (BigDecimal)durationInHours, (BigDecimal)effectiveWagePerHour, (BigDecimal)wageTotalWithoutDeductions, (String)"", (boolean)correctionFactorEnabled, (BigDecimal)sbsCorrectionFactor);
        Iterable groupedAttendances = AbsentDaysVacation_WageTypeCalculator.group((Iterable)vacationDays);
        ImmutableList.Builder detailRowsBuilder = ImmutableList.builder();
        AtomicInteger counter = new AtomicInteger();
        for (Pair groupedAttendance : groupedAttendances) {
            detailRowsBuilder.add((Object)AbsentDaysVacation_WageTypeCalculator.groupedDetails((EWageType)this.getWageType(), (AtomicInteger)counter, (LocalDate)yearMonth.atEndOfMonth(), (PayrollItemType)payrollItemType, (Pair)groupedAttendance, attendancesLocal -> BigDecimal.valueOf(Iterables.size((Iterable)attendancesLocal)), attendancesLocal -> durationInHours, attendancesLocal -> BigDecimal.ZERO, attendancesLocal -> BigDecimal.ZERO, (boolean)correctionFactorEnabled, groupedCorrectionFactorFn));
            detailRowsBuilder.addAll(AbsentDaysVacation_WageTypeCalculator.ungroupedDetails((EWageType)this.getWageType(), (AtomicInteger)counter, (PayrollItemType)payrollItemType, (Pair)groupedAttendance, relatedAttendance -> BigDecimal.ONE, (Function)VACATION_HOURS_FUNCTION, relatedAttendance -> BigDecimal.ZERO, relatedAttendance -> BigDecimal.ZERO, (boolean)correctionFactorEnabled, detailCorrectionFactorFn));
        }
        ImmutableList detailRows = detailRowsBuilder.build();
        return ImmutableList.builder().add((Object)aggregationRow).addAll((Iterable)detailRows).build();
    }
}

