/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AbsentDaysOnDutyAttendanceCostBearer_WageTypeCalculator
extends WageTypeCalculator {
    final Function<Attendance, BigDecimal> ON_DUTY_FUNCTION = attendances -> WageCalculatorHelper.hours((Duration)((Duration)MoreObjects.firstNonNull((Object)attendances.getContractualWorkTimeDuration(), (Object)Duration.ZERO)));

    public AbsentDaysOnDutyAttendanceCostBearer_WageTypeCalculator() {
        super(EWageType.ABSENT_DAYS__ON_DUTY__ATTENDANCE_COST_BEARER);
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        User employee = payrollMonth.getUser();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        List attendances = payrollMonth.getAttendances();
        Iterable onDutyAttendances = this.onyDutyAttendances((Iterable)attendances);
        Duration duration = WageCalculatorHelper.durationInHours((Iterable)onDutyAttendances, Attendance::getContractualWorkTimeDuration);
        BigDecimal durationInHours = WageCalculatorHelper.hours((Duration)duration);
        BigDecimal effectiveWagePerHour = WageCalculatorHelper.effectiveWagePerHour((YearMonth)yearMonth, (User)employee);
        Iterable auxiliaryPaymentPayrollMonthItems = this.auxiliaryPaymentWithPayrollMonthType((Iterable)payrollMonth.getPayrollMonthItems(), payrollItemType);
        BigDecimal total = Streams.stream((Iterable)auxiliaryPaymentPayrollMonthItems).map(item -> (BigDecimal)MoreObjects.firstNonNull((Object)item.getValue(), (Object)BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        WageTypeCalculationResult aggregationRow = WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)"aus Hilfslohn:", (BigDecimal)total, (BigDecimal)durationInHours, (BigDecimal)effectiveWagePerHour, (BigDecimal)total, (String)"");
        Iterable groupedAttendances = AbsentDaysOnDutyAttendanceCostBearer_WageTypeCalculator.group((Iterable)onDutyAttendances);
        ImmutableList.Builder detailRowsBuilder = ImmutableList.builder();
        AtomicInteger counter = new AtomicInteger();
        for (Pair groupedAttendance : groupedAttendances) {
            Iterable localAttendances = (Iterable)groupedAttendance.getRight();
            Duration localDuration = WageCalculatorHelper.durationInHours((Iterable)localAttendances, Attendance::getContractualWorkTimeDuration);
            BigDecimal localDurationInHours = WageCalculatorHelper.hours((Duration)localDuration);
            BigDecimal localDays = BigDecimal.valueOf(Iterables.size((Iterable)localAttendances));
            detailRowsBuilder.add((Object)AbsentDaysOnDutyAttendanceCostBearer_WageTypeCalculator.groupedDetails((EWageType)this.getWageType(), (AtomicInteger)counter, (LocalDate)yearMonth.atEndOfMonth(), (PayrollItemType)payrollItemType, (Pair)groupedAttendance, relatedAttendance -> localDays, relatedAttendance -> localDurationInHours, relatedAttendance -> BigDecimal.ZERO, relatedAttendance -> total, (boolean)false, relatedAttendance -> BigDecimal.ZERO));
            detailRowsBuilder.addAll(AbsentDaysOnDutyAttendanceCostBearer_WageTypeCalculator.ungroupedDetails((EWageType)this.getWageType(), (AtomicInteger)counter, (PayrollItemType)payrollItemType, (Pair)groupedAttendance, relatedAttendance -> BigDecimal.ONE, (Function)this.ON_DUTY_FUNCTION, relatedAttendance -> BigDecimal.ZERO, relatedAttendance -> BigDecimal.ZERO, (boolean)false, relatedAttendance -> BigDecimal.ZERO));
        }
        ImmutableList detailRows = detailRowsBuilder.build();
        return ImmutableList.builder().add((Object)aggregationRow).addAll((Iterable)detailRows).build();
    }
}

