/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.generic.EDayType;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AbsentDaysBankingHolidayWageTypeCalculator
extends WageTypeCalculator {
    private static final Iterable<EAttendanceDayType> ATTENDANCE_DAY_TYPE__BANKING_HOLIDAYS = ImmutableSet.of((Object)EAttendanceDayType.NONE, (Object)EAttendanceDayType.STANDARD, (Object)EAttendanceDayType.VACATION, (Object)EAttendanceDayType.ABSENT, (Object)EAttendanceDayType.PARENTAL_LEAVE, (Object)EAttendanceDayType.BAD_WEATHER, (Object[])new EAttendanceDayType[]{EAttendanceDayType.BAD_WEATHER_SICK});

    public AbsentDaysBankingHolidayWageTypeCalculator() {
        super(EWageType.ABSENT_DAYS__BANKING_HOLIDAY);
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        User employee = payrollMonth.getUser();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        List attendances = payrollMonth.getAttendances();
        Iterable allBankingHolidayDays = this.attendances((Iterable)attendances, EDayType.BANKING_HOLIDAY);
        Iterable bankingHolidayDaysConsiderPresence = AbsentDaysBankingHolidayWageTypeCalculator.attendances((Iterable)allBankingHolidayDays, (Iterable)ATTENDANCE_DAY_TYPE__BANKING_HOLIDAYS);
        Duration durationInHours = WageCalculatorHelper.durationInHours((Iterable)bankingHolidayDaysConsiderPresence, Attendance::getContractualWorkTimeDuration);
        BigDecimal valueInHours = WageCalculatorHelper.hours((Duration)durationInHours);
        BigDecimal effectiveWagePerHour = WageCalculatorHelper.effectiveWagePerHour((YearMonth)yearMonth, (User)employee);
        BigDecimal total = AbsentDaysBankingHolidayWageTypeCalculator.effectiveWageTotal((BigDecimal)valueInHours, (BigDecimal)effectiveWagePerHour);
        return ImmutableList.of((Object)WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)"", (BigDecimal)BigDecimal.ZERO, (BigDecimal)valueInHours, (BigDecimal)effectiveWagePerHour, (BigDecimal)total, (String)""));
    }
}

