/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.aggregator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.service.calculator.wagetype.aggregator.AttendanceDurationAggregator;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class SickAttendanceDurationAggregator
extends AttendanceDurationAggregator {
    public SickAttendanceDurationAggregator() {
        super(EAggregatedAttendanceDayType.AGG_SICK);
    }

    @Nonnull
    public Map<EAggregatedAttendanceDayType, Duration> duration(@NonNull Attendance attendance) {
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        EAttendanceDayType employeeDayType = attendance.getEmployeeDayType();
        Duration contractualWorkTimeDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getContractualWorkTimeDuration(), (Object)Duration.ZERO);
        Duration badWeatherDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getBadWeatherDuration(), (Object)Duration.ZERO);
        if (!contractualWorkTimeDuration.isZero() && EAttendanceDayType.SICK == employeeDayType) {
            return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_SICK, (Object)contractualWorkTimeDuration);
        }
        if (!badWeatherDuration.isZero() && EAttendanceDayType.BAD_WEATHER_SICK == employeeDayType) {
            return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_BAD_WEATHER_SICK, (Object)badWeatherDuration);
        }
        return ImmutableMap.of();
    }
}

