/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.aggregator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.generic.EDayType;
import de.qfm.erp.service.service.calculator.wagetype.aggregator.AttendanceDurationAggregator;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class BankingHolidayDurationAggregator
extends AttendanceDurationAggregator {
    private static final Iterable<EDayType> DAY_TYPES = ImmutableSet.of((Object)EDayType.BANKING_HOLIDAY);
    private static final Iterable<EAttendanceDayType> ATTENDANCE_DAY_TYPE__BANKING_HOLIDAYS = ImmutableSet.of((Object)EAttendanceDayType.NONE, (Object)EAttendanceDayType.STANDARD, (Object)EAttendanceDayType.VACATION, (Object)EAttendanceDayType.ABSENT, (Object)EAttendanceDayType.PARENTAL_LEAVE, (Object)EAttendanceDayType.BAD_WEATHER, (Object[])new EAttendanceDayType[0]);

    public BankingHolidayDurationAggregator() {
        super(EAggregatedAttendanceDayType.AGG_WORK);
    }

    @Nonnull
    public Map<EAggregatedAttendanceDayType, Duration> duration(@NonNull Attendance attendance) {
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        EDayType dayType = attendance.getDayType();
        Duration contractualWorkTime = (Duration)MoreObjects.firstNonNull((Object)attendance.getContractualWorkTimeDuration(), (Object)Duration.ZERO);
        EAttendanceDayType employeeDayType = (EAttendanceDayType)MoreObjects.firstNonNull((Object)attendance.getEmployeeDayType(), (Object)EAttendanceDayType.NONE);
        boolean isConsideredBankingHoliday = Iterables.contains((Iterable)ATTENDANCE_DAY_TYPE__BANKING_HOLIDAYS, (Object)employeeDayType);
        if (isConsideredBankingHoliday && !contractualWorkTime.isZero() && Iterables.contains((Iterable)DAY_TYPES, (Object)dayType)) {
            return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_BANKING_HOLIDAYS, (Object)contractualWorkTime);
        }
        return ImmutableMap.of();
    }
}

