/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.aggregator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.service.calculator.wagetype.aggregator.AttendanceDurationAggregator;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class BadWeatherAttendanceDurationAggregator
extends AttendanceDurationAggregator {
    public BadWeatherAttendanceDurationAggregator() {
        super(EAggregatedAttendanceDayType.AGG_BAD_WEATHER);
    }

    @Nonnull
    public Map<EAggregatedAttendanceDayType, Duration> duration(@NonNull Attendance attendance) {
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        EAttendanceDayType employeeDayType = attendance.getEmployeeDayType();
        Duration workDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getWorkDuration(), (Object)Duration.ZERO);
        Duration badWeatherDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getBadWeatherDuration(), (Object)Duration.ZERO);
        if (EAttendanceDayType.STANDARD == employeeDayType && !badWeatherDuration.isZero()) {
            return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_BAD_WEATHER, (Object)badWeatherDuration);
        }
        if (EAttendanceDayType.SICK == employeeDayType && !badWeatherDuration.isZero()) {
            return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_BAD_WEATHER, (Object)badWeatherDuration);
        }
        if (EAttendanceDayType.CHILD_SICK_LEAVE == employeeDayType && !badWeatherDuration.isZero()) {
            return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_BAD_WEATHER, (Object)badWeatherDuration);
        }
        if (!(EAttendanceDayType.BAD_WEATHER != employeeDayType || workDuration.isZero() && badWeatherDuration.isZero())) {
            return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_BAD_WEATHER, (Object)badWeatherDuration);
        }
        return ImmutableMap.of();
    }
}

