/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.service.calculator.wagetype.aggregator.AttendanceDurationAggregator;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AttendanceDurationAggregators {
    private static final Logger log = LogManager.getLogger(AttendanceDurationAggregators.class);
    private final List<AttendanceDurationAggregator> attendanceDurationAggregators;

    @Autowired
    public AttendanceDurationAggregators(List<AttendanceDurationAggregator> attendanceDurationAggregators) {
        this.attendanceDurationAggregators = ImmutableList.copyOf(attendanceDurationAggregators);
    }

    @Nonnull
    public Map<EAggregatedAttendanceDayType, Duration> duration(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        List attendances = payrollMonth.getAttendances();
        HashMap collectedAggregations = Maps.newHashMap();
        for (EAggregatedAttendanceDayType value : EAggregatedAttendanceDayType.values()) {
            collectedAggregations.put(value, Duration.ZERO);
        }
        for (Attendance attendance : attendances) {
            for (AttendanceDurationAggregator attendanceDurationAggregator : this.attendanceDurationAggregators) {
                Map aggregate = attendanceDurationAggregator.duration(attendance);
                aggregate.forEach((k, v) -> {
                    Duration sum = ((Duration)collectedAggregations.get(k)).plus((Duration)v);
                    collectedAggregations.put(k, sum);
                });
            }
        }
        return ImmutableMap.copyOf((Map)collectedAggregations);
    }

    @Nonnull
    public Map<EAggregatedAttendanceDayType, BigDecimal> count(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        List attendances = payrollMonth.getAttendances();
        HashMap collectedAggregations = Maps.newHashMap();
        for (EAggregatedAttendanceDayType value : EAggregatedAttendanceDayType.values()) {
            collectedAggregations.put(value, BigDecimal.ZERO);
        }
        for (Attendance attendance : attendances) {
            for (AttendanceDurationAggregator attendanceDurationAggregator : this.attendanceDurationAggregators) {
                Map aggregate = attendanceDurationAggregator.count(attendance);
                aggregate.forEach((k, v) -> {
                    BigDecimal sum = ((BigDecimal)collectedAggregations.get(k)).add((BigDecimal)v);
                    collectedAggregations.put(k, sum);
                });
            }
        }
        return ImmutableMap.copyOf((Map)collectedAggregations);
    }
}

