/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.quotation;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.quotation.StageCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.collections4.IterableUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StageSumsCalculator
extends StageCalculator {
    static final int ORDERING = -1;
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD);

    public StageSumsCalculator() {
        super(PROPERTIES, -1);
    }

    void calculateAndApply(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        boolean flagDiscountFeePositions = (Boolean)MoreObjects.firstNonNull((Object)stage.getFlagDiscountFeePositions(), (Object)false);
        Set quotationPositionsOriginal = (Set)MoreObjects.firstNonNull((Object)stage.getQuotationPositions(), (Object)ImmutableSet.of());
        Set quotationPositions = (Set)quotationPositionsOriginal.stream().filter(item -> IterableUtils.contains((Iterable)EPositionType.WAGE_AND_VALUE_TYPES, (Object)item.getPositionType())).filter(item -> {
            boolean isJumboChild = IterableUtils.contains((Iterable)EPositionType.JUMBO_CHILD, (Object)item.getPositionType());
            if (isJumboChild) {
                QuotationPosition supposedParent = item.getParent();
                boolean stageContainsParent = supposedParent != null && quotationPositionsOriginal.contains(supposedParent);
                return !stageContainsParent;
            }
            return true;
        }).collect(ImmutableSet.toImmutableSet());
        BigDecimal priceWithoutDiscountSum = BigDecimal.ZERO;
        BigDecimal squadWageSum = BigDecimal.ZERO;
        BigDecimal companyWageSum = BigDecimal.ZERO;
        BigDecimal materialPurchasePriceSum = BigDecimal.ZERO;
        BigDecimal materialSellingPriceSum = BigDecimal.ZERO;
        BigDecimal externalServicePurchasePriceSum = BigDecimal.ZERO;
        BigDecimal externalServiceSellingPriceSum = BigDecimal.ZERO;
        BigDecimal priceWithDiscountSum = BigDecimal.ZERO;
        BigDecimal generalDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)stage.getGeneralDiscount(), (Object)BigDecimal.ZERO);
        BigDecimal calculationDiscountOrSurcharge = BigDecimal.ONE.subtract(generalDiscount.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_UP));
        for (QuotationPosition quotationPosition : quotationPositions) {
            EAlternativePositionType alternativePositionType = quotationPosition.getAlternativePositionType();
            boolean calculate = null != alternativePositionType && alternativePositionType.calculate();
            if (!calculate) continue;
            Boolean isFeePosition = (Boolean)MoreObjects.firstNonNull((Object)quotationPosition.getFlagFeePosition(), (Object)false);
            boolean applyDiscount = isFeePosition == false || flagDiscountFeePositions;
            BigDecimal priceAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)quotationPosition.getPriceAggregated(), (Object)BigDecimal.ZERO);
            priceWithoutDiscountSum = priceWithoutDiscountSum.add(priceAggregated);
            BigDecimal priceWithDiscount = applyDiscount ? priceAggregated.multiply(calculationDiscountOrSurcharge).setScale(2, RoundingMode.HALF_UP) : priceAggregated;
            priceWithDiscountSum = priceWithDiscountSum.add(priceWithDiscount);
            BigDecimal squadWageAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)quotationPosition.getSquadWageAggregated(), (Object)BigDecimal.ZERO);
            squadWageSum = squadWageSum.add(squadWageAggregated);
            BigDecimal companyWageAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)quotationPosition.getCompanyWageAggregated(), (Object)BigDecimal.ZERO);
            companyWageSum = companyWageSum.add(companyWageAggregated);
            BigDecimal materialWholesalePriceIncludingDiscountAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)quotationPosition.getMaterialWholesalePriceIncludingDiscountAggregated(), (Object)BigDecimal.ZERO);
            materialPurchasePriceSum = materialPurchasePriceSum.add(materialWholesalePriceIncludingDiscountAggregated);
            BigDecimal materialSellingPriceAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)quotationPosition.getMaterialSellingPriceAggregated(), (Object)BigDecimal.ZERO);
            materialSellingPriceSum = materialSellingPriceSum.add(materialSellingPriceAggregated);
            BigDecimal externalServicePurchasePriceAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)quotationPosition.getExternalServicePurchasePriceAggregated(), (Object)BigDecimal.ZERO);
            externalServicePurchasePriceSum = externalServicePurchasePriceSum.add(externalServicePurchasePriceAggregated);
            BigDecimal externalServiceSellingPriceAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)quotationPosition.getExternalServiceSellingPriceAggregated(), (Object)BigDecimal.ZERO);
            externalServiceSellingPriceSum = externalServiceSellingPriceSum.add(externalServiceSellingPriceAggregated);
        }
        BigDecimal vat = (BigDecimal)MoreObjects.firstNonNull((Object)stage.getVatPercent(), (Object)BigDecimal.ZERO);
        stage.setPriceWithoutDiscountSum(priceWithoutDiscountSum);
        stage.setPriceWithDiscountSum(priceWithDiscountSum);
        stage.setSquadWageSum(squadWageSum);
        stage.setCompanyWageSum(companyWageSum);
        stage.setMaterialPurchasePriceSum(materialPurchasePriceSum);
        stage.setMaterialSellingPriceSum(materialSellingPriceSum);
        stage.setExternalServicePurchasePriceSum(externalServicePurchasePriceSum);
        stage.setExternalServiceSellingPriceSum(externalServiceSellingPriceSum);
        BigDecimal wagePercentageWeightedAverage = StageSumsCalculator.percentage((BigDecimal)squadWageSum, (BigDecimal)companyWageSum);
        BigDecimal materialPercentageWeightedAverage = StageSumsCalculator.percentage((BigDecimal)materialPurchasePriceSum, (BigDecimal)materialSellingPriceSum);
        BigDecimal externalCostsPercentageWeightedAverage = StageSumsCalculator.percentage((BigDecimal)externalServicePurchasePriceSum, (BigDecimal)externalServiceSellingPriceSum);
        stage.setWagePercentageWeightedAverage(wagePercentageWeightedAverage);
        stage.setMaterialPercentageWeightedAverage(materialPercentageWeightedAverage);
        stage.setExternalServicePercentageWeightedAverage(externalCostsPercentageWeightedAverage);
        BigDecimal vatValueWithDiscountSum = vat.multiply(priceWithDiscountSum).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        BigDecimal vatValueWithoutDiscountSum = vat.multiply(priceWithoutDiscountSum).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        stage.setVatValueWithDiscountSum(vatValueWithDiscountSum);
        stage.setVatValueWithoutDiscountSum(vatValueWithoutDiscountSum);
        BigDecimal priceGrossWithDiscountSum = priceWithDiscountSum.add(vatValueWithDiscountSum);
        BigDecimal priceGrossWithoutDiscountSum = priceWithoutDiscountSum.add(vatValueWithoutDiscountSum);
        stage.setPriceGrossWithDiscountSum(priceGrossWithDiscountSum);
        stage.setPriceGrossWithoutDiscountSum(priceGrossWithoutDiscountSum);
        BigDecimal orderValue = stage.getOrderValue();
        if (null == orderValue) {
            stage.setOrderValueWithDiscount(null);
        } else {
            BigDecimal orderValueWithDiscount = orderValue.multiply(BigDecimal.ONE.add(generalDiscount.divide(BigDecimal.valueOf(-100L), 4, RoundingMode.HALF_UP))).setScale(2, RoundingMode.HALF_UP);
            stage.setOrderValueWithDiscount(orderValueWithDiscount);
        }
    }

    @Nonnull
    private static BigDecimal percentage(@NonNull BigDecimal left, @NonNull BigDecimal right) {
        if (left == null) {
            throw new NullPointerException("left is marked non-null but is null");
        }
        if (right == null) {
            throw new NullPointerException("right is marked non-null but is null");
        }
        return left.compareTo(BigDecimal.ZERO) != 0 ? right.divide(left, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
    }

    @Nullable
    private static BigDecimal normalize(@Nullable BigDecimal value) {
        if (null != value) {
            return value.setScale(2, RoundingMode.HALF_UP);
        }
        return null;
    }
}

