/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.quotation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.quotation.StagePositionCalculator;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
public class StagePositionTypeCalculator
extends StagePositionCalculator {
    private static final String COMMENT_INDICATOR = "*";
    private static final String REMARK_INDICATOR = "#";
    static final int ORDERING = 1;
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD, (Object)ECalculatorProperty.SYNC);

    public StagePositionTypeCalculator() {
        super(PROPERTIES, 1);
    }

    void calculateAndApply(@NonNull QuotationPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        EPositionType existingPositionType = position.getPositionType();
        if (EPositionType.CHANGE_IN_QUANTITY == existingPositionType) {
            return;
        }
        String positionNumber = StringUtils.trimToEmpty((String)position.getPositionNumber());
        String g1 = StringUtils.trimToEmpty((String)position.getGroupingElementLevel1());
        String g2 = StringUtils.trimToEmpty((String)position.getGroupingElementLevel2());
        String g3 = StringUtils.trimToEmpty((String)position.getGroupingElementLevel3());
        String g4 = StringUtils.trimToEmpty((String)position.getGroupingElementLevel4());
        ImmutableSet relevantGroupingElement = ImmutableSet.of((Object)positionNumber, (Object)g4, (Object)g3, (Object)g2, (Object)g1);
        boolean isCommentaryRow = relevantGroupingElement.contains(COMMENT_INDICATOR);
        boolean isRemarkRow = relevantGroupingElement.contains(REMARK_INDICATOR);
        if (isCommentaryRow) {
            position.setPositionType(EPositionType.COMMENT);
        } else if (isRemarkRow) {
            position.setPositionType(EPositionType.REMARK);
        } else if (position.getPositionType() == null || position.getPositionType() == EPositionType.UNKNOWN) {
            position.setPositionType(EPositionType.STANDARD);
        }
    }

    @VisibleForTesting
    @NonNull
    static String firstNonBlank(String ... arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        for (String item : arr) {
            if (!StringUtils.isNotBlank((CharSequence)item)) continue;
            return item;
        }
        return "";
    }
}

