/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.pss;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.pss.PssCalculator;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
public class PssNameCalculator
extends PssCalculator {
    private static final Joiner NAME_PART_JOINER = Joiner.on((String)" - ").skipNulls();
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD, (Object)ECalculatorProperty.SYNC);
    static final int ORDERING = 0;

    public PssNameCalculator() {
        super(PROPERTIES, 0);
    }

    public void calculateAndApply(@NonNull PssReleaseOrder pssReleaseOrder) {
        String place;
        Long pssId;
        String pssIdAsString;
        String releaseOrderNumber;
        if (pssReleaseOrder == null) {
            throw new NullPointerException("pssReleaseOrder is marked non-null but is null");
        }
        ImmutableList.Builder namePartsSelectBuilder = ImmutableList.builder();
        ImmutableList.Builder namePartsPreviewBuilder = ImmutableList.builder();
        String releaseOrderProjectNumber = pssReleaseOrder.getProjectNumber();
        if (StringUtils.isNotBlank((CharSequence)releaseOrderProjectNumber)) {
            namePartsSelectBuilder.add((Object)releaseOrderProjectNumber);
            namePartsPreviewBuilder.add((Object)releaseOrderProjectNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)(releaseOrderNumber = pssReleaseOrder.getReleaseOrderNumber()))) {
            namePartsSelectBuilder.add((Object)releaseOrderNumber);
            namePartsPreviewBuilder.add((Object)releaseOrderNumber);
        }
        String string = pssIdAsString = null != (pssId = pssReleaseOrder.getPssId()) ? Long.toString(pssId) : "";
        if (StringUtils.isNotBlank((CharSequence)pssIdAsString)) {
            namePartsPreviewBuilder.add((Object)pssIdAsString);
        }
        if (StringUtils.isNotBlank((CharSequence)(place = pssReleaseOrder.getPlace()))) {
            namePartsSelectBuilder.add((Object)place);
            namePartsPreviewBuilder.add((Object)place);
        }
        ImmutableList namePartsSelect = namePartsSelectBuilder.build();
        ImmutableList namePartsPreview = namePartsPreviewBuilder.build();
        String nameSelectNew = NAME_PART_JOINER.join((Iterable)namePartsSelect);
        String namePreviewNew = NAME_PART_JOINER.join((Iterable)namePartsPreview);
        String previewCurrent = StringUtils.trimToEmpty((String)pssReleaseOrder.getReleaseOrderNamePreviewCurrent());
        String releaseOrderNamePreviewPrevious = StringUtils.isNotBlank((CharSequence)previewCurrent) ? previewCurrent : namePreviewNew;
        String selectCurrent = StringUtils.trimToEmpty((String)pssReleaseOrder.getReleaseOrderNameSelectCurrent());
        String releaseOrderNameSelectPrevious = StringUtils.isNotBlank((CharSequence)selectCurrent) ? selectCurrent : nameSelectNew;
        pssReleaseOrder.setReleaseOrderNamePreviewPrevious(releaseOrderNamePreviewPrevious);
        pssReleaseOrder.setReleaseOrderNameSelectPrevious(releaseOrderNameSelectPrevious);
        pssReleaseOrder.setReleaseOrderNamePreviewCurrent(namePreviewNew);
        pssReleaseOrder.setReleaseOrderNameSelectCurrent(nameSelectNew);
    }
}

