/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.measurement;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.helper.MapperHelper;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.measurement.MeasurementCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
public class MeasurementWageAndValueSumCalculator
extends MeasurementCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD, (Object)ECalculatorProperty.SYNC);
    static final int ORDERING = 0;

    public MeasurementWageAndValueSumCalculator() {
        super(PROPERTIES, 0);
    }

    public void calculateAndApply(@NonNull Measurement measurement) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        BigDecimal internalWageOverall = BigDecimal.ZERO;
        BigDecimal squadWageOverall = BigDecimal.ZERO;
        BigDecimal valueOverall = BigDecimal.ZERO;
        BigDecimal companyWageOverall = BigDecimal.ZERO;
        BigDecimal materialPurchasePriceOverall = BigDecimal.ZERO;
        BigDecimal materialSellingPriceOverall = BigDecimal.ZERO;
        BigDecimal externalServicePurchasePriceOverall = BigDecimal.ZERO;
        BigDecimal externalServiceSellingPriceOverall = BigDecimal.ZERO;
        List measurementPositions = measurement.getMeasurementPositions();
        Iterator positionIterator = measurementPositions.stream().filter(item -> Iterables.contains((Iterable)EPositionType.WAGE_AND_VALUE_TYPES, (Object)item.getPositionType())).iterator();
        while (positionIterator.hasNext()) {
            MeasurementPosition measurementPosition = (MeasurementPosition)positionIterator.next();
            BigDecimal internalWageAggregated = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getInternalWageAggregated());
            internalWageOverall = internalWageOverall.add(internalWageAggregated);
            BigDecimal internalSquadWageAggregated = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getInternalSquadWageAggregated());
            squadWageOverall = squadWageOverall.add(internalSquadWageAggregated);
            BigDecimal priceAggregated = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getPriceAggregated());
            valueOverall = valueOverall.add(priceAggregated);
            BigDecimal materialPurchasePriceAgg = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getMaterialPurchasePriceIncludingDiscountAggregated());
            materialPurchasePriceOverall = materialPurchasePriceOverall.add(materialPurchasePriceAgg);
            BigDecimal materialSellingPriceAgg = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getMaterialSellingPriceAggregated());
            materialSellingPriceOverall = materialSellingPriceOverall.add(materialSellingPriceAgg);
            BigDecimal companyWageAggregated = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getCompanyWageAggregated());
            companyWageOverall = companyWageOverall.add(companyWageAggregated);
            BigDecimal externalServicePurchasePriceAggregated = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getExternalServicePurchasePriceAggregated());
            externalServicePurchasePriceOverall = externalServicePurchasePriceOverall.add(externalServicePurchasePriceAggregated);
            BigDecimal externalServiceSellingPriceAggregated = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getExternalServiceSellingPriceAggregated());
            externalServiceSellingPriceOverall = externalServiceSellingPriceOverall.add(externalServiceSellingPriceAggregated);
        }
        measurement.setWageOverall(internalWageOverall.setScale(2, RoundingMode.HALF_UP));
        measurement.setInternalWageOverall(internalWageOverall.setScale(2, RoundingMode.HALF_UP));
        measurement.setSquadWageOverall(squadWageOverall.setScale(2, RoundingMode.HALF_UP));
        measurement.setCompanyWageOverall(companyWageOverall.setScale(2, RoundingMode.HALF_UP));
        measurement.setValueOverall(valueOverall.setScale(2, RoundingMode.HALF_UP));
        measurement.setMaterialPurchasePriceOverall(materialPurchasePriceOverall.setScale(2, RoundingMode.HALF_UP));
        measurement.setMaterialSellingPriceOverall(materialSellingPriceOverall.setScale(2, RoundingMode.HALF_UP));
        measurement.setExternalServicePurchasePriceOverall(externalServicePurchasePriceOverall.setScale(2, RoundingMode.HALF_UP));
        measurement.setExternalServiceSellingPriceOverall(externalServiceSellingPriceOverall.setScale(2, RoundingMode.HALF_UP));
    }
}

