/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.invoice;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.helper.MapperHelper;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.invoice.InvoicePositionCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=4)
public class InvoicePositionMaterialPriceCalculator
extends InvoicePositionCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD);
    static final int ORDERING = 4;

    public InvoicePositionMaterialPriceCalculator() {
        super(PROPERTIES, 4);
    }

    public void calculateAndApply(@NonNull InvoicePosition invoicePosition) {
        BigDecimal sellingPricePerUnit;
        BigDecimal purchasePricePerUnit;
        BigDecimal materialFactor;
        if (invoicePosition == null) {
            throw new NullPointerException("invoicePosition is marked non-null but is null");
        }
        BigDecimal product = invoicePosition.getProduct();
        BigDecimal purchasePricePerUnitCandidate = invoicePosition.getMaterialPurchasePricePerUnit();
        BigDecimal sellingPricePerUnitCandidate = invoicePosition.getMaterialSellingPricePerUnit();
        BigDecimal materialFactorCandidate = this.nonZero(invoicePosition.getMaterialFactor(), BigDecimal.ONE);
        int nonNull = 0;
        if (null != purchasePricePerUnitCandidate) {
            ++nonNull;
        }
        if (null != sellingPricePerUnitCandidate) {
            ++nonNull;
        }
        if (null != materialFactorCandidate) {
            ++nonNull;
        }
        if (nonNull < 2) {
            materialFactor = BigDecimal.ZERO;
            purchasePricePerUnit = BigDecimal.ZERO;
            sellingPricePerUnit = BigDecimal.ZERO;
        } else if (nonNull == 2) {
            materialFactor = null == materialFactorCandidate ? sellingPricePerUnitCandidate.divide(purchasePricePerUnitCandidate, 2, RoundingMode.HALF_UP) : MapperHelper.safeBigDecimal((BigDecimal)materialFactorCandidate).add(BigDecimal.ONE);
            purchasePricePerUnit = null == purchasePricePerUnitCandidate ? sellingPricePerUnitCandidate.divide(materialFactorCandidate, 2, RoundingMode.HALF_UP) : MapperHelper.safeBigDecimal((BigDecimal)purchasePricePerUnitCandidate);
            sellingPricePerUnit = null == sellingPricePerUnitCandidate ? purchasePricePerUnitCandidate.multiply(materialFactorCandidate) : MapperHelper.safeBigDecimal((BigDecimal)sellingPricePerUnitCandidate);
        } else {
            materialFactor = materialFactorCandidate;
            purchasePricePerUnit = purchasePricePerUnitCandidate;
            sellingPricePerUnit = sellingPricePerUnitCandidate;
        }
        BigDecimal purchasePriceAggregated = purchasePricePerUnit.multiply(product);
        BigDecimal materialSellingPriceAggregated = sellingPricePerUnit.multiply(product);
        invoicePosition.setMaterialFactor(materialFactor.setScale(2, RoundingMode.HALF_UP));
        invoicePosition.setMaterialPurchasePricePerUnit(purchasePricePerUnit.setScale(2, RoundingMode.HALF_UP));
        invoicePosition.setMaterialPurchasePriceAgg(purchasePriceAggregated.setScale(2, RoundingMode.HALF_UP));
        invoicePosition.setMaterialSellingPricePerUnit(sellingPricePerUnit.setScale(2, RoundingMode.HALF_UP));
        invoicePosition.setMaterialSellingPriceAggregated(materialSellingPriceAggregated.setScale(2, RoundingMode.HALF_UP));
    }

    @Nonnull
    private BigDecimal nonZero(@Nullable BigDecimal value, @NonNull BigDecimal fallback) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        return null == value || value.compareTo(BigDecimal.ZERO) == 0 ? fallback : value;
    }
}

