/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.invoice;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.InvoiceHelper;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.invoice.InvoiceCalculator;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0)
public class InvoiceMeasurementNumberCalculator
extends InvoiceCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD, (Object)ECalculatorProperty.SYNC);
    static final int ORDERING = 1;
    static final Joiner COMMA_JOINER = Joiner.on((String)", ");

    public InvoiceMeasurementNumberCalculator() {
        super(PROPERTIES, 1);
    }

    public void calculateAndApply(@NonNull Invoice invoice, @NonNull Iterable<Invoice> cumulativeInvoices, boolean optionIgnoreAddendum) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (cumulativeInvoices == null) {
            throw new NullPointerException("cumulativeInvoices is marked non-null but is null");
        }
        Iterable invoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)invoice.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        Iterable measurements = InvoiceHelper.measurements((Iterable)invoiceMeasurements);
        String measurementNumbers = COMMA_JOINER.join(Streams.stream((Iterable)measurements).map(Measurement::getMeasurementNumber).iterator());
        invoice.setMeasurementNumbers(measurementNumbers);
    }
}

