/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource.administration;

import de.qfm.erp.common.response.employee.payroll.PayrollMonthPageCommon;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceOrigin;
import de.qfm.erp.service.service.route.PayrollMonthRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Payroll Month Administration Resource", name="PayrollMonthAdministrationResource")
@OpenAPIDefinition(tags={@Tag(name="PayrollMonthAdministrationResource", description="All Operations around Administration")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/administration"})
public class PayrollMonthAdministrationResource {
    private static final Logger log = LogManager.getLogger(PayrollMonthAdministrationResource.class);
    private final PayrollMonthRoute payrollMonthRoute;

    @Operation(summary="Ensure Attendances for Payroll Month Id")
    @GetMapping(value={"/payrollmonths/{year}/{month}/_ensure_attendances/"}, produces={"application/json"})
    public PayrollMonthPageCommon getById(@PathVariable(value="year") int year, @PathVariable(value="month") int month) {
        return this.payrollMonthRoute.ensureAttendance(EAttendanceOrigin.PAYROLL_MONTH, year, month);
    }

    public PayrollMonthAdministrationResource(PayrollMonthRoute payrollMonthRoute) {
        this.payrollMonthRoute = payrollMonthRoute;
    }
}

