/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import de.qfm.erp.common.request.user.UserDisableRequest;
import de.qfm.erp.common.request.user.UserPasswordUpdateRequest;
import de.qfm.erp.common.request.user.UserSettingUpdateRequest;
import de.qfm.erp.common.request.user.UserUniqueAttributeCheckRequest;
import de.qfm.erp.common.request.user.UserUniqueNameGenerateRequest;
import de.qfm.erp.common.request.user.UserUpdateRequest;
import de.qfm.erp.common.response.profile.UserSettingCommon;
import de.qfm.erp.common.response.profile.UserSettingListCommon;
import de.qfm.erp.common.response.user.EmployeeContractListCommon;
import de.qfm.erp.common.response.user.UserBusinessUnitListCommon;
import de.qfm.erp.common.response.user.UserCommon;
import de.qfm.erp.common.response.user.UserPageCommon;
import de.qfm.erp.common.response.user.UserUniqueAttributeCheckResponse;
import de.qfm.erp.common.response.user.UserUniqueNameResponse;
import de.qfm.erp.service.service.route.UserRoute;
import de.qfm.erp.service.service.route.UserSettingsRoute;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="User/Employee Management Resource", name="UserResource")
@OpenAPIDefinition(tags={@Tag(name="UserResource", description="All Operations around Users/Employees")})
@ApiResponses(value={@ApiResponse(responseCode="400", description="Something went wrong"), @ApiResponse(responseCode="403", description="Access denied"), @ApiResponse(responseCode="401", description="Expired or invalid JWT token")})
@RestController
@RequestMapping(value={"/api/v1/erp/users"})
public class UserResource {
    private static final Logger log = LogManager.getLogger(UserResource.class);
    private final AuthenticationHelper authenticationHelper;
    private final UserRoute userRoute;
    private final UserSettingsRoute userSettingsRoute;

    @Operation(summary="Paged Users Listing")
    @GetMapping(value={"/"})
    public UserPageCommon list(@Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="The Page index starting at 0", example="0") @RequestParam(value="page", defaultValue="0") int page, @Parameter(description="The Page Size", example="1000") @RequestParam(value="size", defaultValue="1000") int size) {
        return this.userRoute.page(filterText, page, size);
    }

    @Operation(summary="User for Id")
    @GetMapping(value={"/{id}/"})
    public UserCommon getById(@PathVariable(value="id") long id) {
        return this.userRoute.byId(id);
    }

    @Operation(summary="Create user from User Update Request")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    public UserCommon createUser(@Parameter(description="User Update Request", required=true) @Valid @RequestBody UserUpdateRequest userUpdateRequest) {
        return this.userRoute.create(userUpdateRequest);
    }

    @Operation(summary="Update a user via User Update for Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public UserCommon updateUser(@PathVariable(value="id") long id, @Parameter(description="User Update Request", required=true) @Valid @RequestBody UserUpdateRequest userUpdateRequest) {
        return this.userRoute.update(id, userUpdateRequest);
    }

    @Operation(summary="Disable User")
    @PostMapping(value={"/{id}/_disable/"}, consumes={"application/json"}, produces={"application/json"})
    public UserCommon disableUser(@PathVariable(value="id") long id, @Parameter(description="User Disable Request", required=true) @Valid @RequestBody UserDisableRequest userDisableRequest) {
        return this.userRoute.disable(id, userDisableRequest);
    }

    @Operation(summary="Get User Business Units for Id")
    @GetMapping(value={"/{id}/business_units/"}, produces={"application/json"})
    public UserBusinessUnitListCommon businessUnitsByUserId(@PathVariable(value="id") long id) {
        return this.userRoute.userBusinessUnits(id);
    }

    @Operation(summary="Get User Labor Union Contracts for Id")
    @GetMapping(value={"/{id}/employee_contracts/"}, produces={"application/json"})
    public EmployeeContractListCommon laborUnionContractsByUserId(@PathVariable(value="id") long id) {
        return this.userRoute.employeeContracts(id);
    }

    @Operation(summary="Update User Password for Id")
    @PostMapping(value={"/{id}/password/"}, consumes={"application/json"}, produces={"application/json"})
    public UserCommon changePassword(@PathVariable(value="id") long id, @RequestBody @Valid UserPasswordUpdateRequest updateRequest) {
        return this.userRoute.update(id, updateRequest);
    }

    @GetMapping(value={"/_me/"})
    @Operation(summary="Logged In User Profile", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=UserCommon.class))})})
    public Map<String, String> whoAmI(@NonNull HttpServletRequest req) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        User user = this.authenticationHelper.currentUser();
        String username = user.getUsername();
        Iterator stringStream = user.getAuthorities().stream().map(GrantedAuthority::getAuthority).iterator();
        String roles = Joiner.on((String)", ").skipNulls().join(stringStream);
        return ImmutableMap.of((Object)"name", (Object)username, (Object)"role", (Object)roles);
    }

    @Operation(summary="User for Id")
    @GetMapping(value={"/{id}/settings/"})
    public UserSettingCommon settingsByUserId(@PathVariable(value="id") long id) {
        return this.userSettingsRoute.byId(id);
    }

    @Operation(summary="User for Id")
    @GetMapping(value={"/_me/settings/"})
    public UserSettingListCommon mysettings() {
        return this.userSettingsRoute.mySettings();
    }

    @Operation(summary="Store a Value under a specific Key")
    @PostMapping(value={"/_me/settings/{key}/{value}/"}, produces={"application/json"})
    public UserSettingCommon createOrUpdate(@PathVariable(value="key") String key, @PathVariable(value="value") String value) {
        return this.userSettingsRoute.createOrUpdate(key, value);
    }

    @Operation(summary="Store a Value under a specific Key")
    @GetMapping(value={"/_me/settings/{key}/"}, produces={"application/json"})
    public UserSettingCommon createOrUpdate(@PathVariable(value="key") String key) {
        return this.userSettingsRoute.byKey(key);
    }

    @Operation(summary="Store a Key/Value Pair")
    @PostMapping(value={"/_me/settings/"}, consumes={"application/json"}, produces={"application/json"})
    public UserSettingCommon createOrUpdate(@RequestBody UserSettingUpdateRequest updateRequest) {
        return this.userSettingsRoute.createOrUpdate(updateRequest);
    }

    @Operation(summary="check an attribute for uniqueness")
    @PostMapping(value={"/_check/"}, consumes={"application/json"}, produces={"application/json"})
    public UserUniqueAttributeCheckResponse uniqueAttributeCheck(@RequestBody UserUniqueAttributeCheckRequest request) {
        return this.userRoute.uniqueAttributeCheck(request);
    }

    @Operation(summary="generate username based upon request data")
    @PostMapping(value={"/_username/"}, consumes={"application/json"}, produces={"application/json"})
    public UserUniqueNameResponse uniqueUsername(@RequestBody UserUniqueNameGenerateRequest request) {
        return this.userRoute.generateUserName(request);
    }

    public UserResource(AuthenticationHelper authenticationHelper, UserRoute userRoute, UserSettingsRoute userSettingsRoute) {
        this.authenticationHelper = authenticationHelper;
        this.userRoute = userRoute;
        this.userSettingsRoute = userSettingsRoute;
    }
}

