/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.leancoders.common.response.reporting.ReportResponse;
import de.qfm.erp.common.request.quotation.StageAliasUpdateRequest;
import de.qfm.erp.common.request.quotation.StageFulfilmentFilterRequest;
import de.qfm.erp.common.request.quotation.StagePositionUpdateItem;
import de.qfm.erp.common.request.quotation.StageProjectUpdateRequest;
import de.qfm.erp.common.request.quotation.StageStateUpdateRequest;
import de.qfm.erp.common.request.quotation.StageUpdateRequest;
import de.qfm.erp.common.request.quotation.StageVersionUpdateRequest;
import de.qfm.erp.common.response.StringListResponse;
import de.qfm.erp.common.response.error.ErrorResponse;
import de.qfm.erp.common.response.quotation.GaebImportResultListCommon;
import de.qfm.erp.common.response.quotation.StageAutoCompleteResponse;
import de.qfm.erp.common.response.quotation.StageBudgetCommon;
import de.qfm.erp.common.response.quotation.StageCommon;
import de.qfm.erp.common.response.quotation.StageFileListCommon;
import de.qfm.erp.common.response.quotation.StageFulfilmentDegreeSimpleCommon;
import de.qfm.erp.common.response.quotation.StageListCommon;
import de.qfm.erp.common.response.quotation.StageOrderNumberListCommon;
import de.qfm.erp.common.response.quotation.StagePageCommon;
import de.qfm.erp.common.response.quotation.StagePositionCommon;
import de.qfm.erp.common.response.quotation.StagePositionPageCommon;
import de.qfm.erp.common.response.quotation.StagePropagationListCommon;
import de.qfm.erp.common.response.validation.ValidationResultCommon;
import de.qfm.erp.service.resource.AbstractResource;
import de.qfm.erp.service.service.route.StagePropagationRoute;
import de.qfm.erp.service.service.route.StageRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(description="Stage Management Resource", name="StageResource")
@OpenAPIDefinition(tags={@Tag(name="StageResource", description="All Operations around Quotations")})
@ApiResponses(value={@ApiResponse(responseCode="400", description="Something went wrong", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Access denied", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Expired or invalid JWT token", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
@RestController
@RequestMapping(value={"/api/v2/erp/qstages"})
public class StageResource {
    private static final Logger log = LogManager.getLogger(StageResource.class);
    private StageRoute route;
    private StagePropagationRoute stagePropagationRoute;

    @ApiResponse(responseCode="200", description="Stage Listing")
    @GetMapping(value={"/"}, produces={"application/json"})
    public StagePageCommon listing(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size, @RequestParam(value="filter_text", defaultValue="") String filterText, @RequestParam(value="filter_customer_id", required=false) Long filterCustomerId, @RequestParam(value="flag_include_archived", defaultValue="false") boolean flagIncludeArchived) {
        return this.route.list(page, size, filterText, filterCustomerId, flagIncludeArchived);
    }

    @ApiResponse(responseCode="200", description="Stage by Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public StageCommon byId(@PathVariable(value="id") long id, @Parameter(description="Commission Flag will be ignored, when returning Positions (all positions will be returned)", example="false") @RequestParam(value="include_all_positions", defaultValue="false") boolean includeAllPositions, @Parameter(description="Versions will be ignored, when returning Positions", example="false") @RequestParam(value="ignore_version_flag", defaultValue="false") boolean ignoreVersionFlag, @Parameter(description="Cost Estimate view will be applied, when returning Positions (only works on stageType=COMMISSION__COST_UNIT_CE)", example="COMMISSION, COMMISSION__COST_UNIT_CE") @RequestParam(value="cost_unit_ce_view_mode", defaultValue="COMMISSION") String costUnitCEViewModeCandidate, @Parameter(description="Positions Sort Option", example="DEFAULT, GROUPING_LEVELS_ASC, SEQUENTIAL_NUMBER_ASC") @RequestParam(value="sort_option", defaultValue="DEFAULT") String sortOptionCandidate) {
        return this.route.byId(id, includeAllPositions, ignoreVersionFlag, StringUtils.trimToEmpty((String)costUnitCEViewModeCandidate), StringUtils.trimToEmpty((String)sortOptionCandidate));
    }

    @ApiResponse(responseCode="200", description="Stage Budget by Id")
    @GetMapping(value={"/{id}/_budget/"}, produces={"application/json"})
    public StageBudgetCommon budgetById(@PathVariable(value="id") long id) {
        return this.route.budgetById(id);
    }

    @ApiResponse(responseCode="200", description="Stage Order Numbers by Id")
    @GetMapping(value={"/{id}/_order_numbers/"}, produces={"application/json"})
    public StageOrderNumberListCommon orderNumbersByStageId(@PathVariable(value="id") long id) {
        return this.route.orderNumbersByStageId(id);
    }

    @ApiResponse(responseCode="200", description="StagePropagation by StageId")
    @GetMapping(value={"/{id}/stage_propagations/"}, produces={"application/json"})
    public StagePropagationListCommon byId(@PathVariable(value="id") long id, @RequestParam(value="show_processed", defaultValue="true") boolean showProcessed) {
        return this.stagePropagationRoute.list((Iterable)ImmutableList.of((Object)id), showProcessed);
    }

    @ApiResponse(responseCode="200", description="Stage Positions by Stage Positon.Short Text")
    @GetMapping(value={"/positions/"}, produces={"application/json"})
    public StagePositionPageCommon listPositions(@Parameter(description="filter positions by stage.id") @RequestParam(value="filter_stage_id", defaultValue="") Long filterByStageId, @Parameter(description="filter positions by text") @RequestParam(value="filter_stage_text", defaultValue="") String filterStageText, @Parameter(description="filter positions by text") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="Positions Sort Option", example="GROUPING_LEVELS_ASC, SEQUENTIAL_NUMBER_ASC") @RequestParam(value="sort_option", defaultValue="GROUPING_LEVELS_ASC") String sortOptionCandidate) {
        return this.route.positions(filterByStageId, StringUtils.trimToEmpty((String)filterStageText), StringUtils.trimToEmpty((String)filterText), StringUtils.trimToEmpty((String)sortOptionCandidate));
    }

    @ApiResponse(responseCode="200", description="Set new State for Stage with Id")
    @PostMapping(value={"/{id}/_state/{new_state}/"}, consumes={"application/json"}, produces={"application/json"})
    public StageCommon updateStateById(@Parameter(description="Stage Id of the Stage to change State", required=true) @PathVariable(value="id") long id, @Parameter(description="new State for Stage", example="[TEMPORARY,NOTIFIED,ACTIVE,CLOSED,ARCHIVED,APPROVED,SUBMITTED,COMMISSIONED,DESIGNATED_COMMISSION,ACCEPTED,REJECTED]", required=true) @PathVariable(value="new_state") String newStateCandidate, @RequestBody @Valid StageStateUpdateRequest updateRequest) {
        return this.route.updateStateForId(id, newStateCandidate, updateRequest);
    }

    @ApiResponse(responseCode="200", description="validate the setting of new State for Stage with Id")
    @PostMapping(value={"/{id}/_state_validation/{new_state}/"}, consumes={"application/json"}, produces={"application/json"})
    public ValidationResultCommon validateUpdateStateById(@Parameter(description="Id of the Stage to change State", required=true) @PathVariable(value="id") long id, @Parameter(description="new State for Stage", example="TBD", required=true) @PathVariable(value="new_state") String newStateCandidate, @Parameter(description="current Stage.rowVersion", required=true, example="-1") @RequestParam(value="row_version") int rowVersion) {
        return this.route.validateUpdateStateForId(id, newStateCandidate, rowVersion);
    }

    @ApiResponse(responseCode="200", description="validate the possibility of the positiontype change to 'CHANGE_IN_QUANTITY' of Position within a Stage by Id")
    @PostMapping(value={"/{id}/_change_in_quantity_validation/"}, consumes={"application/json"}, produces={"application/json"})
    public ValidationResultCommon validateUpdateStateById(@Parameter(description="Id if the Stage to validate a CHANGE_IN_QUANTITY Position against", required=true) @PathVariable(value="id") long id, @RequestBody @Valid StagePositionUpdateItem updateItem) {
        return this.route.validateChangeInQuantity(id, updateItem);
    }

    @ApiResponse(responseCode="200", description="Create new Stage based on Stage with Id")
    @PostMapping(value={"/{id}/_stage/{new_stage}/"}, consumes={"application/json"}, produces={"application/json"})
    public StageCommon createStageById(@Parameter(description="Stage Id of the Stage to change State", required=true) @PathVariable(value="id") long id, @Parameter(description="new Stage for Stage", example="TBD", required=true) @PathVariable(value="new_stage") String newStageCandidate, @RequestParam(value="flag_copy_positions", defaultValue="true") Boolean flagCopyPositionsBoolean) {
        boolean flagCopyPositions = (Boolean)MoreObjects.firstNonNull((Object)flagCopyPositionsBoolean, (Object)true);
        return this.route.createStageByStageId(id, newStageCandidate, flagCopyPositions);
    }

    @ApiResponse(responseCode="200", description="create new Version for Stage with Id")
    @PostMapping(value={"/{id}/_version/"}, consumes={"application/json"}, produces={"application/json"})
    public StageCommon createVersionById(@Parameter(description="Stage Id of the Stage to change State", required=true) @PathVariable(value="id") long id, @RequestBody @Valid StageVersionUpdateRequest updateRequest) {
        return this.route.createVersionByStageId(id, updateRequest);
    }

    @ApiResponse(responseCode="200", description="create new Version for Stage with Id")
    @GetMapping(value={"/{id}/_version/stages/"}, produces={"application/json"})
    public StageListCommon versionStagesByStageId(@Parameter(description="Stage Id of the Stage to retrieve potential Versionable Stages", required=true) @PathVariable(value="id") long id) {
        return this.route.versionStagesByStageId(Long.valueOf(id));
    }

    @ApiResponse(responseCode="200", description="Stage AutoComplete")
    @GetMapping(value={"/_autocomplete/"}, produces={"application/json"})
    public StageAutoCompleteResponse autocomplete(@Parameter(description="filter autocomplete  by stage.id") @RequestParam(value="stage_id", defaultValue="") Long stageId, @Parameter(description="filter autocomplete by text") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="All = Unfiltered, ...", example="ALL, MEASUREMENT_ACTIVE, MEASUREMENT_ALL, NAL, REPORT, ACCOUNTING, IMPORT") @RequestParam(value="autocomplete_mode", defaultValue="ALL") String autoCompleteMode, @Parameter(description="if set, the result includes addendums (addendum number !=0)", example="null, true, false") @RequestParam(value="flag_include_addendum", defaultValue="true") Boolean flagIncludeAddendum) {
        boolean includeAddendum = Boolean.TRUE == flagIncludeAddendum;
        return this.route.standardAutoComplete(stageId, StringUtils.trimToEmpty((String)filterText), StringUtils.trimToEmpty((String)autoCompleteMode), includeAddendum);
    }

    @ApiResponse(responseCode="200", description="Create a QEntity")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public StageCommon createInquiry(@Valid @RequestBody StageUpdateRequest updateRequest) {
        return this.route.createInquiry(updateRequest);
    }

    @ApiResponse(responseCode="200", description="Update Stage for a given Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public StageCommon updateForId(@PathVariable(value="id") Long id, @Valid @RequestBody StageUpdateRequest updateRequest) {
        return this.route.update(id, updateRequest);
    }

    @ApiResponse(responseCode="200", description="Update Stage.Alias for a given Id")
    @PostMapping(value={"/{id}/_alias/"}, consumes={"application/json"}, produces={"application/json"})
    public StageCommon updateAliasForId(@PathVariable(value="id") Long id, @Valid @RequestBody StageAliasUpdateRequest aliasUpdateRequest) {
        return this.route.update(id, aliasUpdateRequest);
    }

    @ApiResponse(responseCode="200", description="Update Stage.Project for a given Id / all Stages in Entity")
    @PostMapping(value={"/{id}/_project/"}, consumes={"application/json"}, produces={"application/json"})
    public StageCommon updateProjectForId(@PathVariable(value="id") Long id, @Valid @RequestBody StageProjectUpdateRequest projectUpdateRequest) {
        return this.route.update(id, projectUpdateRequest);
    }

    @ApiResponse(responseCode="200", description="Stage Files by Id")
    @GetMapping(value={"/{id}/_files/"}, produces={"application/json"})
    public StageFileListCommon filesById(@PathVariable(value="id") long id) {
        return this.route.filesById(Long.valueOf(id));
    }

    @ApiResponse(responseCode="200", description="Root URL File for Stage")
    @GetMapping(value={"/{id}/_url/"})
    public void lnkById(@PathVariable(value="id") long id, @RequestParam(value="reference_path", defaultValue="") String path, HttpServletResponse response) throws IOException {
        Pair result = this.route.urlFile(Long.valueOf(id), StringUtils.trimToEmpty((String)path));
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)result, (String)"application/octet-stream");
    }

    @Deprecated(forRemoval=true)
    @ApiResponse(responseCode="200", description="Populate a Stage from GAEB / X83 Upload")
    @PostMapping(value={"/{id}/_from_x83/"})
    public GaebImportResultListCommon handleFileUploadOld(@PathVariable(value="id") Long id, @RequestParam(value="multiPartFile") MultipartFile[] multiPartFiles, @Parameter(description="Option to print Append Positions instead of Replace", example="false") @RequestParam(value="option_append_positions", defaultValue="true") Boolean optionAppendPositions) {
        boolean append = (Boolean)MoreObjects.firstNonNull((Object)optionAppendPositions, (Object)true);
        return this.route.fromFile(id.longValue(), multiPartFiles, append);
    }

    @ApiResponse(responseCode="200", description="Populate a Stage from GAEB / X83 Upload")
    @PostMapping(value={"/{id}/_from_file/"})
    public GaebImportResultListCommon handleFileUpload(@PathVariable(value="id") Long id, @RequestParam(value="multiPartFile") MultipartFile[] multiPartFiles, @Parameter(description="Option to print Append Positions instead of Replace", example="false") @RequestParam(value="option_append_positions", defaultValue="true") Boolean optionAppendPositions) {
        boolean append = (Boolean)MoreObjects.firstNonNull((Object)optionAppendPositions, (Object)true);
        return this.route.fromFile(id.longValue(), multiPartFiles, append);
    }

    @ApiResponse(responseCode="200", description="Stage Export GAEB.X84")
    @GetMapping(value={"/{id}/_x84/"}, produces={"application/xml"})
    public void exportAsX84(@Parameter(description="Id of the Stage to be exported as X84", required=true) @PathVariable(value="id") Long id, HttpServletResponse response) throws IOException {
        Pair content = this.route.exportAsX84(id);
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"application/xml");
    }

    @ApiResponse(responseCode="200", description="Stage Export XLSX")
    @GetMapping(value={"/{id}/_xls/"}, produces={"application/octet-stream"})
    public void positionsAsXLS(@Parameter(description="Id of the Stage to be exported as XLSX", required=true) @PathVariable(value="id") Long id, HttpServletResponse response) throws IOException {
        Pair content = this.route.exportAsXLSX(id.longValue());
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"application/octet-stream");
    }

    @ApiResponse(responseCode="200", description="Print Stage for Id into PDF")
    @GetMapping(value={"/{id}/_print/"})
    public void printById(@PathVariable(value="id") long id, @Parameter(description="preview flag for preview rendering / if true (default) - no modification of the stage will happen", example="true") @RequestParam(name="flag_preview", defaultValue="true") Boolean flagPreview, @Parameter(description="Option to print Quotation", example="false") @RequestParam(name="flag_print_quotation", defaultValue="false") Boolean flagPrintQuotation, @Parameter(description="Option to print Calculation", example="false") @RequestParam(name="flag_print_calculation", defaultValue="false") Boolean flagPrintCalculation, @Parameter(description="Option to print Paysheet", example="false") @RequestParam(name="flag_print_paysheet", defaultValue="false") Boolean flagPrintPaySheet, @Parameter(description="Option to print Cost Estimate", example="false") @RequestParam(name="flag_print_cost_estimate", defaultValue="false") Boolean flagPrintCostEstimate, @Parameter(description="Print Indent Levels as Headline", example="false") @RequestParam(name="option_quotation_indent_level_as_headline", defaultValue="false") Boolean optionQuotationIndentLevelAsHeadline, @Parameter(description="Print Price per Unit Breakdown", example="false") @RequestParam(name="option_quotation_price_per_unit_break_down", defaultValue="false") Boolean optionQuotationPricePerUnitBreakDown, @Parameter(description="Print Price per Unit Breakdown", example="false") @RequestParam(name="option_quotation_show_discount_data", defaultValue="false") Boolean optionQuotationShowDiscountData, @Parameter(description="Print Price per Unit Breakdown", example="false") @RequestParam(name="option_quotation_no_signature", defaultValue="false") Boolean optionQuotationNoSignature, @Parameter(description="Print Price per Unit Breakdown", example="false") @RequestParam(name="option_quotation_attachment_subtotals", defaultValue="false") Boolean optionQuotationAttachmentSubtotals, @Parameter(description="Print Price per Unit Breakdown", example="false") @RequestParam(name="option_quotation_show_long_text", defaultValue="false") Boolean optionQuotationShowLongText, @Parameter(description="Print  Execution Data", example="false") @RequestParam(name="option_quotation_print_project_execution", defaultValue="false") Boolean optionQuotationPrintProjectExecution, @Parameter(description="Print Binding Period", example="false") @RequestParam(name="option_quotation_print_binding_period", defaultValue="false") Boolean optionQuotationPrintBindingPeriod, @Parameter(description="Print Autograph Paragraph", example="false") @RequestParam(name="option_quotation_print_autograph_paragraph", defaultValue="false") Boolean optionQuotationPrintAutographParagraph, @Parameter(description="Print VOB Paragraph", example="false") @RequestParam(name="option_quotation_print_vob_paragraph", defaultValue="false") Boolean optionQuotationPrintVOBParagraph, @Parameter(description="Print Payment Conditions", example="false") @RequestParam(name="option_quotation_print_payment_conditions", defaultValue="false") Boolean optionQuotationPrintPaymentConditions, @Parameter(description="Print Jumbo/Child (true = print child instead of Jumbo)", example="false") @RequestParam(name="option_quotation_print_child", defaultValue="false") Boolean optionPrintChild, @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @Parameter(description="Override Submission of Bid Date", example="ISO-DATE YYYY-MM-YY") @RequestParam(name="override_submission_of_bid_date", defaultValue="") LocalDate overrideSubmissionOfBidDate, @RequestParam Map<String, String> allRequestParams, HttpServletResponse response) throws IOException {
        Pair pdfContent = this.route.printStage(id, ((Boolean)MoreObjects.firstNonNull((Object)flagPreview, (Object)true)).booleanValue(), ((Boolean)MoreObjects.firstNonNull((Object)flagPrintQuotation, (Object)false)).booleanValue(), ((Boolean)MoreObjects.firstNonNull((Object)flagPrintCalculation, (Object)false)).booleanValue(), ((Boolean)MoreObjects.firstNonNull((Object)flagPrintPaySheet, (Object)false)).booleanValue(), ((Boolean)MoreObjects.firstNonNull((Object)flagPrintCostEstimate, (Object)false)).booleanValue(), allRequestParams, overrideSubmissionOfBidDate);
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)pdfContent, (String)"application/pdf");
    }

    @ApiResponse(responseCode="200", description="Degree of Fulfilment for Stage by Id")
    @PostMapping(value={"/{id}/degree_of_fulfilment/"}, consumes={"application/json"}, produces={"application/json"})
    public StageFulfilmentDegreeSimpleCommon degreeOfFulfilment(@PathVariable(value="id") long id, @Parameter(description="Filter by Quotation Position Ids") @Valid @RequestBody StageFulfilmentFilterRequest stageFulfilmentFilterRequest) {
        return this.route.degreeOfFulfilment(id, stageFulfilmentFilterRequest);
    }

    @ApiResponse(responseCode="200", description="Degree of Fulfilment by Filter Criteria")
    @PostMapping(value={"/degree_of_fulfilment/"}, consumes={"application/json"}, produces={"application/json"})
    public StageFulfilmentDegreeSimpleCommon degreeOfFulfilment(@Parameter(description="Filter by Stage Position Ids") @Valid @RequestBody StageFulfilmentFilterRequest stageFulfilmentFilterRequest) {
        return this.route.degreeOfFulfilment(stageFulfilmentFilterRequest);
    }

    @ApiResponse(responseCode="200", description="Report based on Report Type on actual Data")
    @GetMapping(value={"/{id}/{report}/_report/"}, produces={"application/json"})
    public ReportResponse<?, ?> report(@PathVariable(value="id") Long stageId, @PathVariable(value="report") String report) {
        return this.route.reportResponse(stageId, report);
    }

    @ApiResponse(responseCode="200", description="Download XLS (Bill of Quantities/Price List) Measurement Template")
    @GetMapping(value={"/{stage_id}/measurement_template/_xls/"}, produces={"application/octet-stream"})
    public void billOfQuantitiesMeasurementTemplateById(@PathVariable(value="stage_id") Long quotationId, HttpServletResponse response) throws IOException {
        Pair content = this.route.billOfQuantitiesMeasurementTemplateById(quotationId.longValue());
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"application/octet-stream");
    }

    @ApiResponse(responseCode="200", description="Ensure Correction-Position for Quotation by Id")
    @PostMapping(value={"/{id}/_ensure_correction_position/"}, consumes={"application/json"}, produces={"application/json"})
    public StageCommon ensureCorrectionPosition(@PathVariable(value="id") long id) {
        return this.route.ensureCorrectionPosition(id);
    }

    @ApiResponse(responseCode="200", description="GET Correction-Position for Quotation by Id")
    @GetMapping(value={"/{id}/_correction_positions/"}, produces={"application/json"})
    public List<StagePositionCommon> correctionPosition(@PathVariable(value="id") long id) {
        return this.route.correctionPosition(id);
    }

    @ApiResponse(responseCode="200", description="Person responsible at Client for Stage by Id")
    @GetMapping(value={"/{id}/person_responsible_at_customer/"}, produces={"application/json"})
    public StringListResponse personResponsibleAtClient(@PathVariable(value="id") long id, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        return this.route.personResponsibleAtClient(id, filterText);
    }

    @ApiResponse(responseCode="200", description="Download all Not Exported ER2")
    @GetMapping(value={"/_not_exported_er2/"}, produces={"text/csv"})
    public void personResponsibleAtClient(HttpServletResponse response) throws IOException {
        Pair content = this.route.downloadNotExportedER2();
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"text/csv");
    }

    public StageResource(StageRoute route, StagePropagationRoute stagePropagationRoute) {
        this.route = route;
        this.stagePropagationRoute = stagePropagationRoute;
    }
}

