/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.common.response.quotation.StagePropagationCommon;
import de.qfm.erp.common.response.quotation.StagePropagationListCommon;
import de.qfm.erp.service.service.route.StagePropagationRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Stage Propagation Management Resource", name="StagePropagationResource")
@OpenAPIDefinition(tags={@Tag(name="StagePropagationResource", description="All Operations around Stage Propagations")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/stagepropagations"})
public class StagePropagationResource {
    private static final Logger log = LogManager.getLogger(StagePropagationResource.class);
    private StagePropagationRoute route;

    @Operation(summary="Stage Propagation Listing")
    @GetMapping(value={"/"}, produces={"application/json"})
    public StagePropagationListCommon listing(@RequestParam(value="filter_stage_id", required=false) Long filterStageId, @RequestParam(value="show_processed", defaultValue="true") boolean showProcessed) {
        ImmutableSet filterStageIds = null != filterStageId ? ImmutableSet.of((Object)filterStageId) : ImmutableSet.of();
        return this.route.list((Iterable)filterStageIds, showProcessed);
    }

    @Operation(summary="Stage Propagation by Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public StagePropagationCommon byId(@PathVariable(value="id") long id) {
        return this.route.byId(Long.valueOf(id));
    }

    @Operation(summary="Stage Propagation by Id")
    @PostMapping(value={"/{id}/_process/"}, consumes={"application/json"}, produces={"application/json"})
    public StagePropagationCommon processById(@PathVariable(value="id") long id) {
        return this.route.process(Long.valueOf(id));
    }

    public StagePropagationResource(StagePropagationRoute route) {
        this.route = route;
    }
}

