/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.qfm.erp.common.response.error.ErrorResponse;
import de.qfm.erp.service.model.exception.request.DuplicationException;
import de.qfm.erp.service.model.exception.request.EntityAccessRestrictionException;
import de.qfm.erp.service.model.exception.request.JwtTokenException;
import de.qfm.erp.service.model.exception.request.MissingPrivilegeException;
import de.qfm.erp.service.model.exception.request.NoDataException;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.service.service.MessageService;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.ValidationException;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@ControllerAdvice
@RestControllerAdvice
public class RestResponseEntityExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LogManager.getLogger(RestResponseEntityExceptionHandler.class);
    private final MessageService messageService;
    private static final Map<String, EMessageKey> MESSAGE_CODES = ImmutableMap.builder().put((Object)"NotBlank", (Object)EMessageKey.NOT_EMPTY).put((Object)"NotEmpty", (Object)EMessageKey.NOT_EMPTY).put((Object)"NotNull", (Object)EMessageKey.NOT_NULL).put((Object)"Size", (Object)EMessageKey.SIZE).put((Object)"Max", (Object)EMessageKey.MAX).put((Object)"Min", (Object)EMessageKey.MIN).put((Object)"DecimalMax", (Object)EMessageKey.MAX).put((Object)"DecimalMin", (Object)EMessageKey.MIN).build();

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        log.error("HttpMessageNotReadableException: {}", (Object)ex.getMessage());
        String errorMessage = ex.getMessage();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)ErrorResponse.of((int)HttpStatus.BAD_REQUEST.value(), (String)HttpStatus.BAD_REQUEST.name(), (String)errorMessage, (List)ImmutableList.of()));
    }

    protected ResponseEntity<Object> handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        log.error("HttpMessageNotWritableException: {}", (Object)ex.getMessage());
        String errorMessage = ex.getMessage();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)ErrorResponse.of((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)HttpStatus.INTERNAL_SERVER_ERROR.name(), (String)errorMessage, (List)ImmutableList.of()));
    }

    @ExceptionHandler(value={IllegalArgumentException.class, IllegalStateException.class})
    protected ResponseEntity<Object> handleConflict(RuntimeException ex, WebRequest request) {
        log.error("IllegalArgumentException / IllegalStateException: {}", (Object)ex.getMessage(), (Object)ex);
        return this.handleExceptionInternal((Exception)ex, (Object)ex.getMessage(), new HttpHeaders(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, request);
    }

    @ExceptionHandler(value={AuthenticationException.class, BadCredentialsException.class, AccessDeniedException.class, JwtTokenException.class})
    protected ResponseEntity<Object> handleAuthorization(RuntimeException ex, WebRequest request) {
        log.error("AuthenticationException / BadCredentialsException / AccessDeniedException: {}", (Object)ex.getMessage());
        String errorMessage = ex.getMessage();
        ErrorResponse errorResponse = ErrorResponse.of((int)HttpStatus.UNAUTHORIZED.value(), (String)HttpStatus.UNAUTHORIZED.name(), (String)errorMessage, (List)ImmutableList.of());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).contentType(MediaType.APPLICATION_JSON).body((Object)errorResponse);
    }

    @ExceptionHandler(value={NoDataException.class})
    protected ResponseEntity<Object> handleNoDataException(NoDataException ex, WebRequest request) {
        log.error("NoDataException: {}", (Object)ex.getMessage());
        Message detail = ex.getDetail();
        String message = this.translatedMessage(detail);
        ErrorResponse errorResponse = ErrorResponse.of((int)HttpStatus.BAD_REQUEST.value(), (String)HttpStatus.BAD_REQUEST.name(), (String)message, (List)ImmutableList.of());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)errorResponse);
    }

    @ExceptionHandler(value={EntityAccessRestrictionException.class})
    protected ResponseEntity<Object> handleAccess(EntityAccessRestrictionException ex, WebRequest request) {
        log.error("SecurityException: {}, Details: {}", (Object)ex.getMessage(), (Object)ex.toString());
        EEntityClass clazz = ex.getClazz();
        Long entityId = ex.getEntityId();
        String entityIdForMessage = ex.getEntityIdForMessage();
        String translatedMessage = clazz == EEntityClass.MEASUREMENT ? this.messageService.get((Translatable)EMessageKey.SECURITY__MEASUREMENT_ACCESS_RESTRICTION, new Object[]{entityIdForMessage}) : this.messageService.get((Translatable)EMessageKey.SECURITY__GENERIC_ENTITY_ACCESS_RESTRICTION, new Object[]{clazz, entityId, entityIdForMessage});
        ErrorResponse errorResponse = ErrorResponse.of((int)HttpStatus.FORBIDDEN.value(), (String)HttpStatus.FORBIDDEN.name(), (String)translatedMessage, (List)ImmutableList.of());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_JSON).body((Object)errorResponse);
    }

    @ExceptionHandler(value={MissingPrivilegeException.class})
    protected ResponseEntity<Object> handleAccess(MissingPrivilegeException ex, WebRequest request) {
        log.error("SecurityException: {}, Details: {}", (Object)ex.getMessage(), (Object)ex.toString());
        String translatedMessage = this.messageService.get(ex.getInternalMessage());
        ErrorResponse errorResponse = ErrorResponse.of((int)HttpStatus.FORBIDDEN.value(), (String)HttpStatus.FORBIDDEN.name(), (String)translatedMessage, (List)ImmutableList.of());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_JSON).body((Object)errorResponse);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(@NonNull MethodArgumentNotValidException ex, @Nullable HttpHeaders headers, @Nullable HttpStatusCode status, @Nullable WebRequest request) {
        if (ex == null) {
            throw new NullPointerException("ex is marked non-null but is null");
        }
        log.error("MethodArgumentNotValidException: {}", (Object)ex.getMessage());
        ImmutableList.Builder details = ImmutableList.builder();
        String errorMessage = ex.getBindingResult().getFieldErrors().stream().map(item -> {
            String field = item.getField();
            String defaultMessage = item.getDefaultMessage();
            String rejectedValue = RestResponseEntityExceptionHandler.rejectedValue((Object)item.getRejectedValue());
            String code = item.getCode();
            EMessageKey messageKey = MESSAGE_CODES.getOrDefault(code, EMessageKey.UNKNOWN);
            String translatedField = this.translatedField(field);
            String translatedMessage = this.translatedMessage(Message.of((EMessageKey)messageKey, (List)ImmutableList.of((Object)translatedField)));
            List allowedArguments = RestResponseEntityExceptionHandler.allowedArguments((FieldError)item);
            details.add((Object)ErrorResponse.Detail.of((String)field, (String)translatedMessage, (String)defaultMessage, (String)rejectedValue, (String)messageKey.name(), (List)allowedArguments));
            return this.errorMessage(field, defaultMessage, rejectedValue);
        }).findFirst().orElse(ex.getMessage());
        return ResponseEntity.badRequest().contentType(MediaType.APPLICATION_JSON).body((Object)ErrorResponse.of((int)HttpStatus.BAD_REQUEST.value(), (String)HttpStatus.BAD_REQUEST.name(), (String)errorMessage, (List)details.build()));
    }

    @Nonnull
    private static List<String> allowedArguments(@NonNull FieldError fieldError) {
        if (fieldError == null) {
            throw new NullPointerException("fieldError is marked non-null but is null");
        }
        Object[] arguments = fieldError.getArguments();
        if (null != arguments) {
            ImmutableList argumentsFromMessageSource = ImmutableList.copyOf(Arrays.stream(arguments).skip(1L).filter(Objects::nonNull).filter(item -> item instanceof MessageSourceResolvable).flatMap(item -> {
                String[] codes = ((MessageSourceResolvable)item).getCodes();
                if (null != codes) {
                    return Arrays.stream(codes);
                }
                return Stream.empty();
            }).sorted().iterator());
            if (!argumentsFromMessageSource.isEmpty()) {
                return argumentsFromMessageSource;
            }
            return ImmutableList.copyOf(Arrays.stream(arguments).skip(1L).filter(Objects::nonNull).filter(item -> item.getClass().getPackage().getName().startsWith("java.lang")).map(Object::toString).sorted().iterator());
        }
        return ImmutableList.of();
    }

    @ExceptionHandler(value={DuplicationException.class, RequestValidationException.class})
    public ResponseEntity<?> handleRequestValidationException(RequestValidationException requestValidationException, WebRequest request) {
        log.error("RequestValidationException: {}", (Object)requestValidationException.getMessage(), (Object)requestValidationException);
        ImmutableList.Builder details = ImmutableList.builder();
        String errorMessage = requestValidationException.getDetails().stream().map(item -> {
            String fieldName = item.getFieldName().path();
            String originalMessage = item.getMessageText();
            String rejectedValue = RestResponseEntityExceptionHandler.rejectedValue((Object)item.getRejectedValue());
            Message message = item.getMessage();
            EMessageKey messageKey = message.getMessageKey();
            String translatedMessage = this.translatedMessage(message);
            List allowedArguments = item.getAllowedArguments();
            details.add((Object)ErrorResponse.Detail.of((String)fieldName, (String)translatedMessage, (String)originalMessage, (String)rejectedValue, (String)messageKey.name(), (List)allowedArguments));
            return this.errorMessage(fieldName, translatedMessage, rejectedValue);
        }).findFirst().orElse(requestValidationException.getMessage());
        log.error("RequestValidationException: {}", (Object)errorMessage);
        return ResponseEntity.badRequest().contentType(MediaType.APPLICATION_JSON).body((Object)ErrorResponse.of((int)HttpStatus.BAD_REQUEST.value(), (String)HttpStatus.BAD_REQUEST.name(), (String)errorMessage, (List)details.build()));
    }

    @ExceptionHandler(value={jakarta.validation.ValidationException.class})
    public ResponseEntity<?> handlingModelError(RuntimeException rte, WebRequest request) {
        log.error("ValidationException: {}", (Object)rte.getMessage(), (Object)rte);
        ImmutableList.Builder details = ImmutableList.builder();
        String errorMessage = rte.getMessage();
        return ResponseEntity.internalServerError().contentType(MediaType.APPLICATION_JSON).body((Object)ErrorResponse.of((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)HttpStatus.INTERNAL_SERVER_ERROR.name(), (String)errorMessage, (List)details.build()));
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<?> handlingVE(ValidationException rte, WebRequest request) {
        log.error("ValidationException: {}", (Object)rte.getMessage(), (Object)rte);
        ImmutableList.Builder details = ImmutableList.builder();
        String errorMessage = rte.getMessage();
        return ResponseEntity.badRequest().contentType(MediaType.APPLICATION_JSON).body((Object)ErrorResponse.of((int)HttpStatus.BAD_REQUEST.value(), (String)HttpStatus.BAD_REQUEST.name(), (String)errorMessage, (List)details.build()));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<?> handlingRTE(RuntimeException rte, WebRequest request) {
        log.error("RuntimeException: {}", (Object)rte.getMessage(), (Object)rte);
        ImmutableList.Builder details = ImmutableList.builder();
        String errorMessage = rte.getMessage();
        return ResponseEntity.badRequest().contentType(MediaType.APPLICATION_JSON).body((Object)ErrorResponse.of((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)HttpStatus.INTERNAL_SERVER_ERROR.name(), (String)errorMessage, (List)details.build()));
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public ResponseEntity<?> handleEntityNotFoundException(ResourceNotFoundException exception, WebRequest request) {
        String clazz = exception.getClazz();
        String fieldName = exception.getFieldName().path();
        String value = exception.getValue();
        String originalMessage = exception.getMessage();
        Message message = Message.of((EMessageKey)EMessageKey.ENTITY_NOT_FOUND_GENERIC, (List)ImmutableList.of((Object)clazz, (Object)fieldName, (Object)value));
        String translatedMessage = this.translatedMessage(message);
        log.error("ResourceNotFoundException: clazz: {}, fieldName: {}, value: {}, e.getMessage: {}, message: {}", (Object)clazz, (Object)fieldName, (Object)value, (Object)exception.getMessage(), (Object)message);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_JSON).body((Object)ErrorResponse.of((int)HttpStatus.NOT_FOUND.value(), (String)HttpStatus.NOT_FOUND.name(), (String)translatedMessage, (List)ImmutableList.of((Object)ErrorResponse.Detail.of((String)fieldName, (String)translatedMessage, (String)originalMessage, (String)value, (String)EMessageKey.ENTITY_NOT_FOUND.name(), (List)ImmutableList.of((Object)clazz)))));
    }

    @ExceptionHandler(value={ParseException.class})
    public ResponseEntity<?> handleParseException(ParseException exception, WebRequest request) {
        log.error("ParseException: {}", (Object)exception.getMessage());
        return ResponseEntity.badRequest().contentType(MediaType.APPLICATION_JSON).body((Object)ErrorResponse.of((int)HttpStatus.BAD_REQUEST.value(), (String)HttpStatus.BAD_REQUEST.name(), (String)exception.getMessage(), (List)ImmutableList.of()));
    }

    @NonNull
    private String errorMessage(@NonNull String field, @NonNull String defaultMessage, @Nullable String rejectedValue) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (defaultMessage == null) {
            throw new NullPointerException("defaultMessage is marked non-null but is null");
        }
        return this.messageService.get((Translatable)EMessageKey.FIELD_AND_REJECTED_VALUE, new Object[]{field, defaultMessage, MoreObjects.firstNonNull((Object)rejectedValue, (Object)"null")});
    }

    @Nullable
    private static String rejectedValue(@Nullable Object rejectedValue) {
        return null != rejectedValue ? rejectedValue.toString() : null;
    }

    @Nonnull
    private String translatedField(@NonNull String field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.messageService.translateField(field);
    }

    @Nonnull
    private String translatedMessage(@NonNull Message message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.messageService.get(message);
    }

    @Autowired
    public RestResponseEntityExceptionHandler(MessageService messageService) {
        this.messageService = messageService;
    }
}

