/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.Charsets;
import de.qfm.erp.common.response.measurement.MeasurementCommon;
import de.qfm.erp.service.service.route.MeasurementRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="ReadOnly Resource", name="ReadOnlyResource")
@OpenAPIDefinition(tags={@Tag(name="ReadOnlyResource", description="Readonly Operations for reading Data between this Service and PSS/ELAN. This Endpoint is protected with a HTTP Basic / Read-Only User Mechanism to prevent standard OAuth2 Token-Authentication")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp-readonly"})
public class ReadOnlyResource {
    private static final Logger log = LogManager.getLogger(ReadOnlyResource.class);
    private final MeasurementRoute measurementRoute;

    @GetMapping(value={"/"})
    public String pingGet() {
        return "ReadOnly Resource (GET Ping)";
    }

    @PostMapping(value={"/"})
    public String pingPost() {
        return "ReadOnly  Resource (POST Ping)";
    }

    @Operation(summary="Measurement by internal Id")
    @GetMapping(value={"/measurements/{id}/"}, produces={"application/json"})
    public MeasurementCommon getById(@Parameter(description="Measurement Id of the Measurement to retrieve", required=true) @PathVariable(value="id") long id) {
        return this.measurementRoute.byId(id);
    }

    @Operation(summary="Measurement by Measurement Number")
    @GetMapping(value={"/measurements/measurementNumber={measurementNumber}/"}, produces={"application/json"})
    public MeasurementCommon getByMeasurementNumber(@Parameter(description="Measurement Number of the Measurement to retrieve", required=true) @PathVariable(value="measurementNumber") String measurementNumber) throws UnsupportedEncodingException {
        String decodedMeasurementNumber = URLDecoder.decode(measurementNumber, Charsets.UTF_8.name());
        return this.measurementRoute.byMeasurementNumber(decodedMeasurementNumber);
    }

    @Operation(summary="Measurement by internal Id")
    @PostMapping(value={"/measurements/{id}/"}, produces={"application/json"})
    public MeasurementCommon postById(@Parameter(description="Measurement Id of the Measurement to retrieve", required=true) @PathVariable(value="id") long id) {
        return this.measurementRoute.byId(id);
    }

    @Operation(summary="Measurement by Measurement Number")
    @PostMapping(value={"/measurements/measurementNumber={measurementNumber}/"}, produces={"application/json"})
    public MeasurementCommon postByMeasurementNumber(@Parameter(description="Measurement Number of the Measurement to retrieve", required=true) @PathVariable(value="measurementNumber") String measurementNumber) throws UnsupportedEncodingException {
        String decodedMeasurementNumber = URLDecoder.decode(measurementNumber, Charsets.UTF_8.name());
        return this.measurementRoute.byMeasurementNumber(decodedMeasurementNumber);
    }

    public ReadOnlyResource(MeasurementRoute measurementRoute) {
        this.measurementRoute = measurementRoute;
    }
}

