/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.Charsets;
import de.qfm.erp.common.response.StringListResponse;
import de.qfm.erp.common.response.quotation.QuotationCommon;
import de.qfm.erp.common.response.quotation.QuotationPageCommon;
import de.qfm.erp.common.response.quotation.QuotationPositionCommon;
import de.qfm.erp.service.resource.AbstractResource;
import de.qfm.erp.service.service.route.QuotationRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Quotation Management Resource", name="QuotationResource")
@OpenAPIDefinition(tags={@Tag(name="QuotationResource", description="All Operations around Quotations")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/quotations"})
public class QuotationResource {
    private static final Logger log = LogManager.getLogger(QuotationResource.class);
    private final QuotationRoute quotationRoute;

    @Operation(summary="Quotations List / Paging")
    @GetMapping(value={"/"}, produces={"application/json"})
    public QuotationPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size) {
        return this.quotationRoute.page(page, size);
    }

    @Operation(summary="Quotation for Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public QuotationCommon getById(@PathVariable(value="id") long id, @RequestParam(value="include_all_positions", defaultValue="false") boolean includeAllPositions, @Parameter(description="Commission Flag will be ignored, when returning Positions (all positions will be returned)", example="false") @RequestParam(value="ignore_commission_flag", defaultValue="false") boolean ignoreCommissionFlag, @Parameter(description="Positions Sort Option", example="GROUPING_LEVELS_ASC, SEQUENTIAL_NUMBER_ASC") @RequestParam(value="sort_option", defaultValue="SEQUENTIAL_NUMBER_ASC") String sortOptionCandidate) {
        return this.quotationRoute.byId(id, includeAllPositions, ignoreCommissionFlag, sortOptionCandidate);
    }

    @Operation(summary="Ensure Correction-Position for Quotation by Id")
    @PostMapping(value={"/{id}/_ensure_correction_position/"}, consumes={"application/json"}, produces={"application/json"})
    public QuotationCommon ensureCorrectionPosition(@PathVariable(value="id") long id) {
        return this.quotationRoute.ensureCorrectionPosition(id);
    }

    @Operation(summary="GET Correction-Position for Quotation by Id")
    @GetMapping(value={"/{id}/_correction_positions/"}, produces={"application/json"})
    public List<QuotationPositionCommon> correctionPosition(@PathVariable(value="id") long id) {
        return this.quotationRoute.correctionPosition(id);
    }

    @Operation(summary="Person responbsible at Client for Quotation by Id")
    @GetMapping(value={"/{id}/person_responsible_at_customer/"}, produces={"application/json"})
    public StringListResponse personResponsibleAtClient(@PathVariable(value="id") long id, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        return this.quotationRoute.personResponsibleAtClient(id, filterText);
    }

    @Operation(summary="Quotation for Quotation Number")
    @GetMapping(value={"/quotation_number={quotation_number}/"}, produces={"application/json"})
    public QuotationCommon getByQuotationNumber(@Parameter(description="Quotation Number from of the Quotation to retrieve", required=true) @PathVariable(value="quotation_number") String quotationNumber, @Parameter(description="Commission Flag will be ignored, when returning Positions (all positions will be returned)", example="false") @RequestParam(value="ignore_commission_flag", defaultValue="false") boolean ignoreCommissionFlag, @Parameter(description="Positions Sort Option", example="GROUPING_LEVELS_ASC, SEQUENTIAL_NUMBER_ASC") @RequestParam(value="sort_option", defaultValue="SEQUENTIAL_NUMBER_ASC") String sortOptionCandidate) {
        String decodedQuotationNumber = URLDecoder.decode(quotationNumber, Charsets.UTF_8);
        return this.quotationRoute.byQuotationNumber(decodedQuotationNumber, ignoreCommissionFlag, sortOptionCandidate);
    }

    @Operation(summary="Download XLS (Bill of Quantities/Price List) Measurement Template")
    @GetMapping(value={"/{quotation_id}/measurement_template/_xls/"}, produces={"application/octet-stream"})
    public void billOfQuantitiesMeasurementTemplateById(@PathVariable(value="quotation_id") Long quotationId, HttpServletResponse response) throws IOException {
        Pair content = this.quotationRoute.billOfQuantitiesMeasurementTemplateById(quotationId.longValue());
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"application/octet-stream");
    }

    public QuotationResource(QuotationRoute quotationRoute) {
        this.quotationRoute = quotationRoute;
    }
}

