/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.queue.QueueItemListCommon;
import de.qfm.erp.service.service.route.QueueRoute;
import io.swagger.v3.oas.annotations.Operation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/erp/queue"})
public class QueueResource {
    private static final Logger log = LogManager.getLogger(QueueResource.class);
    private final QueueRoute queueRoute;

    @Operation(summary="Queue List")
    @GetMapping(value={"/"})
    public QueueItemListCommon list(@RequestParam(value="size", defaultValue="100") int size) {
        return this.queueRoute.list(size);
    }

    @Operation(summary="Queue Process Next")
    @PostMapping(value={"/_trigger/"})
    public boolean trigger() {
        return this.queueRoute.processNextItem();
    }

    public QueueResource(QueueRoute queueRoute) {
        this.queueRoute = queueRoute;
    }
}

