/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.pss.PssReleaseOrderCommon;
import de.qfm.erp.common.response.pss.PssReleaseOrdersCommon;
import de.qfm.erp.service.service.route.PssRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="PSS Management Resource", name="PssResource")
@OpenAPIDefinition(tags={@Tag(name="PssResource", description="All Operations around PSS")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/pss"})
public class PssResource {
    private static final Logger log = LogManager.getLogger(PssResource.class);
    private final PssRoute pssRoute;

    @Operation(summary="PSS Release Order List / Paging", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PssReleaseOrdersCommon.class))})})
    @GetMapping(value={"/releaseorders/quotation_id={quotation_id}/"})
    public PssReleaseOrdersCommon list(@Parameter(description="Quotation Id", required=true) @PathVariable(value="quotation_id") Long quotationId, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="The Page index starting at 0", example="0") @RequestParam(value="page", defaultValue="0") int page, @Parameter(description="The Page Size", example="25") @RequestParam(value="size", defaultValue="25") int size) {
        return this.pssRoute.pssReleaseOrders(quotationId, filterText, page, size);
    }

    @Operation(summary="PSS Release Order by ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PssReleaseOrderCommon.class))})})
    @GetMapping(value={"/releaseorders/{id}/"})
    public PssReleaseOrderCommon byId(@PathVariable(value="id") Long id) {
        return this.pssRoute.byId(id);
    }

    public PssResource(PssRoute pssRoute) {
        this.pssRoute = pssRoute;
    }
}

