/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemGroupListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemListCommon;
import de.qfm.erp.service.resource.AbstractResource;
import de.qfm.erp.service.service.route.PayrollMonthItemRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDate;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@Tag(description="Payroll Month Item Resource based on Cost Centers", name="PayrollMonthItemResource")
@OpenAPIDefinition(tags={@Tag(name="PayrollMonthItemResource", description="All Operations around Payroll Month Items")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/payroll_month_items"})
public class PayrollMonthItemResource
extends AbstractResource {
    private static final Logger log = LogManager.getLogger(PayrollMonthItemResource.class);
    private final PayrollMonthItemRoute route;

    @Operation(summary="Payroll Month Item List for the given Filters")
    @GetMapping(value={"/"}, produces={"application/json"})
    public PayrollMonthItemListCommon list(@Parameter(description="Accounting Month in (including day - 1st of month)", example="ISO Date Format yyyy-MM-dd") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="accounting_month", defaultValue="") LocalDate accountingMonth, @Parameter(description="Cost Center: exact without * - start with using as suffix *") @RequestParam(value="cost_center", defaultValue="") String costCenterFilter, @Parameter(description="Filter Option", example="SENDER_IN_OR_RECIPIENT_IN_BUSINESS_UNIT,SENDER_IN_AND_RECIPIENT_IN_BUSINESS_UNIT,SENDER_IN_AND_RECIPIENT_NOT_IN_BUSINESS_UNIT,SENDER_NOT_IN_AND_RECIPIENT_IN_BUSINESS_UNIT") @RequestParam(value="filter_option", defaultValue="SENDER_IN_OR_RECIPIENT_IN_BUSINESS_UNIT") String payrollItemFilterOption, @Parameter(description="Clazz Filter Option", example="ALL,AUXILIARY_WAGE,INCENTIVE_PAYMENT") @RequestParam(value="clazz_filter_option", defaultValue="ALL") String payrollItemClazzFilterOption, @RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.list(accountingMonth, costCenterFilter, payrollItemFilterOption, payrollItemClazzFilterOption, page, size);
    }

    @Operation(summary="Payroll Month Item List for the given Filters")
    @GetMapping(value={"/{accounting_month}/{cost_center}/_aggregated/"}, produces={"application/json"})
    public PayrollMonthItemGroupListCommon aggregatedList(@Parameter(description="Accounting Month in (including day - 1st of month)", example="ISO Date Format yyyy-MM-dd") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @PathVariable(value="accounting_month") LocalDate accountingMonth, @Parameter(description="Cost Center: exact without * - start with using as suffix *") @PathVariable(value="cost_center") String costCenter, @Parameter(description="Filter Option", example="SENDER_IN_BUSINESS_UNIT, SENDER_IN_CHILD_BUSINESS_UNIT_AND_RECIPIENT_IN_UNEQUAL_CHILD_BUSINESS_UNIT,SENDER_IN_OR_RECIPIENT_IN_BUSINESS_UNIT,SENDER_IN_AND_RECIPIENT_IN_BUSINESS_UNIT,SENDER_IN_AND_RECIPIENT_NOT_IN_BUSINESS_UNIT,SENDER_NOT_IN_AND_RECIPIENT_IN_BUSINESS_UNIT") @RequestParam(value="filter_option", defaultValue="SENDER_IN_BUSINESS_UNIT") String payrollItemFilterOption, @Parameter(description="Clazz Filter Option", example="ALL,AUXILIARY_WAGE,INCENTIVE_PAYMENT") @RequestParam(value="clazz_filter_option", defaultValue="ALL") String payrollItemClazzFilterOption, @RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.aggregatedList(accountingMonth, costCenter, payrollItemFilterOption, payrollItemClazzFilterOption, page, size);
    }

    @Operation(summary="XLS Export based on given Template and Parameters")
    @GetMapping(value={"/{accounting_month}/{sender_cost_center}/{recipient_cost_center}/_xls/"}, produces={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public void xls(@Parameter(description="Accounting Month in (including day - 1st of month)", example="ISO Date Format yyyy-MM-dd") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @PathVariable(value="accounting_month") LocalDate accountingMonth, @Parameter(description="Sender Cost Center: exact without * - start with using as suffix *") @PathVariable(value="sender_cost_center") String senderCostCenter, @Parameter(description="Recipient Cost Center: exact without * - start with using as suffix *") @PathVariable(value="recipient_cost_center") String recipientCostCenter, @Parameter(description="XLS Template", example="SALES_REVENUE_CORRECTION") @RequestParam(value="template", defaultValue="SALES_REVENUE_CORRECTION") String template, @Parameter(description="Clazz Filter Option", example="ALL,AUXILIARY_WAGE,INCENTIVE_PAYMENT") @RequestParam(value="clazz_filter_option", defaultValue="INCENTIVE_PAYMENT") String payrollItemClazzFilterOption, @NonNull HttpServletResponse response) throws IOException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Pair xls = this.route.detailXLS(accountingMonth, senderCostCenter, recipientCostCenter, payrollItemClazzFilterOption, template);
        PayrollMonthItemResource.writeToStream((HttpServletResponse)response, (Pair)xls, (String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    }

    @Operation(summary="XLS Export based on given Template and Parameters")
    @GetMapping(value={"/{accounting_month}/{cost_center}/_aggregated/_xls/"}, produces={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public void aggregatedXLS(@Parameter(description="Accounting Month in (including day - 1st of month)", example="ISO Date Format yyyy-MM-dd") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @PathVariable(value="accounting_month") LocalDate accountingMonth, @Parameter(description="Sender Cost Center: exact without * - start with using as suffix *") @PathVariable(value="cost_center") String costCenter, @Parameter(description="XLS Template", example="SALES_REVENUE_CORRECTION_GROUPED") @RequestParam(value="template", defaultValue="SALES_REVENUE_CORRECTION_GROUPED") String template, @Parameter(description="Filter Option", example="SENDER_IN_BUSINESS_UNIT, SENDER_IN_CHILD_BUSINESS_UNIT_AND_RECIPIENT_IN_UNEQUAL_CHILD_BUSINESS_UNIT,SENDER_IN_OR_RECIPIENT_IN_BUSINESS_UNIT,SENDER_IN_AND_RECIPIENT_IN_BUSINESS_UNIT,SENDER_IN_AND_RECIPIENT_NOT_IN_BUSINESS_UNIT,SENDER_NOT_IN_AND_RECIPIENT_IN_BUSINESS_UNIT") @RequestParam(value="filter_option", defaultValue="SENDER_IN_BUSINESS_UNIT") String payrollItemFilterOption, @Parameter(description="Clazz Filter Option", example="ALL,AUXILIARY_WAGE,INCENTIVE_PAYMENT") @RequestParam(value="clazz_filter_option", defaultValue="INCENTIVE_PAYMENT") String payrollItemClazzFilterOption, @NonNull HttpServletResponse response) throws IOException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Pair xls = this.route.aggregatedXLS(accountingMonth, costCenter, payrollItemFilterOption, payrollItemClazzFilterOption, template);
        PayrollMonthItemResource.writeToStream((HttpServletResponse)response, (Pair)xls, (String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    }

    @Operation(summary="ZIP/XLS Export based on given Template and Parameters")
    @GetMapping(value={"/{accounting_month}/_zip/"}, produces={"application/zip"})
    public void xlsAsZip(@Parameter(description="Accounting Month in (including day - 1st of month)", example="ISO Date Format yyyy-MM-dd") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @PathVariable(value="accounting_month") LocalDate accountingMonth, @Parameter(description="Sender Cost Center: exact without * - start with using as suffix *") @RequestParam(value="sender_cost_center", defaultValue="") String senderCostCenter, @Parameter(description="Recipient Cost Center: exact without * - start with using as suffix *") @RequestParam(value="recipient_cost_center", defaultValue="") String recipientCostCenter, @Parameter(description="XLS Template", example="SALES_REVENUE_CORRECTION") @RequestParam(value="template", defaultValue="SALES_REVENUE_CORRECTION") String template, @Parameter(description="Clazz Filter Option", example="ALL,AUXILIARY_WAGE,INCENTIVE_PAYMENT") @RequestParam(value="clazz_filter_option", defaultValue="INCENTIVE_PAYMENT") String payrollItemClazzFilterOption, @Parameter(description="Payroll Item Type Filter Option", example="SENDER_IN_BUSINESS_UNIT,RECIPIENT_IN_BUSINESS_UNIT,SENDER_IN_OR_RECIPIENT_IN_BUSINESS_UNIT,SENDER_IN_AND_RECIPIENT_IN_BUSINESS_UNIT,SENDER_IN_AND_RECIPIENT_NOT_IN_BUSINESS_UNIT,SENDER_NOT_IN_AND_RECIPIENT_IN_BUSINESS_UNIT,SENDER_IN_CHILD_BUSINESS_UNIT_AND_RECIPIENT_IN_UNEQUAL_CHILD_BUSINESS_UNIT") @RequestParam(value="payroll_item_type_filter_option", defaultValue="SENDER_IN_AND_RECIPIENT_IN_BUSINESS_UNIT") String payrollItemTypeFilterOption, @NonNull HttpServletResponse response) throws IOException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Pair xls = this.route.xlsAsZip(accountingMonth, senderCostCenter, recipientCostCenter, payrollItemClazzFilterOption, payrollItemTypeFilterOption, template);
        PayrollMonthItemResource.writeToStream((HttpServletResponse)response, (Pair)xls, (String)"application/zip");
    }

    public PayrollMonthItemResource(PayrollMonthItemRoute route) {
        this.route = route;
    }
}

