/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.request.generic.PayrollItemTypeUpdateRequest;
import de.qfm.erp.common.response.generic.PayrollItemTypeCommon;
import de.qfm.erp.common.response.generic.PayrollItemTypePageCommon;
import de.qfm.erp.service.service.route.PayrollItemTypeRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Payroll Item Types Management Resource", name="PayrollItemTypesResource")
@OpenAPIDefinition(tags={@Tag(name="PayrollItemTypesResource", description="All Operations around Payroll Item Types")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/payroll_item_types"})
public class PayrollItemTypesResource {
    private static final Logger log = LogManager.getLogger(PayrollItemTypesResource.class);
    private final PayrollItemTypeRoute route;

    @Operation(summary="PayrollItemType List / Paging")
    @GetMapping(value={"/"}, produces={"application/json"})
    public PayrollItemTypePageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.page(page, size);
    }

    @Operation(summary="PayrollItemType for Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public PayrollItemTypeCommon getById(@Parameter(description="PayrollItemType Id of the Entity to retrieve", required=true) @PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @Operation(summary="Create PayrollItemType")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    public PayrollItemTypeCommon create(@RequestBody @Valid PayrollItemTypeUpdateRequest request) {
        return this.route.create(request);
    }

    @Operation(summary="Update PayrollItemType for Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public PayrollItemTypeCommon update(@Parameter(description="PayrollItemType Id of the Entity to retrieve", required=true) @PathVariable(value="id") long id, @RequestBody @Valid PayrollItemTypeUpdateRequest request) {
        return this.route.update(id, request);
    }

    public PayrollItemTypesResource(PayrollItemTypeRoute route) {
        this.route = route;
    }
}

