/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.common.request.invoice.MeasurementValidationRequest;
import de.qfm.erp.common.request.measurement.MeasurementPatchRequest;
import de.qfm.erp.common.request.measurement.MeasurementPositionsStandardToTransposeRequest;
import de.qfm.erp.common.request.measurement.MeasurementPositionsTransposeToStandardRequest;
import de.qfm.erp.common.request.measurement.MeasurementPreliminaryPrintRequest;
import de.qfm.erp.common.request.measurement.MeasurementUpdateRequest;
import de.qfm.erp.common.response.invoice.MeasurementValidationResponse;
import de.qfm.erp.common.response.measurement.MeasurementAvailableStatesCommon;
import de.qfm.erp.common.response.measurement.MeasurementCommon;
import de.qfm.erp.common.response.measurement.MeasurementDuplicateCheckResponse;
import de.qfm.erp.common.response.measurement.MeasurementImportResultListCommon;
import de.qfm.erp.common.response.measurement.MeasurementNumberExistsResponse;
import de.qfm.erp.common.response.measurement.MeasurementPageCommon;
import de.qfm.erp.common.response.measurement.MeasurementPatchResponse;
import de.qfm.erp.common.response.measurement.MeasurementPositionsTransposedCommon;
import de.qfm.erp.common.response.measurement.MeasurementPositionsUntransposedResponse;
import de.qfm.erp.common.response.measurement.MeasurementSearchResultCommon;
import de.qfm.erp.service.model.internal.measurement.EMeasurementPrintTemplate;
import de.qfm.erp.service.resource.AbstractResource;
import de.qfm.erp.service.service.route.MeasurementRoute;
import de.qfm.erp.service.service.route.TranspositionRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.net.URLDecoder;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(description="Measurement Management Resource", name="MeasurementResource")
@OpenAPIDefinition(tags={@Tag(name="MeasurementResource", description="All Operations around Measurements")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/measurements"})
public class MeasurementResource {
    private static final Logger log = LogManager.getLogger(MeasurementResource.class);
    private static final String TRANSPOSED_PRINT_COLUMN_AMOUNT_DEFAULT = "9";
    private static final String TRANSPOSED_PRINT_HEADER_LENGTH = "50";
    public static final Splitter COMMA_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private final MeasurementRoute measurementRoute;
    private final TranspositionRoute transpositionRoute;

    @Operation(summary="Measurement List / Paging", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=MeasurementPageCommon.class))})})
    @GetMapping(value={"/"}, produces={"application/json"})
    public MeasurementPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="1000") int size, @Parameter(description="filter Measurements by any Text") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="filter Measurements by Stage Id") @RequestParam(value="filter_stage_id", defaultValue="") Long filterStageId, @Parameter(description="filter Measurements with Cost Center (Employee at Project Begin)") @RequestParam(value="filter_cost_center", defaultValue="") String filterCostCenter, @Parameter(description="filter Measurements with Positions by Position Number / ShortText") @RequestParam(value="filter_position", defaultValue="") String filterPositionNumber, @Parameter(description="filter Measurements by Assigned User") @RequestParam(value="filter_user_id", defaultValue="") Long filterUserId, @Parameter(description="filter Measurements with Project Execution Date FROM (Overlapping)", example="ISO DATE - YYYY-MM-DD") @RequestParam(value="filter_execution_period_from", defaultValue="") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate filterProjectExecutionFrom, @Parameter(description="filter Measurements with Project Execution Date TO (Overlapping)", example="ISO DATE - YYYY-MM-DD") @RequestParam(value="filter_execution_period_to", defaultValue="") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate filterProjectExecutionTo, @Parameter(description="filter Measurements with Accounting Month", example="ISO DATE - YYYY-MM-DD") @RequestParam(value="filter_accounting_month", defaultValue="") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate filterAccountingMonth, @Parameter(description="filter Measurements by PSX CS ReferenceId") @RequestParam(value="filter_psx_construction_site_reference_ids", defaultValue="") String filterPssConstructionSiteReferenceIds, @Parameter(description="filter Measurements by PSX RO ReferenceId") @RequestParam(value="filter_psx_release_order_reference_ids", defaultValue="") String filterPssReleaseOrderReferenceIds, @Parameter(description="only show measurements with state 'TEMPORARY'") @RequestParam(name="option_show_only_temporary", defaultValue="false") Boolean optionShowOnlyTemporary, @Parameter(description="only show my measurements (created by login / assigned to login)") @RequestParam(name="option_my_measurements", defaultValue="false") Boolean optionMyMeasurements, @Parameter(description="only show recent measurements (created within a configured time period (e.g. 90 days))") @RequestParam(name="option_recent", defaultValue="false") Boolean optionRecent, @Parameter(description="include deleted measurements") @RequestParam(name="option_include_deleted", defaultValue="false") Boolean optionIncludeDeleted) throws IOException {
        List psxConstructionSiteReferenceIds = COMMA_SPLITTER.splitToList((CharSequence)filterPssConstructionSiteReferenceIds);
        List psxReleaseOrderReferenceIds = COMMA_SPLITTER.splitToList((CharSequence)filterPssReleaseOrderReferenceIds);
        return this.measurementRoute.page(page, size, StringUtils.trimToEmpty((String)filterText), filterStageId, StringUtils.trimToEmpty((String)filterCostCenter), StringUtils.trimToEmpty((String)filterPositionNumber), filterUserId, filterProjectExecutionFrom, filterProjectExecutionTo, filterAccountingMonth, (Iterable)psxConstructionSiteReferenceIds, (Iterable)psxReleaseOrderReferenceIds, optionShowOnlyTemporary, optionMyMeasurements, optionRecent, optionIncludeDeleted);
    }

    @Operation(summary="Measurement Export as XLS")
    @GetMapping(value={"/_xls/"}, produces={"application/octet-stream"})
    public void xls(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="1000") int size, @Parameter(description="filter Measurements by any Text") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="filter Measurements by Quotation Number") @RequestParam(value="filter_quotation_number", defaultValue="") String filterQuotationNumber, @Parameter(description="filter Measurements with Cost Center (Employee at Project Begin)") @RequestParam(value="filter_cost_center", defaultValue="") String filterCostCenter, @Parameter(description="filter Measurements with Positions by Position Number") @RequestParam(value="filter_position_number", defaultValue="") String filterPositionNumber, @Parameter(description="filter Measurements by Assigned User") @RequestParam(value="filter_user_id", defaultValue="") Long filterUserId, @Parameter(description="filter Measurements with Project Execution Date FROM (Overlapping)", example="ISO DATE - YYYY-MM-DD") @RequestParam(value="filter_execution_period_from", defaultValue="") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate filterProjectExecutionFrom, @Parameter(description="filter Measurements with Project Execution Date TO (Overlapping)", example="ISO DATE - YYYY-MM-DD") @RequestParam(value="filter_execution_period_to", defaultValue="") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate filterProjectExecutionTo, @Parameter(description="filter Measurements with Accounting Month", example="ISO DATE - YYYY-MM-DD") @RequestParam(value="filter_accounting_month", defaultValue="") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate filterAccountingMonth, @Parameter(description="filter Measurements by QEntity.Id") @RequestParam(value="filter_qentity_id", defaultValue="") Long filterEntityId, @Parameter(description="filter Measurements by Stage.Id") @RequestParam(value="filter_qentity_id", defaultValue="") Long filterStageId, @Parameter(description="filter Measurements by ProjectId") @RequestParam(value="filter_project_id", defaultValue="") Long filterProjectId, @Parameter(description="only show measurements with state 'TEMPORARY'") @RequestParam(name="option_show_only_temporary", defaultValue="false") Boolean optionShowOnlyTemporary, @Parameter(description="only show my measurements (created by login / assigned to login)") @RequestParam(name="option_my_measurements", defaultValue="false") Boolean optionMyMeasurements, @Parameter(description="only show recent measurements (created within a configured time period (e.g. 90 days))") @RequestParam(name="option_recent", defaultValue="false") Boolean optionRecent, @Parameter(description="include deleted measurements") @RequestParam(name="option_include_deleted", defaultValue="false") Boolean optionIncludeDeleted, @Parameter(description="only show recent measurements (created within a configured time period (e.g. 90 days))") @RequestParam(name="option_last_viewed", defaultValue="false") Boolean optionLastViewed, HttpServletResponse response) throws IOException {
        Pair content = this.measurementRoute.exportToXLS(page, size, filterText, filterQuotationNumber, filterCostCenter, filterPositionNumber, filterEntityId, filterStageId, filterProjectId, filterUserId, filterProjectExecutionFrom, filterProjectExecutionTo, filterAccountingMonth, optionShowOnlyTemporary, optionMyMeasurements, optionRecent, optionIncludeDeleted, optionLastViewed);
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"application/octet-stream");
    }

    @Operation(summary="Measurement Export as GAEB/D11")
    @GetMapping(value={"/{id}/_gaeb/d11/"}, produces={"text/plain"})
    public void gaebD11(@PathVariable(value="id") long id, HttpServletResponse response) throws IOException {
        Pair content = this.measurementRoute.exportToD11(id);
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"text/plain");
    }

    @Operation(summary="Measurement Export as GAEB/X31")
    @GetMapping(value={"/{id}/_gaeb/x31/"}, produces={"application/xml"})
    public void gaebX31(@PathVariable(value="id") long id, HttpServletResponse response) throws IOException {
        Pair content = this.measurementRoute.exportToX31(id);
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"text/plain");
    }

    @Operation(summary="Measurement Search", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=MeasurementSearchResultCommon.class))})})
    @GetMapping(value={"/_search/"}, produces={"application/json"})
    public MeasurementSearchResultCommon search(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size, @RequestParam(value="q", defaultValue="") String query, @RequestParam(value="include_deleted", defaultValue="false") boolean includeDeleted) {
        return this.measurementRoute.search(page, size, query, includeDeleted);
    }

    @Operation(summary="Measurement for Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public MeasurementCommon getById(@Parameter(description="Measurement Id of the Measurement to retrieve", required=true) @PathVariable(value="id") long id) {
        return this.measurementRoute.byId(id);
    }

    @Operation(summary="Measurement Duplication for Id")
    @PostMapping(value={"/{id}/_duplicate/"}, produces={"application/json"})
    public MeasurementCommon duplicateById(@Parameter(description="Measurement Id of the Measurement to duplicate", required=true) @PathVariable(value="id") long id, @Parameter(description="Flag to allow Partial Copy", example="false, true") @RequestParam(name="option_allow_partial_copy", defaultValue="false") String allowPartialCopyString, @Parameter(description="Include Release Order in Copy Operation", example="true") @RequestParam(name="include_release_order", defaultValue="true") boolean includeReleaseOrder, @Parameter(description="Include Positions in Copy Operation", example="true") @RequestParam(name="include_positions", defaultValue="true") boolean includePositions, @Parameter(description="Copy Amounts in Copy Operation", example="false") @RequestParam(name="option_copy_amounts", defaultValue="false") boolean optionCopyAmounts, @Parameter(description="Stage into Copy", example="", required=false) @RequestParam(name="target_stage_id", defaultValue="", required=false) Long targetStageId) {
        boolean allowPartialCopy = StringUtils.equalsIgnoreCase((CharSequence)allowPartialCopyString, (CharSequence)"true");
        return this.measurementRoute.duplicate(id, targetStageId, allowPartialCopy, includeReleaseOrder, includePositions, optionCopyAmounts);
    }

    @Operation(summary="Measurement Duplication for Id")
    @PostMapping(value={"/{id}/_move/"}, produces={"application/json"})
    public MeasurementCommon moveById(@Parameter(description="Measurement Id of the Measurement to duplicate", required=true) @PathVariable(value="id") long id, @Parameter(description="Flag to allow Partial Copy", example="false, true") @RequestParam(name="option_allow_partial_copy", defaultValue="false") String allowPartialCopyString, @Parameter(description="Include Release Order in Copy Operation", example="true") @RequestParam(name="include_release_order", defaultValue="true") boolean includeReleaseOrder, @Parameter(description="Include Positions in Copy Operation", example="true") @RequestParam(name="include_positions", defaultValue="true") boolean includePositions, @Parameter(description="Copy Amounts in Copy Operation", example="false") @RequestParam(name="option_copy_amounts", defaultValue="false") boolean optionCopyAmounts, @Parameter(description="Stage into Move to", example="", required=false) @RequestParam(name="target_stage_id", defaultValue="", required=false) Long targetStageId) {
        boolean allowPartialCopy = StringUtils.equalsIgnoreCase((CharSequence)allowPartialCopyString, (CharSequence)"true");
        return this.measurementRoute.move(id, targetStageId, allowPartialCopy, includeReleaseOrder, includePositions, optionCopyAmounts);
    }

    @Operation(summary="Measurement Number Exists Check")
    @GetMapping(value={"/measurementNumber={measurementNumber}/_exists/"}, produces={"application/json"})
    public MeasurementNumberExistsResponse existsCheck(@Parameter(description="Measurement Number of the Measurement to retrieve", required=true) @PathVariable(value="measurementNumber") String measurementNumber) {
        return this.measurementRoute.existsCheck(measurementNumber);
    }

    @Operation(summary="Measurement Duplication for Id")
    @GetMapping(value={"/{id}/_duplicate_check/"}, produces={"application/json"})
    public MeasurementDuplicateCheckResponse duplicateByIdCheck(@Parameter(description="Measurement Id of the Measurement to duplicate", required=true) @PathVariable(value="id") long id, @Parameter(description="Stage into Copy/Move too", example="", required=false) @RequestParam(name="target_stage_id", defaultValue="", required=false) Long targetStageId) {
        return this.measurementRoute.duplicateCheck(id, targetStageId);
    }

    @Operation(summary="Measurement for Measurement Number")
    @GetMapping(value={"/measurementNumber={measurementNumber}/"}, produces={"application/json"})
    public MeasurementCommon getByMeasurementNumber(@Parameter(description="Measurement Number of the Measurement to retrieve", required=true) @PathVariable(value="measurementNumber") String measurementNumber) {
        String decodedMeasurementNumber = URLDecoder.decode(measurementNumber, Charsets.UTF_8);
        return this.measurementRoute.byMeasurementNumber(decodedMeasurementNumber);
    }

    @Operation(summary="Update Measurement for Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public MeasurementCommon updateForId(@Parameter(description="Measurement Id of the Measurement to Update", required=true) @PathVariable(value="id") long id, @Parameter(description="The Measurement Update Request Object", required=true) @Valid @RequestBody MeasurementUpdateRequest measurementUpdateRequest) {
        return this.measurementRoute.update(id, measurementUpdateRequest);
    }

    @Operation(summary="Set new State for Measurement with Id")
    @PostMapping(value={"/{id}/_state/{new_state}/"}, consumes={"application/json"}, produces={"application/json"})
    public MeasurementCommon updateStateForId(@Parameter(description="Measurement Id of the Measurement to Change State", required=true) @PathVariable(value="id") long id, @Parameter(description="new State for Measurement", example="TEMPORARY,APPROVED,ACCOUNTED,CLOSED,WAITING_FOR_APPROVAL,IN_ACCOUNTING", required=true) @PathVariable(value="new_state") String newStateCandidate) {
        return this.measurementRoute.updateStateForId(id, newStateCandidate);
    }

    @Operation(summary="Set new State for Measurement with Measurement Number")
    @PostMapping(value={"/measurementNumber={measurementNumber}/_state/{new_state}/"}, consumes={"application/json"}, produces={"application/json"})
    public MeasurementCommon updateStateForMeasurementNumber(@Parameter(description="Measurement Number of the Measurement to Change State", required=true) @PathVariable(value="measurementNumber") String measurementNumber, @Parameter(description="new State for Measurement", example="TEMPORARY,APPROVED,ACCOUNTED,CLOSED,WAITING_FOR_APPROVAL,IN_ACCOUNTING", required=true) @PathVariable(value="new_state") String newStateCandidate) {
        return this.measurementRoute.updateStateForMeasurementNumber(measurementNumber, newStateCandidate);
    }

    @Operation(summary="Delete Measurement By Id")
    @DeleteMapping(value={"/{id}/"}, produces={"application/json"})
    public MeasurementCommon deleteById(@Parameter(description="Measurement Id of the Measurement to Delete", required=true) @PathVariable(value="id") long id) {
        return this.measurementRoute.delete(id);
    }

    @Operation(summary="Create a Measurement")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    public MeasurementCommon create(@Parameter(description="The Measurement Update Request Object", required=true) @Valid @RequestBody MeasurementUpdateRequest measurementUpdateRequest) {
        return this.measurementRoute.create(measurementUpdateRequest);
    }

    @Operation(summary="Create an initial Measurement Object based on XLS Upload")
    @PostMapping(value={"/_from_xls/"})
    public MeasurementImportResultListCommon handleFileUpload(@RequestParam(value="multiPartFile") MultipartFile[] multiPartFiles) {
        return this.measurementRoute.fromFile(multiPartFiles);
    }

    @Operation(summary="Measurement Export by CSV for Id")
    @GetMapping(value={"/{id}/_csv/{csvExportType}/"}, produces={"text/csv"})
    public void csvById(@Parameter(description="Measurement Id of the Measurement to exported as CSV", required=true) @PathVariable(value="id") long id, @Parameter(description="CSV Export Type of the CSV", required=true) @PathVariable(value="csvExportType") String csvExportType, HttpServletResponse response) throws IOException {
        Pair content = this.measurementRoute.csv(id, csvExportType);
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"text/csv");
    }

    @Operation(summary="Measurement XLS Download / BOQ for CLUSTER35 by Id")
    @GetMapping(value={"/{measurement_id}/_xls/cluster35/"}, produces={"application/octet-stream"})
    public void xlsCluster35ById(@Parameter(description="Measurement Id of the Measurement to exported as XLS", required=true) @PathVariable(value="measurement_id") long id, HttpServletResponse response) throws IOException {
        Pair content = this.measurementRoute.boqXLSCluster35(id);
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"application/octet-stream");
    }

    @Operation(summary="Measurement XLS Download / BOQ for SubContractor by Id")
    @GetMapping(value={"/{measurement_id}/_xls/subcontractor/"}, produces={"application/octet-stream"})
    public void xlsSubContractorById(@Parameter(description="Measurement Id of the Measurement to exported as XLS", required=true) @PathVariable(value="measurement_id") long id, HttpServletResponse response) throws IOException {
        Pair content = this.measurementRoute.boqXLSSubContractor(id);
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"application/octet-stream");
    }

    @Operation(summary="Print Measurement Id")
    @GetMapping(value={"/{id}/_print/"})
    public void printId(@Parameter(description="Measurement Id of the Measurement to Print", required=true) @PathVariable(value="id") long id, @Parameter(description="Printing Template", example="[STANDARD, GROUPED, TRANSPOSED]", required=true) @RequestParam(value="print_template", defaultValue="STANDARD", required=false) String printTemplate, @Parameter(description="Print Font Size", example="[DEFAULT, SMALLER, SMALLEST]", required=true) @RequestParam(value="print_font_size", defaultValue="DEFAULT", required=false) String printFontSize, @Parameter(description="Option print Wage", example="false") @RequestParam(name="option_print_internal_wage", defaultValue="false") boolean optionPrintInternalWage, @Parameter(description="Option print Wage", example="false") @RequestParam(name="option_print_overall_value", defaultValue="false") boolean optionPrintOverallValue, @Parameter(description="Option FillUp Table", example="false") @RequestParam(name="option_fillup_table", defaultValue="false") boolean optionFillUpTable, @Parameter(description="Option Check on Free From Defects", example="false") @RequestParam(name="option_free_from_defects_checked", defaultValue="false") boolean optionFreeFromDefectsChecked, @Parameter(description="Option Check on Work is Accepted", example="false") @RequestParam(name="option_work_is_accepted_checked", defaultValue="false") boolean optionWorkIsAcceptedChecked, @Parameter(description="Option Check on Transfer of Perils", example="false") @RequestParam(name="option_transfer_of_peril_checked", defaultValue="false") boolean optionTransferOfPerilsChecked, @Parameter(description="Option Print Header Remarks", example="false") @RequestParam(name="option_print_header_remarks", defaultValue="false") boolean optionPrintHeaderRemarks, @Parameter(description="Option Print Squad", example="true") @RequestParam(name="option_print_squad", defaultValue="true") boolean optionPrintSquad, @Parameter(description="Option Print Jumbo instead of JUMBO_*", example="true") @RequestParam(name="option_print_jumbo_a", defaultValue="true") boolean optionPrintJumboA, @RequestParam(name="option_print_jumbo_b", defaultValue="true") boolean optionPrintJumboB, @Parameter(description="Date to be Printed", example="ISO Date Format yyyy-MM-dd") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(name="override_print_date", defaultValue="") LocalDate overridePrintDate, @Parameter(description="Transposed Print Column Amount", example="9") @RequestParam(name="transposed_column_amount", defaultValue="9") int transposedColumnAmount, @Parameter(description="Transposed Print Header Length", example="50") @RequestParam(name="transposed_header_length", defaultValue="50") int transposedHeaderLength, @RequestParam Map<String, String> allRequestParams, HttpServletResponse response) throws IOException {
        Pair pdfContent = this.measurementRoute.print(id, printTemplate, printFontSize, allRequestParams, overridePrintDate, transposedColumnAmount, transposedHeaderLength);
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)pdfContent, (String)"application/pdf");
    }

    @Operation(summary="Print File(s) into PDF by Measurement Ids")
    @PostMapping(value={"/_print/"}, consumes={"application/json"}, produces={"application/pdf"})
    public void printInvoicesIntoZIP(@Parameter(description="Measurement Ids to be printed") @Valid @RequestBody MeasurementPreliminaryPrintRequest printRequest, HttpServletResponse response) throws IOException {
        Iterable safeLongs = (Iterable)((Set)MoreObjects.firstNonNull((Object)printRequest.getMeasurementIds(), (Object)ImmutableSet.of())).stream().filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Pair pdfContent = this.measurementRoute.print(safeLongs, EMeasurementPrintTemplate.PRELIMINARY.name());
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)pdfContent, (String)"application/pdf");
    }

    @Operation(summary="Export all measurement into a Customer Template (xlsx)")
    @PostMapping(value={"/_customer_template/"}, consumes={"application/json"}, produces={"*/*"})
    public void exportMeasurementFromCustomerTemplate(@Parameter(description="Measurement Ids to be Exported into the Customer Template") @Valid @RequestBody MeasurementPreliminaryPrintRequest measurementRequest, HttpServletResponse response) throws IOException {
        Iterable safeLongs = (Iterable)((Set)MoreObjects.firstNonNull((Object)measurementRequest.getMeasurementIds(), (Object)ImmutableSet.of())).stream().filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Triple exported = this.measurementRoute.exportCustomerTemplate(safeLongs);
        Pair pair = Pair.of((Object)((String)exported.getMiddle()), (Object)((byte[])exported.getRight()));
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)pair, (String)((String)exported.getLeft()));
    }

    @Operation(summary="Transpose Ungrouped View to Grouped View for Measurement Id")
    @PostMapping(value={"/_transpose_and_group/"}, consumes={"application/json"}, produces={"application/json"})
    public MeasurementPositionsTransposedCommon transposeAndGroup(@RequestBody @Valid MeasurementPositionsStandardToTransposeRequest request) {
        return this.transpositionRoute.transpose(request);
    }

    @Operation(summary="Transpose Grouped View to Ungrouped View for Measurement Id")
    @PostMapping(value={"/_transpose_and_ungroup/"}, consumes={"application/json"}, produces={"application/json"})
    public MeasurementPositionsUntransposedResponse transposeAndUngroup(@RequestBody @Valid MeasurementPositionsTransposeToStandardRequest request) {
        return this.transpositionRoute.transposeAndUngroup(request);
    }

    @Operation(summary="Provides available Measurement States for Measurement Id for User/Quotation/MeasurementState")
    @GetMapping(value={"/{id}/_available_states/"}, produces={"application/json"})
    public MeasurementAvailableStatesCommon availableStates(@Parameter(description="Measurement Id of the Measurement to query available states", required=true) @PathVariable(value="id") long id) {
        return this.measurementRoute.availableStates(id);
    }

    @Operation(summary="Validate Measurements against Quotation (Existence of Positions)")
    @PostMapping(value={"/measurements/_validate/"})
    public MeasurementValidationResponse validate(@RequestBody @Valid MeasurementValidationRequest validationRequest) {
        return this.measurementRoute.validate(validationRequest);
    }

    @Operation(summary="Patch a set of Measurement.RemarkInternal fields to a given Value")
    @PutMapping(value={"/remarks_internal/"})
    public MeasurementPatchResponse patchRemarksInternal(@RequestBody @Valid MeasurementPatchRequest patchRequest) {
        return this.measurementRoute.patchRemarksInternal(patchRequest);
    }

    @Operation(summary="Patch a set of Measurement.AccountingMonthPlanned fields to a given Value")
    @PutMapping(value={"/accounting_month_planned/"})
    public MeasurementPatchResponse patchAccountingMonthPlanned(@RequestBody @Valid MeasurementPatchRequest patchRequest) {
        return this.measurementRoute.patchAccountingMonthPlanned(patchRequest);
    }

    public MeasurementResource(MeasurementRoute measurementRoute, TranspositionRoute transpositionRoute) {
        this.measurementRoute = measurementRoute;
        this.transpositionRoute = transpositionRoute;
    }
}

