/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.jpa.queue.EProcessingState;
import de.qfm.erp.service.model.jpa.quotation.StagePropagation;
import jakarta.persistence.criteria.Join;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

/*
 * Exception performing whole class analysis ignored.
 */
public interface StagePropagationRepository
extends JpaRepository<StagePropagation, Long>,
JpaSpecificationExecutor<StagePropagation> {
    @Nonnull
    public static Optional<Specification<StagePropagation>> processingStateIn(@NonNull Iterable<EProcessingState> processingStates) {
        if (processingStates == null) {
            throw new NullPointerException("processingStates is marked non-null but is null");
        }
        if (Iterables.isEmpty(processingStates)) {
            return Optional.empty();
        }
        Specification & Serializable specification = (Specification & Serializable)(root, query, builder) -> root.get("processingState").in((Collection)ImmutableSet.copyOf((Iterable)processingStates));
        return Optional.of(specification);
    }

    @Nonnull
    public static Optional<Specification<StagePropagation>> batchIn(@NonNull Iterable<Long> batches) {
        if (batches == null) {
            throw new NullPointerException("batches is marked non-null but is null");
        }
        if (Iterables.isEmpty(batches)) {
            return Optional.empty();
        }
        Specification & Serializable specification = (Specification & Serializable)(root, query, builder) -> root.get("batch").in((Collection)ImmutableSet.copyOf((Iterable)batches));
        return Optional.of(specification);
    }

    @Nonnull
    public static Optional<Specification<StagePropagation>> sourceStageIdIn(@NonNull Iterable<Long> ids) {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (Iterables.isEmpty(ids)) {
            return Optional.empty();
        }
        Specification & Serializable specification = (Specification & Serializable)(root, query, builder) -> {
            Join stageFrom = root.join("stageFrom");
            return stageFrom.get("id").in((Collection)ImmutableList.copyOf((Iterable)ids));
        };
        return Optional.of(specification);
    }

    @Nonnull
    public static Specification<StagePropagation> conjunction(@NonNull Iterable<Specification<StagePropagation>> specs) {
        if (specs == null) {
            throw new NullPointerException("specs is marked non-null but is null");
        }
        return Streams.stream(specs).filter(Objects::nonNull).reduce(Specification::and).orElse(StagePropagationRepository.identity());
    }

    @Nonnull
    public static Specification<StagePropagation> identity() {
        return (Specification & Serializable)(root, query, builder) -> root.isNotNull();
    }

    @Query(value="select sp from StagePropagation sp where sp.processingState = 'UNPROCESSED' order by sp.id asc")
    @Nonnull
    public List<StagePropagation> nextUnprocessed(Pageable var1);

    @Query(value="select distinct sp.batch from StagePropagation sp join sp.stageFrom sf where sp.processingState = 'PROCESSED' AND sf.id in :stageFromIds order by sp.batch desc")
    @Nonnull
    public List<Long> lastBatch(@Param(value="stageFromIds") @NonNull Iterable<Long> var1, @NonNull Pageable var2);

    @Query(value="select distinct sp.batch from StagePropagation sp join sp.stageFrom sf where sp.processingState = 'UNPROCESSED' AND sf.id in :stageFromIds")
    @Nonnull
    public List<Long> unfinishedBatches(@Param(value="stageFromIds") @NonNull Iterable<Long> var1);
}

