/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import de.qfm.erp.service.model.internal.sharepoint.ESharepointState;
import de.qfm.erp.service.model.jpa.EPsxNotifyState;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface CustomerRepository
extends JpaRepository<Customer, Long>,
JpaSpecificationExecutor<Customer> {
    @Query(value="SELECT c FROM Customer c WHERE   c.searchIndexState in :searchIndexStates")
    @Nonnull
    public List<Customer> findAllUnIndexed(@Param(value="searchIndexStates") @NonNull Iterable<ESearchIndexState> var1, @NonNull Pageable var2);

    @Modifying
    @Query(value="update Customer c set c.searchIndexState = :searchIndexState where c.id in :customerIds")
    public int updateSearchIndexState(@Param(value="searchIndexState") @NonNull ESearchIndexState var1, @Param(value="customerIds") @NonNull Iterable<Long> var2);

    @Query(value="SELECT c FROM Customer c WHERE   c.sharepointState in :sharepointStates")
    @Nonnull
    public List<Customer> findAllSharepointNotSynced(@Param(value="sharepointStates") @NonNull Iterable<ESharepointState> var1, @NonNull Pageable var2);

    @Modifying
    @Query(value="update Customer c set c.sharepointState = :sharepointState, c.sharepointUrl = :sharepointUrl, c.sharepointSiteId = :sharepointSiteId, c.sharepointDriveId = :sharepointDriveId, c.sharepointDriveItemId = :sharepointDriveItemId where c.id = :id")
    public int updateSharepointState(@Param(value="sharepointState") @NonNull ESharepointState var1, @Param(value="sharepointUrl") @NonNull String var2, @Param(value="sharepointSiteId") @NonNull String var3, @Param(value="sharepointDriveId") @NonNull String var4, @Param(value="sharepointDriveItemId") @NonNull String var5, @Param(value="id") long var6);

    @Query(value="select c FROM Customer c WHERE c.psxNotifyState = 'NOT_NOTIFIED' order by c.id")
    @Nonnull
    public List<Customer> nextNotNotified(@NonNull Pageable var1);

    @Modifying
    @Query(value="update Customer c set c.psxNotifyState = :psxNotifyState where c.id in :customerIds")
    public int updatePsxNotifyState(@Param(value="psxNotifyState") @NonNull EPsxNotifyState var1, @Param(value="customerIds") @NonNull Iterable<Long> var2);
}

